/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class CalculosFlexi {
    String claveBAS;
    String claveEP;
    String clavePASI;
    String claveIMA;
    String claveDI;
    String claveTI;
    String claveEG;
    Integer tarifaSH;
    Integer edad;
    String sexo;
    String fuma;
    Double tarifaBAS;
    Double tarifaEP;
    Double tarifaPASI;
    Double tarifaIMA;
    Double tarifaDI;
    Double tarifaTI;
    Double tarifaEG;
    Double tarifaGF;
    Long tmpLong;
    Double tasaTecnica;
    Double tasaTecnicaMensual;
    Integer edadQX;
    Integer edadCanEP;
    Integer edadCanPASI;
    Integer edadCanIMA;
    Integer edadCanDI;
    Integer edadCanTI;
    Integer edadCanEG;
    Integer edadCanGF;
    Integer anoCanEP;
    Integer anoCanPASI;
    Integer anoCanIMA;
    Integer anoCanDI;
    Integer anoCanTI;
    Integer anoCanEG;
    Integer anoCanGF;
    Double[] qxBAS = new Double[101];
    Double[] qxEP = new Double[101];
    Double[] qxPASI = new Double[101];
    Double[] qxEG = new Double[101];
    Double[] qxGF = new Double[101];
    Double qxIMA;
    Double qxDI;
    Double qxTI;
    Double costoAdmin1;
    Double costoAdmin2;
    Double caEP1;
    Double caEP2;
    Double caPASI1;
    Double caPASI2;
    Double caIMA1;
    Double caIMA2;
    Double caDI1;
    Double caDI2;
    Double caTI1;
    Double caTI2;
    Double caEG1;
    Double caEG2;
    Double caGF1;
    Double caGF2;
    Double[] costoRescate = new Double[12];
    Double[][] tasaInv = new Double[3][6];
    Double pmaBAS;
    Double pmaEP;
    Double pmaPASI;
    Double pmaIMA;
    Double pmaDI;
    Double pmaTI;
    Double pmaEG;
    Double pmaGF;
    Integer[] vecAno;
    Integer[] vecMes;
    Double[] recargoFijo;
    Double[] primaBAS;
    Double[] primaEG;
    Double[] primaGF;
    Double[] costoAdmin;
    Double[] costoSeguro;
    Double[] costoSeguroBAS;
    Double[] costoSeguroEP;
    Double[] costoSeguroPASI;
    Double[] costoSeguroIMA;
    Double[] costoSeguroDI;
    Double[] costoSeguroTI;
    Double[] costoSeguroEG;
    Double[] costoSeguroGF;
    Double[] intereses;
    Double[] castigo;
    Double[] reservaSinIntereses;
    Double[] reservaConIntereses;
    Double[] costoAdminBAS;
    Double[] fondoBase;
    Double[] seguroPuro;
    Double[][][] aportacionTotal;
    Double[][][] rendimiento;
    Double[][][] rendimientoAcu;
    Double[][][] aportacionAnual;
    Double[][][] rendimientoAnual;
    String nombreArchivo;
    String rutaUser;
    Boolean errorArchivo;
    Path pathArchivo;
    List<String> renMemoria = new ArrayList<String>();
    String txtMemoria;
    private static CalculosFlexi calculosFlexi = new CalculosFlexi();
    private DatosVI datosvi = DatosVI.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();

    private CalculosFlexi() {
    }

    public static CalculosFlexi getInstance() {
        return calculosFlexi;
    }

    public void CalculaPrimas() {
        this.TarifasConstantes();
        this.BuscaTarifas();
        this.datosvi.recargoFijo = this.genSubs.VlookUp2IntInt(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.lstIdPlanSumaMin, this.datosvi.lstIdMonedaSumaMin, this.datosvi.lstRecFijo);
        this.datosvi.primaBAS = (double)this.datosvi.sumaBAS.intValue() * this.tarifaBAS / 1000.0;
        if (this.datosvi.selPASI.booleanValue()) {
            this.datosvi.primaPASI = (double)this.datosvi.sumaPASI.intValue() * this.tarifaPASI / 1000.0;
        } else {
            this.datosvi.primaPASI = 0.0;
            this.datosvi.sumaPASI = 0;
        }
        if (this.datosvi.selIMA.booleanValue()) {
            this.datosvi.primaIMA = (double)this.datosvi.sumaIMA.intValue() * this.tarifaIMA / 1000.0;
            this.datosvi.sumaDI = 0;
            this.datosvi.primaDI = 0.0;
            this.datosvi.sumaTI = 0;
            this.datosvi.primaTI = 0.0;
        } else {
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
        }
        if (this.datosvi.selDI.booleanValue()) {
            this.datosvi.primaDI = (double)this.datosvi.sumaDI.intValue() * this.tarifaDI / 1000.0;
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
            this.datosvi.sumaTI = 0;
            this.datosvi.primaTI = 0.0;
        } else {
            this.datosvi.primaDI = 0.0;
            this.datosvi.sumaDI = 0;
        }
        if (this.datosvi.selTI.booleanValue()) {
            this.datosvi.primaTI = (double)this.datosvi.sumaTI.intValue() * this.tarifaTI / 1000.0;
            this.datosvi.sumaDI = 0;
            this.datosvi.primaDI = 0.0;
            this.datosvi.sumaIMA = 0;
            this.datosvi.primaIMA = 0.0;
        } else {
            this.datosvi.primaTI = 0.0;
            this.datosvi.sumaTI = 0;
        }
        if (this.datosvi.selEG.booleanValue()) {
            this.datosvi.primaEG = (double)this.datosvi.sumaEG.intValue() * this.tarifaEG / 1000.0;
        } else {
            this.datosvi.primaEG = 0.0;
            this.datosvi.sumaEG = 0;
        }
        if (this.datosvi.selGF.booleanValue()) {
            this.datosvi.primaGF = (double)this.datosvi.sumaGF.intValue() * this.tarifaGF / 1000.0;
        } else {
            this.datosvi.primaGF = 0.0;
            this.datosvi.sumaGF = 0;
        }
        if (this.datosvi.selEP.booleanValue()) {
            this.datosvi.sumaEP = this.datosvi.primaBAS + (double)this.datosvi.recargoFijo.intValue();
            this.datosvi.primaEP = this.datosvi.sumaEP * this.tarifaEP / 100.0;
            this.tmpLong = Math.round(this.datosvi.primaEP * 100.0);
            this.datosvi.primaEP = this.tmpLong.doubleValue();
            this.datosvi.primaEP = this.datosvi.primaEP / 100.0;
        } else {
            this.datosvi.sumaEP = 0.0;
            this.datosvi.primaEP = 0.0;
        }
    }

    private void BuscaTarifas() {
        this.claveBAS = this.genSubs.VlookUp4IntStr(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.plazoSel, this.datosvi.indexRiesgo, this.datosvi.lstIdPlanClaves, this.datosvi.lstIdMonedaClaves, this.datosvi.lstPlazoClaves, this.datosvi.lstRiesgoClaves, this.datosvi.lstClavesBAS);
        this.claveEP = this.genSubs.VlookUp4IntStr(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.plazoSel, this.datosvi.indexRiesgo, this.datosvi.lstIdPlanClaves, this.datosvi.lstIdMonedaClaves, this.datosvi.lstPlazoClaves, this.datosvi.lstRiesgoClaves, this.datosvi.lstClavesEP);
        this.clavePASI = this.genSubs.VlookUp4IntStr(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.plazoSel, this.datosvi.indexRiesgo, this.datosvi.lstIdPlanClaves, this.datosvi.lstIdMonedaClaves, this.datosvi.lstPlazoClaves, this.datosvi.lstRiesgoClaves, this.datosvi.lstClavesPASI);
        this.claveEG = this.genSubs.VlookUp4IntStr(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.plazoSel, this.datosvi.indexRiesgo, this.datosvi.lstIdPlanClaves, this.datosvi.lstIdMonedaClaves, this.datosvi.lstPlazoClaves, this.datosvi.lstRiesgoClaves, this.datosvi.lstClavesEG);
        this.tarifaSH = this.genSubs.VlookUp4IntInt(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.plazoSel, this.datosvi.indexRiesgo, this.datosvi.lstIdPlanClaves, this.datosvi.lstIdMonedaClaves, this.datosvi.lstPlazoClaves, this.datosvi.lstRiesgoClaves, this.datosvi.lstTarifaSH);
        String clave = this.claveBAS;
        this.DeterminaEdadSexoTablasBAS();
        this.tarifaBAS = this.tablas.CargaTarifa(clave, this.edad, this.datosvi.banda, this.sexo, this.fuma);
        if (this.claveEP.equals("NA") || !this.datosvi.selEP.booleanValue()) {
            this.tarifaEP = 0.0;
        } else {
            clave = this.claveEP;
            this.edad = this.datosvi.edadReal;
            this.sexo = this.datosvi.sexo;
            this.fuma = this.datosvi.fuma;
            this.tarifaEP = this.tablas.CargaTarifa(clave, this.edad, 0, this.sexo, this.fuma);
        }
        clave = this.clavePASI;
        this.edad = this.datosvi.edadReal;
        this.sexo = this.datosvi.sexo;
        this.fuma = this.datosvi.fuma;
        this.tarifaPASI = this.datosvi.selPASI == false ? Double.valueOf(0.0) : this.tablas.CargaTarifa(clave, this.edad, 0, this.sexo, this.fuma);
        clave = this.claveEG;
        this.edad = this.datosvi.edadReal;
        if (!this.datosvi.selEG.booleanValue()) {
            this.tarifaGF = 0.0;
        } else {
            this.sexo = this.datosvi.sexo;
            this.fuma = this.datosvi.fuma;
            this.tarifaEG = this.tablas.CargaTarifa(clave, this.edad, 0, this.sexo, this.fuma);
        }
        if (!this.datosvi.selGF.booleanValue()) {
            this.tarifaGF = 0.0;
        } else {
            clave = "NGF01F";
            this.sexo = this.datosvi.sexo;
            this.fuma = this.datosvi.fuma;
            this.edad = this.datosvi.edadReal;
            this.tarifaGF = this.tablas.CargaTarifa(clave, this.edad, 0, this.sexo, this.fuma);
        }
    }

    private void TarifasConstantes() {
        this.tarifaIMA = 1.24;
        this.tarifaDI = 1.64;
        this.tarifaTI = 2.19;
        this.datosvi.lstBandaFlexi.clear();
        this.datosvi.lstBandaFlexi.add(499999);
        this.datosvi.lstBandaFlexi.add(999999);
        this.datosvi.lstBandaFlexi.add(1499999);
    }

    private void DeterminaEdadSexoTablasBAS() {
        this.edad = this.datosvi.plazoSel >= 50 ? this.datosvi.edadReal : (this.datosvi.indexRiesgo == 1 ? this.datosvi.edadReal : this.datosvi.edadCalculo);
        this.datosvi.banda = this.datosvi.idPlanSel == 31 ? Integer.valueOf(0) : (this.datosvi.indexRiesgo == 1 ? Integer.valueOf(4) : (this.datosvi.sumaBAS <= this.datosvi.lstBandaFlexi.get(0) ? Integer.valueOf(0) : (this.datosvi.sumaBAS <= this.datosvi.lstBandaFlexi.get(1) ? Integer.valueOf(1) : (this.datosvi.sumaBAS <= this.datosvi.lstBandaFlexi.get(2) ? Integer.valueOf(2) : Integer.valueOf(3)))));
        if (this.tarifaSH == 1) {
            this.sexo = this.datosvi.sexo;
            this.fuma = this.datosvi.fuma;
            this.edad = this.datosvi.edadReal;
        } else {
            this.sexo = "M";
            this.fuma = "S";
        }
    }

    public void ConstruyeCotizacion() {
        this.CargaParametros();
        this.Proyecta();
    }

    private void CargaParametros() {
        int i;
        this.claveBAS = this.genSubs.VlookUp4IntStr(this.datosvi.idPlanSel, this.datosvi.idMonedaSel, this.datosvi.plazoSel, this.datosvi.indexRiesgo, this.datosvi.lstIdPlanClaves, this.datosvi.lstIdMonedaClaves, this.datosvi.lstPlazoClaves, this.datosvi.lstRiesgoClaves, this.datosvi.lstClavesBAS);
        if (this.datosvi.idPlanSel == 31) {
            this.datosvi.recFijoMensual = 350.0;
            this.costoAdmin1 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadCalculo, "BAS", 0, 1, "M", "S");
            this.costoAdmin2 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadCalculo, "BAS", 0, 2, "M", "S");
            this.edadQX = this.datosvi.edadCalculo;
            this.edadCanEP = 0;
            this.edadCanPASI = 0;
            this.edadCanIMA = 0;
            this.edadCanDI = 0;
            this.edadCanTI = 0;
            this.edadCanEG = 0;
            this.anoCanEP = 0;
            this.anoCanPASI = 0;
            this.anoCanIMA = 0;
            this.anoCanDI = 0;
            this.anoCanTI = 0;
            this.anoCanEG = 0;
            this.anoCanGF = 0;
            this.qxBAS = this.tablas.CargaCoiFlexi(31, "BAS", 1, this.datosvi.sexo, this.datosvi.fuma);
            for (i = 0; i < 101; ++i) {
                this.qxEP[i] = 0.0;
                this.qxPASI[i] = 0.0;
                this.qxEG[i] = 0.0;
                this.qxGF[i] = 0.0;
            }
            this.qxIMA = 0.0;
            this.qxDI = 0.0;
            this.qxTI = 0.0;
            this.caEP1 = 0.0;
            this.caEP2 = 0.0;
            this.caPASI1 = 0.0;
            this.caPASI2 = 0.0;
            this.caIMA1 = 0.0;
            this.caIMA2 = 0.0;
            this.caDI1 = 0.0;
            this.caDI2 = 0.0;
            this.caTI1 = 0.0;
            this.caTI2 = 0.0;
            this.caEG1 = 0.0;
            this.caEG2 = 0.0;
            this.caGF1 = 0.0;
            this.caGF2 = 0.0;
        } else {
            this.datosvi.recFijoMensual = 75.0;
            this.costoAdmin1 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "BAS", this.datosvi.banda, 1, this.datosvi.sexo, this.datosvi.fuma);
            this.costoAdmin2 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "BAS", this.datosvi.banda, 2, this.datosvi.sexo, this.datosvi.fuma);
            this.edadQX = this.datosvi.edadReal;
            this.edadCanEP = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, this.datosvi.plazoSel, "EP", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.edadCanPASI = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, this.datosvi.plazoSel, "PASI", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.edadCanIMA = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, this.datosvi.plazoSel, "IMA", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.edadCanDI = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, this.datosvi.plazoSel, "DI", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.edadCanTI = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, this.datosvi.plazoSel, "TI", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.edadCanEG = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, this.datosvi.plazoSel, "EG", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.edadCanGF = this.genSubs.VlookUp2IntStrInt(this.datosvi.idPlanSel, 0, "GF", this.datosvi.lstIdPlanEdad, this.datosvi.lstPlazoEdad, this.datosvi.lstIdBeneficio, this.datosvi.lstEdadCan);
            this.anoCanEP = this.edadCanEP - this.datosvi.edadReal + 1;
            this.anoCanPASI = this.edadCanPASI - this.datosvi.edadReal + 1;
            this.anoCanIMA = this.edadCanIMA - this.datosvi.edadReal + 1;
            this.anoCanDI = this.edadCanDI - this.datosvi.edadReal + 1;
            this.anoCanTI = this.edadCanTI - this.datosvi.edadReal + 1;
            this.anoCanEG = this.edadCanEG - this.datosvi.edadReal + 1;
            this.anoCanGF = this.edadCanGF - this.datosvi.edadReal + 1;
            this.qxBAS = this.tablas.CargaCoiFlexi(32, "BAS", this.datosvi.indexRiesgo + 1, this.datosvi.sexo, this.datosvi.fuma);
            this.qxEP = this.tablas.CargaCoiFlexi(32, "EP", 0, this.datosvi.sexo, this.datosvi.fuma);
            this.qxPASI = this.tablas.CargaCoiFlexi(32, "PASI", 0, this.datosvi.sexo, this.datosvi.fuma);
            this.qxEG = this.tablas.CargaCoiFlexi(32, "EG", 0, this.datosvi.sexo, this.datosvi.fuma);
            this.qxGF = this.tablas.CargaCoiFlexi(32, "GF", 0, this.datosvi.sexo, this.datosvi.fuma);
            this.qxIMA = 0.0;
            this.qxDI = 0.0;
            this.qxTI = 0.0;
            this.caEP1 = 0.0;
            this.caEP2 = 0.0;
            if (this.datosvi.selEP.booleanValue()) {
                this.caEP1 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "EP", 0, 1, this.datosvi.sexo, this.datosvi.fuma);
                this.caEP2 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "EP", 0, 2, this.datosvi.sexo, this.datosvi.fuma);
            }
            this.caPASI1 = 0.0;
            this.caPASI2 = 0.0;
            if (this.datosvi.selPASI.booleanValue()) {
                this.caPASI1 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "PASI", 0, 1, this.datosvi.sexo, this.datosvi.fuma);
                this.caPASI2 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "PASI", 0, 2, this.datosvi.sexo, this.datosvi.fuma);
            }
            this.caIMA1 = 0.1;
            this.caIMA2 = 0.1;
            this.caDI1 = 0.14;
            this.caDI2 = 0.14;
            this.caTI1 = 0.18;
            this.caTI2 = 0.18;
            this.caEG1 = 0.0;
            this.caEG2 = 0.0;
            if (this.datosvi.selEG.booleanValue()) {
                this.caEG1 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "EG", 0, 1, this.datosvi.sexo, this.datosvi.fuma);
                this.caEG2 = this.tablas.CargaCostoAdmFlexi(this.claveBAS, this.datosvi.edadReal, "EG", 0, 2, this.datosvi.sexo, this.datosvi.fuma);
            }
            this.caGF2 = this.caGF1 = this.tablas.CargaCostoAdmFlexi("NUVA00", this.datosvi.edadReal, "GF", 0, 0, this.datosvi.sexo, this.datosvi.fuma);
        }
        this.costoRescate = this.tablas.CargaCostoRescateFlexi();
        this.datosvi.tasaInvAnual = this.tablas.CargaTasasFlexi();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.tasaInv[i][j] = Math.pow(1.0 + this.datosvi.tasaInvAnual[i][j], 0.08333333333333333) - 1.0;
            }
        }
        this.tasaTecnica = 0.045;
        this.tasaTecnicaMensual = Math.pow(1.0 + this.tasaTecnica, 0.08333333333333333) - 1.0;
        this.pmaBAS = this.datosvi.primaBAS + (double)this.datosvi.recargoFijo.intValue();
        this.pmaEP = this.datosvi.primaEP;
        this.pmaPASI = this.datosvi.primaPASI;
        this.pmaIMA = this.datosvi.primaIMA;
        this.pmaDI = this.datosvi.primaDI;
        this.pmaTI = this.datosvi.primaTI;
        this.pmaEG = this.datosvi.primaEG;
        this.pmaGF = this.datosvi.primaGF;
    }

    private void Proyecta() {
        int i;
        int tipo;
        int plan;
        int k;
        int j;
        int i2;
        Integer idMes = 0;
        Integer flag = 0;
        Integer auxMod = this.datosvi.indexFormaPago == 0 ? Integer.valueOf(12) : (this.datosvi.indexFormaPago == 1 ? Integer.valueOf(6) : (this.datosvi.indexFormaPago == 2 ? Integer.valueOf(3) : Integer.valueOf(1)));
        this.datosvi.anosSeguro = this.datosvi.plazoSel == 65 ? Integer.valueOf(65 - this.datosvi.edadReal) : this.datosvi.plazoSel;
        this.datosvi.mesesSeguro = this.datosvi.anosSeguro * 12;
        this.vecAno = new Integer[this.datosvi.mesesSeguro + 1];
        this.vecMes = new Integer[this.datosvi.mesesSeguro + 1];
        this.datosvi.primaFlexi = new Double[this.datosvi.mesesSeguro + 1];
        this.recargoFijo = new Double[this.datosvi.mesesSeguro + 1];
        this.primaBAS = new Double[this.datosvi.mesesSeguro + 1];
        this.primaEG = new Double[this.datosvi.mesesSeguro + 1];
        this.primaGF = new Double[this.datosvi.mesesSeguro + 1];
        this.costoAdmin = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguro = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroBAS = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroEP = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroPASI = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroIMA = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroDI = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroTI = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroEG = new Double[this.datosvi.mesesSeguro + 1];
        this.costoSeguroGF = new Double[this.datosvi.mesesSeguro + 1];
        this.intereses = new Double[this.datosvi.mesesSeguro + 1];
        this.castigo = new Double[this.datosvi.mesesSeguro + 1];
        this.datosvi.rescateFlexi = new Double[this.datosvi.mesesSeguro + 1];
        this.reservaSinIntereses = new Double[this.datosvi.mesesSeguro + 1];
        this.reservaConIntereses = new Double[this.datosvi.mesesSeguro + 1];
        this.costoAdminBAS = new Double[this.datosvi.mesesSeguro + 1];
        this.fondoBase = new Double[this.datosvi.mesesSeguro + 1];
        this.seguroPuro = new Double[this.datosvi.mesesSeguro + 1];
        this.aportacionTotal = new Double[3][6][this.datosvi.mesesSeguro + 1];
        this.rendimiento = new Double[3][6][this.datosvi.mesesSeguro + 1];
        this.datosvi.fondo = new Double[3][6][this.datosvi.mesesSeguro + 1];
        this.rendimientoAcu = new Double[3][6][this.datosvi.mesesSeguro + 1];
        this.aportacionAnual = new Double[3][6][this.datosvi.anosSeguro + 1];
        this.rendimientoAnual = new Double[3][6][this.datosvi.anosSeguro + 1];
        this.datosvi.aportacionAnualAcum = new Double[3][6][this.datosvi.anosSeguro + 1];
        this.datosvi.rendimientoAnualAcum = new Double[3][6][this.datosvi.anosSeguro + 1];
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 6; ++j) {
                for (k = 0; k < this.datosvi.mesesSeguro + 1; ++k) {
                    this.aportacionTotal[i2][j][k] = 0.0;
                    this.datosvi.fondo[i2][j][k] = 0.0;
                    this.rendimientoAcu[i2][j][k] = 0.0;
                }
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 6; ++j) {
                for (k = 0; k < this.datosvi.anosSeguro + 1; ++k) {
                    this.aportacionAnual[i2][j][k] = 0.0;
                    this.rendimientoAnual[i2][j][k] = 0.0;
                    this.datosvi.aportacionAnualAcum[i2][j][k] = 0.0;
                    this.datosvi.rendimientoAnualAcum[i2][j][k] = 0.0;
                }
            }
        }
        Integer edadActual = this.datosvi.edadReal - 1;
        Integer anoActual = 0;
        for (i2 = 1; i2 <= this.datosvi.mesesSeguro; ++i2) {
            Double[] j2;
            this.vecAno[i2] = (i2 - 1) / 12 + 1;
            if ((idMes = Integer.valueOf(idMes + 1)) > 12) {
                idMes = 1;
            }
            this.vecMes[i2] = idMes;
            if ((i2 - 1) % 12 == 0) {
                edadActual = edadActual + 1;
                anoActual = anoActual + 1;
            }
            if ((i2 - 1) % auxMod == 0) {
                if (this.datosvi.idPlanSel == 32) {
                    if (i2 >= 12 * this.anoCanEP - 11) {
                        this.pmaEP = 0.0;
                    }
                    if (i2 >= 12 * this.anoCanPASI - 11) {
                        this.pmaPASI = 0.0;
                    }
                    if (i2 >= 12 * this.anoCanIMA - 11) {
                        this.pmaIMA = 0.0;
                    }
                    if (i2 >= 12 * this.anoCanDI - 11) {
                        this.pmaDI = 0.0;
                    }
                    if (i2 >= 12 * this.anoCanTI - 11) {
                        this.pmaTI = 0.0;
                    }
                    if (i2 >= 12 * this.anoCanEG - 11) {
                        this.pmaEG = 0.0;
                    } else {
                        this.tarifaEG = this.tablas.CargaTarifa(this.claveEG, edadActual, 0, this.sexo, this.fuma);
                        this.pmaEG = (double)this.datosvi.sumaEG.intValue() * this.tarifaEG / 1000.0;
                    }
                    this.primaEG[i2] = this.pmaEG;
                    if (i2 >= 12 * this.anoCanGF - 11) {
                        this.pmaGF = 0.0;
                    } else {
                        this.tarifaGF = this.tablas.CargaTarifa("NGF01F", edadActual, 0, this.sexo, this.fuma);
                        this.pmaGF = (double)this.datosvi.sumaGF.intValue() * this.tarifaGF / 1000.0;
                    }
                    this.primaGF[i2] = this.pmaGF;
                } else {
                    this.pmaEP = 0.0;
                    this.pmaPASI = 0.0;
                    this.pmaIMA = 0.0;
                    this.pmaDI = 0.0;
                    this.pmaTI = 0.0;
                    this.pmaEG = 0.0;
                    this.pmaGF = 0.0;
                }
                Double primaTotalAno = this.pmaBAS + this.pmaEP + this.pmaPASI + this.pmaIMA + this.pmaDI + this.pmaTI + this.pmaEG + this.pmaGF;
                Double recargoAnual = this.datosvi.tasaRecargo * primaTotalAno;
                this.datosvi.primaFlexi[i2] = (primaTotalAno + recargoAnual) / (double)this.datosvi.numPagos.intValue();
                this.primaBAS[i2] = (this.pmaBAS + recargoAnual) / (double)this.datosvi.numPagos.intValue();
                if (i2 == 301) {
                    flag = 1;
                }
                Double saEP = this.pmaBAS;
            } else {
                this.datosvi.primaFlexi[i2] = 0.0;
                this.primaBAS[i2] = 0.0;
                this.primaEG[i2] = 0.0;
                this.primaGF[i2] = 0.0;
            }
            this.recargoFijo[i2] = this.datosvi.idPlanSel == 31 ? Double.valueOf((double)this.datosvi.recargoFijo.intValue() / 12.0) : this.datosvi.recFijoMensual;
            if (this.datosvi.idPlanSel == 32) {
                if (i2 >= 12 * this.anoCanEP - 11) {
                    this.caEP1 = 0.0;
                    this.caEP2 = 0.0;
                }
                if (i2 >= 12 * this.anoCanPASI - 11) {
                    this.caPASI1 = 0.0;
                    this.caPASI2 = 0.0;
                }
                if (i2 >= 12 * this.anoCanIMA - 11) {
                    this.caIMA1 = 0.0;
                    this.caIMA2 = 0.0;
                }
                if (i2 >= 12 * this.anoCanDI - 11) {
                    this.caDI1 = 0.0;
                    this.caDI2 = 0.0;
                }
                if (i2 >= 12 * this.anoCanTI - 11) {
                    this.caTI1 = 0.0;
                    this.caTI2 = 0.0;
                }
                if (i2 >= 12 * this.anoCanEG - 11) {
                    this.caEG1 = 0.0;
                    this.caEG2 = 0.0;
                }
                if (i2 >= 12 * this.anoCanGF - 11) {
                    this.caGF1 = 0.0;
                    this.caGF2 = 0.0;
                }
            } else {
                this.caEP1 = 0.0;
                this.caEP2 = 0.0;
                this.caPASI1 = 0.0;
                this.caPASI2 = 0.0;
                this.caIMA1 = 0.0;
                this.caIMA2 = 0.0;
                this.caDI1 = 0.0;
                this.caDI2 = 0.0;
                this.caTI1 = 0.0;
                this.caTI2 = 0.0;
                this.caEG1 = 0.0;
                this.caEG2 = 0.0;
                this.caGF1 = 0.0;
                this.caGF2 = 0.0;
            }
            if (i2 <= 12) {
                this.costoAdminBAS[i2] = this.costoAdmin1 * (double)this.datosvi.sumaBAS.intValue() / 1000.0;
                this.costoAdmin[i2] = this.costoAdmin1 * (double)this.datosvi.sumaBAS.intValue() / 1000.0;
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caEP1 * this.datosvi.sumaEP / 100.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caPASI1 * (double)this.datosvi.sumaPASI.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caIMA1 * (double)this.datosvi.sumaIMA.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caDI1 * (double)this.datosvi.sumaDI.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caTI1 * (double)this.datosvi.sumaTI.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caEG1 * (double)this.datosvi.sumaEG.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caGF1 * (double)this.datosvi.sumaGF.intValue() / 1000.0);
            } else {
                this.costoAdminBAS[i2] = this.costoAdmin2 * (double)this.datosvi.sumaBAS.intValue() / 1000.0;
                this.costoAdmin[i2] = this.costoAdmin2 * (double)this.datosvi.sumaBAS.intValue() / 1000.0;
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caEP2 * this.datosvi.sumaEP / 100.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caPASI2 * (double)this.datosvi.sumaPASI.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caIMA2 * (double)this.datosvi.sumaIMA.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caDI2 * (double)this.datosvi.sumaDI.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caTI2 * (double)this.datosvi.sumaTI.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caEG2 * (double)this.datosvi.sumaEG.intValue() / 1000.0);
                j2 = this.costoAdmin;
                k = i2;
                Double.valueOf(j2[k] + this.caGF2 * (double)this.datosvi.sumaGF.intValue() / 1000.0);
            }
            this.costoSeguroEP[i2] = 0.0;
            this.costoSeguroPASI[i2] = 0.0;
            this.costoSeguroIMA[i2] = 0.0;
            this.costoSeguroDI[i2] = 0.0;
            this.costoSeguroTI[i2] = 0.0;
            this.costoSeguroEG[i2] = 0.0;
            this.costoSeguroGF[i2] = 0.0;
            if (this.datosvi.idPlanSel == 32) {
                if (this.datosvi.selEP.booleanValue()) {
                    this.costoSeguroEP[i2] = this.qxEP[edadActual] * (this.primaBAS[i2] + this.recargoFijo[i2]) / 100.0;
                }
                if (this.datosvi.selPASI.booleanValue()) {
                    this.costoSeguroPASI[i2] = this.qxPASI[edadActual] * (double)this.datosvi.sumaPASI.intValue() / 1000.0;
                }
                if (this.datosvi.selIMA.booleanValue()) {
                    this.costoSeguroIMA[i2] = this.qxIMA * (double)this.datosvi.sumaIMA.intValue() / 1000.0;
                }
                if (this.datosvi.selDI.booleanValue()) {
                    this.costoSeguroDI[i2] = this.qxDI * (double)this.datosvi.sumaDI.intValue() / 1000.0;
                }
                if (this.datosvi.selTI.booleanValue()) {
                    this.costoSeguroTI[i2] = this.qxTI * (double)this.datosvi.sumaTI.intValue() / 1000.0;
                }
                if (this.datosvi.selEG.booleanValue()) {
                    this.costoSeguroEG[i2] = this.qxEG[edadActual] * (double)this.datosvi.sumaEG.intValue() / 1000.0;
                }
                if (this.datosvi.selGF.booleanValue()) {
                    this.costoSeguroGF[i2] = this.qxGF[edadActual] * (double)this.datosvi.sumaGF.intValue() / 1000.0;
                }
            }
            this.fondoBase[i2] = i2 == 1 ? (this.datosvi.idPlanSel == 32 ? Double.valueOf(this.datosvi.primaFlexi[i2] - this.costoAdmin[i2] - this.recargoFijo[i2]) : Double.valueOf(this.primaBAS[i2] - this.costoAdminBAS[i2] - this.recargoFijo[i2])) : (this.datosvi.idPlanSel == 32 ? Double.valueOf(this.datosvi.primaFlexi[i2] - this.costoAdmin[i2] - this.recargoFijo[i2] + this.reservaConIntereses[i2 - 1]) : Double.valueOf(this.primaBAS[i2] - this.costoAdminBAS[i2] - this.recargoFijo[i2] + this.reservaConIntereses[i2 - 1]));
            this.seguroPuro[i2] = this.datosvi.idPlanSel == 32 ? Double.valueOf((double)this.datosvi.sumaBAS.intValue() - this.fondoBase[i2]) : Double.valueOf((double)this.datosvi.sumaBAS.intValue() * 1.0);
            this.costoSeguroBAS[i2] = this.qxBAS[edadActual] * this.seguroPuro[i2] / 1000.0;
            this.costoSeguro[i2] = this.datosvi.idPlanSel == 32 ? Double.valueOf(this.costoSeguroBAS[i2] + this.costoSeguroEG[i2] + this.costoSeguroGF[i2]) : this.costoSeguroBAS[i2];
            this.reservaSinIntereses[i2] = i2 == 1 ? (this.datosvi.idPlanSel == 32 ? Double.valueOf(this.datosvi.primaFlexi[i2] - this.costoAdmin[i2] - this.recargoFijo[i2] - this.costoSeguro[i2]) : Double.valueOf(this.primaBAS[i2] - this.costoAdminBAS[i2] - this.recargoFijo[i2] - this.costoSeguro[i2])) : (this.datosvi.idPlanSel == 32 ? Double.valueOf(this.datosvi.primaFlexi[i2] - this.costoAdmin[i2] - this.recargoFijo[i2] + this.reservaConIntereses[i2 - 1] - this.costoSeguro[i2]) : Double.valueOf(this.primaBAS[i2] - this.costoAdminBAS[i2] - this.recargoFijo[i2] + this.reservaConIntereses[i2 - 1] - this.costoSeguro[i2]));
            this.intereses[i2] = this.reservaSinIntereses[i2] * this.tasaTecnicaMensual;
            this.reservaConIntereses[i2] = this.reservaSinIntereses[i2] + this.intereses[i2];
            double factorCastigo = i2 > 120 ? 0.0 : this.costoRescate[anoActual];
            this.castigo[i2] = this.reservaConIntereses[i2] * factorCastigo;
            this.datosvi.rescateFlexi[i2] = this.reservaConIntereses[i2] - this.castigo[i2];
            Integer mes = i2;
            Integer planIni = 0;
            Integer planFin = 2;
            for (int plan2 = planIni.intValue(); plan2 < planFin + 1; ++plan2) {
                for (int tipo2 = 0; tipo2 < 6; ++tipo2) {
                    if (mes == 1) {
                        this.aportacionTotal[plan2][tipo2][mes.intValue()] = this.datosvi.Aportacion[plan2][tipo2][0];
                    } else {
                        this.aportacionTotal[plan2][tipo2][mes.intValue()] = this.aportacionTotal[plan2][tipo2][mes] + this.datosvi.Aportacion[plan2][tipo2][1];
                        if ((mes - 1) % 3 == 0) {
                            this.aportacionTotal[plan2][tipo2][mes.intValue()] = this.aportacionTotal[plan2][tipo2][mes] + this.datosvi.Aportacion[plan2][tipo2][2];
                        }
                        if ((mes - 1) % 12 == 0) {
                            this.aportacionTotal[plan2][tipo2][mes.intValue()] = this.aportacionTotal[plan2][tipo2][mes] + this.datosvi.Aportacion[plan2][tipo2][3];
                        }
                    }
                    if (mes == 1) {
                        this.rendimiento[plan2][tipo2][mes.intValue()] = this.aportacionTotal[plan2][tipo2][mes] * this.tasaInv[plan2][tipo2];
                        this.datosvi.fondo[plan2][tipo2][mes.intValue()] = this.aportacionTotal[plan2][tipo2][mes] + this.rendimiento[plan2][tipo2][mes];
                        this.rendimientoAcu[plan2][tipo2][mes.intValue()] = this.rendimiento[plan2][tipo2][mes];
                        continue;
                    }
                    this.rendimiento[plan2][tipo2][mes.intValue()] = (this.datosvi.fondo[plan2][tipo2][mes - 1] + this.aportacionTotal[plan2][tipo2][mes]) * this.tasaInv[plan2][tipo2];
                    this.datosvi.fondo[plan2][tipo2][mes.intValue()] = this.datosvi.fondo[plan2][tipo2][mes - 1] + this.aportacionTotal[plan2][tipo2][mes] + this.rendimiento[plan2][tipo2][mes];
                    this.rendimientoAcu[plan2][tipo2][mes.intValue()] = this.rendimientoAcu[plan2][tipo2][mes - 1] + this.rendimiento[plan2][tipo2][mes];
                }
            }
        }
        for (plan = 0; plan < 3; ++plan) {
            for (tipo = 0; tipo < 6; ++tipo) {
                for (i = 1; i <= this.datosvi.anosSeguro; ++i) {
                    for (int j3 = (i - 1) * 12 + 1; j3 <= i * 12; ++j3) {
                        this.aportacionAnual[plan][tipo][i] = this.aportacionAnual[plan][tipo][i] + this.aportacionTotal[plan][tipo][j3];
                        this.rendimientoAnual[plan][tipo][i] = this.rendimientoAnual[plan][tipo][i] + this.rendimiento[plan][tipo][j3];
                    }
                }
            }
        }
        for (plan = 0; plan < 3; ++plan) {
            for (tipo = 0; tipo < 6; ++tipo) {
                for (i = 1; i <= this.datosvi.anosSeguro; ++i) {
                    if (i == 1) {
                        this.datosvi.aportacionAnualAcum[plan][tipo][i] = this.aportacionAnual[plan][tipo][i];
                        this.datosvi.rendimientoAnualAcum[plan][tipo][i] = this.rendimientoAnual[plan][tipo][i];
                        continue;
                    }
                    this.datosvi.aportacionAnualAcum[plan][tipo][i] = this.datosvi.aportacionAnualAcum[plan][tipo][i - 1] + this.aportacionAnual[plan][tipo][i];
                    this.datosvi.rendimientoAnualAcum[plan][tipo][i] = this.datosvi.rendimientoAnualAcum[plan][tipo][i - 1] + this.rendimientoAnual[plan][tipo][i];
                }
            }
        }
        if (this.datosvi.conMemoriaFlexi.booleanValue()) {
            this.ConstruyeArchivo();
            this.EliminaArchivoAnterior();
            if (!this.errorArchivo.booleanValue()) {
                this.EscribeArchivo();
            }
        }
    }

    private void ConstruyeArchivo() {
        this.renMemoria.clear();
        this.txtMemoria = "A\u00f1o,";
        this.txtMemoria = this.txtMemoria + "Mes,";
        this.txtMemoria = this.txtMemoria + "prima,";
        this.txtMemoria = this.txtMemoria + "recargoFijo,";
        this.txtMemoria = this.txtMemoria + "primaBas,";
        this.txtMemoria = this.txtMemoria + "primaEG,";
        this.txtMemoria = this.txtMemoria + "primaGF,";
        this.txtMemoria = this.txtMemoria + "costoAdmin,";
        this.txtMemoria = this.txtMemoria + "costoSeguro,";
        this.txtMemoria = this.txtMemoria + "costoSeguroBAS,";
        this.txtMemoria = this.txtMemoria + "costoSeguroEP,";
        this.txtMemoria = this.txtMemoria + "costoSeguroPASI,";
        this.txtMemoria = this.txtMemoria + "costoSeguroIMA,";
        this.txtMemoria = this.txtMemoria + "costoSeguroDI,";
        this.txtMemoria = this.txtMemoria + "costoSeguroTI,";
        this.txtMemoria = this.txtMemoria + "costoSeguroEG,";
        this.txtMemoria = this.txtMemoria + "costoSeguroGF,";
        this.txtMemoria = this.txtMemoria + "intereses,";
        this.txtMemoria = this.txtMemoria + "castigo,";
        this.txtMemoria = this.txtMemoria + "rescate,";
        this.txtMemoria = this.txtMemoria + "reservaSinIntereses,";
        this.txtMemoria = this.txtMemoria + "reservaConIntereses,";
        this.txtMemoria = this.txtMemoria + "costoAdminBAS,";
        this.txtMemoria = this.txtMemoria + "fondoBase,";
        this.txtMemoria = this.txtMemoria + "seguroPuro,";
        this.txtMemoria = this.txtMemoria + "pprAptDiaria,";
        this.txtMemoria = this.txtMemoria + "pprAptMensual,";
        this.txtMemoria = this.txtMemoria + "pprAptTrimestral,";
        this.txtMemoria = this.txtMemoria + "pprAptSemestral,";
        this.txtMemoria = this.txtMemoria + "pprAptDiariaDls,";
        this.txtMemoria = this.txtMemoria + "pprAptMensualDls,";
        this.txtMemoria = this.txtMemoria + "cpeaAptDiaria,";
        this.txtMemoria = this.txtMemoria + "cpeaAptMensual,";
        this.txtMemoria = this.txtMemoria + "cpeaAptTrimestral,";
        this.txtMemoria = this.txtMemoria + "cpeaAptSemestral,";
        this.txtMemoria = this.txtMemoria + "cpeaAptDiariaDls,";
        this.txtMemoria = this.txtMemoria + "cpeaAptMensualDls,";
        this.txtMemoria = this.txtMemoria + "AhoAptDiaria,";
        this.txtMemoria = this.txtMemoria + "AhoAptMensual,";
        this.txtMemoria = this.txtMemoria + "AhoAptTrimestral,";
        this.txtMemoria = this.txtMemoria + "AhoAptSemestral,";
        this.txtMemoria = this.txtMemoria + "AhoAptDiariaDls,";
        this.txtMemoria = this.txtMemoria + "AhoAptMensualDls,";
        this.txtMemoria = this.txtMemoria + "pprRndDiaria,";
        this.txtMemoria = this.txtMemoria + "pprRndMensual,";
        this.txtMemoria = this.txtMemoria + "pprRndTrimestral,";
        this.txtMemoria = this.txtMemoria + "pprRndSemestral,";
        this.txtMemoria = this.txtMemoria + "pprRndDiariaDls,";
        this.txtMemoria = this.txtMemoria + "pprRndMensualDls,";
        this.txtMemoria = this.txtMemoria + "cpeaRndDiaria,";
        this.txtMemoria = this.txtMemoria + "cpeaRndMensual,";
        this.txtMemoria = this.txtMemoria + "cpeaRndTrimestral,";
        this.txtMemoria = this.txtMemoria + "cpeaRndSemestral,";
        this.txtMemoria = this.txtMemoria + "cpeaRndDiariaDls,";
        this.txtMemoria = this.txtMemoria + "cpeaRndMensualDls,";
        this.txtMemoria = this.txtMemoria + "AhoRndDiaria,";
        this.txtMemoria = this.txtMemoria + "AhoRndMensual,";
        this.txtMemoria = this.txtMemoria + "AhoRndTrimestral,";
        this.txtMemoria = this.txtMemoria + "AhoRndSemestral,";
        this.txtMemoria = this.txtMemoria + "AhoRndDiariaDls,";
        this.txtMemoria = this.txtMemoria + "AhoRndMensualDls,";
        this.txtMemoria = this.txtMemoria + "pprFdoDiaria,";
        this.txtMemoria = this.txtMemoria + "pprFdoMensual,";
        this.txtMemoria = this.txtMemoria + "pprFdoTrimestral,";
        this.txtMemoria = this.txtMemoria + "pprFdoSemestral,";
        this.txtMemoria = this.txtMemoria + "pprFdoDiariaDls,";
        this.txtMemoria = this.txtMemoria + "pprFdoMensualDls,";
        this.txtMemoria = this.txtMemoria + "cpeaFdoDiaria,";
        this.txtMemoria = this.txtMemoria + "cpeaFdoMensual,";
        this.txtMemoria = this.txtMemoria + "cpeaFdoTrimestral,";
        this.txtMemoria = this.txtMemoria + "cpeaFdoSemestral,";
        this.txtMemoria = this.txtMemoria + "cpeaFdoDiariaDls,";
        this.txtMemoria = this.txtMemoria + "cpeaFdoMensualDls,";
        this.txtMemoria = this.txtMemoria + "AhoFdoDiaria,";
        this.txtMemoria = this.txtMemoria + "AhoFdoMensual,";
        this.txtMemoria = this.txtMemoria + "AhoFdoTrimestral,";
        this.txtMemoria = this.txtMemoria + "AhoFdoSemestral,";
        this.txtMemoria = this.txtMemoria + "AhoFdoDiariaDls,";
        this.txtMemoria = this.txtMemoria + "AhoFdoMensualDls,";
        this.renMemoria.add(this.txtMemoria + "\n");
        this.txtMemoria = "";
        Integer mes = 0;
        for (int i = 1; i <= this.datosvi.mesesSeguro; ++i) {
            this.txtMemoria = "";
            this.AgregaDatoInteger(this.vecAno[i]);
            mes = (i - 1) % 12 == 0 ? Integer.valueOf(1) : Integer.valueOf(mes + 1);
            this.AgregaDatoInteger(mes);
            this.AgregaDatoDouble(this.datosvi.primaFlexi[i]);
            this.AgregaDatoDouble(this.recargoFijo[i]);
            this.AgregaDatoDouble(this.primaBAS[i]);
            this.AgregaDatoDouble(this.primaEG[i]);
            this.AgregaDatoDouble(this.primaGF[i]);
            this.AgregaDatoDouble(this.costoAdmin[i]);
            this.AgregaDatoDouble(this.costoSeguro[i]);
            this.AgregaDatoDouble(this.costoSeguroBAS[i]);
            this.AgregaDatoDouble(this.costoSeguroEP[i]);
            this.AgregaDatoDouble(this.costoSeguroPASI[i]);
            this.AgregaDatoDouble(this.costoSeguroIMA[i]);
            this.AgregaDatoDouble(this.costoSeguroDI[i]);
            this.AgregaDatoDouble(this.costoSeguroTI[i]);
            this.AgregaDatoDouble(this.costoSeguroEG[i]);
            this.AgregaDatoDouble(this.costoSeguroGF[i]);
            this.AgregaDatoDouble(this.intereses[i]);
            this.AgregaDatoDouble(this.castigo[i]);
            this.AgregaDatoDouble(this.datosvi.rescateFlexi[i]);
            this.AgregaDatoDouble(this.reservaSinIntereses[i]);
            this.AgregaDatoDouble(this.reservaConIntereses[i]);
            this.AgregaDatoDouble(this.costoAdminBAS[i]);
            this.AgregaDatoDouble(this.fondoBase[i]);
            this.AgregaDatoDouble(this.seguroPuro[i]);
            this.AgregaDatoDouble(this.aportacionTotal[0][0][i]);
            this.AgregaDatoDouble(this.aportacionTotal[0][1][i]);
            this.AgregaDatoDouble(this.aportacionTotal[0][2][i]);
            this.AgregaDatoDouble(this.aportacionTotal[0][3][i]);
            this.AgregaDatoDouble(this.aportacionTotal[0][4][i]);
            this.AgregaDatoDouble(this.aportacionTotal[0][5][i]);
            this.AgregaDatoDouble(this.aportacionTotal[1][0][i]);
            this.AgregaDatoDouble(this.aportacionTotal[1][1][i]);
            this.AgregaDatoDouble(this.aportacionTotal[1][2][i]);
            this.AgregaDatoDouble(this.aportacionTotal[1][3][i]);
            this.AgregaDatoDouble(this.aportacionTotal[1][4][i]);
            this.AgregaDatoDouble(this.aportacionTotal[1][5][i]);
            this.AgregaDatoDouble(this.aportacionTotal[2][0][i]);
            this.AgregaDatoDouble(this.aportacionTotal[2][1][i]);
            this.AgregaDatoDouble(this.aportacionTotal[2][2][i]);
            this.AgregaDatoDouble(this.aportacionTotal[2][3][i]);
            this.AgregaDatoDouble(this.aportacionTotal[2][4][i]);
            this.AgregaDatoDouble(this.aportacionTotal[2][5][i]);
            this.AgregaDatoDouble(this.rendimiento[0][0][i]);
            this.AgregaDatoDouble(this.rendimiento[0][1][i]);
            this.AgregaDatoDouble(this.rendimiento[0][2][i]);
            this.AgregaDatoDouble(this.rendimiento[0][3][i]);
            this.AgregaDatoDouble(this.rendimiento[0][4][i]);
            this.AgregaDatoDouble(this.rendimiento[0][5][i]);
            this.AgregaDatoDouble(this.rendimiento[1][0][i]);
            this.AgregaDatoDouble(this.rendimiento[1][1][i]);
            this.AgregaDatoDouble(this.rendimiento[1][2][i]);
            this.AgregaDatoDouble(this.rendimiento[1][3][i]);
            this.AgregaDatoDouble(this.rendimiento[1][4][i]);
            this.AgregaDatoDouble(this.rendimiento[1][5][i]);
            this.AgregaDatoDouble(this.rendimiento[2][0][i]);
            this.AgregaDatoDouble(this.rendimiento[2][1][i]);
            this.AgregaDatoDouble(this.rendimiento[2][2][i]);
            this.AgregaDatoDouble(this.rendimiento[2][3][i]);
            this.AgregaDatoDouble(this.rendimiento[2][4][i]);
            this.AgregaDatoDouble(this.rendimiento[2][5][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[0][0][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[0][1][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[0][2][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[0][3][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[0][4][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[0][5][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[1][0][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[1][1][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[1][2][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[1][3][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[1][4][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[1][5][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[2][0][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[2][1][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[2][2][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[2][3][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[2][4][i]);
            this.AgregaDatoDouble(this.datosvi.fondo[2][5][i]);
            this.renMemoria.add(this.txtMemoria + "\n");
        }
    }

    private void AgregaDatoInteger(Integer datoInt) {
        this.txtMemoria = this.txtMemoria + Integer.toString(datoInt) + ",";
    }

    private void AgregaDatoDouble(Double datoDouble) {
        this.txtMemoria = this.txtMemoria + Double.toString(datoDouble) + ",";
    }

    private void EliminaArchivoAnterior() {
        this.nombreArchivo = "MemoriaCalculoFlexiLife.csv";
        this.errorArchivo = false;
        this.rutaUser = System.getProperty("user.home") + File.separator + this.nombreArchivo;
        this.pathArchivo = Paths.get(this.rutaUser, new String[0]);
        if (Files.exists(this.pathArchivo, new LinkOption[0])) {
            try {
                Files.delete(this.pathArchivo);
            }
            catch (IOException x) {
                System.err.println(x);
                this.genSubs.MuestraMensaje("Por favor cierre el archivo anterior creado");
                this.errorArchivo = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EscribeArchivo() {
        BufferedWriter bufferWriter = null;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.rutaUser);
            bufferWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i <= this.datosvi.mesesSeguro; ++i) {
                bufferWriter.write(this.renMemoria.get(i));
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            try {
                if (bufferWriter != null) {
                    bufferWriter.close();
                }
                if (bufferWriter != null) {
                    bufferWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

