/*
 * Decompiled with CFR 0.152.
 */
public class CalculosGM {
    Integer sumaAsegurada;
    String sexo;
    Integer edad;
    Double tarifaBaseNal;
    Double tarifaBaseExt;
    Double facSumaNal;
    Double facSumaExt;
    Double facDedNal;
    Double facDedExt;
    Double facCoasNal;
    Double facCoasExt;
    Double facRegion;
    Double facIncTabulador;
    Double primaTotalAseg;
    Double primaBasica;
    Double primaBasicaExt;
    Double primaMetDental;
    Double primaMetDentalPlus;
    Double primaVision;
    Double primaEmExt;
    Double primaEnfCatExt;
    Double primaDedCero;
    Double primaFranjaFronteriza;
    Double primaPG;
    Double primaConvInstitucional;
    Double primaConvColectivo;
    Double primaIncSuma;
    Double primaEstExt;
    Double primaAsistencia;
    Double primaRD;
    Double primaUG;
    Double primaMA;
    private static CalculosGM calculosgm = new CalculosGM();
    private DatosGM datosgm = DatosGM.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();

    private CalculosGM() {
    }

    public static CalculosGM getInstance() {
        return calculosgm;
    }

    public void CalculaPrimas() {
        this.sumaAsegurada = this.datosgm.lstSumaAseg.get(this.datosgm.indexSuma);
        this.datosgm.primaNeta = 0.0;
        for (int i = 0; i < this.datosgm.listaAseg.size(); ++i) {
            this.primaTotalAseg = 0.0;
            this.sexo = ((Aseg)this.datosgm.listaAseg.get(i)).getSexoAseg();
            this.edad = Integer.parseInt(((Aseg)this.datosgm.listaAseg.get(i)).getEdadAseg());
            this.primaBasica = 0.0;
            this.primaBasicaExt = 0.0;
            this.primaMetDentalPlus = 0.0;
            this.primaVision = 0.0;
            this.primaEmExt = 0.0;
            this.primaEnfCatExt = 0.0;
            this.primaDedCero = 0.0;
            this.primaFranjaFronteriza = 0.0;
            this.primaPG = 0.0;
            this.primaConvInstitucional = 0.0;
            this.primaConvColectivo = 0.0;
            this.primaIncSuma = 0.0;
            this.primaEstExt = 0.0;
            this.primaMA = 0.0;
            this.primaRD = 0.0;
            this.primaUG = 0.0;
            this.PrimaBasica();
            this.primaMetDental = this.datosgm.tarMetDental;
            this.primaAsistencia = this.datosgm.asistenciaViajes;
            if (this.datosgm.selDentalPlus.booleanValue()) {
                this.primaMetDentalPlus = this.datosgm.tarMetDentalPlus;
            }
            if (this.datosgm.selVision.booleanValue()) {
                this.primaVision = this.datosgm.tarVision;
            }
            if (this.datosgm.selEmergencia.booleanValue()) {
                this.primaEmExt = this.datosgm.zonaSel.equals("A") ? this.datosgm.tarEmExtA : (this.datosgm.zonaSel.equals("B") ? this.datosgm.tarEmExtB : this.datosgm.tarEmExtC);
            }
            if (this.datosgm.selCatastroficas.booleanValue()) {
                this.primaEnfCatExt = this.datosgm.enfCatExtranjero;
            }
            if (this.datosgm.selDeducibleCero.booleanValue()) {
                this.primaDedCero = this.datosgm.reduccionDedAcc;
            }
            if (this.datosgm.selFranjaFronteriza.booleanValue()) {
                this.primaFranjaFronteriza = this.datosgm.tarFranjaFronteriza * this.primaBasica;
            }
            if (this.datosgm.selPG.booleanValue()) {
                this.primaPG = this.datosgm.tarPG * this.primaBasica;
            }
            if (this.datosgm.selConversionPG.booleanValue()) {
                this.primaConvInstitucional = this.datosgm.tarConvInstitucional * this.primaBasica;
            }
            if (this.datosgm.selConversionCol.booleanValue()) {
                this.primaConvColectivo = this.datosgm.tarConvColectivo * this.primaBasica;
            }
            if (this.datosgm.selIncSuma.booleanValue()) {
                this.primaIncSuma = this.datosgm.indexPlan == 0 ? Double.valueOf(this.datosgm.tarIncrementoSumaNal * this.primaBasica) : Double.valueOf(this.datosgm.tarIncrementoSumaExt * this.primaBasica);
            }
            if (this.datosgm.selEstudiantesExtranjero.booleanValue()) {
                this.primaEstExt = this.datosgm.zonaSel.equals("A") ? this.datosgm.tarEstExtA : (this.datosgm.zonaSel.equals("B") ? this.datosgm.tarEstExtB : this.datosgm.tarEstExtC);
            }
            if (this.datosgm.selRD.booleanValue() && this.edad <= this.datosgm.edadMaxRD && this.edad > 0) {
                this.primaRD = this.tablas.CargaTarifaRD(this.edad, this.sexo) * (double)this.datosgm.lstSumaRD.get(this.datosgm.indexRentaDiaria).intValue();
            }
            if (this.datosgm.selUG.booleanValue() && this.edad <= this.datosgm.edadMaxUG) {
                this.primaUG = this.tablas.CargaTarifaUltimosGastos(this.edad) * (double)this.datosgm.lstSumaUG.get(this.datosgm.indexUltimosGastos).intValue() / 1000.0;
            }
            if (this.datosgm.selMA.booleanValue() && this.edad <= this.datosgm.edadMaxAccidentes) {
                this.primaMA = this.datosgm.tarMuerteAcc * (double)this.datosgm.lstSumaMA.get(this.datosgm.indexMuerteAccidental).intValue() / 1000.0;
            }
            this.primaTotalAseg = this.primaBasica + this.primaBasicaExt + this.primaMetDental + this.primaAsistencia + this.primaMetDentalPlus + this.primaVision + this.primaEmExt;
            this.primaTotalAseg = this.primaTotalAseg + (this.primaEnfCatExt + this.primaDedCero + this.primaFranjaFronteriza + this.primaConvInstitucional + this.primaIncSuma);
            this.primaTotalAseg = this.primaTotalAseg + (this.primaEstExt + this.primaRD + this.primaUG + this.primaMA);
            ((Aseg)this.datosgm.listaAseg.get(i)).setPrimaAseg(this.genSubs.FormatoNumDouble("###,###.00", this.primaTotalAseg));
            DatosGM datosGM = this.datosgm;
            Double.valueOf(datosGM.primaNeta + this.primaTotalAseg);
            datosGM.primaNeta = datosGM.primaNeta;
        }
    }

    private void PrimaBasica() {
        this.tarifaBaseNal = this.sexo.equals("M") ? this.datosgm.lstTarNalHombres.get(this.edad) : this.datosgm.lstTarNalMujeres.get(this.edad);
        this.facSumaNal = this.datosgm.lstFacSumaNal.get(this.datosgm.indexSuma);
        this.facDedNal = this.datosgm.lstFacDedNal.get(this.datosgm.indexDedNal);
        this.facCoasNal = this.datosgm.lstFacCoasNal.get(this.datosgm.indexCoasNal);
        this.facRegion = this.tablas.FactorRegion(this.datosgm.indexPlan, this.datosgm.regionSel);
        this.facIncTabulador = this.datosgm.lstFacIncTabulador.get(this.datosgm.indexIncTabulador);
        this.primaBasica = this.tarifaBaseNal * this.facSumaNal * this.facDedNal * this.facCoasNal * this.facRegion * this.facIncTabulador;
        if (this.datosgm.indexPlan == 0) {
            this.tarifaBaseExt = this.sexo.equals("M") ? this.datosgm.lstTarExtHombres.get(this.edad) : this.datosgm.lstTarExtMujeres.get(this.edad);
            this.facSumaExt = this.datosgm.lstFacSumaExt.get(this.datosgm.indexSuma);
            this.facDedExt = this.datosgm.lstFacDedExt.get(this.datosgm.indexDedExt);
            this.facCoasExt = this.facCoasNal;
            this.primaBasicaExt = this.tarifaBaseExt * this.facSumaExt * this.facDedExt * this.facCoasExt;
        }
    }
}

