/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.stage.Stage;

public class InicioController
implements Initializable {
    private DatosVI datosvi = DatosVI.getInstance();
    private Datos datos = Datos.getInstance();
    private DatosGM datosgm = DatosGM.getInstance();
    private DatosPrimor datosPrimor = DatosPrimor.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    @FXML
    Label lblMetaLife;
    @FXML
    Label lblHorizonte;
    @FXML
    Label lblEducaLife;
    @FXML
    Label lblPerfectLife;
    @FXML
    Label lblTotaLife;
    @FXML
    Label lblTempoLife;
    @FXML
    Label lblTempoLifeGS;
    @FXML
    Label lblTempoLifePref;
    @FXML
    Label lblMetaRep;
    @FXML
    Label lblFlexiSuenos;
    @FXML
    Label lblFlexiInver;
    @FXML
    Label lblMedicaLife;
    @FXML
    Label lblPrimordial;
    @FXML
    Label lblMetPlus;
    @FXML
    Label lblCombina;
    @FXML
    Label lblVersion;
    @FXML
    Button btnPersonaliza;
    String idTexto;
    String textoSubrayado;
    String textoNoSubrayado;
    Stage stage;
    Parent root;

    @FXML
    public void initialize(URL url, ResourceBundle rb) {
        this.ValoresIniciales();
        this.datosvi.combinaPlanes = false;
        this.InicializaVentana();
    }

    public void CombinasPlanes() {
        this.datosvi.planSel = "TotaLife";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 2;
        this.datosvi.combinaPlanes = true;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void TotaLife() {
        this.datosvi.planSel = "TotaLife";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 2;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void TempoLife() {
        this.datosvi.planSel = "TempoLife";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 1;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void TempoLifeGS() {
        this.datosvi.planSel = "TempoLife Grandes Sumas";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 1;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void TempoLifePreferente() {
        this.datosvi.planSel = "TempoLife Preferente";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 1;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void PerfectLife() {
        this.datosvi.planSel = "PerfectLife";
        this.datosvi.prodSel = "Ahorro";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 2;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void Horizonte() {
        this.datosvi.planSel = "Horizonte";
        this.datosvi.prodSel = "Retiro";
        this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        this.datosvi.idMonedaSel = 2;
        this.MuestraInfo("Coberturas.fxml");
    }

    public void EducaLife() {
        this.datosvi.planSel = "EducaLife";
        this.MuestraInfo("CobEduca.fxml");
    }

    public void MetaLife() {
        this.datosvi.planSel = "MetaLife";
        this.datosvi.prodSel = "MetaLife";
        this.datos.reproyectaMetaLife = false;
        this.datos.conAcompa\u00f1amiento = false;
        this.MuestraInfo("MetaLife.fxml");
        this.datosPrimor.combinaPrimordial = false;
    }

    public void FlexiInver() {
        this.datosvi.planSel = "FlexiLife Inversi\u00f3n";
        this.datosvi.prodSel = "FlexiLife";
        this.datosvi.idPlanSel = 31;
        this.datosvi.plazoSel = 10;
        this.ValoresInicialesFlexi();
        this.MuestraInfo("FlexiCob.fxml");
    }

    public void FlexiSuenos() {
        this.datosvi.planSel = "FlexiLife Sue\u00f1os";
        this.datosvi.prodSel = "FlexiLife";
        this.datosvi.idPlanSel = 32;
        this.datosvi.plazoSel = 10;
        this.ValoresInicialesFlexi();
        this.MuestraInfo("FlexiCob.fxml");
    }

    public void MedicaLife() {
        this.datosvi.planSel = "MedicaLife";
        this.datosvi.prodSel = "MedicaLife";
        this.ValoresInicialesMedicaLife();
        this.MuestraInfo("MedicaCob.fxml");
    }

    public void Primordial() {
        this.datosvi.planSel = "Primordial";
        this.datosvi.prodSel = "Primordial";
        this.ValoresInicialesPrimordial();
        this.MuestraInfo("PrimorCob.fxml");
    }

    public void MetPlus() {
        this.datosvi.planSel = "MetPlus";
        this.datosvi.prodSel = "MetPlus";
        this.MuestraInfo("MetPlusCob.fxml");
    }

    public void MetaRep() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.datosvi.planSel = "MetaLife";
        this.datosvi.prodSel = "MetaLife";
        this.datos.reproyectaMetaLife = true;
        this.datos.optOpcionCalculo = "Suma";
        this.MuestraVentana("MetaRep.fxml");
    }

    private void MuestraInfo(String nombreVentana) {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        if (this.datosvi.planSel == "EducaLife") {
            this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt("B\u00e1sico EducaLife", this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        } else {
            this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        }
        this.MuestraVentana(nombreVentana);
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            this.stage.setResizable(true);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println(e2 + "...No pudo cargar ventana");
        }
    }

    public void MuestraEtiquetaMetaLife() {
        this.OcultaEtiquetas();
        this.lblMetaLife.setVisible(true);
        this.lblMetaRep.setVisible(true);
    }

    public void MuestraEtiquetaHorizonte() {
        this.OcultaEtiquetas();
        this.lblHorizonte.setVisible(true);
    }

    public void MuestraEtiquetaEducaLife() {
        this.OcultaEtiquetas();
        this.lblEducaLife.setVisible(true);
    }

    public void MuestraEtiquetaPerfectLife() {
        this.OcultaEtiquetas();
        this.lblPerfectLife.setVisible(true);
    }

    public void MuestraEtiquetasProteccion() {
        this.OcultaEtiquetas();
        this.datosvi.prodSel = "Proteccion";
        this.lblTotaLife.setVisible(true);
        this.lblTempoLife.setVisible(true);
        this.lblTempoLifeGS.setVisible(true);
        this.lblTempoLifePref.setVisible(true);
    }

    public void MuestraEtiquetasFlexi() {
        this.OcultaEtiquetas();
        this.datosvi.prodSel = "FlexiLife";
        this.lblFlexiSuenos.setVisible(true);
        this.lblFlexiInver.setVisible(true);
    }

    public void MuestraEtiquetasGMM() {
        this.OcultaEtiquetas();
        this.lblMedicaLife.setVisible(true);
        this.lblPrimordial.setVisible(true);
        this.lblMetPlus.setVisible(false);
    }

    private void OcultaEtiquetas() {
        this.lblMetaLife.setVisible(false);
        this.lblMetaRep.setVisible(false);
        this.lblHorizonte.setVisible(false);
        this.lblEducaLife.setVisible(false);
        this.lblPerfectLife.setVisible(false);
        this.lblPerfectLife.setVisible(false);
        this.lblTotaLife.setVisible(false);
        this.lblTempoLife.setVisible(false);
        this.lblTempoLifeGS.setVisible(false);
        this.lblTempoLifePref.setVisible(false);
        this.lblFlexiSuenos.setVisible(false);
        this.lblFlexiInver.setVisible(false);
        this.lblMedicaLife.setVisible(false);
        this.lblPrimordial.setVisible(false);
        this.lblMetPlus.setVisible(false);
    }

    private void ValoresIniciales() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.btnPersonaliza.setVisible(true);
        this.datosvi.nombreTitular = "Nombre del titular";
        this.lblCombina.setVisible(false);
        this.OcultaEtiquetas();
        LocalDateTime now = LocalDateTime.now();
        this.datos.anoCambio = now.getYear();
        this.datos.mesCambio = now.getMonthValue();
        this.datos.diaCambio = now.getDayOfMonth();
        this.datos.anoInicial = this.datos.anoCambio;
        this.datos.mesInicial = this.datos.mesCambio;
        this.datos.diaInicial = this.datos.diaCambio;
        this.datos.fechaCambio = LocalDate.of((int)this.datos.anoCambio, this.datos.mesCambio, (int)this.datos.diaCambio);
        this.datos.vigenciaInicial = LocalDate.of((int)this.datos.anoInicial, this.datos.mesInicial, (int)this.datos.diaInicial);
        this.datos.fechaNuevosRecargos = LocalDate.of(2019, 4, 1);
        this.datos.sumaOriginal = 0.0;
        this.datos.sumaNueva = 0.0;
        this.datos.fondoBasActual = 0.0;
        this.datos.fondoAdiActual = 0.0;
        this.datos.conAcompa\u00f1amiento = false;
        this.datosPrimor.combinaPrimordial = false;
    }

    public void Personaliza() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Personaliza.fxml");
    }

    private void InicializaVentana() {
        this.textoSubrayado = "-fx-underline: true";
        this.textoNoSubrayado = "-fx-underline: false";
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.lblMetPlus.setVisible(false);
    }

    private void ValoresInicialesFlexi() {
        this.datosvi.indexPlazo = 0;
        this.datosvi.indexFormaPago = 0;
        this.datosvi.numPagos = 1;
        this.datosvi.indexRiesgo = 0;
        this.datosvi.indexCuenta = 0;
        this.datosvi.idMonedaSel = 1;
        this.datosvi.nombreTitular = "";
        this.datosvi.optMasculino = true;
        this.datosvi.sexo = "M";
        this.datosvi.optFuma = true;
        this.datosvi.fuma = "S";
        this.datosvi.edadReal = 35;
        this.datosvi.salarioMinimo = 88.36;
        this.datosvi.selEP = false;
        this.datosvi.selPASI = false;
        this.datosvi.selIMA = false;
        this.datosvi.selDI = false;
        this.datosvi.selTI = false;
        this.datosvi.selEG = false;
        this.datosvi.selGF = false;
        this.datosvi.sumaBAS = this.genSubs.VlookUpIntInt(this.datosvi.idPlanSel, this.datosvi.lstIdPlanSumaMin, this.datosvi.lstSumaMin);
        this.datosvi.sumaPASI = 0;
        this.datosvi.sumaIMA = 0;
        this.datosvi.sumaDI = 0;
        this.datosvi.sumaTI = 0;
        this.datosvi.sumaEG = 0;
        this.datosvi.sumaGF = 0;
        this.datosvi.primaPASI = 0.0;
        this.datosvi.primaIMA = 0.0;
        this.datosvi.primaDI = 0.0;
        this.datosvi.primaTI = 0.0;
        this.datosvi.primaEG = 0.0;
        this.datosvi.primaGF = 0.0;
        this.datosvi.tasaInvAnual = this.tablas.CargaTasasFlexi();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.datosvi.Aportacion[i][j][k] = 0.0;
                }
            }
        }
        this.datosvi.indexCuenta = 0;
        this.datosvi.indexLiquidez = 0;
        this.datosvi.indexPeriodicidad = 0;
        this.datosvi.maximoCPEA = 152000.0;
        this.datosvi.maximoPPR = this.datosvi.salarioMinimo * 365.0 * 5.0;
        this.datosvi.tipoCambioDolar = 20.0;
        this.datosvi.aptMinima[0] = 5000.0;
        this.datosvi.aptMinima[1] = 30000.0;
        this.datosvi.aptMinima[2] = 70000.0;
        this.datosvi.aptMinima[3] = 100000.0;
        this.datosvi.aptMinima[4] = 500.0;
        this.datosvi.aptMinima[5] = 10000.0;
        this.datosvi.nombreLiquidez[0] = "Diaria en Moneda Nacional";
        this.datosvi.nombreLiquidez[1] = "Mensual en Moneda Nacional";
        this.datosvi.nombreLiquidez[2] = "Trimestral en Moneda Nacional";
        this.datosvi.nombreLiquidez[3] = "Semestral en Moneda Nacional";
        this.datosvi.nombreLiquidez[4] = "Diaria en D\u00f3lares";
        this.datosvi.nombreLiquidez[5] = "Mensual en D\u00f3lares";
    }

    private void ValoresInicialesMedicaLife() {
        this.datosgm.indexPlan = 1;
        this.datosgm.indexSuma = 16;
        this.datosgm.indexDedNal = 0;
        this.datosgm.indexCoasNal = 0;
        this.datosgm.indexEstado = 0;
        this.datosgm.selDentalPlus = false;
        this.datosgm.selVision = false;
        this.datosgm.selEmergencia = false;
        this.datosgm.selCatastroficas = false;
        this.datosgm.selIncSuma = false;
        this.datosgm.selUG = false;
        this.datosgm.selMA = false;
        this.datosgm.selRD = false;
        this.datosgm.selPG = false;
        this.datosgm.selConversionPG = false;
        this.datosgm.selConversionCol = false;
        this.datosgm.selDeducibleCero = false;
        this.datosgm.selEstudiantesExtranjero = false;
        this.datosgm.selFranjaFronteriza = false;
        this.datosgm.optPolizaNueva = true;
        this.datosgm.polizaNueva = true;
        this.datosgm.polizaGrupo = "";
        this.datosgm.nombreEmpresa = "";
        this.datosgm.nombreContratante = "";
        this.datosPrimor.combinaPrimordial = false;
    }

    private void ValoresInicialesPrimordial() {
        this.datosPrimor.indexPlan = 0;
        this.datosPrimor.combinaPrimordial = false;
    }

    public void MuestraInstructivoEP() {
        this.AbreArchivoPDF("Manual extraprimas.pdf");
    }

    private void AbreArchivoPDF(String archivoPDF) {
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(archivoPDF);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException ex) {
                this.genSubs.MuestraMensaje("Es necesario tener instalado Adobe Acrobat Reader");
            }
        }
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Vida Individual");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            this.tablas.CierraBD();
            Platform.exit();
        }
    }
}

