/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PrimorCobController
implements Initializable {
    private DatosVI datosvi = DatosVI.getInstance();
    private DatosPrimor datosPrimor = DatosPrimor.getInstance();
    private CalculosPrimor calculosPrimor = CalculosPrimor.getInstance();
    private CotizPrimor cotizPrimor = CotizPrimor.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private DatosGM datosgm = DatosGM.getInstance();
    private Datos datos = Datos.getInstance();
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    Label lblPlanSel;
    @FXML
    ComboBox cmbPlan;
    @FXML
    ComboBox cmbEstado;
    @FXML
    RadioButton optPolizaNueva;
    @FXML
    RadioButton optRenovacion;
    @FXML
    CheckBox chkSumaAdicional;
    @FXML
    CheckBox chkZonaFronteriza;
    @FXML
    TextField nombre;
    @FXML
    ComboBox cmbParentesco;
    @FXML
    ComboBox cmbEstadoCivil;
    @FXML
    RadioButton optMasculino;
    @FXML
    RadioButton optFemenino;
    @FXML
    TextField edad;
    @FXML
    TableView<Aseg> tblAseg;
    @FXML
    TableColumn tblNombreAseg;
    @FXML
    TableColumn tblParentescoAseg;
    @FXML
    TableColumn tblEdadAseg;
    @FXML
    TableColumn tblSexoAseg;
    @FXML
    TableColumn tblPrimaAseg;
    @FXML
    ComboBox cmbFormaPago;
    @FXML
    Label lblPrimaNeta;
    @FXML
    Label lblRecargoFP;
    @FXML
    Label lblDerPol;
    @FXML
    Label lblSubTotal;
    @FXML
    Label lblIVA;
    @FXML
    Label lblPrimaTotal;
    @FXML
    Label lblPrimerPago;
    @FXML
    Label lblSubsecuentes;
    @FXML
    Label titPrimerPago;
    @FXML
    Label titSubsecuentes;
    @FXML
    CheckBox chkCarta;
    @FXML
    DatePicker calendario;
    @FXML
    Label lblInicioVigencia;
    @FXML
    Label lblPlanFamiliar;
    @FXML
    ComboBox cmbCombinar;
    @FXML
    Button btnCombinar;
    String txtMensaje;
    String txtNombre;
    String txtParentesco;
    String txtEdad;
    String txtSexo;
    String txtPrima;
    Boolean asegValido;
    Integer edadMin;
    Integer edadMax;
    Boolean informacionValida;
    Integer indexPlanCombinado;

    public void initialize(URL url, ResourceBundle rb) {
        this.tblNombreAseg.setCellValueFactory((Callback)new PropertyValueFactory("nombreAseg"));
        this.tblParentescoAseg.setCellValueFactory((Callback)new PropertyValueFactory("parentescoAseg"));
        this.tblEdadAseg.setCellValueFactory((Callback)new PropertyValueFactory("edadAseg"));
        this.tblSexoAseg.setCellValueFactory((Callback)new PropertyValueFactory("sexoAseg"));
        this.tblPrimaAseg.setCellValueFactory((Callback)new PropertyValueFactory("primaAseg"));
        this.tblAseg.setItems(this.datosPrimor.listaAseg);
        this.InicializaVentana();
        if (this.datosPrimor.combinaPrimordial.booleanValue()) {
            this.ValoresInicialesMixPrimordial();
        } else {
            this.ValoresIniciales();
        }
        this.cmbPlan.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrimorCobController.this.RevisaPlanSeleccionado();
            }
        });
        this.cmbEstado.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrimorCobController.this.RevisaEstadoSeleccionado();
            }
        });
        this.cmbParentesco.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrimorCobController.this.RevisaParentescoSeleccionado();
            }
        });
        this.cmbEstadoCivil.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrimorCobController.this.RevisaEstadoCivilSeleccionado();
            }
        });
        this.cmbFormaPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrimorCobController.this.RevisaFormaPagoSeleccionado();
            }
        });
        this.cmbCombinar.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PrimorCobController.this.RevisaCotizCombinada();
            }
        });
        this.calendario.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ((PrimorCobController)PrimorCobController.this).datosPrimor.date = (LocalDate)PrimorCobController.this.calendario.getValue();
                PrimorCobController.this.RevisaFechaSeleccionada();
            }
        });
        this.nombre.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    PrimorCobController.this.FormatoTituloNombre();
                }
            }
        });
        this.nombre.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(100));
        this.edad.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
    }

    private void RevisaPlanSeleccionado() {
        this.datosPrimor.indexPlan = this.cmbPlan.getSelectionModel().getSelectedIndex();
        this.optMasculino.setDisable(false);
        this.optFemenino.setDisable(false);
        if (this.datosPrimor.indexPlan == 0) {
            this.optFemenino.setSelected(true);
            this.optMasculino.setDisable(true);
        } else if (this.datosPrimor.indexPlan == 1) {
            this.optMasculino.setSelected(true);
            this.optFemenino.setDisable(true);
        }
        if (this.datosPrimor.indexPlan < 3) {
            this.datosPrimor.listaAseg.clear();
        }
        this.CalculaPrimas();
    }

    private void RevisaEstadoSeleccionado() {
        this.datosPrimor.indexEstado = this.cmbEstado.getSelectionModel().getSelectedIndex();
    }

    private void RevisaParentescoSeleccionado() {
        this.datosPrimor.indexParentesco = this.cmbParentesco.getSelectionModel().getSelectedIndex();
    }

    private void RevisaEstadoCivilSeleccionado() {
        this.datosPrimor.indexEstadoCivil = this.cmbEstadoCivil.getSelectionModel().getSelectedIndex();
        this.datosPrimor.estadoCivilTitular = this.datosPrimor.lstEstdoCivil.get(this.datosPrimor.indexEstadoCivil);
    }

    private void RevisaFormaPagoSeleccionado() {
        this.datosPrimor.indexFormaPago = this.cmbFormaPago.getSelectionModel().getSelectedIndex();
        this.calculosPrimor.CalculaPrimas();
        this.EscribeTotales();
    }

    private void RevisaFechaSeleccionada() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyy/MMM/dd");
    }

    private void RevisaCotizCombinada() {
        this.indexPlanCombinado = this.cmbCombinar.getSelectionModel().getSelectedIndex();
        this.datosPrimor.combinaPrimordial = true;
        switch (this.indexPlanCombinado) {
            case 0: {
                this.datosPrimor.planCombinado = "";
                this.datosPrimor.combinaPrimordial = false;
                break;
            }
            case 1: {
                this.datosPrimor.planCombinado = "MedicaLife";
                break;
            }
            case 2: {
                this.datosPrimor.planCombinado = "MetaLife";
                break;
            }
            default: {
                this.datosPrimor.planCombinado = "";
            }
        }
        if (this.datosPrimor.combinaPrimordial.booleanValue()) {
            this.btnCombinar.setVisible(true);
        } else {
            this.btnCombinar.setVisible(false);
        }
    }

    public void ValidaCombinacion() {
        this.ValidaInformacion();
        if (this.datosPrimor.planCombinado.equals("MetaLife")) {
            this.ValidaFormaPago();
        }
        if (this.informacionValida.booleanValue()) {
            if (this.datosPrimor.planCombinado.equals("MetaLife")) {
                this.AbreMetaLife();
            } else {
                this.AbreMedicaLife();
            }
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void ValidaFormaPago() {
        if (this.datosPrimor.indexFormaPago > 0 && this.datosPrimor.indexFormaPago % 2 == 0) {
            this.txtMensaje = this.txtMensaje + "La forma de pago seleccionada no es aplicable a MetaLife";
            this.informacionValida = false;
        }
    }

    private void AbreMedicaLife() {
        this.datosvi.planSel = "MedicaLife";
        this.datosvi.prodSel = "MedicaLife";
        this.ValoresInicialesMedicaLife();
        this.MuestraInfo("MedicaCob.fxml");
    }

    private void AbreMetaLife() {
        this.datosvi.planSel = "MetaLife";
        this.datosvi.prodSel = "MetaLife";
        this.datos.reproyectaMetaLife = false;
        this.datos.conAcompa\u00f1amiento = false;
        this.MuestraInfo("MetaLife.fxml");
    }

    private void ValoresInicialesMedicaLife() {
        this.datosgm.indexPlan = 1;
        this.datosgm.indexSuma = 16;
        this.datosgm.indexDedNal = 0;
        this.datosgm.indexCoasNal = 0;
        this.datosgm.indexEstado = 0;
        this.datosgm.selDentalPlus = false;
        this.datosgm.selVision = false;
        this.datosgm.selEmergencia = false;
        this.datosgm.selCatastroficas = false;
        this.datosgm.selIncSuma = false;
        this.datosgm.selUG = false;
        this.datosgm.selMA = false;
        this.datosgm.selRD = false;
        this.datosgm.selPG = false;
        this.datosgm.selConversionPG = false;
        this.datosgm.selConversionCol = false;
        this.datosgm.selDeducibleCero = false;
        this.datosgm.selEstudiantesExtranjero = false;
        this.datosgm.selFranjaFronteriza = false;
        this.datosgm.optPolizaNueva = true;
        this.datosgm.polizaNueva = true;
        this.datosgm.polizaGrupo = "";
        this.datosgm.nombreEmpresa = "";
        this.datosgm.nombreContratante = "";
    }

    private void ValoresInicialesMetaLife() {
    }

    private void MuestraInfo(String nombreVentana) {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        if (this.datosvi.planSel == "EducaLife") {
            this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt("B\u00e1sico EducaLife", this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        } else {
            this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        }
        this.MuestraVentana(nombreVentana);
    }

    public void ClicNuevaRenovacion() {
        this.datosPrimor.polizaNueva = this.optPolizaNueva.isSelected();
        if (this.optPolizaNueva.isSelected()) {
            this.edadMin = this.datosPrimor.lstEdadMinNueva.get(this.datosPrimor.indexPlan);
            this.edadMax = this.datosPrimor.lstEdadMaxNueva.get(this.datosPrimor.indexPlan);
            this.lblInicioVigencia.setVisible(false);
            this.calendario.setVisible(false);
            for (int i = 0; i < this.datosPrimor.listaAseg.size(); ++i) {
                Integer edadAseg = Integer.parseInt(((Aseg)this.datosPrimor.listaAseg.get(i)).getEdadAseg());
                if (edadAseg >= this.edadMin && edadAseg <= this.edadMax) continue;
                this.txtMensaje = "Edad fuera de rango para p\u00f3liza nueva";
                this.genSubs.MuestraMensaje(this.txtMensaje);
                this.optPolizaNueva.setSelected(false);
                this.optRenovacion.setSelected(true);
            }
        } else {
            this.lblInicioVigencia.setVisible(false);
            this.calendario.setVisible(false);
        }
    }

    public void ClicSumaAdicional() {
        this.CalculaPrimas();
    }

    public void AgregaAseg() {
        this.txtMensaje = "";
        Boolean continuar = true;
        if (continuar.booleanValue()) {
            Integer edadCapturada;
            int i;
            if (this.optPolizaNueva.isSelected()) {
                this.edadMin = this.datosPrimor.lstEdadMinNueva.get(this.datosPrimor.indexPlan);
                this.edadMax = this.datosPrimor.lstEdadMaxNueva.get(this.datosPrimor.indexPlan);
            } else {
                this.edadMin = this.datosPrimor.lstEdadMinRenov.get(this.datosPrimor.indexPlan);
                this.edadMax = this.datosPrimor.lstEdadMaxRenov.get(this.datosPrimor.indexPlan);
            }
            this.txtNombre = this.nombre.getText().toString();
            this.txtParentesco = this.datosPrimor.lstParentesco.get(this.datosPrimor.indexParentesco);
            if (this.edad.getText().equals("")) {
                this.edad.setText("0");
            }
            this.txtEdad = this.edad.getText().toString();
            this.txtSexo = this.optMasculino.isSelected() ? "M" : "F";
            this.asegValido = true;
            this.txtMensaje = "";
            if (this.txtNombre == "") {
                this.asegValido = false;
                this.txtMensaje = "Falta nombre del solicitante\r";
            }
            if (this.datosPrimor.indexParentesco == 0 && this.datosPrimor.listaAseg.size() > 0) {
                for (i = 0; i < this.datosPrimor.listaAseg.size(); ++i) {
                    if (((Aseg)this.datosPrimor.listaAseg.get(i)).getParentescoAseg() == "Titular") {
                        this.asegValido = false;
                    }
                    if (this.asegValido.booleanValue()) continue;
                    this.txtMensaje = this.txtMensaje + "Ya exite el titular";
                }
            }
            if (this.datosPrimor.indexParentesco == 1 && this.datosPrimor.listaAseg.size() > 0) {
                for (i = 0; i < this.datosPrimor.listaAseg.size(); ++i) {
                    if (((Aseg)this.datosPrimor.listaAseg.get(i)).getParentescoAseg() == "C\u00f3nyuge") {
                        this.asegValido = false;
                    }
                    if (this.asegValido.booleanValue()) continue;
                    this.txtMensaje = this.txtMensaje + "Ya exite C\u00f3nyuge";
                }
            }
            if ((edadCapturada = Integer.valueOf(Integer.parseInt(this.txtEdad))) > this.edadMax || edadCapturada < this.edadMin) {
                this.txtMensaje = "Edad fuera de rango v\u00e1lido";
                this.asegValido = false;
            }
            if (this.asegValido.booleanValue()) {
                this.txtPrima = "$$";
                this.datosPrimor.listaAseg.add((Object)new Aseg(this.txtNombre, this.txtParentesco, this.txtEdad, this.txtSexo, this.txtPrima));
                this.CalculaPrimas();
                this.nombre.setText("");
                this.edad.setText("");
            } else {
                this.genSubs.MuestraMensaje(this.txtMensaje);
            }
        }
    }

    public void EliminaAseg() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            Aseg aseg = (Aseg)this.tblAseg.getSelectionModel().getSelectedItem();
            this.datosPrimor.listaAseg.remove((Object)aseg);
            this.CalculaPrimas();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar un solicitante");
        }
    }

    public void ModificaAseg() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            Aseg aseg = (Aseg)this.tblAseg.getSelectionModel().getSelectedItem();
            this.txtNombre = aseg.getNombreAseg();
            this.txtParentesco = aseg.getParentescoAseg();
            this.txtSexo = aseg.getSexoAseg();
            this.txtEdad = aseg.getEdadAseg();
            int index = this.txtParentesco == "Titular" ? 0 : (this.txtParentesco == "C\u00f3nyuge" ? 1 : (this.txtParentesco == "Hijo" ? 2 : 3));
            if (this.txtSexo == "M") {
                this.optMasculino.setSelected(true);
            } else {
                this.optFemenino.setSelected(true);
            }
            this.nombre.setText(this.txtNombre);
            this.edad.setText(this.txtEdad);
            this.cmbParentesco.getSelectionModel().select(index);
            this.EliminaAseg();
        }
    }

    public void ClicFronterizo() {
        this.datosPrimor.zonaFronteriza = false;
        if (this.chkZonaFronteriza.isSelected()) {
            this.datosPrimor.zonaFronteriza = true;
        }
        this.calculosPrimor.CalculaPrimas();
        this.EscribeTotales();
    }

    public void ClicCarta() {
        this.datosPrimor.conCarta = this.chkCarta.isSelected();
    }

    private void CalculaPrimas() {
        this.datosPrimor.sumaAdicional = false;
        if (this.chkSumaAdicional.isSelected()) {
            this.datosPrimor.sumaAdicional = true;
        }
        if (this.datosPrimor.listaAseg.size() > 0) {
            this.calculosPrimor.CalculaPrimas();
            this.EscribeTotales();
        }
    }

    private void EscribeTotales() {
        this.lblPrimaNeta.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.primaNeta));
        this.lblRecargoFP.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.recargoFP));
        this.lblDerPol.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.derPolTotal));
        this.lblSubTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.subTotal));
        this.lblIVA.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.IVA));
        this.lblPrimaTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.primaTotal));
        if (this.datosPrimor.indexFormaPago > 0) {
            this.titPrimerPago.setVisible(true);
            this.titSubsecuentes.setVisible(true);
            this.lblPrimerPago.setVisible(true);
            this.lblSubsecuentes.setVisible(true);
            this.lblPrimerPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.primerPago));
            this.lblSubsecuentes.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosPrimor.subsecuentes));
        } else {
            this.titPrimerPago.setVisible(false);
            this.titSubsecuentes.setVisible(false);
            this.lblPrimerPago.setVisible(false);
            this.lblSubsecuentes.setVisible(false);
        }
    }

    public void VerCotizacion() {
        this.ValidaInformacion();
        if (this.informacionValida.booleanValue()) {
            this.cotizPrimor.ImprimeCotizacion();
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    private void ValidaInformacion() {
        this.informacionValida = true;
        this.txtMensaje = "";
        if (this.datosPrimor.listaAseg.size() == 0) {
            this.txtMensaje = this.txtMensaje + "No hay asegurados";
            this.informacionValida = false;
        } else {
            this.datosPrimor.nombreTitular = "";
            for (int i = 0; i < this.datosPrimor.listaAseg.size(); ++i) {
                if (!((Aseg)this.datosPrimor.listaAseg.get(i)).getParentescoAseg().equals("Titular")) continue;
                this.datosPrimor.nombreTitular = ((Aseg)this.datosPrimor.listaAseg.get(i)).getNombreAseg();
                this.datosPrimor.edadTitular = Integer.parseInt(((Aseg)this.datosPrimor.listaAseg.get(i)).getEdadAseg().toString());
                this.datosPrimor.sexoTitular = ((Aseg)this.datosPrimor.listaAseg.get(i)).getSexoAseg();
            }
            if (this.datosPrimor.nombreTitular.equals("")) {
                this.txtMensaje = this.txtMensaje + "No hay titular";
                this.informacionValida = false;
            }
        }
    }

    public void clicZonFronteriza() {
        this.datosPrimor.zonaFronteriza = false;
        if (this.chkZonaFronteriza.isSelected()) {
            this.datosPrimor.zonaFronteriza = true;
        }
    }

    private void FormatoTituloNombre() {
        String[] arr = this.nombre.getText().split(" ");
        StringBuffer sb = new StringBuffer();
        if (!this.nombre.getText().equals("")) {
            for (int i = 0; i < arr.length; ++i) {
                sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1)).append(" ");
                this.nombre.setText(sb.toString().trim());
            }
        }
    }

    private void InicializaVentana() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.lblPlanSel.setText(this.datosvi.planSel);
        this.LlenaCombos();
        this.tblParentescoAseg.getStyleClass().add((Object)"alineadoCentro2");
        this.tblSexoAseg.getStyleClass().add((Object)"alineadoCentro2");
        this.tblEdadAseg.getStyleClass().add((Object)"alineadoCentro2");
        this.tblPrimaAseg.getStyleClass().add((Object)"alineadoDerecha2");
        this.chkCarta.setVisible(false);
        this.lblPlanFamiliar.setLayoutX(this.cmbPlan.getLayoutX());
        this.lblPlanFamiliar.setLayoutY(this.cmbPlan.getLayoutY());
        this.cmbPlan.setVisible(false);
        this.lblPlanFamiliar.setVisible(true);
        this.chkZonaFronteriza.setVisible(false);
    }

    private void ValoresIniciales() {
        this.datosPrimor.indexPlan = 4;
        this.datosPrimor.indexEstado = 0;
        this.datosPrimor.indexParentesco = 0;
        this.datosPrimor.indexEstadoCivil = 0;
        this.datosPrimor.indexFormaPago = 0;
        this.datosPrimor.zonaFronteriza = false;
        this.datosPrimor.derPolAseg = 100.0;
        this.datosPrimor.conCarta = false;
        this.cmbPlan.getSelectionModel().select(this.datosPrimor.indexPlan);
        this.RevisaPlanSeleccionado();
        this.cmbEstado.getSelectionModel().select(this.datosPrimor.indexEstado);
        this.cmbEstadoCivil.getSelectionModel().select(this.datosPrimor.indexEstadoCivil);
        this.cmbParentesco.getSelectionModel().select(this.datosPrimor.indexParentesco);
        this.cmbFormaPago.getSelectionModel().select(this.datosPrimor.indexFormaPago);
        this.datosPrimor.primaNeta = 0.0;
        this.datosPrimor.derPolTotal = 0.0;
        this.datosPrimor.recargoFP = 0.0;
        this.datosPrimor.derPolTotal = 0.0;
        this.datosPrimor.subTotal = 0.0;
        this.datosPrimor.IVA = 0.0;
        this.datosPrimor.primaTotal = 0.0;
        this.datosPrimor.primerPago = 0.0;
        this.datosPrimor.subsecuentes = 0.0;
        this.datosPrimor.vigenciaRenovacion = "";
        this.datosPrimor.polizaNueva = true;
        this.datosPrimor.estadoCivilTitular = this.datosPrimor.lstEstdoCivil.get(this.datosPrimor.indexEstadoCivil);
        this.lblInicioVigencia.setVisible(false);
        this.optRenovacion.setVisible(true);
        this.calendario.setVisible(false);
        this.chkSumaAdicional.setSelected(true);
        this.datosPrimor.listaAseg.clear();
        this.EscribeTotales();
    }

    private void ValoresInicialesMixPrimordial() {
        this.datosPrimor.indexPlan = 4;
        this.datosPrimor.indexParentesco = 0;
        this.datosPrimor.indexEstadoCivil = 0;
        if (this.datosPrimor.sumaAdicional.booleanValue()) {
            this.chkSumaAdicional.setSelected(true);
        } else {
            this.chkSumaAdicional.setSelected(false);
        }
        this.cmbPlan.getSelectionModel().select(this.datosPrimor.indexPlan);
        this.RevisaPlanSeleccionado();
        this.cmbEstado.getSelectionModel().select(this.datosPrimor.indexEstado);
        this.cmbEstadoCivil.getSelectionModel().select(this.datosPrimor.indexEstadoCivil);
        this.cmbParentesco.getSelectionModel().select(this.datosPrimor.indexParentesco);
        this.cmbFormaPago.getSelectionModel().select(this.datosPrimor.indexFormaPago);
        this.datosPrimor.estadoCivilTitular = this.datosPrimor.lstEstdoCivil.get(this.datosPrimor.indexEstadoCivil);
        if (this.datosPrimor.polizaNueva.booleanValue()) {
            this.lblInicioVigencia.setVisible(false);
            this.optRenovacion.setVisible(false);
            this.calendario.setVisible(false);
        } else {
            this.optRenovacion.setSelected(true);
            this.lblInicioVigencia.setVisible(false);
            this.optRenovacion.setVisible(true);
            this.calendario.setVisible(false);
        }
        this.EscribeTotales();
    }

    private void LlenaCombos() {
        this.cmbPlan.getItems().clear();
        this.cmbPlan.getItems().addAll(this.datosPrimor.lstPlan);
        this.cmbEstado.getItems().clear();
        this.cmbEstado.getItems().addAll(this.datosPrimor.lstEstado);
        this.cmbFormaPago.getItems().clear();
        this.cmbFormaPago.getItems().addAll(this.datosPrimor.lstFormaPago);
        this.datosPrimor.lstParentesco.clear();
        this.datosPrimor.lstParentesco.add("Titular");
        this.datosPrimor.lstParentesco.add("C\u00f3nyuge");
        this.datosPrimor.lstParentesco.add("Hijo");
        this.datosPrimor.lstParentesco.add("Madre");
        this.datosPrimor.lstParentesco.add("Padre");
        this.cmbParentesco.getItems().clear();
        this.cmbParentesco.getItems().addAll(this.datosPrimor.lstParentesco);
        this.datosPrimor.lstEstdoCivil.clear();
        this.datosPrimor.lstEstdoCivil.add("Soltero");
        this.datosPrimor.lstEstdoCivil.add("Casado");
        this.datosPrimor.lstEstdoCivil.add("Divorciado");
        this.datosPrimor.lstEstdoCivil.add("Viudo");
        this.cmbEstadoCivil.getItems().clear();
        this.cmbEstadoCivil.getItems().addAll(this.datosPrimor.lstEstdoCivil);
        this.cmbCombinar.getItems().clear();
        this.cmbCombinar.getItems().add((Object)"Cotizar s\u00f3lo Primordial");
        this.cmbCombinar.getItems().add((Object)"Cotizar con M\u00e9dicaLife");
        this.cmbCombinar.getItems().add((Object)"Cotizar con MetaLife");
        this.cmbCombinar.getSelectionModel().selectFirst();
        this.btnCombinar.setVisible(false);
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
    }
}

