/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;

public class Tablas {
    private static Tablas tablas = new Tablas();
    private RutinasDB rutinasDB = new RutinasDB();
    private Datos datos = Datos.getInstance();
    private DatosVI datosvi = DatosVI.getInstance();
    private DatosGM datosgm = DatosGM.getInstance();
    private DatosPrimor datosPrimor = DatosPrimor.getInstance();
    private DatosMetPlus datosMetPlus = DatosMetPlus.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private String txtQuery;
    private ResultSet rs = null;
    private Connection c = null;
    private Connection cMLnn = null;
    private Connection cMLren = null;
    private Connection cMLrenAnt = null;
    private Connection cMLrenAnt2 = null;
    private Connection cMLrenAnt3 = null;

    private Tablas() {
    }

    public static Tablas getInstance() {
        return tablas;
    }

    public void ConectaBD(String nombreBD) {
        this.rutinasDB.ConectaDb(nombreBD);
        this.c = this.rutinasDB.c;
    }

    public void ConectaBdMLnn(String nombreBD) {
        this.rutinasDB.ConectaDbmlNN(nombreBD);
        this.cMLnn = this.rutinasDB.cMLnn;
    }

    public void ConectaBdMLrenAnt(String nombreML) {
        this.rutinasDB.ConectaDbMLrenAnt(nombreML);
        this.cMLrenAnt = this.rutinasDB.cMLrenAnt;
    }

    public void ConectaBdMLrenAnt2(String nombreML) {
        this.rutinasDB.ConectaDbMLrenAnt2(nombreML);
        this.cMLrenAnt2 = this.rutinasDB.cMLrenAnt2;
    }

    public void ConectaBdMLrenAnt3(String nombreML) {
        this.rutinasDB.ConectaDbMLrenAnt3(nombreML);
        this.cMLrenAnt3 = this.rutinasDB.cMLrenAnt3;
    }

    public void ConectaDbMLren(String nombreML) {
        this.rutinasDB.ConectaDbMLren(nombreML);
        this.cMLren = this.rutinasDB.c;
    }

    public void CierraBD() {
        try {
            this.c.close();
            this.cMLnn.close();
            this.cMLren.close();
            this.cMLrenAnt.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    public void CargaTarifasMetaLife() {
        try {
            this.txtQuery = this.datos.indexOpcionMeta == 0 ? "SELECT * FROM tblTarMetaLife WHERE " : "SELECT * FROM tblTarMetaLife2025 WHERE ";
            this.txtQuery = this.txtQuery + "moneda='" + this.datos.moneda + "'";
            this.txtQuery = this.txtQuery + " AND edad=" + this.datos.edad;
            this.txtQuery = this.txtQuery + " AND sexo='" + this.datos.sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + this.datos.fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.datos.tarMetaLife = this.rs.getDouble("tarMetaLife");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tarMetaLife: " + e2.getMessage());
        }
    }

    public void CargaTarifasBeneficios() {
        try {
            this.txtQuery = "SELECT * FROM tblTarBeneficios WHERE ";
            this.txtQuery = this.txtQuery + "edad=" + this.datos.edad + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.tarMA = this.rs.getDouble("tarMA");
                this.datos.tarDI = this.rs.getDouble("tarDI");
                this.datos.tarTI = this.rs.getDouble("tarTI");
                if (this.datos.sexo.equals("M")) {
                    if (this.datos.fuma.equals("S")) {
                        this.datos.tarEP = this.rs.getDouble("tarEPms");
                        this.datos.tarPASI = this.rs.getDouble("tarPASIms");
                        continue;
                    }
                    this.datos.tarEP = this.rs.getDouble("tarEPmn");
                    this.datos.tarPASI = this.rs.getDouble("tarPASImn");
                    continue;
                }
                if (this.datos.fuma.equals("S")) {
                    this.datos.tarEP = this.rs.getDouble("tarEPfs");
                    this.datos.tarPASI = this.rs.getDouble("tarPASIfs");
                    continue;
                }
                this.datos.tarEP = this.rs.getDouble("tarEPfn");
                this.datos.tarPASI = this.rs.getDouble("tarPASIfn");
            }
            this.datos.tarEP = this.datos.tarEP * (1.0 + this.datos.epPorINV);
            this.datos.tarPASI = this.datos.tarPASI * (1.0 + this.datos.epPorINV);
            this.datos.tarMA = this.datos.tarMA * (1.0 + this.datos.epPorACC);
            this.datos.tarDI = this.datos.tarDI * (1.0 + this.datos.epPorACC);
            this.datos.tarTI = this.datos.tarTI * (1.0 + this.datos.epPorACC);
            this.datos.tarGE.clear();
            for (int i = 0; i < 18; ++i) {
                this.datos.tarGE.add(0.0);
            }
            this.rs.close();
            this.txtQuery = "SELECT * FROM tblTarBeneficios ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                if (this.datos.sexo.equals("M")) {
                    if (this.datos.fuma.equals("S")) {
                        this.datos.tarGE.add(this.rs.getDouble("tarGEms"));
                        continue;
                    }
                    this.datos.tarGE.add(this.rs.getDouble("tarGEmn"));
                    continue;
                }
                if (this.datos.fuma.equals("S")) {
                    this.datos.tarGE.add(this.rs.getDouble("tarGEfs"));
                    continue;
                }
                this.datos.tarGE.add(this.rs.getDouble("tarGEfn"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tarBeneficios: " + e2.getMessage());
        }
    }

    public void CargaTarifasPerfect() {
        try {
            this.txtQuery = "SELECT * FROM tblTarPerfect WHERE ";
            this.txtQuery = this.txtQuery + "moneda='" + this.datos.moneda + "'";
            this.txtQuery = this.txtQuery + " AND edad= " + this.datos.edad;
            this.txtQuery = this.txtQuery + " AND banda= " + this.datos.banda;
            this.txtQuery = this.txtQuery + " AND sexo='" + this.datos.sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + this.datos.fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.datos.tarPerfect10 = this.rs.getDouble("tarPerfect10");
            this.datos.tarPerfect15 = this.rs.getDouble("tarPerfect15");
            this.datos.tarPerfect20 = this.rs.getDouble("tarPerfect20");
            this.datos.tarPerfect65 = this.rs.getDouble("tarPerfect65");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tarPerfect: " + e2.getMessage());
        }
    }

    public void CargaComisiones() {
        this.datos.comisMetaLife.clear();
        this.datos.comisPerfect10.clear();
        this.datos.comisPerfect15.clear();
        this.datos.comisPerfect20.clear();
        this.datos.comisMetaLife.add(0.0);
        this.datos.comisPerfect10.add(0.0);
        this.datos.comisPerfect15.add(0.0);
        this.datos.comisPerfect20.add(0.0);
        try {
            this.txtQuery = "SELECT * FROM tblComis WHERE ";
            this.txtQuery = this.txtQuery + "moneda='" + this.datos.moneda + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.comisMetaLife.add(this.rs.getDouble("comisMetaLife"));
                this.datos.comisPerfect10.add(this.rs.getDouble("comisPerfect10"));
                this.datos.comisPerfect15.add(this.rs.getDouble("comisPerfect15"));
                this.datos.comisPerfect20.add(this.rs.getDouble("comisPerfect20"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tarPerfect: " + e2.getMessage());
        }
    }

    public void CargaCoiBAS() {
        this.datos.coiBASms.clear();
        this.datos.coiBASmn.clear();
        this.datos.coiBASfs.clear();
        this.datos.coiBASfn.clear();
        for (int i = 0; i < 18; ++i) {
            this.datos.coiBASms.add(0.0);
            this.datos.coiBASmn.add(0.0);
            this.datos.coiBASfs.add(0.0);
            this.datos.coiBASfn.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblCoiBas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.coiBASms.add(this.rs.getDouble("coiBASms"));
                this.datos.coiBASmn.add(this.rs.getDouble("coiBASmn"));
                this.datos.coiBASfs.add(this.rs.getDouble("coiBASfs"));
                this.datos.coiBASfn.add(this.rs.getDouble("coiBASfn"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblCoiBAS: " + e2.getMessage());
        }
    }

    public void CargaCoiBeneficios() {
        this.datos.coiGEpms.clear();
        this.datos.coiGEpmn.clear();
        this.datos.coiGEpfs.clear();
        this.datos.coiGEpfn.clear();
        this.datos.coiPASIpms.clear();
        this.datos.coiPASIpmn.clear();
        this.datos.coiPASIpfs.clear();
        this.datos.coiPASIpfn.clear();
        this.datos.coiEPpms.clear();
        this.datos.coiEPpmn.clear();
        this.datos.coiEPpfs.clear();
        this.datos.coiEPpfn.clear();
        this.datos.coiGEdms.clear();
        this.datos.coiGEdmn.clear();
        this.datos.coiGEdfs.clear();
        this.datos.coiGEdfn.clear();
        this.datos.coiPASIdms.clear();
        this.datos.coiPASIdmn.clear();
        this.datos.coiPASIdfs.clear();
        this.datos.coiPASIdfn.clear();
        this.datos.coiEPdms.clear();
        this.datos.coiEPdmn.clear();
        this.datos.coiEPdfs.clear();
        this.datos.coiEPdfn.clear();
        for (int i = 0; i < 18; ++i) {
            this.datos.coiGEpms.add(0.0);
            this.datos.coiGEpmn.add(0.0);
            this.datos.coiGEpfs.add(0.0);
            this.datos.coiGEpfn.add(0.0);
            this.datos.coiPASIpms.add(0.0);
            this.datos.coiPASIpmn.add(0.0);
            this.datos.coiPASIpfs.add(0.0);
            this.datos.coiPASIpfn.add(0.0);
            this.datos.coiEPpms.add(0.0);
            this.datos.coiEPpmn.add(0.0);
            this.datos.coiEPpfs.add(0.0);
            this.datos.coiEPpfn.add(0.0);
            this.datos.coiGEdms.add(0.0);
            this.datos.coiGEdmn.add(0.0);
            this.datos.coiGEdfs.add(0.0);
            this.datos.coiGEdfn.add(0.0);
            this.datos.coiPASIdms.add(0.0);
            this.datos.coiPASIdmn.add(0.0);
            this.datos.coiPASIdfs.add(0.0);
            this.datos.coiPASIdfn.add(0.0);
            this.datos.coiEPdms.add(0.0);
            this.datos.coiEPdmn.add(0.0);
            this.datos.coiEPdfs.add(0.0);
            this.datos.coiEPdfn.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblCoiBeneficios ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                if (this.rs.getString("moneda").equals("P")) {
                    this.datos.coiGEpms.add(this.rs.getDouble("coiGEms"));
                    this.datos.coiGEpmn.add(this.rs.getDouble("coiGEmn"));
                    this.datos.coiGEpfs.add(this.rs.getDouble("coiGEfs"));
                    this.datos.coiGEpfn.add(this.rs.getDouble("coiGEfn"));
                    this.datos.coiPASIpms.add(this.rs.getDouble("coiPASIms"));
                    this.datos.coiPASIpmn.add(this.rs.getDouble("coiPASImn"));
                    this.datos.coiPASIpfs.add(this.rs.getDouble("coiPASIfs"));
                    this.datos.coiPASIpfn.add(this.rs.getDouble("coiPASIfn"));
                    this.datos.coiEPpms.add(this.rs.getDouble("coiEPms"));
                    this.datos.coiEPpmn.add(this.rs.getDouble("coiEPmn"));
                    this.datos.coiEPpfs.add(this.rs.getDouble("coiEPfs"));
                    this.datos.coiEPpfn.add(this.rs.getDouble("coiEPfn"));
                    continue;
                }
                this.datos.coiGEdms.add(this.rs.getDouble("coiGEms"));
                this.datos.coiGEdmn.add(this.rs.getDouble("coiGEmn"));
                this.datos.coiGEdfs.add(this.rs.getDouble("coiGEfs"));
                this.datos.coiGEdfn.add(this.rs.getDouble("coiGEfn"));
                this.datos.coiPASIdms.add(this.rs.getDouble("coiPASIms"));
                this.datos.coiPASIdmn.add(this.rs.getDouble("coiPASImn"));
                this.datos.coiPASIdfs.add(this.rs.getDouble("coiPASIfs"));
                this.datos.coiPASIdfn.add(this.rs.getDouble("coiPASIfn"));
                this.datos.coiEPdms.add(this.rs.getDouble("coiEPms"));
                this.datos.coiEPdmn.add(this.rs.getDouble("coiEPmn"));
                this.datos.coiEPdfs.add(this.rs.getDouble("coiEPfs"));
                this.datos.coiEPdfn.add(this.rs.getDouble("coiEPfn"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblCoiBAS: " + e2.getMessage());
        }
    }

    public void CargaFacSel() {
        this.datos.facSelMin.clear();
        this.datos.facSelMax.clear();
        this.datos.facSelMin.add(0.0);
        this.datos.facSelMax.add(0.0);
        try {
            this.txtQuery = "SELECT * FROM tblFacSel ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.facSelMin.add(this.rs.getDouble("facSelMin"));
                this.datos.facSelMax.add(this.rs.getDouble("facSelMax"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblFacSel: " + e2.getMessage());
        }
    }

    public void CargaReglas() {
        try {
            this.txtQuery = "SELECT * FROM tblReglas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.lstIdCob.add(this.rs.getString("idCobertura"));
                this.datos.lstMonCob.add(this.rs.getString("moneda"));
                this.datos.lstEdadMinCob.add(this.rs.getInt("edadMin"));
                this.datos.lstEdadMaxCob.add(this.rs.getInt("edadMax"));
                this.datos.lstEdadCanCob.add(this.rs.getInt("edadCan"));
                this.datos.lstSumaMinCob.add(this.rs.getInt("sumaMin"));
                this.datos.lstSumaMaxCob.add(this.rs.getInt("sumaMax"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblReglas: " + e2.getMessage());
        }
    }

    public void CargaCastigoRescate() {
        this.datos.porCastigoBase.clear();
        this.datos.porCastigoAdi.clear();
        this.datos.porCastigoBase.add(0.0);
        this.datos.porCastigoAdi.add(0.0);
        try {
            this.txtQuery = this.datos.nuevosRecargos.booleanValue() ? (this.datos.indexOpcionMeta == 0 ? "SELECT * FROM tblCastigoRescateMod ;" : "SELECT * FROM tblCastigoRescateModMetaLife2025 ;") : "SELECT * FROM tblCastigoRescate ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.porCastigoBase.add(this.rs.getDouble("porCastigoBase"));
                this.datos.porCastigoAdi.add(this.rs.getDouble("porCastigoAdi"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblCastigoRescate: " + e2.getMessage());
        }
    }

    public void CargaISR() {
        this.datos.lstLimInferior.clear();
        this.datos.lstLimSuperior.clear();
        this.datos.lstCuotaFija.clear();
        this.datos.lstPorExcedente.clear();
        try {
            this.txtQuery = "SELECT * FROM tblISR ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.lstLimInferior.add(this.rs.getDouble("limInferior"));
                this.datos.lstLimSuperior.add(this.rs.getDouble("limSuperior"));
                this.datos.lstCuotaFija.add(this.rs.getDouble("cuotaFija"));
                this.datos.lstPorExcedente.add(this.rs.getDouble("porExcedente"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblCastigoRescate: " + e2.getMessage());
        }
    }

    public void CargaRecargoBeneficios() {
        try {
            this.txtQuery = "SELECT * FROM tblRecargoBeneficios WHERE ";
            this.txtQuery = this.txtQuery + "Edad=" + this.datos.edad + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.datos.recargoPrimaEPms = this.rs.getDouble("recargoPrimaEPms");
            this.datos.recargoPrimaEPmn = this.rs.getDouble("recargoPrimaEPmn");
            this.datos.recargoPrimaEPfs = this.rs.getDouble("recargoPrimaEPfs");
            this.datos.recargoPrimaEPfn = this.rs.getDouble("recargoPrimaEPfn");
            this.datos.recargoPrimaPASIms = this.rs.getDouble("recargoPrimaPASIms");
            this.datos.recargoPrimaPASImn = this.rs.getDouble("recargoPrimaPASImn");
            this.datos.recargoPrimaPASIfs = this.rs.getDouble("recargoPrimaPASIfs");
            this.datos.recargoPrimaPASIfn = this.rs.getDouble("recargoPrimaPASIfn");
            this.datos.recargoPrimaMA = this.rs.getDouble("recargoPrimaMA");
            this.datos.recargoPrimaDI = this.rs.getDouble("recargoPrimaDI");
            this.datos.recargoPrimaTI = this.rs.getDouble("recargoPrimaTI");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblRecargoBeneficios: " + e2.getMessage());
        }
        if (this.datos.sexo.equals("M")) {
            if (this.datos.fuma.equals("S")) {
                this.datos.recargoPrimaEP = this.datos.recargoPrimaEPms;
                this.datos.recargoPrimaPASI = this.datos.recargoPrimaPASIms;
            } else {
                this.datos.recargoPrimaEP = this.datos.recargoPrimaEPmn;
                this.datos.recargoPrimaPASI = this.datos.recargoPrimaPASImn;
            }
        } else if (this.datos.fuma.equals("S")) {
            this.datos.recargoPrimaEP = this.datos.recargoPrimaEPfs;
            this.datos.recargoPrimaPASI = this.datos.recargoPrimaPASIfs;
        } else {
            this.datos.recargoPrimaEP = this.datos.recargoPrimaEPfn;
            this.datos.recargoPrimaPASI = this.datos.recargoPrimaPASIfn;
        }
    }

    public void CargaRecargoGE() {
        this.datos.recargoPrimaGEmn.clear();
        this.datos.recargoPrimaGEms.clear();
        this.datos.recargoPrimaGEfn.clear();
        this.datos.recargoPrimaGEfs.clear();
        for (int i = 0; i < 18; ++i) {
            this.datos.recargoPrimaGEms.add(0.0);
            this.datos.recargoPrimaGEmn.add(0.0);
            this.datos.recargoPrimaGEfs.add(0.0);
            this.datos.recargoPrimaGEfn.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblRecargoBeneficios; ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.recargoPrimaGEms.add(this.rs.getDouble("recargoPrimaGEms"));
                this.datos.recargoPrimaGEmn.add(this.rs.getDouble("recargoPrimaGEmn"));
                this.datos.recargoPrimaGEfs.add(this.rs.getDouble("recargoPrimaGEfs"));
                this.datos.recargoPrimaGEfn.add(this.rs.getDouble("recargoPrimaGEfn"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblRecargoBeneficios GE: " + e2.getMessage());
        }
    }

    public void CargaMonedas() {
        this.datosvi.lstIdMoneda.clear();
        this.datosvi.lstNombreMoneda.clear();
        try {
            this.txtQuery = "SELECT * FROM Monedas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdMoneda.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstNombreMoneda.add(this.rs.getString("nombreMoneda"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Monedas: " + e2.getMessage());
        }
    }

    public void CargaPlanes() {
        this.datosvi.lstIdPlan.clear();
        this.datosvi.lstNombrePlan.clear();
        try {
            this.txtQuery = "SELECT * FROM Planes ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlan.add(this.rs.getInt("idPlan"));
                this.datosvi.lstNombrePlan.add(this.rs.getString("nombrePlan"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Planes: " + e2.getMessage());
        }
    }

    public void CargaPlanMoneda() {
        this.datosvi.lstIdPlanMoneda.clear();
        this.datosvi.lstIdMonedaPlan.clear();
        try {
            this.txtQuery = "SELECT * FROM PlanMoneda ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlanMoneda.add(this.rs.getInt("idPlan"));
                this.datosvi.lstIdMonedaPlan.add(this.rs.getInt("idMoneda"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " PlanMoneda: " + e2.getMessage());
        }
    }

    public void CargaClaveValores() {
        this.datosvi.lstIdPlanClaves.clear();
        this.datosvi.lstIdMonedaClaves.clear();
        this.datosvi.lstPlazoClaves.clear();
        this.datosvi.lstRiesgoClaves.clear();
        this.datosvi.lstFumaClaves.clear();
        this.datosvi.lstClavesBAS.clear();
        this.datosvi.lstClavesIMA.clear();
        this.datosvi.lstClavesDI.clear();
        this.datosvi.lstClavesTI.clear();
        this.datosvi.lstClavesEP.clear();
        this.datosvi.lstClavesEG.clear();
        this.datosvi.lstClavesPASI.clear();
        this.datosvi.lstClavesGPPI.clear();
        this.datosvi.lstClavesGPPF.clear();
        this.datosvi.lstClavesVG.clear();
        this.datosvi.lstClaveBanda.clear();
        this.datosvi.lstTarifaSH.clear();
        try {
            this.txtQuery = "SELECT * FROM ClaveValores ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlanClaves.add(this.rs.getInt("idPlan"));
                this.datosvi.lstIdMonedaClaves.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstPlazoClaves.add(this.rs.getInt("plazo"));
                this.datosvi.lstRiesgoClaves.add(this.rs.getInt("riesgo"));
                this.datosvi.lstFumaClaves.add(this.rs.getString("fuma"));
                this.datosvi.lstClavesBAS.add(this.rs.getString("BAS"));
                this.datosvi.lstClavesIMA.add(this.rs.getString("IMA"));
                this.datosvi.lstClavesDI.add(this.rs.getString("DI"));
                this.datosvi.lstClavesTI.add(this.rs.getString("TI"));
                this.datosvi.lstClavesEP.add(this.rs.getString("EP"));
                this.datosvi.lstClavesEG.add(this.rs.getString("EG"));
                this.datosvi.lstClavesPASI.add(this.rs.getString("PASI"));
                this.datosvi.lstClavesGPPI.add(this.rs.getString("GPPI"));
                this.datosvi.lstClavesGPPF.add(this.rs.getString("GPPF"));
                this.datosvi.lstClavesVG.add(this.rs.getString("VG"));
                this.datosvi.lstClaveBanda.add(this.rs.getInt("claveBanda"));
                this.datosvi.lstTarifaSH.add(this.rs.getInt("tarifaSH"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " ClaveValores: " + e2.getMessage());
        }
    }

    public void CargaEdades() {
        this.datosvi.lstIdPlanEdad.clear();
        this.datosvi.lstPlazoEdad.clear();
        this.datosvi.lstIdBeneficio.clear();
        this.datosvi.lstEdadMin.clear();
        this.datosvi.lstEdadMax.clear();
        this.datosvi.lstEdadCan.clear();
        try {
            this.txtQuery = "SELECT * FROM Edades ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlanEdad.add(this.rs.getInt("idPlan"));
                this.datosvi.lstPlazoEdad.add(this.rs.getInt("plazo"));
                this.datosvi.lstIdBeneficio.add(this.rs.getString("idBeneficio"));
                this.datosvi.lstEdadMin.add(this.rs.getInt("edadMin"));
                this.datosvi.lstEdadMax.add(this.rs.getInt("edadMax"));
                this.datosvi.lstEdadCan.add(this.rs.getInt("edadCan"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Edades: " + e2.getMessage());
        }
    }

    public void CargaEdadesVPL(Integer plan, Integer plazo, Integer plazoVPL, String beneficio) {
        try {
            this.txtQuery = "SELECT * FROM EdadesVPL WHERE ";
            this.txtQuery = this.txtQuery + "idPlan=" + plan;
            this.txtQuery = this.txtQuery + " AND plazo=" + plazo;
            this.txtQuery = this.txtQuery + " AND plazoVPL=" + plazoVPL;
            this.txtQuery = this.txtQuery + " AND idBeneficio='" + beneficio + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.datosvi.edadMinVPL = this.rs.getInt("edadMin");
            this.datosvi.edadMaxVPL = this.rs.getInt("edadMax");
            this.datosvi.edadCanVPL = this.rs.getInt("edadCan");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " EdadesVPL: " + e2.getMessage());
        }
    }

    public void CargaSumaMinBas() {
        this.datosvi.lstIdPlanSumaMin.clear();
        this.datosvi.lstIdMonedaSumaMin.clear();
        this.datosvi.lstPlazoSumaMin.clear();
        this.datosvi.lstSumaMin.clear();
        this.datosvi.lstRecFijo.clear();
        try {
            this.txtQuery = "SELECT * FROM SumaMinBas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlanSumaMin.add(this.rs.getInt("idPlan"));
                this.datosvi.lstIdMonedaSumaMin.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstPlazoSumaMin.add(this.rs.getInt("plazo"));
                this.datosvi.lstSumaMin.add(this.rs.getInt("sumaMin"));
                this.datosvi.lstRecFijo.add(this.rs.getInt("recFijo"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaMinBas: " + e2.getMessage());
        }
    }

    public void CargaSumaBeneficios() {
        this.datosvi.lstIdBeneficioSumas.clear();
        this.datosvi.lstIdMonedaSumas.clear();
        this.datosvi.lstSumaMinBeneficio.clear();
        this.datosvi.lstSumaMaxBeneficio.clear();
        try {
            this.txtQuery = "SELECT * FROM SumaBeneficios ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdBeneficioSumas.add(this.rs.getString("idBeneficio"));
                this.datosvi.lstIdMonedaSumas.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstSumaMinBeneficio.add(this.rs.getInt("sumaMin"));
                this.datosvi.lstSumaMaxBeneficio.add(this.rs.getInt("sumaMax"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaBeneficios: " + e2.getMessage());
        }
    }

    public void CargaBandas() {
        this.datosvi.lstIdPlanBandas.clear();
        this.datosvi.lstIdMonedaBandas.clear();
        this.datosvi.lstIdBanda.clear();
        this.datosvi.lstSumaInferior.clear();
        this.datosvi.lstSumaSuperior.clear();
        try {
            this.txtQuery = "SELECT * FROM Bandas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlanBandas.add(this.rs.getInt("idPlan"));
                this.datosvi.lstIdMonedaBandas.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstIdBanda.add(this.rs.getInt("idBanda"));
                this.datosvi.lstSumaInferior.add(this.rs.getInt("sumaInferior"));
                this.datosvi.lstSumaSuperior.add(this.rs.getInt("sumaSuperior"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Bandas: " + e2.getMessage());
        }
    }

    public Double CargaTarifa(String plan, Integer edad, Integer banda, String sexo, String fuma) {
        Double tarifa = 0.0;
        try {
            this.txtQuery = "SELECT * FROM Primas WHERE ";
            this.txtQuery = this.txtQuery + "plan='" + plan + "'";
            this.txtQuery = this.txtQuery + " AND edad=" + edad;
            this.txtQuery = this.txtQuery + " AND banda=" + banda;
            this.txtQuery = this.txtQuery + " AND sexo='" + sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            tarifa = this.rs.getDouble("prima");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Primas: " + this.txtQuery + e2.getMessage());
        }
        return tarifa;
    }

    public void CargaClaves(Integer plan, Integer moneda, Integer plazo, Integer riesgo, String fuma) {
        try {
            this.txtQuery = "SELECT * FROM ClaveValores WHERE ";
            this.txtQuery = this.txtQuery + "idPlan=" + plan;
            this.txtQuery = this.txtQuery + " AND idMoneda=" + moneda;
            this.txtQuery = this.txtQuery + " AND plazo=" + plazo;
            this.txtQuery = this.txtQuery + " AND riesgo=" + riesgo;
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.datosvi.claveBAS = this.rs.getString("BAS");
            this.datosvi.claveIMA = this.rs.getString("IMA");
            this.datosvi.claveDI = this.rs.getString("DI");
            this.datosvi.claveTI = this.rs.getString("TI");
            this.datosvi.claveEP = this.rs.getString("EP");
            this.datosvi.claveGF = this.rs.getString("GF");
            this.datosvi.claveEPGF = this.rs.getString("EPGF");
            this.datosvi.claveEG = this.rs.getString("EG");
            this.datosvi.clavePASI = this.rs.getString("PASI");
            this.datosvi.claveVG = this.rs.getString("VG");
            this.datosvi.claveBanda = this.rs.getInt("claveBanda");
            this.datosvi.tarifaSH = this.rs.getInt("tarifaSH");
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Claves: " + this.txtQuery + e2.getMessage());
        }
    }

    public Double CargaTarifaGF(Integer moneda, String sexo, String fuma, Integer edad) {
        Double tarifa = 0.0;
        try {
            this.txtQuery = "SELECT * FROM PrimasGF WHERE ";
            this.txtQuery = this.txtQuery + "idMoneda=" + moneda;
            this.txtQuery = this.txtQuery + " AND sexo='" + sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "'";
            this.txtQuery = this.txtQuery + " AND edad=" + edad + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            tarifa = this.rs.getDouble("GF");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " PrimasGF: " + e2.getMessage());
        }
        return tarifa;
    }

    public void CargaRecargoFormaPago() {
        this.datosvi.lstIdPlanRecargo.clear();
        this.datosvi.lstIdMonedaRecargo.clear();
        this.datosvi.lstIdFormaPago.clear();
        this.datosvi.lstTasaRecargo.clear();
        try {
            this.txtQuery = "SELECT * FROM RecargoFormaPago ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPlanRecargo.add(this.rs.getInt("idPlan"));
                this.datosvi.lstIdMonedaRecargo.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstIdFormaPago.add(this.rs.getInt("idFormaPago"));
                this.datosvi.lstTasaRecargo.add(this.rs.getDouble("tasaRecargo"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Recargo Forma de Pago: " + e2.getMessage());
        }
    }

    public void CargaEdadEquiv() {
        Integer n2;
        Integer n3;
        Integer j;
        Integer i = 0;
        while (i <= 60) {
            j = 0;
            while (j <= 60) {
                this.datosvi.edadEquiv[i.intValue()][j.intValue()] = 0;
                n3 = j;
                n2 = j = Integer.valueOf(j + 1);
            }
            n3 = i;
            n2 = i = Integer.valueOf(i + 1);
        }
        try {
            this.txtQuery = "SELECT * FROM tblEdadEquiv ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            i = 17;
            while (this.rs.next()) {
                i = i + 1;
                j = 2;
                while (j <= 44) {
                    this.datosvi.edadEquiv[i.intValue()][j.intValue() + 16] = this.rs.getInt(j);
                    n3 = j;
                    n2 = j = Integer.valueOf(j + 1);
                }
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Edad eauivalente: " + e2.getMessage());
        }
    }

    public void CargaSumaMinEdu() {
        this.datosvi.lstCoberturaEdu.clear();
        this.datosvi.lstIdMonedaEdu.clear();
        this.datosvi.lstSumaMinEdu.clear();
        this.datosvi.lstSumaMaxEdu.clear();
        this.datosvi.lstRecFijoEdu.clear();
        try {
            this.txtQuery = "SELECT * FROM SumaMinEdu ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstCoberturaEdu.add(this.rs.getString("cobertura"));
                this.datosvi.lstIdMonedaEdu.add(this.rs.getInt("idMoneda"));
                this.datosvi.lstSumaMinEdu.add(this.rs.getInt("sumaMin"));
                this.datosvi.lstSumaMaxEdu.add(this.rs.getInt("sumaMax"));
                this.datosvi.lstRecFijoEdu.add(this.rs.getInt("recFijo"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaMinEdu: " + e2.getMessage());
        }
    }

    public Double CargaFacAhorro(String plan, Integer edad, String sexo, String fuma) {
        Double facAhorro = 0.0;
        try {
            this.txtQuery = "SELECT * FROM FacAhorro WHERE ";
            this.txtQuery = this.txtQuery + "plan='" + plan + "'";
            this.txtQuery = this.txtQuery + " AND edad=" + edad;
            this.txtQuery = this.txtQuery + " AND sexo='" + sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            facAhorro = this.rs.getDouble("facAhorro");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " FacAhorro: " + e2.getMessage());
        }
        return facAhorro;
    }

    public Double CargaFacRenta(Integer moneda, Integer plazo, Integer garantia, String sexo, String fuma) {
        Double facRenta = 0.0;
        try {
            this.txtQuery = "SELECT * FROM FacRenta WHERE ";
            this.txtQuery = this.txtQuery + "moneda=" + moneda;
            this.txtQuery = this.txtQuery + " AND plazo=" + plazo;
            this.txtQuery = this.txtQuery + " AND garantia=" + garantia;
            this.txtQuery = this.txtQuery + " AND sexo='" + sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            facRenta = this.rs.getDouble("facRenta");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " FacRenta: " + e2.getMessage());
        }
        return facRenta;
    }

    public void CargaValoresGarantizados(String plan, Integer edad, String sexo, String fuma) {
        this.datosvi.lstFacRescate.clear();
        this.datosvi.lstFacSaldado.clear();
        this.datosvi.lstAnosP.clear();
        this.datosvi.lstDiasP.clear();
        this.datosvi.lstEfeP.clear();
        this.datosvi.lstFacRescate.add(0.0);
        this.datosvi.lstFacSaldado.add(0.0);
        this.datosvi.lstAnosP.add(0);
        this.datosvi.lstDiasP.add(0);
        this.datosvi.lstEfeP.add(0.0);
        try {
            this.txtQuery = "SELECT * FROM valgar WHERE ";
            this.txtQuery = this.txtQuery + "plan='" + plan + "'";
            this.txtQuery = this.txtQuery + " AND edad=" + edad;
            this.txtQuery = this.txtQuery + " AND sexo='" + sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstFacRescate.add(this.rs.getDouble("rescate"));
                this.datosvi.lstFacSaldado.add(this.rs.getDouble("saldado"));
                this.datosvi.lstAnosP.add(this.rs.getInt("anosp"));
                this.datosvi.lstDiasP.add(this.rs.getInt("diasp"));
                this.datosvi.lstEfeP.add(this.rs.getDouble("efep"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " valgar: " + e2.getMessage());
        }
    }

    public void CargaDesBeneficios() {
        this.datosvi.lstIdDesBeneficio.clear();
        this.datosvi.lstDesBeneficio.clear();
        try {
            this.txtQuery = "SELECT * FROM DesBeneficios ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdDesBeneficio.add(this.rs.getString("idBeneficio"));
                this.datosvi.lstDesBeneficio.add(this.rs.getString("desBeneficio"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " DesBeneficios: " + e2.getMessage());
        }
    }

    public Integer BuscaSumaMinBeneficio(String beneficio, Integer moneda, Integer plazo) {
        Integer sumaMinima = 0;
        try {
            this.txtQuery = "SELECT * FROM SumaBeneficios WHERE idBeneficio='" + beneficio + "'";
            this.txtQuery = this.txtQuery + " AND idMoneda= " + moneda + " AND plazo=" + plazo + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                sumaMinima = this.rs.getInt("sumaMin");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaBeneficioa: " + e2.getMessage());
        }
        return sumaMinima;
    }

    public void CargaNombrePruebas() {
        this.datosvi.lstIdPrueba.clear();
        this.datosvi.lstNombrePrueba.clear();
        try {
            this.txtQuery = "SELECT * FROM NombrePruebas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPrueba.add(this.rs.getString("idPrueba"));
                this.datosvi.lstNombrePrueba.add(this.rs.getString("nombrePrueba"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " NombrePruebas: " + e2.getMessage());
        }
    }

    public void CargaPaquetePruebas() {
        this.datosvi.lstIdPaquete.clear();
        this.datosvi.lstIdPruebaPaquete.clear();
        try {
            this.txtQuery = "SELECT * FROM PaquetePruebas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPaquete.add(this.rs.getInt("idPaquete"));
                this.datosvi.lstIdPruebaPaquete.add(this.rs.getString("idPrueba"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " PaquetePruebas: " + e2.getMessage());
        }
    }

    public void CargaPaqueteEdadSuma() {
        this.datosvi.lstEdadIniPrueba.clear();
        this.datosvi.lstEdadFinPrueba.clear();
        this.datosvi.lstSumaIniPrueba.clear();
        this.datosvi.lstSumaFinPrueba.clear();
        this.datosvi.lstIdPaqueteEdad.clear();
        try {
            this.txtQuery = "SELECT * FROM PaqueteEdadSuma ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstEdadIniPrueba.add(this.rs.getInt("edadIni"));
                this.datosvi.lstEdadFinPrueba.add(this.rs.getInt("edadFin"));
                this.datosvi.lstSumaIniPrueba.add(this.rs.getInt("sumaIni"));
                this.datosvi.lstSumaFinPrueba.add(this.rs.getInt("sumaFin"));
                this.datosvi.lstIdPaqueteEdad.add(this.rs.getInt("idPaquete"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " PaqueteEdadSuma: " + e2.getMessage());
        }
    }

    public void CargaReqFinanciero() {
        this.datosvi.lstIdReqFinanciero.clear();
        this.datosvi.lstNombreReqFinanciero.clear();
        try {
            this.txtQuery = "SELECT * FROM ReqFinanciero ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdReqFinanciero.add(this.rs.getInt("idReqFinanciero"));
                this.datosvi.lstNombreReqFinanciero.add(this.rs.getString("nombreReqFinanciero"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " lstNombreReqFinanciero: " + e2.getMessage());
        }
    }

    public void CargaSumaReqFinanciero() {
        this.datosvi.lstSumaIniReqFinanciero.clear();
        this.datosvi.lstSumaFinReqFinanciero.clear();
        this.datosvi.lstIdSumaReqFinanciero.clear();
        try {
            this.txtQuery = "SELECT * FROM SumaReqFinanciero ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstSumaIniReqFinanciero.add(this.rs.getInt("sumaIni"));
                this.datosvi.lstSumaFinReqFinanciero.add(this.rs.getInt("sumaFin"));
                this.datosvi.lstIdSumaReqFinanciero.add(this.rs.getInt("idReqFinanciero"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaReqFinanciero: " + e2.getMessage());
        }
    }

    public void CargaDatosPromotor() {
        try {
            this.txtQuery = "SELECT * FROM DatosPromotor ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.nombrePromotor = this.rs.getString("nombrePromotor");
                this.datosvi.direccion1Promotor = this.rs.getString("direccion1Promotor");
                this.datosvi.direccion2Promotor = this.rs.getString("direccion2Promotor");
                this.datosvi.telefonoPromotor = this.rs.getString("telefonoPromotor");
                this.datosvi.correoPromotor = this.rs.getString("correoPromotor");
                this.datosvi.nombreAgente = this.rs.getString("nombreAgente");
                this.datosvi.telefonoAgente = this.rs.getString("telefonoAgente");
                this.datosvi.correoAgente = this.rs.getString("correoAgente");
                this.datosvi.nombreLogo = this.rs.getString("nombreLogo");
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " DatosPromotor: " + e2.getMessage());
        }
    }

    public void CargaPromotorias() {
        this.datosvi.lstIdPromotor.clear();
        this.datosvi.lstNombrePromotor.clear();
        this.datosvi.lstNombreLogo.clear();
        try {
            this.txtQuery = "SELECT * FROM Promotorias ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.lstIdPromotor.add(this.rs.getInt("idPromotor"));
                this.datosvi.lstNombrePromotor.add(this.rs.getString("nombrePromotor"));
                this.datosvi.lstNombreLogo.add(this.rs.getString("nombreLogo"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Promotorias: " + e2.getMessage());
        }
    }

    public void GuardaPromotoria() {
        this.txtQuery = "UPDATE DatosPromotor SET nombrePromotor = '" + this.datosvi.nombrePromotor + "', ";
        this.txtQuery = this.txtQuery + "idPromotor = " + this.datosvi.idPromotor + ", ";
        this.txtQuery = this.txtQuery + "direccion1Promotor = '" + this.datosvi.direccion1Promotor + "', ";
        this.txtQuery = this.txtQuery + "direccion2Promotor = '" + this.datosvi.direccion2Promotor + "', ";
        this.txtQuery = this.txtQuery + "telefonoPromotor = '" + this.datosvi.telefonoPromotor + "', ";
        this.txtQuery = this.txtQuery + "correoPromotor = '" + this.datosvi.correoPromotor + "', ";
        this.txtQuery = this.txtQuery + "nombreAgente = '" + this.datosvi.nombreAgente + "', ";
        this.txtQuery = this.txtQuery + "telefonoAgente = '" + this.datosvi.telefonoAgente + "', ";
        this.txtQuery = this.txtQuery + "correoAgente = '" + this.datosvi.correoAgente + "', ";
        this.txtQuery = this.txtQuery + "nombreLogo = '" + this.datosvi.nombreLogo + "' ";
        this.txtQuery = this.txtQuery + "WHERE id = 1";
        this.rutinasDB.ActualizaTabla(this.txtQuery);
    }

    public void CargaPromotoriaActual() {
        try {
            this.txtQuery = "SELECT * FROM DatosPromotor ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosvi.idPromotor = this.rs.getInt("idPromotor");
                this.datosvi.nombrePromotor = this.rs.getString("nombrePromotor");
                this.datosvi.direccion1Promotor = this.rs.getString("direccion1Promotor");
                this.datosvi.direccion2Promotor = this.rs.getString("direccion2Promotor");
                this.datosvi.telefonoPromotor = this.rs.getString("telefonoPromotor");
                this.datosvi.correoPromotor = this.rs.getString("correoPromotor");
                this.datosvi.nombreAgente = this.rs.getString("nombreAgente");
                this.datosvi.telefonoAgente = this.rs.getString("telefonoAgente");
                this.datosvi.correoAgente = this.rs.getString("correoAgente");
                this.datosvi.nombreLogo = this.rs.getString("nombreLogo");
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Promotorias: " + e2.getMessage());
        }
    }

    public void CargaRecargoPoliza() {
        this.datos.recargoPoliza.clear();
        this.datos.recargoPoliza.add(0.0);
        try {
            this.txtQuery = this.datos.indexOpcionMeta == 0 ? "SELECT * FROM tblRecargoPoliza ;" : "SELECT * FROM tblRecargoPolizaMetaLife2025 ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.recargoPoliza.add(this.rs.getDouble("recargoPoliza"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblRecargoPoliza: " + e2.getMessage());
        }
    }

    public void CargaCostoUni() {
        this.datos.lstAnoUni.clear();
        this.datos.lstCostoIbero.clear();
        this.datos.lstCostoItam.clear();
        this.datos.lstCostoTec.clear();
        try {
            this.txtQuery = "SELECT * FROM TblCostoUni ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datos.lstAnoUni.add(this.rs.getInt("anoUni"));
                this.datos.lstCostoItam.add(this.rs.getInt("CostoItam"));
                this.datos.lstCostoIbero.add(this.rs.getInt("CostoIbero"));
                this.datos.lstCostoTec.add(this.rs.getInt("CostoTec"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " CostoUni: " + e2.getMessage());
        }
    }

    public Double CargaCostoAdmFlexi(String plan, Integer edad, String benef, Integer banda, Integer ano, String sexo, String fuma) {
        Double costoAdm = 0.0;
        try {
            this.txtQuery = "SELECT * FROM CostoAdmFlexi WHERE ";
            this.txtQuery = this.txtQuery + "plan='" + plan + "'";
            this.txtQuery = this.txtQuery + " AND edad=" + edad;
            this.txtQuery = this.txtQuery + " AND benef='" + benef + "'";
            this.txtQuery = this.txtQuery + " AND banda=" + banda;
            this.txtQuery = this.txtQuery + " AND ano=" + ano;
            this.txtQuery = this.txtQuery + " AND sexo='" + sexo + "'";
            this.txtQuery = this.txtQuery + " AND fuma='" + fuma + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            costoAdm = this.rs.getDouble("admin");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " CostoAdmFlexi: " + this.txtQuery + e2.getMessage());
        }
        return costoAdm;
    }

    public Double[] CargaCoiFlexi(Integer idPlan, String benef, Integer riesgo, String sexo, String fuma) {
        int i;
        Double[] qx = new Double[101];
        String nombreCol = "";
        for (i = 0; i < 101; ++i) {
            qx[i] = 0.0;
        }
        try {
            i = 0;
            this.txtQuery = "SELECT * FROM CoiFlexi WHERE ";
            this.txtQuery = this.txtQuery + "idPlan=" + idPlan;
            this.txtQuery = this.txtQuery + " AND benef='" + benef + "'";
            this.txtQuery = this.txtQuery + " AND riesgo=" + riesgo;
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                nombreCol = sexo == "M" ? (fuma == "S" ? "coiMS" : "coiMN") : (fuma == "S" ? "coiFS" : "coiFN");
                qx[i] = this.rs.getDouble(nombreCol);
                ++i;
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " CoiFlexi: " + e2.getMessage());
        }
        return qx;
    }

    public Double[] CargaCostoRescateFlexi() {
        int i = 0;
        Double[] costo = new Double[11];
        try {
            this.txtQuery = "SELECT * FROM CostoRescateFlexi ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                costo[i] = this.rs.getDouble("costoRescate");
                ++i;
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " CostoRescateFlexi: " + e2.getMessage());
        }
        return costo;
    }

    public Double[][] CargaTasasFlexi() {
        Double[][] tasa = new Double[5][6];
        int i = 0;
        try {
            this.txtQuery = "SELECT * FROM TasasFlexi ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                tasa[i][0] = this.rs.getDouble("diariaMN");
                tasa[i][1] = this.rs.getDouble("mensualMN");
                tasa[i][2] = this.rs.getDouble("trimestralMN");
                tasa[i][3] = this.rs.getDouble("semestralMN");
                tasa[i][4] = this.rs.getDouble("diariaDls");
                tasa[i][5] = this.rs.getDouble("mensualDls");
                ++i;
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " CostoUni: " + e2.getMessage());
        }
        return tasa;
    }

    public void GuardaTasasFlexi() {
        this.txtQuery = "UPDATE TasasFlexi SET ";
        this.txtQuery = this.txtQuery + "diariaMN = " + this.datosvi.tasaInvAnual[0][0] + ", ";
        this.txtQuery = this.txtQuery + "mensualMN = " + this.datosvi.tasaInvAnual[0][1] + ", ";
        this.txtQuery = this.txtQuery + "trimestralMN = " + this.datosvi.tasaInvAnual[0][2] + ", ";
        this.txtQuery = this.txtQuery + "semestralMN = " + this.datosvi.tasaInvAnual[0][3] + ", ";
        this.txtQuery = this.txtQuery + "diariaDls = " + this.datosvi.tasaInvAnual[0][4] + ", ";
        this.txtQuery = this.txtQuery + "mensualDls = " + this.datosvi.tasaInvAnual[0][5];
        this.txtQuery = this.txtQuery + " WHERE cuenta = 'PPR' OR cuenta ='CPEA' OR cuenta ='Ahorro'";
        this.rutinasDB.ActualizaTabla(this.txtQuery);
    }

    public void CargaEstados() {
        this.datosgm.lstEstado.clear();
        this.datosgm.lstIdEstado.clear();
        try {
            this.txtQuery = "SELECT * FROM gmEstados ;";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstIdEstado.add(this.rs.getInt("idEstado"));
                this.datosgm.lstEstado.add(this.rs.getString("Estado"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Etados: " + e2.getMessage());
        }
    }

    public void CargaPlanesGM() {
        this.datosgm.lstPlan.clear();
        this.datosgm.lstIdPlan.clear();
        try {
            this.txtQuery = "SELECT * FROM gmPlanes ;";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstIdPlan.add(this.rs.getInt("idPlan"));
                this.datosgm.lstPlan.add(this.rs.getString("Plan"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Planes: " + e2.getMessage());
        }
    }

    public void CargaFactoresSuma() {
        this.datosgm.lstSumaAseg.clear();
        this.datosgm.lstFacSumaNal.clear();
        this.datosgm.lstFacSumaExt.clear();
        this.datosgm.lstTxtSumaAseg.clear();
        this.datosgm.lstTxtSumaAsegRen.clear();
        try {
            this.txtQuery = "SELECT * FROM gmFactoresSuma ;";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstSumaAseg.add(this.rs.getInt("SumaAsegurada"));
                this.datosgm.lstFacSumaNal.add(this.rs.getDouble("FacNal"));
                this.datosgm.lstFacSumaExt.add(this.rs.getDouble("FacExt"));
                String suma = this.genSubs.FormatoNumInteger("###,###", this.rs.getInt("SumaAsegurada"));
                suma = suma + " UMAM";
                if (this.rs.getInt("SumaAsegurada") == 0) {
                    suma = "Sin l\u00edmite";
                    this.datosgm.lstTxtSumaAsegRen.add(suma);
                    continue;
                }
                this.datosgm.lstTxtSumaAseg.add(suma);
                this.datosgm.lstTxtSumaAsegRen.add(suma);
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmFactoresSuma: " + e2.getMessage());
        }
    }

    public void CargaTarifaNacional() {
        this.datosgm.lstTarNalHombres.clear();
        this.datosgm.lstTarNalMujeres.clear();
        try {
            this.txtQuery = "SELECT * FROM gmTarifaNacional WHERE ";
            this.txtQuery = this.txtQuery + "Region=" + this.datosgm.regionSel + ";";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstTarNalHombres.add(this.rs.getDouble("Hombre"));
                this.datosgm.lstTarNalMujeres.add(this.rs.getDouble("Mujer"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmTarifaNacional: " + e2.getMessage());
        }
    }

    public void CargaTarifaExtranjero() {
        String nombreColH = "";
        String nombreColM = "";
        this.datosgm.lstTarExtHombres.clear();
        this.datosgm.lstTarExtMujeres.clear();
        try {
            this.txtQuery = "SELECT * FROM gmTarifaExtranjero WHERE ";
            this.txtQuery = this.txtQuery + "Region=" + this.datosgm.regionSel + ";";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                nombreColH = "HombreZona" + this.datosgm.zonaSel;
                nombreColM = "MujerZona" + this.datosgm.zonaSel;
                this.datosgm.lstTarExtHombres.add(this.rs.getDouble(nombreColH));
                this.datosgm.lstTarExtMujeres.add(this.rs.getDouble(nombreColM));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmTarifaExtranjero: " + e2.getMessage());
        }
    }

    public void CargaOtrasTarifas() {
        try {
            this.txtQuery = "SELECT * FROM gmOtrasTarifas ;";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.asistenciaViajes = this.rs.getDouble("AsistenciaViajes");
                this.datosgm.enfCatExtranjero = this.rs.getDouble("EnfCatExtranjero");
                this.datosgm.tarEmExtA = this.rs.getDouble("TarEmExtA");
                this.datosgm.tarEmExtB = this.rs.getDouble("TarEmExtB");
                this.datosgm.tarEmExtC = this.rs.getDouble("TarEmExtC");
                this.datosgm.tarEstExtA = this.rs.getDouble("TarEstExtA");
                this.datosgm.tarEstExtB = this.rs.getDouble("TarEstExtB");
                this.datosgm.tarEstExtC = this.rs.getDouble("TarEstExtC");
                this.datosgm.tarFranjaFronteriza = this.rs.getDouble("TarFranjaFronteriza");
                this.datosgm.reduccionDedAcc = this.rs.getDouble("ReduccionDedAcc");
                this.datosgm.tarVision = this.rs.getDouble("TarVision");
                this.datosgm.tarMuerteAcc = this.rs.getDouble("TarMuerteAcc");
                this.datosgm.tarConvInstitucional = this.rs.getDouble("TarConvInstitucional");
                this.datosgm.tarConvColectivo = this.rs.getDouble("TarConvColectivo");
                this.datosgm.tarPG = this.rs.getDouble("TarPG");
                this.datosgm.valorUMA = this.rs.getDouble("valorUMA");
                this.datosgm.derPol = this.rs.getDouble("derPol");
                this.datosgm.maxDerPol = this.rs.getInt("MaxDerPol");
                this.datosgm.sumaMinIncSuma = this.rs.getInt("SumaMinIncSuma");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmOtrasTarifas: " + e2.getMessage());
        }
    }

    public void CargaMetDental() {
        try {
            this.txtQuery = "SELECT * FROM gmMetDental ;";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.tarMetDental = this.rs.getDouble("TarMetDental");
                this.datosgm.tarMetDentalPlus = this.rs.getDouble("TarMetDentalPlus");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmMetDental: " + e2.getMessage());
        }
    }

    public void CargaDedExtTodos() {
        this.datosgm.lstDedExtTodos.clear();
        this.datosgm.lstFacDedExtTodos.clear();
        try {
            this.txtQuery = "SELECT * FROM gmFactoresDeducibleExt";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstDedExtTodos.add(this.rs.getInt("Deducible"));
                this.datosgm.lstFacDedExtTodos.add(this.rs.getDouble("FactorDeducibleExt"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " FactoresDeducibleExt: " + e2.getMessage());
        }
    }

    public void CargaIncrementoTabulador() {
        this.datosgm.lstIncTabulador.clear();
        this.datosgm.lstFacIncTabulador.clear();
        this.datosgm.lstTxtIncTabulador.clear();
        try {
            this.txtQuery = "SELECT * FROM gmIncrementoTabulador";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstIncTabulador.add(this.rs.getDouble("IncTabulador"));
                this.datosgm.lstFacIncTabulador.add(this.rs.getDouble("FacIncTabulador"));
                this.datosgm.lstTxtIncTabulador.add(this.genSubs.FormatoNumDouble("##", this.rs.getDouble("IncTabulador") * 100.0) + " %");
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Inc. IncrementoTabulador: " + e2.getMessage());
        }
    }

    public void CargaSumaMA() {
        this.datosgm.lstSumaMA.clear();
        this.datosgm.lstTxtSumaMA.clear();
        try {
            this.txtQuery = "SELECT * FROM gmSumaMA";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstSumaMA.add(this.rs.getInt("SumaMA"));
                this.datosgm.lstTxtSumaMA.add(this.genSubs.FormatoNumInteger("###,###", this.rs.getInt("SumaMA")));
            }
            this.datosgm.lstSumaMA.add(0);
            this.datosgm.lstTxtSumaMA.add("Excluida");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaMA: " + e2.getMessage());
        }
    }

    public Double CargaTarifaRD(Integer edad, String sexo) {
        Double tarifa = 0.0;
        try {
            this.txtQuery = "SELECT * FROM gmTarifaRentaDiaria WHERE EdadIni<=" + edad;
            this.txtQuery = this.txtQuery + " AND EdadFin>=" + edad;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                if (sexo == "M") {
                    tarifa = this.rs.getDouble("TarRentaHombres");
                    continue;
                }
                tarifa = this.rs.getDouble("TarRentaMujeres");
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " TarifaRentaDiaria: " + e2.getMessage());
        }
        return tarifa;
    }

    public void CargaSumaUG() {
        this.datosgm.lstSumaUG.clear();
        this.datosgm.lstTxtSumaUG.clear();
        try {
            this.txtQuery = "SELECT * FROM gmSumaUG";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstSumaUG.add(this.rs.getInt("SumaUG"));
                this.datosgm.lstTxtSumaUG.add(this.genSubs.FormatoNumInteger("###,###", this.rs.getInt("SumaUG")));
            }
            this.datosgm.lstSumaUG.add(0);
            this.datosgm.lstTxtSumaUG.add("Excluida");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaUG: " + e2.getMessage());
        }
    }

    public void CargaSumaRD() {
        this.datosgm.lstSumaRD.clear();
        this.datosgm.lstTxtSumaRD.clear();
        try {
            this.txtQuery = "SELECT * FROM gmSumaRD";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstSumaRD.add(this.rs.getInt("SumaRD"));
                this.datosgm.lstTxtSumaRD.add(this.genSubs.FormatoNumInteger("###,###", this.rs.getInt("SumaRD")));
            }
            this.datosgm.lstSumaRD.add(0);
            this.datosgm.lstTxtSumaRD.add("Excluida");
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " SumaRD: " + e2.getMessage());
        }
    }

    public void CargaRecargoFP() {
        this.datosgm.lstFormaPago.clear();
        this.datosgm.lstRecFP.clear();
        this.datosgm.lstNumPagos.clear();
        try {
            this.txtQuery = "SELECT * FROM gmRecargoFP ";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstFormaPago.add(this.rs.getString("FormaPago"));
                this.datosgm.lstRecFP.add(this.rs.getDouble("RecargoFP"));
                this.datosgm.lstNumPagos.add(this.rs.getInt("NumPagos"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " RecargoFP: " + e2.getMessage());
        }
    }

    public void CargaDedNal() {
        this.datosgm.lstDedNal.clear();
        this.datosgm.lstTxtDedNal.clear();
        this.datosgm.lstFacDedNal.clear();
        this.datosgm.lstDedExtMin.clear();
        this.datosgm.lstDedExtMax.clear();
        try {
            this.txtQuery = "SELECT * FROM gmFactoresDeducible WHERE ";
            this.txtQuery = this.datosgm.conversionPG != false ? this.txtQuery + "Producto=1 AND" : this.txtQuery + "Producto=0 AND";
            this.txtQuery = this.txtQuery + " idPlan=" + this.datosgm.indexPlan;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstDedNal.add(this.rs.getInt("Deducible"));
                this.datosgm.lstFacDedNal.add(this.rs.getDouble("FactorDeducible"));
                this.datosgm.lstDedExtMin.add(this.rs.getInt("DedExtMin"));
                this.datosgm.lstDedExtMax.add(this.rs.getInt("DedExtMax"));
                this.datosgm.lstTxtDedNal.add(this.genSubs.FormatoNumInteger("$###,###", this.rs.getInt("Deducible")));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmFactoresDeducible: " + e2.getMessage());
        }
    }

    public void CargaCoasNal() {
        Integer coasMin = 0;
        if (this.datosgm.indexPlan == 0) {
            coasMin = 10;
        } else if (this.datosgm.polizaNueva.booleanValue()) {
            coasMin = 10;
        } else if (this.datosgm.indexAnoVenta == 0 || this.datosgm.indexAnoVenta == 3) {
            coasMin = 10;
        } else if (this.datosgm.indexAnoVenta == 1) {
            coasMin = 0;
        } else if (this.datosgm.indexAnoVenta == 2) {
            coasMin = 10;
        }
        this.datosgm.lstCoasNal.clear();
        this.datosgm.lstTxtCoasNal.clear();
        this.datosgm.lstFacCoasNal.clear();
        try {
            this.txtQuery = "SELECT * FROM gmFactoresCoasNal WHERE CoasMin=" + coasMin;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstCoasNal.add(this.rs.getDouble("Coaseguro"));
                this.datosgm.lstFacCoasNal.add(this.rs.getDouble("FactorCoasNal"));
                Double tmpDouble = this.rs.getDouble("Coaseguro") * 100.0;
                String tmpString = this.genSubs.FormatoNumDouble("##", tmpDouble) + "%";
                this.datosgm.lstTxtCoasNal.add(tmpString);
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmFactoresCoasNal: " + e2.getMessage());
        }
    }

    public void CargaMunicipios() {
        this.datosgm.lstMunicipios.clear();
        this.datosgm.lstRegiones.clear();
        this.datosgm.lstZonas.clear();
        this.datosgm.lstFronterizos.clear();
        try {
            this.txtQuery = "SELECT * FROM gmMunicipios WHERE idEstado=" + this.datosgm.idEstadoSel;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.lstMunicipios.add(this.rs.getString("Municipio"));
                this.datosgm.lstRegiones.add(this.rs.getInt("Region"));
                this.datosgm.lstZonas.add(this.rs.getString("Zona"));
                this.datosgm.lstFronterizos.add(this.rs.getString("Fronterizo"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmMunicipios: " + e2.getMessage());
        }
    }

    public Double FactorRegion(Integer idPlan, Integer region) {
        Double factor = 0.0;
        try {
            this.txtQuery = "SELECT * FROM gmFactoresRegion WHERE idPlan =" + idPlan;
            this.txtQuery = this.txtQuery + " AND Region=" + region;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                factor = this.rs.getDouble("FactorRegion");
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmFactoresRegion: " + e2.getMessage());
        }
        return factor;
    }

    public void CargaTarifaIncrementoSuma() {
        try {
            this.txtQuery = "SELECT * FROM gmTarifaIncrementoSuma ";
            this.txtQuery = this.txtQuery + "WHERE Zona='" + this.datosgm.zonaSel + "'";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.tarIncrementoSumaNal = this.rs.getDouble("TarIncSumaNal");
                this.datosgm.tarIncrementoSumaExt = this.rs.getDouble("TarIncSumaExt");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmTarifaIncrementoSuma: " + e2.getMessage());
        }
    }

    public Double CargaTarifaUltimosGastos(Integer edad) {
        Double tarifa = 0.0;
        try {
            this.txtQuery = "SELECT * FROM gmTarifaUltimosGastos ";
            this.txtQuery = this.txtQuery + " WHERE EdadIni<=" + edad + " AND EdadFin>=" + edad;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                tarifa = this.rs.getDouble("TarUltimosGastos");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmTarifaUltimosGastos: " + e2.getMessage());
        }
        return tarifa;
    }

    public void CargaEdadMaxima() {
        try {
            this.txtQuery = "SELECT * FROM gmEdadMaxima ";
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.edadMaxBasico = this.rs.getInt("edadMaxBasico");
                this.datosgm.edadMaxAccidentes = this.rs.getInt("edadMaxAccidentes");
                this.datosgm.edadMaxRD = this.rs.getInt("edadMaxRD");
                this.datosgm.edadMaxUG = this.rs.getInt("edadMaxUG");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmEdadMaxima: " + e2.getMessage());
        }
    }

    public void CargaDescripcion(Integer idPlan, Integer idTexto) {
        try {
            this.txtQuery = "SELECT * FROM gmDesCoberturas ";
            this.txtQuery = this.txtQuery + "WHERE idPlan=" + idPlan;
            this.txtQuery = this.txtQuery + " AND idTexto=" + idTexto;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.tituloDescripcion = this.rs.getString("Titulo");
                this.datosgm.txtDescripcion = this.rs.getString("Descripcion");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmDesCoberturas: " + e2.getMessage());
        }
    }

    public void CargaTopeCoaseguro() {
        Double coasSel = this.datosgm.lstCoasNal.get(this.datosgm.indexCoasNal);
        try {
            this.txtQuery = "SELECT * FROM gmTopeCoaseguro ";
            this.txtQuery = this.txtQuery + "WHERE Coaseguro=" + coasSel;
            this.rs = this.rutinasDB.SeleccionaDatosML(this.txtQuery);
            while (this.rs.next()) {
                this.datosgm.topeCoas0 = this.rs.getInt("Nivel0");
                this.datosgm.topeCoas1 = this.rs.getInt("Nivel1");
                this.datosgm.topeCoas2 = this.rs.getInt("Nivel2");
                this.datosgm.topeCoas3 = this.rs.getInt("Nivel3");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " gmTopeCoaseguro: " + e2.getMessage());
        }
    }

    public void CargaPlanesPrimor() {
        this.datosPrimor.lstPlan.clear();
        this.datosPrimor.lstIdPlan.clear();
        try {
            this.txtQuery = "SELECT * FROM prmPlanes ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.lstIdPlan.add(this.rs.getInt("idPlan"));
                this.datosPrimor.lstPlan.add(this.rs.getString("Plan"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Planes: " + e2.getMessage());
        }
    }

    public void CargaEstadosPrimor() {
        this.datosPrimor.lstEstado.clear();
        this.datosPrimor.lstIdEstado.clear();
        try {
            this.txtQuery = "SELECT * FROM prmEstados ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.lstIdEstado.add(this.rs.getInt("idEstado"));
                this.datosPrimor.lstEstado.add(this.rs.getString("Estado"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Estados: " + e2.getMessage());
        }
    }

    public void CargaEdadesPrimordial() {
        this.datosPrimor.lstEdadMinNueva.clear();
        this.datosPrimor.lstEdadMaxNueva.clear();
        this.datosPrimor.lstEdadMinRenov.clear();
        this.datosPrimor.lstEdadMaxRenov.clear();
        try {
            this.txtQuery = "SELECT * FROM prmEdades ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.lstEdadMinNueva.add(this.rs.getInt("edadMinNueva"));
                this.datosPrimor.lstEdadMaxNueva.add(this.rs.getInt("edadMaxNueva"));
                this.datosPrimor.lstEdadMinRenov.add(this.rs.getInt("edadMinRenov"));
                this.datosPrimor.lstEdadMaxRenov.add(this.rs.getInt("edadMaxRenov"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Edades: " + e2.getMessage());
        }
    }

    public void CargaPrimasPrimordial() {
        this.datosPrimor.lstPrima.clear();
        this.datosPrimor.lstPrimaAdi.clear();
        try {
            this.txtQuery = "SELECT * FROM prmPrimas ;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.lstEdad.add(this.rs.getInt("Edad"));
                this.datosPrimor.lstPrima.add(this.rs.getDouble("Prima"));
                this.datosPrimor.lstPrimaAdi.add(this.rs.getDouble("PrimaAdi"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Primas: " + e2.getMessage());
        }
    }

    public void CargaPrimaEdadPrimordial(Integer edad) {
        try {
            this.txtQuery = "SELECT * FROM prmPrimas WHERE Edad = " + edad + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.prima = this.rs.getDouble("Prima");
                this.datosPrimor.primaAdi = this.rs.getDouble("PrimaAdi");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Primas edad: " + e2.getMessage());
        }
    }

    public void CargaPrimasMetPlus(Integer edad, String sexo) {
        try {
            this.txtQuery = "SELECT * FROM PrimasMetPlus WHERE Edad = " + edad + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosMetPlus.primaBasicoHombre = 0.0;
                this.datosMetPlus.primaBasicoMujer = 0.0;
                this.datosMetPlus.primaMujer = 0.0;
                this.datosMetPlus.primaPlusHombre = 0.0;
                this.datosMetPlus.primaFamiliarHombre = 0.0;
                this.datosMetPlus.primaPlusMujer = 0.0;
                this.datosMetPlus.primaFamiliarMujer = 0.0;
                if (sexo == "M") {
                    this.datosMetPlus.primaBasicoHombre = this.rs.getDouble("BasicoHombre");
                    this.datosMetPlus.primaMujer = 0.0;
                    this.datosMetPlus.primaPlusHombre = this.rs.getDouble("PlusHombre");
                    this.datosMetPlus.primaFamiliarHombre = this.rs.getDouble("FamiliarHombre");
                    continue;
                }
                this.datosMetPlus.primaBasicoMujer = this.rs.getDouble("BasicoMujer");
                this.datosMetPlus.primaMujer = this.rs.getDouble("Mujer");
                this.datosMetPlus.primaPlusMujer = this.rs.getDouble("PlusMujer");
                this.datosMetPlus.primaFamiliarMujer = this.rs.getDouble("FamiliarMujer");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Primas MetPlus edad: " + e2.getMessage());
        }
    }

    public void CargaRecargoFPprimordial() {
        this.datosPrimor.lstFormaPago.clear();
        this.datosPrimor.lstRecFP.clear();
        this.datosPrimor.lstNumPagos.clear();
        try {
            this.txtQuery = "SELECT * FROM prmRecargoFP ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.lstFormaPago.add(this.rs.getString("FormaPago"));
                this.datosPrimor.lstRecFP.add(this.rs.getDouble("RecargoFP"));
                this.datosPrimor.lstNumPagos.add(this.rs.getInt("NumPagos"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " RecargoFPPeimor: " + e2.getMessage());
        }
    }

    public void CargaPadecimientos() {
        this.datosPrimor.lstPadecimientos.clear();
        this.datosPrimor.lstSumaPadecimiento.clear();
        this.datosPrimor.lstPeriodoEspera.clear();
        try {
            this.txtQuery = "SELECT * FROM prmPadecimientos ";
            this.txtQuery = this.txtQuery + "WHERE idPlan='" + this.datosPrimor.indexPlan + "'";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosPrimor.lstPadecimientos.add(this.rs.getString("Padecimiento"));
                this.datosPrimor.lstSumaPadecimiento.add(this.rs.getInt("SumaPadecimiento"));
                this.datosPrimor.lstSumaAdicional.add(this.rs.getInt("SumaAdicional"));
                this.datosPrimor.lstPeriodoEspera.add(this.rs.getString("PeriodoEspera"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Padecimientos: " + e2.getMessage());
        }
    }

    public void CargaCoberturaMetPlus(String paquete, Integer idCob) {
        try {
            this.txtQuery = "SELECT * FROM PaquetesMetPlus ";
            this.txtQuery = this.txtQuery + "WHERE Paquete='" + paquete + "'";
            this.txtQuery = this.txtQuery + " AND idCob=" + idCob;
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.datosMetPlus.cobertura = this.rs.getString("Cobertura");
                this.datosMetPlus.suma = this.rs.getInt("Suma");
                this.datosMetPlus.deducible = this.rs.getInt("Deducible");
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Cobertura: " + e2.getMessage());
        }
    }

    public ResultSet CargaCasoMeta(String archivo) {
        try {
            this.txtQuery = "SELECT * FROM " + archivo + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " RecargoFP: " + e2.getMessage());
        }
        return this.rs;
    }
}

