/*
 * Decompiled with CFR 0.152.
 */
import com.cete.dynamicpdf.Document;
import com.cete.dynamicpdf.Font;
import com.cete.dynamicpdf.LineStyle;
import com.cete.dynamicpdf.Page;
import com.cete.dynamicpdf.PageDimensions;
import com.cete.dynamicpdf.PageOrientation;
import com.cete.dynamicpdf.PageSize;
import com.cete.dynamicpdf.RgbColor;
import com.cete.dynamicpdf.Template;
import com.cete.dynamicpdf.TextAlign;
import com.cete.dynamicpdf.VAlign;
import com.cete.dynamicpdf.pageelements.Image;
import com.cete.dynamicpdf.pageelements.Label;
import com.cete.dynamicpdf.pageelements.Line;
import com.cete.dynamicpdf.pageelements.Row2;
import com.cete.dynamicpdf.pageelements.Table2;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CotizMedica {
    private static CotizMedica cotizMedica = new CotizMedica();
    private DatosGM datosgm = DatosGM.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private DatosVI datosvi = DatosVI.getInstance();
    private Datos datos = Datos.getInstance();
    Float margenIzquierdo;
    Float margenDerecho;
    Float margenSuperior;
    Float margenInferior;
    Float alturaRen;
    Float gapTablas;
    Float posHeader;
    Integer numPag = 0;
    Float alturaPag;
    Float currentX;
    Float currentY;
    Boolean errorPDF = false;
    Float Xprimas;
    Float Yprimas;
    Float XfinPrimas;
    Float YfinPrimas;
    Float posFooter;
    List<Float> anchoTmp = new ArrayList<Float>();
    String txtTemp;
    Image logo1Met = null;
    Float YfinHeader;
    Float XdatosPlan;
    Float YdatosPlan;
    Float XfinDatosPlan;
    Float YfinDatosPlan;
    Float XdesCoberturas;
    Float YdesCoberturas;
    Integer colorAnterior;
    Boolean hayAdicionales;
    Font idFont;
    Integer numCol;
    Integer idColor;
    Float fontSize;
    List<String> string = new ArrayList<String>();
    List<Integer> nCol = new ArrayList<Integer>();
    Float posX;
    Float posY;
    Float anchoRen;
    TextAlign txtAlineado;
    RgbColor txtColor;
    float anchoTexto;
    float anchoDisponible;
    RgbColor colorAzul;
    RgbColor colorAzulOscuro;
    RgbColor colorAzulClaro;
    RgbColor colorBlanco;
    RgbColor colorGris;
    RgbColor colorNegro;
    RgbColor colorVerde;
    RgbColor colorAzulPry1;
    RgbColor colorAzulPry2;
    RgbColor colorRen;
    RgbColor MedicaLifeColor1;
    RgbColor MedicaLifeColor2;
    RgbColor MedicaLifeColor3;
    RgbColor MedicaLifeColor4;
    RgbColor MedicaLifeColor5;
    Document docCotiz;
    PageDimensions dimensions;
    Table2 tblHeader;
    Table2 tblFooter;
    Row2 renHeader;
    Row2 renFooter;
    Page paginaDoc;
    Label lblTexto;
    Table2 tblSeccion;
    Table2 tblPlan;
    Table2 tblPrimas;
    Row2 renSeccion;

    private CotizMedica() {
    }

    public static CotizMedica getInstance() {
        return cotizMedica;
    }

    public void ImprimeCotizacion() {
        this.datos.baseDatos = this.datos.esGManterior ? "Anterior" : "Actual";
        this.ValoresConstantes();
        this.docCotiz = new Document();
        this.docCotiz.setCreator("Ramos Tecnolog\u00eda y Herramientas, S.C.");
        this.docCotiz.setAuthor("Fenando Ramos S.");
        this.docCotiz.setTitle("MedicaLife");
        this.dimensions = new PageDimensions(PageSize.LETTER, PageOrientation.PORTRAIT);
        this.dimensions.setLeftMargin(this.margenIzquierdo.floatValue());
        this.dimensions.setTopMargin(this.margenSuperior.floatValue());
        this.dimensions.setRightMargin(this.margenDerecho.floatValue());
        this.dimensions.setBottomMargin(this.margenInferior.floatValue());
        this.alturaRen = Float.valueOf(14.2f);
        this.gapTablas = Float.valueOf(0.0f);
        this.numPag = 0;
        this.paginaDoc = new Page(this.dimensions);
        this.alturaPag = Float.valueOf(this.paginaDoc.getDimensions().getBody().getHeight());
        this.docCotiz.getPages().add(this.paginaDoc);
        this.Header();
        this.Footer();
        this.numPag = this.numPag + 1;
        this.FormatoMedicaLife();
        this.FormatoCarta();
        this.errorPDF = false;
        this.DibujaPDF();
        if (!this.errorPDF.booleanValue()) {
            this.AbreCotizacion();
        }
    }

    private void FormatoMedicaLife() {
        this.RevisaCoberturasAdicionales();
        this.SeccionInicial();
        this.SeccionDesCoberturas();
        this.SeccionNotas();
        this.SeccionDatosAgente();
    }

    private void SeccionInicial() {
        this.SeccionDatosPlan();
        this.YfinDatosPlan = this.NuevaCoordenadaY(this.YdatosPlan, this.tblPlan);
        this.SeccionPrimas();
        this.YfinPrimas = this.NuevaCoordenadaY(this.Yprimas, this.tblPrimas);
        this.XdesCoberturas = this.XdatosPlan;
        if (this.YfinDatosPlan.floatValue() > this.YfinPrimas.floatValue()) {
            this.tblPlan.getBorder().getRight().setWidth(0.5f);
            this.YdesCoberturas = this.YfinDatosPlan;
        } else {
            this.tblPrimas.getBorder().getLeft().setWidth(0.5f);
            this.YdesCoberturas = this.YfinPrimas;
        }
        this.paginaDoc.getElements().add(this.tblPlan);
        this.paginaDoc.getElements().add(this.tblPrimas);
    }

    private void SeccionDatosPlan() {
        this.string.clear();
        this.nCol.clear();
        for (int i = 0; i < 3; ++i) {
            this.string.add("");
            this.nCol.add(1);
        }
        this.anchoTmp.clear();
        this.anchoTmp.add(Float.valueOf(100.0f));
        this.anchoTmp.add(Float.valueOf(80.0f));
        this.anchoTmp.add(Float.valueOf(70.0f));
        this.XdatosPlan = Float.valueOf(0.0f);
        this.YdatosPlan = Float.valueOf(30.0f);
        this.tblPlan = this.CreaTabla(this.XdatosPlan, this.YdatosPlan, this.anchoTmp, Float.valueOf(250.0f), Float.valueOf(500.0f));
        this.tblPlan.getBorder().setWidth(0.0f);
        this.txtTemp = "Caracter\u00edsticas del plan " + this.datosgm.lstPlan.get(this.datosgm.indexPlan);
        this.string.set(0, this.txtTemp);
        this.nCol.set(0, 3);
        this.colorRen = this.datos.esNN ? this.SeleccionaColor(1) : this.SeleccionaColor(5);
        this.idFont = Font.getHelveticaBold();
        this.fontSize = Float.valueOf(11.0f);
        this.RenNcolumnas(this.tblPlan);
        if (!this.datosgm.nombreContratante.equals("")) {
            this.colorRen = this.colorBlanco;
            this.idFont = Font.getHelvetica();
            this.fontSize = Float.valueOf(9.0f);
            this.string.set(0, "Contratante");
            this.nCol.set(0, 1);
            this.string.set(1, this.datosgm.nombreContratante);
            this.nCol.set(1, 2);
            this.string.set(2, "");
            this.nCol.set(2, 0);
            this.RenNcolumnas(this.tblPlan);
        }
        this.colorRen = this.colorBlanco;
        this.idFont = Font.getHelvetica();
        this.fontSize = Float.valueOf(9.0f);
        this.string.set(0, "SumaAsegurada");
        this.nCol.set(0, 1);
        if (this.datosgm.esRenovacion.booleanValue()) {
            this.string.set(1, this.datosgm.lstTxtSumaAsegRen.get(this.datosgm.indexSuma));
            this.nCol.set(1, 1);
        } else {
            if (this.datosgm.selConversionPG.booleanValue()) {
                this.string.set(1, this.datosgm.lstTxtSumaAsegRen.get(this.datosgm.indexSuma));
            } else {
                this.string.set(1, this.datosgm.lstTxtSumaAseg.get(this.datosgm.indexSuma));
            }
            this.nCol.set(1, 1);
        }
        this.string.set(2, this.datosgm.sumaEquiv);
        this.nCol.set(2, 1);
        this.RenNcolumnas(this.tblPlan);
        this.string.set(0, "Deducible Nacional");
        this.nCol.set(0, 1);
        this.string.set(1, this.genSubs.FormatoNumInteger("###,###", this.datosgm.lstDedNal.get(this.datosgm.indexDedNal)) + " pesos");
        this.nCol.set(1, 1);
        this.string.set(2, "");
        this.nCol.set(2, 0);
        this.RenNcolumnas(this.tblPlan);
        if (this.datosgm.indexPlan == 0) {
            this.string.set(0, "Deducible Extranjero");
            this.nCol.set(0, 1);
            this.string.set(1, this.genSubs.FormatoNumInteger("###,###", this.datosgm.lstDedExt.get(this.datosgm.indexDedExt)) + " d\u00f3lares");
            this.nCol.set(1, 1);
            this.RenNcolumnas(this.tblPlan);
        }
        this.string.set(0, "Coaseguro Nacional");
        this.nCol.set(0, 1);
        this.string.set(1, this.genSubs.FormatoNumDouble("#0%", this.datosgm.lstCoasNal.get(this.datosgm.indexCoasNal)));
        this.nCol.set(1, 1);
        this.RenNcolumnas(this.tblPlan);
        if (this.datosgm.indexPlan == 0) {
            this.string.set(0, "Coaseguro Extranjero");
            this.nCol.set(0, 1);
            this.string.set(1, this.genSubs.FormatoNumDouble("#0%", this.datosgm.coasExt));
            this.nCol.set(1, 1);
            this.RenNcolumnas(this.tblPlan);
        }
        this.colorRen = this.colorBlanco;
        this.idFont = Font.getHelvetica();
        this.fontSize = Float.valueOf(9.0f);
        this.string.set(0, "Forma de pago");
        this.nCol.set(0, 1);
        this.string.set(1, this.datosgm.lstFormaPago.get(this.datosgm.indexFormaPago));
        this.nCol.set(1, 1);
        this.RenNcolumnas(this.tblPlan);
        this.txtTemp = "Residencia: ";
        this.txtTemp = this.txtTemp + this.datosgm.nombreEstado;
        if (!this.datosgm.nombreMunicipio.equals("Todos")) {
            this.txtTemp = this.txtTemp + ", " + this.datosgm.nombreMunicipio;
        }
        this.string.set(0, this.txtTemp);
        this.nCol.set(0, 3);
        this.RenNcolumnas(this.tblPlan);
        this.txtTemp = "Cotizaci\u00f3n para ";
        this.txtTemp = this.datosgm.esRenovacion != false ? this.txtTemp + "renovaci\u00f3n" : this.txtTemp + "p\u00f3liza nueva";
        this.string.set(0, this.txtTemp);
        this.nCol.set(0, 3);
        this.RenNcolumnas(this.tblPlan);
        this.colorRen = this.datos.esNN ? this.SeleccionaColor(1) : this.SeleccionaColor(5);
        this.idFont = Font.getHelveticaBold();
        this.fontSize = Float.valueOf(11.0f);
        this.string.set(0, "Coberturas adicionales solicitadas");
        this.nCol.set(0, 3);
        this.RenNcolumnas(this.tblPlan);
        this.colorRen = this.colorBlanco;
        this.idFont = Font.getHelvetica();
        this.fontSize = Float.valueOf(10.0f);
        if (this.hayAdicionales.booleanValue()) {
            this.EscribeCoberturaAdicional("MetDental Plus", "", this.datosgm.selDentalPlus);
            this.EscribeCoberturaAdicional("Visi\u00f3n", "", this.datosgm.selVision);
            this.EscribeCoberturaAdicional("Emergencia en el extranjero", "", this.datosgm.selEmergencia);
            this.EscribeCoberturaAdicional("Enfermedades catastr\u00f3ficas en el extranjero", "", this.datosgm.selCatastroficas);
            this.EscribeCoberturaAdicional("Incremento en suma asegurada", "", this.datosgm.selIncSuma);
            this.EscribeCoberturaAdicional("Reducci\u00f3n de deducible por accidente", "", this.datosgm.selDeducibleCero);
            this.EscribeCoberturaAdicional("Estudiantes en el extranjero", "", this.datosgm.selEstudiantesExtranjero);
            this.EscribeCoberturaAdicional("Franja fronteriza", "", this.datosgm.selFranjaFronteriza);
            this.EscribeCoberturaAdicional("Incremento al tabulado", this.genSubs.FormatoNumDouble("#0%", this.datosgm.lstIncTabulador.get(this.datosgm.indexIncTabulador)), this.datosgm.selIncTabulador);
            this.EscribeCoberturaAdicional("\u00daltimos gastos", this.datosgm.lstTxtSumaUG.get(this.datosgm.indexUltimosGastos) + " pesos", this.datosgm.selUG);
            this.EscribeCoberturaAdicional("Muerte accidental", this.datosgm.lstTxtSumaMA.get(this.datosgm.indexMuerteAccidental) + " pesos", this.datosgm.selMA);
            this.EscribeCoberturaAdicional("Renta diaria por hospitalizaci\u00f3n", this.datosgm.lstTxtSumaRD.get(this.datosgm.indexRentaDiaria) + " pesos", this.datosgm.selRD);
            this.EscribeCoberturaAdicional("Protecci\u00f3n garantizada", "", this.datosgm.selPG);
            if (this.datosgm.selPG.booleanValue()) {
                if (!this.datosgm.polizaGrupo.equals("")) {
                    this.colorRen = this.colorBlanco;
                    this.idFont = Font.getHelvetica();
                    this.fontSize = Float.valueOf(9.0f);
                    this.string.set(0, "P\u00f3liza Grupo");
                    this.nCol.set(0, 1);
                    this.string.set(1, this.datosgm.polizaGrupo);
                    this.nCol.set(1, 2);
                    this.string.set(2, "");
                    this.nCol.set(2, 0);
                    this.RenNcolumnas(this.tblPlan);
                }
                if (!this.datosgm.nombreEmpresa.equals("")) {
                    this.colorRen = this.colorBlanco;
                    this.idFont = Font.getHelvetica();
                    this.fontSize = Float.valueOf(9.0f);
                    this.string.set(0, "Empresa");
                    this.nCol.set(0, 1);
                    this.string.set(1, this.datosgm.nombreEmpresa);
                    this.nCol.set(1, 2);
                    this.string.set(2, "");
                    this.nCol.set(2, 0);
                    this.RenNcolumnas(this.tblPlan);
                }
            }
            this.EscribeCoberturaAdicional("Conversi\u00f3n por Protecci\u00f3n Garantizada", "", this.datosgm.selConversionPG);
            this.EscribeCoberturaAdicional("Conversi\u00f3n por Endoso Colectivo", "", this.datosgm.selConversionCol);
        } else {
            this.EscribeCoberturaAdicional("Ninguna", "", true);
        }
    }

    private void EscribeCoberturaAdicional(String cobertura, String importe, Boolean cobSel) {
        if (cobSel.booleanValue()) {
            this.string.set(0, cobertura);
            if (importe.equals("")) {
                this.nCol.set(0, 3);
            } else {
                this.nCol.set(0, 2);
                this.string.set(1, importe);
                this.nCol.set(1, 1);
            }
            this.RenNcolumnas(this.tblPlan);
        }
    }

    private void SeccionPrimas() {
        int i;
        this.string.clear();
        this.nCol.clear();
        for (i = 0; i < 4; ++i) {
            this.string.add("");
            this.nCol.add(1);
        }
        this.anchoTmp.clear();
        this.anchoTmp.add(Float.valueOf(130.0f));
        this.anchoTmp.add(Float.valueOf(50.0f));
        this.anchoTmp.add(Float.valueOf(30.0f));
        this.anchoTmp.add(Float.valueOf(60.0f));
        this.Xprimas = Float.valueOf(252.0f);
        this.Yprimas = Float.valueOf(30.0f);
        this.tblPrimas = this.CreaTabla(this.Xprimas, this.Yprimas, this.anchoTmp, Float.valueOf(270.0f), Float.valueOf(500.0f));
        this.tblPrimas.getBorder().setWidth(0.0f);
        this.string.set(0, "Solicitantes");
        this.nCol.set(0, 1);
        this.string.set(1, "Sexo");
        this.nCol.set(1, 1);
        this.string.set(2, "Edad");
        this.nCol.set(2, 1);
        this.string.set(3, "PrimaAnual");
        this.nCol.set(3, 1);
        this.colorRen = this.datos.esNN ? this.SeleccionaColor(1) : this.SeleccionaColor(5);
        this.idFont = Font.getHelveticaBold();
        this.fontSize = Float.valueOf(10.0f);
        this.RenNcolumnas(this.tblPrimas);
        this.CentraColumna(1);
        this.CentraColumna(2);
        this.AlineaDerecha(3);
        this.colorRen = this.colorBlanco;
        this.idFont = Font.getHelvetica();
        this.fontSize = Float.valueOf(10.0f);
        for (i = 0; i < this.datosgm.listaAseg.size(); ++i) {
            this.string.set(0, ((Aseg)this.datosgm.listaAseg.get(i)).getNombreAseg());
            this.nCol.set(0, 1);
            if (((Aseg)this.datosgm.listaAseg.get(i)).getSexoAseg().equals("M")) {
                this.string.set(1, "Masculino");
            } else {
                this.string.set(1, "Femenino");
            }
            this.string.set(2, ((Aseg)this.datosgm.listaAseg.get(i)).getEdadAseg());
            this.nCol.set(2, 1);
            this.string.set(3, ((Aseg)this.datosgm.listaAseg.get(i)).getPrimaAseg());
            this.nCol.set(3, 1);
            this.RenNcolumnas(this.tblPrimas);
            this.CentraColumna(1);
            this.CentraColumna(2);
            this.AlineaDerecha(3);
        }
        this.renSeccion.getCellDefault().getBorder().getBottom().setWidth(0.5f);
        this.EscribeTotales("Prima Neta Anual", this.datosgm.primaNeta);
        if (this.datosgm.indexFormaPago > 0) {
            this.EscribeTotales("Recargo por forma de pago", this.datosgm.recargoFP);
        }
        this.EscribeTotales("Derecho de p\u00f3liza", this.datosgm.derPolTotal);
        this.EscribeTotales("Subtotal", this.datosgm.subTotal);
        this.EscribeTotales("IVA", this.datosgm.IVA);
        this.EscribeTotales("Prima Total", this.datosgm.primaTotal);
        if (this.datosgm.indexFormaPago > 0) {
            this.EscribeTotales("Primer pago", this.datosgm.primerPago);
            this.EscribeTotales("Subsecuentes", this.datosgm.subsecuentes);
        }
    }

    private void EscribeTotales(String txtTotal, Double importe) {
        this.string.set(0, txtTotal);
        this.nCol.set(0, 3);
        this.string.set(1, this.genSubs.FormatoNumDouble("###,###", importe));
        this.nCol.set(1, 1);
        this.RenNcolumnas(this.tblPrimas);
        this.AlineaDerecha(0);
        this.AlineaDerecha(1);
    }

    private void SeccionDesCoberturas() {
        this.EncabezadoDescripcionCoberturas();
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        this.anchoRen = Float.valueOf(520.0f);
        this.alturaRen = Float.valueOf(15.0f);
        this.idFont = Font.getHelveticaBold();
        this.fontSize = Float.valueOf(12.0f);
        this.txtAlineado = TextAlign.LEFT;
        this.txtColor = this.colorNegro;
        this.txtTemp = "Estas coberturas \u00fanicamente aplican para p\u00f3lizas de ";
        this.txtTemp = this.datos.esNN ? this.txtTemp + "venta nueva." : this.txtTemp + "renovaci\u00f3n.";
        this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), this.alturaRen.floatValue(), this.idFont, this.fontSize.floatValue(), this.txtAlineado, this.txtColor);
        this.paginaDoc.getElements().add(this.lblTexto);
        this.currentY = Float.valueOf(this.currentY.floatValue() + (this.alturaRen.floatValue() + 5.0f));
        this.txtTemp = "COBERTURA B\u00c1SICA:";
        this.fontSize = Float.valueOf(10.0f);
        this.posY = this.currentY;
        this.alturaRen = Float.valueOf(12.0f);
        this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), this.alturaRen.floatValue(), this.idFont, this.fontSize.floatValue(), this.txtAlineado, this.txtColor);
        this.paginaDoc.getElements().add(this.lblTexto);
        this.currentY = Float.valueOf(this.currentY.floatValue() + this.alturaRen.floatValue());
        this.anchoDisponible = this.anchoRen.floatValue();
        this.EscribeTituloDescripcion(this.datosgm.indexPlan, 1, Font.getHelveticaBold(), Float.valueOf(10.0f));
        this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        if (this.datosgm.selPG.booleanValue()) {
            this.EscribeTituloDescripcion(this.datosgm.indexPlan, 3, Font.getHelveticaBold(), Float.valueOf(10.0f));
        } else {
            this.EscribeTituloDescripcion(this.datosgm.indexPlan, 2, Font.getHelveticaBold(), Float.valueOf(10.0f));
        }
        this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        this.EscribeTituloDescripcion(9, 18, Font.getHelveticaBold(), Float.valueOf(10.0f));
        this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        this.EscribeTituloDescripcion(9, 11, Font.getHelveticaBold(), Float.valueOf(10.0f));
        this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        this.tablas.CargaTopeCoaseguro();
        this.EscribeTituloDescripcion(9, 20, Font.getHelveticaBold(), Float.valueOf(10.0f));
        if (this.datosgm.topeCoas0 == 0) {
            this.txtTemp = "Sin coaseguro en hospital del Plan Contratado o inferior,";
        } else {
            this.txtTemp = "De " + this.genSubs.FormatoNumInteger("$###,###", this.datosgm.topeCoas0);
            this.txtTemp = this.txtTemp + " en Hospital de Plan Contratado o inferior, ";
        }
        if (this.datosgm.topeCoas1 == 999999) {
            this.txtTemp = this.txtTemp + "sin l\u00edmite para Niveles Hospitalarios superiores al Plan Contratado ";
            this.txtTemp = this.txtTemp + " y sin l\u00edmite en Plan Internacional";
        } else {
            this.txtTemp = this.txtTemp + "de " + this.genSubs.FormatoNumInteger("$###,###", this.datosgm.topeCoas1);
            this.txtTemp = this.txtTemp + " para un Nivel Hospitalario superior al Plan Contratado, ";
            this.txtTemp = this.txtTemp + "sin l\u00edmite para Niveles Hospitalarios superiores ";
            this.txtTemp = this.txtTemp + " y sin l\u00edmite en Plan Internacional";
        }
        this.datosgm.txtDescripcion = this.txtTemp;
        this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        this.txtTemp = "COBERTURAS ADICIONALES:";
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        this.anchoRen = Float.valueOf(520.0f);
        this.alturaRen = Float.valueOf(12.0f);
        this.idFont = Font.getHelveticaBold();
        this.fontSize = Float.valueOf(10.0f);
        this.txtAlineado = TextAlign.LEFT;
        this.txtColor = this.colorNegro;
        this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), this.alturaRen.floatValue(), this.idFont, this.fontSize.floatValue(), this.txtAlineado, this.txtColor);
        this.paginaDoc.getElements().add(this.lblTexto);
        this.currentY = Float.valueOf(this.currentY.floatValue() + this.alturaRen.floatValue());
        if (this.datosgm.selDentalPlus.booleanValue()) {
            this.EscribeTituloDescripcion(9, 1, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selVision.booleanValue()) {
            this.EscribeTituloDescripcion(9, 2, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selEmergencia.booleanValue()) {
            this.EscribeTituloDescripcion(9, 4, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selCatastroficas.booleanValue()) {
            this.EscribeTituloDescripcion(9, 5, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selIncSuma.booleanValue()) {
            this.EscribeTituloDescripcion(9, 15, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selDeducibleCero.booleanValue()) {
            this.EscribeTituloDescripcion(9, 10, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selEstudiantesExtranjero.booleanValue()) {
            this.EscribeTituloDescripcion(9, 14, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selFranjaFronteriza.booleanValue()) {
            this.EscribeTituloDescripcion(9, 9, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selIncTabulador.booleanValue()) {
            this.EscribeTituloDescripcion(9, 12, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selUG.booleanValue()) {
            this.EscribeTituloDescripcion(9, 6, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selMA.booleanValue()) {
            this.EscribeTituloDescripcion(9, 7, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selRD.booleanValue()) {
            this.EscribeTituloDescripcion(9, 8, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selPG.booleanValue()) {
            this.EscribeTituloDescripcion(9, 13, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selConversionPG.booleanValue()) {
            this.EscribeTituloDescripcion(9, 16, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
        if (this.datosgm.selConversionCol.booleanValue()) {
            this.EscribeTituloDescripcion(9, 17, Font.getHelveticaBold(), Float.valueOf(10.0f));
            this.EscribeTextoDescripcion(Font.getHelvetica(), Float.valueOf(10.0f));
        }
    }

    private void EncabezadoDescripcionCoberturas() {
        this.string.clear();
        this.nCol.clear();
        for (int i = 0; i < 1; ++i) {
            this.string.add("");
            this.nCol.add(1);
        }
        this.anchoTmp.clear();
        this.anchoTmp.add(Float.valueOf(520.0f));
        this.XdesCoberturas = Float.valueOf(0.0f);
        this.tblSeccion = this.CreaTabla(this.XdesCoberturas, this.YdesCoberturas, this.anchoTmp, Float.valueOf(520.0f), Float.valueOf(500.0f));
        this.tblSeccion.getBorder().setWidth(0.0f);
        this.txtTemp = "Descripci\u00f3n del Plan y Coberturas Solicitadas ";
        this.string.set(0, this.txtTemp);
        this.nCol.set(0, 1);
        this.colorRen = this.datos.esNN ? this.SeleccionaColor(1) : this.SeleccionaColor(5);
        this.idFont = Font.getHelveticaBold();
        this.fontSize = Float.valueOf(11.0f);
        this.RenNcolumnas(this.tblSeccion);
        this.tblSeccion.getBorder().getTop().setWidth(0.5f);
        this.paginaDoc.getElements().add(this.tblSeccion);
        this.currentY = Float.valueOf(this.NuevaCoordenadaY(this.YdesCoberturas, this.tblSeccion).floatValue() + 3.0f);
    }

    private void EscribeTituloDescripcion(Integer idPlan, Integer idTexto, Font font, Float fontSize) {
        this.RevisaEspacioDisponible(Float.valueOf(55.0f));
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        this.tablas.CargaDescripcion(idPlan, idTexto);
        this.txtTemp = this.datosgm.tituloDescripcion;
        this.anchoTexto = font.getTextWidth(this.txtTemp, fontSize.floatValue());
        this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoTexto, this.alturaRen.floatValue(), font, fontSize.floatValue(), this.txtAlineado, this.txtColor);
        this.paginaDoc.getElements().add(this.lblTexto);
        this.currentX = Float.valueOf(this.anchoTexto);
    }

    private void EscribeTextoDescripcion(Font font, Float fontSize) {
        String txtRemanente = this.txtTemp = this.datosgm.txtDescripcion;
        this.anchoTexto = font.getTextWidth(this.txtTemp, fontSize.floatValue());
        this.anchoDisponible = this.anchoRen.floatValue() - this.currentX.floatValue();
        this.posX = this.currentX;
        this.posY = this.currentY;
        Integer totalChar = txtRemanente.length();
        while (!txtRemanente.equals("")) {
            this.posX = this.currentX;
            this.posY = this.currentY;
            if (this.anchoDisponible > this.anchoTexto) {
                this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoDisponible, this.alturaRen.floatValue(), font, fontSize.floatValue(), this.txtAlineado, this.txtColor);
                this.paginaDoc.getElements().add(this.lblTexto);
                this.currentX = Float.valueOf(this.currentX.floatValue() + this.anchoTexto);
                this.currentY = Float.valueOf(this.currentY.floatValue() + this.alturaRen.floatValue());
                txtRemanente = "";
                continue;
            }
            totalChar = txtRemanente.length();
            this.txtTemp = txtRemanente;
            String lastChar = this.txtTemp.substring(totalChar - 1, totalChar);
            int finStr = totalChar - 1;
            for (int i = totalChar.intValue(); i > 1; --i) {
                this.txtTemp = this.txtTemp.substring(0, i - 1);
                lastChar = this.txtTemp.substring(i - 2, i - 1);
                this.anchoTexto = this.idFont.getTextWidth(this.txtTemp, fontSize.floatValue());
                if (this.anchoTexto < this.anchoDisponible && lastChar.equals(" ")) break;
            }
            txtRemanente = txtRemanente.substring(this.txtTemp.length(), txtRemanente.length());
            this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoDisponible, this.alturaRen.floatValue(), font, fontSize.floatValue(), this.txtAlineado, this.txtColor);
            this.paginaDoc.getElements().add(this.lblTexto);
            this.currentX = Float.valueOf(0.0f);
            this.currentY = Float.valueOf(this.currentY.floatValue() + this.alturaRen.floatValue());
            this.anchoDisponible = this.anchoRen.floatValue();
            this.txtTemp = txtRemanente;
            this.anchoTexto = this.idFont.getTextWidth(this.txtTemp, fontSize.floatValue());
            totalChar = this.txtTemp.length();
        }
        this.currentY = Float.valueOf(this.currentY.floatValue() + 5.0f);
    }

    private void RevisaEspacioDisponible(Float espacioMinimo) {
        if (this.alturaPag.floatValue() - this.currentY.floatValue() < espacioMinimo.floatValue()) {
            this.numPag = this.numPag + 1;
            this.paginaDoc = new Page(this.dimensions);
            this.docCotiz.getPages().add(this.paginaDoc);
            this.Header();
            this.Footer();
            this.SeccionInicial();
            this.EncabezadoDescripcionCoberturas();
        }
    }

    private void SeccionNotas() {
        this.RevisaEspacioDisponible(Float.valueOf(60.0f));
        this.currentY = Float.valueOf(this.currentY.floatValue() + 5.0f);
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        Line line = new Line(this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), this.posY.floatValue(), 1.0f, this.colorNegro, LineStyle.getSolid());
        this.paginaDoc.getElements().add(line);
        this.currentY = Float.valueOf(this.currentY.floatValue() + 7.0f);
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        this.txtTemp = "NOTA: La descripci\u00f3n del Plan y Coberturas solicitadas tienen car\u00e1cter general e informativo ";
        this.txtTemp = this.txtTemp + "apeg\u00e1ndose a las Condiciones Generales  de la p\u00f3liza que en su caso se emita, ";
        this.txtTemp = this.txtTemp + "por lo tanto este documento s\u00f3lo cnstituye una cotizaci\u00f3n de seguro, no representa garant\u00eda";
        this.txtTemp = this.txtTemp + "alguna de aceptaci\u00f3n y, por tanto, no representa garant\u00eda legal.";
        this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), 30.0f, Font.getHelvetica(), 8.0f, this.txtAlineado, this.txtColor);
        this.paginaDoc.getElements().add(this.lblTexto);
        this.currentY = Float.valueOf(this.currentY.floatValue() + 30.0f);
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        this.txtTemp = "(*)Si usted realiza su pago con cargo autom\u00e1tico a tarjeta de cr\u00e9dito Visa o Mastercard, ";
        this.txtTemp = this.txtTemp + "el Recargo por forma de pago ser\u00e1 eliminado.";
        this.lblTexto = new Label(this.txtTemp, this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), this.alturaRen.floatValue(), Font.getHelvetica(), 8.0f, this.txtAlineado, this.txtColor);
        this.paginaDoc.getElements().add(this.lblTexto);
        this.currentY = Float.valueOf(this.currentY.floatValue() + this.alturaRen.floatValue());
        this.posX = Float.valueOf(0.0f);
        this.posY = this.currentY;
        Line line2 = new Line(this.posX.floatValue(), this.posY.floatValue(), this.anchoRen.floatValue(), this.posY.floatValue(), 1.0f, this.colorNegro, LineStyle.getSolid());
        this.paginaDoc.getElements().add(line2);
        this.currentY = Float.valueOf(this.currentY.floatValue() + 3.0f);
    }

    private void SeccionDatosAgente() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MMM/yyyy");
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        this.anchoTmp.clear();
        this.anchoTmp.add(Float.valueOf(150.0f));
        this.anchoTmp.add(Float.valueOf(150.0f));
        this.anchoTmp.add(Float.valueOf(200.0f));
        this.tblSeccion = this.CreaTabla(Float.valueOf(0.0f), Float.valueOf(this.posY.floatValue() + 5.0f), this.anchoTmp, Float.valueOf(500.0f), Float.valueOf(400.0f));
        this.tblSeccion.getBorder().setWidth(0.0f);
        this.AgregaRenglon(Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(2.0f));
        this.AgregaRenglon(Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(2.0f));
        this.renSeccion.getCellDefault().setAlign(TextAlign.LEFT);
        String string1 = "Elaborado por: " + this.datosvi.nombreAgente;
        this.renSeccion.getCells().add(string1, 2);
        string1 = "Fecha de elaboraci\u00f3n: " + sdf.format(c2.getTime());
        this.renSeccion.getCells().add(string1);
        this.AgregaRenglon(Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(1.0f));
        this.renSeccion.getCellDefault().setAlign(TextAlign.LEFT);
        string1 = "Tel\u00e9fono: " + this.datosvi.telefonoAgente;
        this.renSeccion.getCells().add(string1);
        string1 = "Cel: " + this.datosvi.telefonoAgente;
        this.renSeccion.getCells().add(string1);
        string1 = "Versi\u00f3n: " + this.datosvi.numVersion;
        this.renSeccion.getCells().add(string1);
        this.AgregaRenglon(Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(1.0f));
        this.renSeccion.getCellDefault().setAlign(TextAlign.LEFT);
        string1 = "La presente cotizaci\u00f3n tiene una vigencia de 30 d\u00edas naturales a partir de la fecha de elaboraci\u00f3n ";
        string1 = string1 + "y puede sufrir variaci\u00f3n al momento de la suscripci\u00f3n.";
        this.renSeccion.getCells().add(string1, 3);
        this.paginaDoc.getElements().add(this.tblSeccion);
    }

    private void AgregaRenglon(Float renHeight, Float fontSize, Float padding) {
        this.renSeccion = this.tblSeccion.getRows().add(renHeight.floatValue(), Font.getHelvetica(), fontSize.floatValue(), this.colorNegro, RgbColor.getWhite());
        this.renSeccion.getCellDefault().getBorder().setWidth(0.0f);
        this.renSeccion.getCellDefault().setBackgroundColor(RgbColor.getWhite());
        this.renSeccion.getCellDefault().getPadding().setValue(padding.floatValue());
    }

    private void FormatoCarta() {
        this.HeaderCarta();
        this.FooterCarta();
        this.DatosTitularCarta();
        this.PlanCarta();
        this.BeneficiosCarta();
        this.AgenteCarta();
    }

    private void HeaderCarta() {
    }

    private void FooterCarta() {
    }

    private void DatosTitularCarta() {
    }

    private void PlanCarta() {
    }

    private void BeneficiosCarta() {
    }

    private void AgenteCarta() {
    }

    private void Header() {
        this.posHeader = Float.valueOf(0.0f);
        this.anchoTmp.clear();
        this.anchoTmp.add(Float.valueOf(120.0f));
        this.anchoTmp.add(Float.valueOf(400.0f));
        this.tblSeccion = this.CreaTabla(Float.valueOf(0.0f), this.posHeader, this.anchoTmp, Float.valueOf(520.0f), Float.valueOf(50.0f));
        this.tblSeccion.getBorder().setWidth(0.0f);
        this.ConstruyeTblHeader();
        this.paginaDoc.getElements().add(this.tblSeccion);
        this.YfinHeader = this.NuevaCoordenadaY(Float.valueOf(0.0f), this.tblSeccion);
    }

    private void DibujaPDF() {
        String nombreArchivo = this.datosgm.nombrePDF;
        this.errorPDF = false;
        String rutaUser = System.getProperty("user.home") + File.separator + nombreArchivo;
        Path pathArchivo = Paths.get(rutaUser, new String[0]);
        if (Files.exists(pathArchivo, new LinkOption[0])) {
            try {
                Files.delete(pathArchivo);
                this.docCotiz.draw(rutaUser);
            }
            catch (IOException x2) {
                System.err.println(x2);
                this.genSubs.MuestraMensaje("Por favor cierre la cotizaci\u00f3n anterior");
                this.errorPDF = true;
            }
        } else {
            this.docCotiz.draw(rutaUser);
            this.errorPDF = false;
        }
    }

    private Table2 CreaTabla(Float posX, Float posY, List<Float> anchoCol, Float anchoTabla, Float altoTabla) {
        Table2 tbl = new Table2(posX.floatValue(), posY.floatValue(), anchoTabla.floatValue(), altoTabla.floatValue());
        tbl.getCellDefault().getPadding().setValue(2.0f);
        tbl.getBorder().setWidth(0.0f);
        Integer numCols = anchoCol.size();
        for (int i = 0; i < numCols; ++i) {
            tbl.getColumns().add(anchoCol.get(i).floatValue());
        }
        return tbl;
    }

    private void ConstruyeTblHeader() {
        String archivoLogo = "";
        this.renSeccion = this.tblSeccion.getRows().add(10.0f, Font.getHelvetica(), 12.0f, this.colorNegro, this.colorNegro);
        this.renSeccion.getCellDefault().getBorder().setWidth(0.0f);
        archivoLogo = "src/ImgMedica/LogoMedicaLife.jpg";
        try {
            this.logo1Met = new Image(archivoLogo, 0.0f, 0.0f);
        }
        catch (Exception e2) {
            System.out.println("Mensaje: " + e2);
            this.genSubs.MuestraMensaje("No encuentra imagen Logo FlexiLife");
        }
        this.renSeccion.getCells().add(this.logo1Met);
        this.txtTemp = "Cotizaci\u00f3n";
        this.txtTemp = this.datos.esNN ? this.txtTemp + " de Venta Nueva" : this.txtTemp + " de Renovaci\u00f3n";
        this.renSeccion.getCells().add(this.txtTemp);
        this.renSeccion.getCells().getCell2(0).setAlign(TextAlign.LEFT);
        this.renSeccion.getCells().getCell2(1).setAlign(TextAlign.RIGHT);
        this.renSeccion.getCells().getCell2(1).setBackgroundColor(this.colorBlanco);
        this.renSeccion.getCells().getCell2(1).setFontSize(14.0f);
        this.renSeccion.getCells().getCell2(0).setBackgroundColor(this.colorBlanco);
        this.renSeccion.getCells().getCell2(1).setBackgroundColor(this.colorBlanco);
        this.renSeccion.getCells().getCell2(0).setVAlign(VAlign.CENTER);
        this.renSeccion.getCells().getCell2(1).setVAlign(VAlign.BOTTOM);
        this.renSeccion.getCells().getCell2(1).setTextColor(this.colorNegro);
        this.renSeccion.getCells().getCell2(1).setFont(Font.getHelveticaBold());
    }

    private void Footer() {
        Template template = new Template();
        this.TablaFooter();
        this.tblFooter.setY(700.0f);
        template.getElements().add(this.tblFooter);
        this.docCotiz.setTemplate(template);
    }

    private void TablaFooter() {
        this.posFooter = Float.valueOf(0.0f);
        this.anchoTmp.clear();
        this.anchoTmp.add(Float.valueOf(520.0f));
        this.tblFooter = this.CreaTabla(Float.valueOf(0.0f), this.posFooter, this.anchoTmp, Float.valueOf(520.0f), Float.valueOf(200.0f));
        this.tblFooter.getBorder().setWidth(0.0f);
        this.ConstruyeTblFooter();
    }

    private void ConstruyeTblFooter() {
        this.renFooter = this.tblFooter.getRows().add(40.0f, Font.getHelvetica(), 7.0f, this.colorGris, RgbColor.getWhite());
        this.renFooter.getCellDefault().getBorder().setWidth(0.0f);
        this.renFooter.getCellDefault().setBackgroundColor(RgbColor.getWhite());
        this.txtTemp = "MetLife M\u00e9xico, S.A. de C.V., ";
        this.txtTemp = this.txtTemp + "Tel\u00e9fono 55 5328 7000. Lada sin costo 800 METLIFE (638 5433). www.metlife.com.mx";
        this.renFooter.getCells().add(this.txtTemp);
        this.renFooter.getCells().getCell2(0).setAlign(TextAlign.LEFT);
        this.renFooter.getCells().getCell2(0).setVAlign(VAlign.CENTER);
    }

    private void RenNcolumnas(Table2 tbl) {
        this.renSeccion = tbl.getRows().add(10.0f, this.idFont, this.fontSize.floatValue(), this.colorNegro, RgbColor.getWhite());
        this.renSeccion.getCellDefault().getBorder().setWidth(0.0f);
        this.renSeccion.getCellDefault().setBackgroundColor(RgbColor.getWhite());
        this.renSeccion.getCellDefault().getPadding().setValue(1.5f);
        this.renSeccion.getCellDefault().setBackgroundColor(this.colorRen);
        for (int i = 0; i < this.string.size(); ++i) {
            if (this.nCol.get(i) <= 0) continue;
            this.renSeccion.getCells().add(this.string.get(i), (int)this.nCol.get(i));
        }
    }

    private RgbColor SeleccionaColor(Integer nivelColor) {
        RgbColor colorRen = this.MedicaLifeColor1;
        switch (nivelColor) {
            case 1: {
                colorRen = this.MedicaLifeColor1;
                break;
            }
            case 2: {
                colorRen = this.MedicaLifeColor2;
                break;
            }
            case 3: {
                colorRen = this.MedicaLifeColor3;
                break;
            }
            case 4: {
                colorRen = this.MedicaLifeColor4;
                break;
            }
            case 5: {
                colorRen = this.MedicaLifeColor5;
            }
        }
        return colorRen;
    }

    private Float NuevaCoordenadaY(Float yActual, Table2 tabla) {
        Float yNueva = yActual;
        Float alturaVisible = Float.valueOf(tabla.getVisibleHeight());
        yNueva = Float.valueOf(yActual.floatValue() + alturaVisible.floatValue());
        return yNueva;
    }

    private void CentraColumna(Integer numColumna) {
        this.renSeccion.getCells().getCell2(numColumna).setAlign(TextAlign.CENTER);
    }

    private void AlineaIzquierda(Integer numColumna) {
        this.renSeccion.getCells().getCell2(numColumna).setAlign(TextAlign.LEFT);
    }

    private void AlineaDerecha(Integer numColumna) {
        this.renSeccion.getCells().getCell2(numColumna).setAlign(TextAlign.RIGHT);
    }

    private void RevisaCoberturasAdicionales() {
        this.hayAdicionales = false;
        if (this.datosgm.selDentalPlus.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selVision.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selEmergencia.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selCatastroficas.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selIncSuma.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selDeducibleCero.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selEstudiantesExtranjero.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selFranjaFronteriza.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selIncTabulador.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selMA.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selRD.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selUG.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selPG.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selConversionPG.booleanValue()) {
            this.hayAdicionales = true;
        }
        if (this.datosgm.selConversionCol.booleanValue()) {
            this.hayAdicionales = true;
        }
    }

    private void ValoresConstantes() {
        this.margenIzquierdo = Float.valueOf(42.5f);
        this.margenDerecho = Float.valueOf(42.5f);
        this.margenSuperior = Float.valueOf(43.0f);
        this.margenInferior = Float.valueOf(28.35f);
        this.colorAzul = new RgbColor(0, 144, 218);
        this.colorAzulOscuro = new RgbColor(0, 197, 160);
        this.colorAzulClaro = new RgbColor(229, 244, 251);
        this.colorBlanco = new RgbColor(255, 255, 255);
        this.colorGris = new RgbColor(117, 120, 123);
        this.colorNegro = new RgbColor(0, 0, 0);
        this.colorVerde = new RgbColor(164, 206, 78);
        this.colorAzulPry1 = new RgbColor(240, 246, 252);
        this.colorAzulPry2 = new RgbColor(228, 239, 250);
        this.MedicaLifeColor1 = new RgbColor(171, 206, 237);
        this.MedicaLifeColor2 = new RgbColor(255, 255, 255);
        this.MedicaLifeColor3 = new RgbColor(255, 255, 255);
        this.MedicaLifeColor4 = new RgbColor(255, 255, 255);
        this.MedicaLifeColor5 = new RgbColor(255, 232, 153);
    }

    private void AbreCotizacion() {
        String nombreArchivo = this.datosgm.nombrePDF;
        String rutaUser = System.getProperty("user.home") + File.separator + nombreArchivo;
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(rutaUser);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException e2) {
                this.genSubs.MuestraMensaje("Es necesario tener instalado Adobe Acrobat Reader");
            }
        }
    }
}

