/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;

public class MedicaCobController
implements Initializable {
    private DatosVI datosvi = DatosVI.getInstance();
    private DatosGM datosgm = DatosGM.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private CalculosGM calculosgm = CalculosGM.getInstance();
    private CotizMedica cotizMedica = CotizMedica.getInstance();
    private Datos datos = Datos.getInstance();
    private MedicaAlt medicaAlt = MedicaAlt.getInstance();
    private CotizMixMedicaLife cotizMixMedicaLife = CotizMixMedicaLife.getInstance();
    private DatosPrimor datosPrimor = DatosPrimor.getInstance();
    Stage stage;
    Parent root;
    @FXML
    Label lblVersion;
    @FXML
    RadioButton optPolizaNueva;
    @FXML
    RadioButton optRenovacion;
    @FXML
    Label lblAnoVenta;
    @FXML
    ComboBox cmbAnoVenta;
    @FXML
    Label lblPlanSel;
    @FXML
    ComboBox cmbPlan;
    @FXML
    ComboBox cmbSumaAseg;
    @FXML
    Label lblSumaEquiv;
    @FXML
    ComboBox cmbEstado;
    @FXML
    ComboBox cmbMunicipio;
    @FXML
    ComboBox cmbDedNal;
    @FXML
    ComboBox cmbDedExt;
    @FXML
    Label lblDedExt;
    @FXML
    ComboBox cmbCoasNal;
    @FXML
    Label lblCoasExt;
    @FXML
    Label txtCoasExt;
    @FXML
    CheckBox chkConversionPG;
    @FXML
    CheckBox chkConversionEndoso;
    @FXML
    TextField polizaGrupo;
    @FXML
    TextField nombreEmpresa;
    @FXML
    Label lblPolizaGrupo;
    @FXML
    Label lblNombreEmpresa;
    @FXML
    TextField nombre;
    @FXML
    ComboBox cmbParentesco;
    @FXML
    RadioButton optMasculino;
    @FXML
    RadioButton optFemenino;
    @FXML
    TextField edad;
    @FXML
    ComboBox cmbFormaPago;
    @FXML
    Label lblPrimaNeta;
    @FXML
    Label lblRecargoFP;
    @FXML
    Label lblDerPol;
    @FXML
    Label lblSubTotal;
    @FXML
    Label lblIVA;
    @FXML
    Label lblPrimaTotal;
    @FXML
    Label lblPrimerPago;
    @FXML
    Label lblSubsecuentes;
    @FXML
    Label titPrimerPago;
    @FXML
    Label titSubsecuentes;
    @FXML
    CheckBox chkDentalPlus;
    @FXML
    CheckBox chkVision;
    @FXML
    CheckBox chkEmergencia;
    @FXML
    CheckBox chkCatastroficas;
    @FXML
    CheckBox chkIncSuma;
    @FXML
    CheckBox chkDeducibleCero;
    @FXML
    CheckBox chkEstudiantesExtranjero;
    @FXML
    CheckBox chkFranjaFronteriza;
    @FXML
    CheckBox chkPG;
    @FXML
    ComboBox cmbIncTabulador;
    @FXML
    ComboBox cmbUltimosGastos;
    @FXML
    ComboBox cmbMuerteAccidental;
    @FXML
    ComboBox cmbRentaDiaria;
    @FXML
    TableView<Aseg> tblAseg;
    @FXML
    TableColumn tblNombreAseg;
    @FXML
    TableColumn tblParentescoAseg;
    @FXML
    TableColumn tblEdadAseg;
    @FXML
    TableColumn tblSexoAseg;
    @FXML
    TableColumn tblPrimaAseg;
    @FXML
    Label titIva;
    @FXML
    TextField nombreContratante;
    @FXML
    Button btnPrimordial;
    @FXML
    Button btnCotizCombinada;
    @FXML
    Button btnAgregar;
    @FXML
    Button btnModificar;
    @FXML
    Button btnEliminar;
    String txtMensaje;
    String txtNombre;
    String txtParentesco;
    String txtEdad;
    String txtSexo;
    String txtPrima;
    Boolean asegValido;
    Boolean continuar;

    public void initialize(URL url, ResourceBundle rb) {
        this.tblNombreAseg.setCellValueFactory((Callback)new PropertyValueFactory("nombreAseg"));
        this.tblParentescoAseg.setCellValueFactory((Callback)new PropertyValueFactory("parentescoAseg"));
        this.tblEdadAseg.setCellValueFactory((Callback)new PropertyValueFactory("edadAseg"));
        this.tblSexoAseg.setCellValueFactory((Callback)new PropertyValueFactory("sexoAseg"));
        this.tblPrimaAseg.setCellValueFactory((Callback)new PropertyValueFactory("primaAseg"));
        this.tblAseg.setItems(this.datosgm.listaAseg);
        this.InicializaVentana();
        this.ValoresIniciales();
        if (this.datosPrimor.combinaPrimordial.booleanValue()) {
            this.datosgm.listaAseg.clear();
            for (int i = 0; i < this.datosPrimor.listaAseg.size(); ++i) {
                this.txtNombre = ((Aseg)this.datosPrimor.listaAseg.get(i)).getNombreAseg();
                this.txtParentesco = ((Aseg)this.datosPrimor.listaAseg.get(i)).getParentescoAseg();
                this.txtEdad = ((Aseg)this.datosPrimor.listaAseg.get(i)).getEdadAseg();
                this.txtSexo = ((Aseg)this.datosPrimor.listaAseg.get(i)).getSexoAseg();
                this.txtPrima = "$$";
                this.datosgm.listaAseg.add((Object)new Aseg(this.txtNombre, this.txtParentesco, this.txtEdad, this.txtSexo, this.txtPrima));
            }
            this.datosgm.indexFormaPago = this.datosPrimor.indexFormaPago;
            this.cmbFormaPago.getSelectionModel().select(this.datosgm.indexFormaPago);
            this.cmbFormaPago.setDisable(true);
            this.CalculaPrimas();
            this.btnAgregar.setDisable(false);
            this.btnModificar.setDisable(false);
            this.btnEliminar.setDisable(false);
        } else {
            this.btnAgregar.setDisable(false);
            this.btnModificar.setDisable(false);
            this.btnEliminar.setDisable(false);
            this.cmbFormaPago.setDisable(false);
        }
        this.cmbPlan.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaPlanSeleccionado();
            }
        });
        this.cmbSumaAseg.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaSumaSeleccionada();
            }
        });
        this.cmbDedNal.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaDedNalSeleccionado();
            }
        });
        this.cmbDedExt.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaDedExtSeleccionado();
            }
        });
        this.cmbCoasNal.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaCoasNalSeleccionado();
            }
        });
        this.cmbEstado.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaEstadoSeleccionado();
            }
        });
        this.cmbMunicipio.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaMunicipioSeleccionado();
            }
        });
        this.cmbParentesco.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaParentescoSeleccionado();
            }
        });
        this.cmbIncTabulador.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaIncTabuladorSeleccionado();
            }
        });
        this.cmbUltimosGastos.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaUltimosGastosSeleccionado();
            }
        });
        this.cmbRentaDiaria.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaRentaDiariaSeleccionada();
            }
        });
        this.cmbMuerteAccidental.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaMuerteAccidentalSeleccionado();
            }
        });
        this.cmbFormaPago.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaFormaPagoSeleccionado();
            }
        });
        this.cmbAnoVenta.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MedicaCobController.this.RevisaAnoVenta();
            }
        });
        this.nombre.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(100));
        this.edad.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumerosNdigitos(3));
    }

    private void CalculaPrimas() {
        this.calculosgm.CalculaPrimas();
        this.CalculaTotales();
    }

    private void CalculaTotales() {
        this.datosgm.tasaRecargoFP = this.datosgm.lstRecFP.get(this.datosgm.indexFormaPago);
        this.datosgm.recargoFP = this.datosgm.primaNeta * this.datosgm.tasaRecargoFP;
        this.datosgm.numAseg = this.datosgm.listaAseg.size();
        this.datosgm.derPolTotal = this.datosgm.numAseg > this.datosgm.maxDerPol ? Double.valueOf(this.datosgm.derPol * (double)this.datosgm.maxDerPol.intValue()) : Double.valueOf(this.datosgm.derPol * (double)this.datosgm.numAseg.intValue());
        this.datosgm.subTotal = this.datosgm.primaNeta + this.datosgm.recargoFP + this.datosgm.derPolTotal;
        this.datosgm.IVA = this.datosgm.subTotal * this.datosgm.tasaIva;
        this.datosgm.primaTotal = this.datosgm.subTotal + this.datosgm.IVA;
        if (this.datosgm.indexFormaPago > 0) {
            this.datosgm.numPagos = this.datosgm.lstNumPagos.get(this.datosgm.indexFormaPago);
            this.datosgm.primerPago = ((this.datosgm.primaNeta + this.datosgm.recargoFP) / (double)this.datosgm.numPagos.intValue() + this.datosgm.derPolTotal) * (1.0 + this.datosgm.tasaIva);
            this.datosgm.primerPago = this.genSubs.Redondea(this.datosgm.primerPago, 2);
            this.datosgm.subsecuentes = (this.datosgm.primaTotal - this.datosgm.primerPago) / (double)(this.datosgm.numPagos - 1);
        } else {
            this.datosgm.numPagos = 1;
            this.datosgm.primerPago = this.datosgm.primaTotal;
            this.datosgm.subsecuentes = 0.0;
        }
        this.lblPrimaNeta.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.primaNeta));
        this.lblRecargoFP.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.recargoFP));
        this.lblDerPol.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.derPolTotal));
        this.lblSubTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.subTotal));
        this.lblIVA.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.IVA));
        this.lblPrimaTotal.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.primaTotal));
        this.lblPrimerPago.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.primerPago));
        this.lblSubsecuentes.setText(this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.subsecuentes));
    }

    private void ValoresIniciales() {
        this.datosgm.zonaSel = "A";
        this.LlenaCombos();
    }

    private void LlenaCombos() {
        this.cmbPlan.getItems().clear();
        this.cmbPlan.getItems().addAll(this.datosgm.lstPlan);
        this.cmbPlan.getSelectionModel().select(this.datosgm.indexPlan);
        this.cmbAnoVenta.getItems().clear();
        this.cmbAnoVenta.getItems().add((Object)"Julio 2021 a Marzo 2023");
        this.cmbAnoVenta.getItems().add((Object)"Anterior a Julio 2021");
        this.cmbAnoVenta.getItems().add((Object)"Abril 2023 a Marzo 2024");
        this.cmbAnoVenta.getItems().add((Object)"Abril 2024 en adelante");
        this.cmbAnoVenta.getSelectionModel().select(0);
        this.lblAnoVenta.setVisible(true);
        this.cmbAnoVenta.setVisible(true);
        this.optPolizaNueva.setSelected(this.datosgm.polizaNueva.booleanValue());
        this.optRenovacion.setSelected(false);
        this.ClicNuevaRenov();
        this.RevisaPlanSeleccionado();
        this.cmbSumaAseg.getItems().clear();
        this.cmbSumaAseg.getItems().addAll(this.datosgm.lstTxtSumaAseg);
        this.cmbSumaAseg.getSelectionModel().select(this.cmbSumaAseg.getItems().size() - 2);
        this.cmbSumaAseg.getSelectionModel().select(this.datosgm.indexSuma);
        this.RevisaSumaSeleccionada();
        this.cmbEstado.getItems().clear();
        this.cmbEstado.getItems().addAll(this.datosgm.lstEstado);
        this.cmbEstado.getSelectionModel().selectFirst();
        this.RevisaEstadoSeleccionado();
        this.cmbParentesco.getItems().clear();
        this.cmbParentesco.getItems().addAll(this.datosgm.lstParentesco);
        this.cmbParentesco.getSelectionModel().selectFirst();
        this.RevisaParentescoSeleccionado();
        this.cmbIncTabulador.getItems().clear();
        this.cmbIncTabulador.getItems().addAll(this.datosgm.lstTxtIncTabulador);
        this.cmbIncTabulador.getSelectionModel().select(this.datosgm.indexIncTabulador);
        this.RevisaIncTabuladorSeleccionado();
        this.cmbUltimosGastos.getItems().clear();
        this.cmbUltimosGastos.getItems().addAll(this.datosgm.lstTxtSumaUG);
        this.cmbUltimosGastos.getSelectionModel().select(this.datosgm.indexUltimosGastos);
        this.RevisaUltimosGastosSeleccionado();
        this.cmbMuerteAccidental.getItems().clear();
        this.cmbMuerteAccidental.getItems().addAll(this.datosgm.lstTxtSumaMA);
        this.cmbMuerteAccidental.getSelectionModel().select(this.datosgm.indexMuerteAccidental);
        this.RevisaMuerteAccidentalSeleccionado();
        this.cmbRentaDiaria.getItems().clear();
        this.cmbRentaDiaria.getItems().addAll(this.datosgm.lstTxtSumaRD);
        this.cmbRentaDiaria.getSelectionModel().select(this.datosgm.indexRentaDiaria);
        this.RevisaMuerteAccidentalSeleccionado();
        this.cmbFormaPago.getItems().clear();
        this.cmbFormaPago.getItems().addAll(this.datosgm.lstFormaPago);
        this.cmbFormaPago.getSelectionModel().select(this.datosgm.indexFormaPago);
        this.RevisaFormaPagoSeleccionado();
        this.nombreContratante.setText(this.datosgm.nombreContratante);
    }

    private void RevisaPlanSeleccionado() {
        this.datosgm.indexPlan = this.cmbPlan.getSelectionModel().getSelectedIndex();
        this.continuar = true;
        if (this.datosgm.lstIdPlan.get(this.datosgm.indexPlan) != 4) {
            this.continuar = true;
        }
        if (this.continuar.booleanValue()) {
            if (this.datosgm.indexPlan == 0) {
                this.lblDedExt.setVisible(true);
                this.cmbDedExt.setVisible(true);
                this.lblCoasExt.setVisible(true);
                this.txtCoasExt.setVisible(true);
            } else {
                this.lblDedExt.setVisible(false);
                this.cmbDedExt.setVisible(false);
                this.lblCoasExt.setVisible(false);
                this.txtCoasExt.setVisible(false);
            }
            this.ArmaDeducibleCoaseguro();
            this.CalculaPrimas();
        }
    }

    private void RevisaPlanPractico() {
        Integer idEstado = this.datosgm.lstIdEstado.get(this.datosgm.indexEstado);
        if (idEstado == 9 || idEstado == 11 || idEstado == 15 || idEstado == 19) {
            this.continuar = true;
        } else {
            this.continuar = false;
            this.txtMensaje = "El plan Pr\u00e1ctico s\u00f3lo aplica a CDMX, Estado de M\u00e9xico, Jalisco y Nuevo Le\u00f3n\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a CDMX";
            this.genSubs.MuestraMensaje(this.txtMensaje);
            this.cmbEstado.getSelectionModel().select(8);
        }
    }

    private void RevisaEstadoPlanPractico() {
        Integer idEstado = this.datosgm.lstIdEstado.get(this.datosgm.indexEstado);
        if (idEstado == 9 || idEstado == 11 || idEstado == 15 || idEstado == 19) {
            this.continuar = true;
        } else {
            this.continuar = false;
            this.txtMensaje = "El plan Pr\u00e1ctico s\u00f3lo aplica a CDMX, Estado de M\u00e9xico, Jalisco y Nuevo Le\u00f3n\r";
            this.txtMensaje = this.txtMensaje + "Se cambia a Plan B\u00e1sico";
            this.genSubs.MuestraMensaje(this.txtMensaje);
            this.cmbPlan.getSelectionModel().select(3);
        }
    }

    private void ArmaDeducibleCoaseguro() {
        this.tablas.CargaDedNal();
        this.ArmaCmbDedNal();
        this.RevisaDedNalSeleccionado();
        this.tablas.CargaCoasNal();
        this.ArmaCmbCoasNal();
        this.RevisaCoasNalSeleccionado();
        this.RevisaMunicipioSeleccionado();
    }

    private void ArmaCmbDedNal() {
        this.cmbDedNal.getItems().clear();
        this.cmbDedNal.getItems().addAll(this.datosgm.lstTxtDedNal);
        this.cmbDedNal.getSelectionModel().selectFirst();
        this.datosgm.indexDedNal = this.cmbDedNal.getSelectionModel().getSelectedIndex();
    }

    private void ArmaCmbCoasNal() {
        this.cmbCoasNal.getItems().clear();
        this.cmbCoasNal.getItems().addAll(this.datosgm.lstTxtCoasNal);
        this.cmbCoasNal.getSelectionModel().selectFirst();
        this.datosgm.indexCoasNal = this.cmbCoasNal.getSelectionModel().getSelectedIndex();
    }

    private void InicializaVentana() {
        this.lblVersion.setText(this.datosvi.idVersion + this.datosvi.textoLegal);
        this.lblPolizaGrupo.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.polizaGrupo.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.lblNombreEmpresa.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.nombreEmpresa.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.lblPlanSel.setText(this.datosvi.planSel);
        this.tblPrimaAseg.getStyleClass().add((Object)"alineadoDerecha2");
        if (this.datosPrimor.combinaPrimordial.booleanValue()) {
            this.btnPrimordial.setVisible(true);
            this.btnCotizCombinada.setVisible(true);
        } else {
            this.btnPrimordial.setVisible(false);
            this.btnCotizCombinada.setVisible(false);
        }
    }

    private void RevisaSumaSeleccionada() {
        if (this.cmbSumaAseg.getItems().size() > 0) {
            this.datosgm.indexSuma = this.cmbSumaAseg.getSelectionModel().getSelectedIndex();
            this.RevisaEdadMayor();
            if (this.datosgm.existeMayorDeEdad.booleanValue() && this.datosgm.polizaNueva.booleanValue() && this.datosgm.lstSumaAseg.get(this.datosgm.indexSuma) > 7500) {
                this.txtMensaje = "Suma asegurada mayor a 7,500 UMAM no est\u00e1 permitida si hay alg\u00fan asegurado con edad mayor a 65 a\u00f1os. ";
                this.txtMensaje = this.txtMensaje + "Se cambia a 7,500 UMAM";
                this.genSubs.MuestraMensaje(this.txtMensaje);
                this.datosgm.indexSuma = 14;
                this.cmbSumaAseg.getSelectionModel().select(this.datosgm.indexSuma);
            }
            if (this.datosgm.lstSumaAseg.get(this.datosgm.indexSuma) >= this.datosgm.sumaMinIncSuma) {
                this.chkIncSuma.setVisible(true);
            } else {
                this.datosgm.selIncSuma = false;
                this.chkIncSuma.setSelected(false);
                this.chkIncSuma.setVisible(false);
            }
            Double sumaEquiv = (double)this.datosgm.lstSumaAseg.get(this.datosgm.indexSuma).intValue() * this.datosgm.valorUMA;
            if (sumaEquiv == 0.0) {
                this.lblSumaEquiv.setText("Sin l\u00edmite");
                this.datosgm.sumaEquiv = "Sin l\u00edmite";
            } else {
                this.lblSumaEquiv.setText(this.genSubs.FormatoNumDouble("$###,###", sumaEquiv));
                this.datosgm.sumaEquiv = this.genSubs.FormatoNumDouble("$###,###", sumaEquiv);
            }
            this.CalculaPrimas();
        }
    }

    private void RevisaEdadMayor() {
        this.datosgm.existeMayorDeEdad = false;
        if (!(this.optPolizaNueva.isSelected() && (this.datosgm.selConversionCol.booleanValue() || this.datosgm.selConversionPG.booleanValue()) || this.datosgm.listaAseg.size() <= 0)) {
            for (int i = 0; i < this.datosgm.listaAseg.size(); ++i) {
                Integer edadAseg = Integer.parseInt(((Aseg)this.datosgm.listaAseg.get(i)).getEdadAseg());
                if (edadAseg < 65) continue;
                this.datosgm.existeMayorDeEdad = true;
            }
        }
    }

    private void RevisaDedNalSeleccionado() {
        if (this.cmbDedNal.getItems().size() > 0) {
            this.datosgm.indexDedNal = this.cmbDedNal.getSelectionModel().getSelectedIndex();
            Integer valorDeducible = this.datosgm.lstDedNal.get(this.datosgm.indexDedNal);
            if (valorDeducible >= 100000) {
                // empty if block
            }
            this.DatosEmpresa();
            if (this.datosgm.indexPlan == 0) {
                this.datosgm.lstDedExt.clear();
                this.datosgm.lstFacDedExt.clear();
                this.datosgm.lstTxtDedExt.clear();
                Integer indexDedMin = this.datosgm.lstDedExtMin.get(this.datosgm.indexDedNal);
                Integer indexDedMax = this.datosgm.lstDedExtMax.get(this.datosgm.indexDedNal);
                for (int i = indexDedMin.intValue(); i <= indexDedMax; ++i) {
                    this.datosgm.lstDedExt.add(this.datosgm.lstDedExtTodos.get(i));
                    this.datosgm.lstFacDedExt.add(this.datosgm.lstFacDedExtTodos.get(i));
                    this.datosgm.lstTxtDedExt.add(this.genSubs.FormatoNumInteger("###,###", this.datosgm.lstDedExtTodos.get(i)) + " usd");
                }
                this.cmbDedExt.getItems().clear();
                this.cmbDedExt.getItems().addAll(this.datosgm.lstTxtDedExt);
                this.cmbDedExt.getSelectionModel().selectFirst();
                this.datosgm.indexDedExt = this.cmbDedExt.getSelectionModel().getSelectedIndex();
            }
            this.CalculaPrimas();
        }
    }

    private void RevisaDedExtSeleccionado() {
        if (this.cmbDedExt.getItems().size() > 0) {
            this.datosgm.indexDedExt = this.cmbDedExt.getSelectionModel().getSelectedIndex();
        }
        this.CalculaPrimas();
    }

    private void RevisaCoasNalSeleccionado() {
        if (this.cmbCoasNal.getItems().size() > 0) {
            this.datosgm.indexCoasNal = this.cmbCoasNal.getSelectionModel().getSelectedIndex();
            if (this.datosgm.indexPlan == 0) {
                this.datosgm.coasExt = this.datosgm.lstCoasNal.get(this.datosgm.indexCoasNal);
                this.datosgm.facCoasExt = this.datosgm.lstFacCoasNal.get(this.datosgm.indexCoasNal);
                this.txtCoasExt.setText(this.genSubs.FormatoNumDouble("##", this.datosgm.coasExt * 100.0) + "%");
            }
            this.CalculaPrimas();
        }
    }

    private void RevisaEstadoSeleccionado() {
        this.datosgm.indexEstado = this.cmbEstado.getSelectionModel().getSelectedIndex();
        this.datosgm.idEstadoSel = this.datosgm.lstIdEstado.get(this.datosgm.indexEstado);
        this.datosgm.nombreEstado = this.datosgm.lstEstado.get(this.datosgm.indexEstado);
        this.tablas.CargaMunicipios();
        this.cmbMunicipio.getItems().clear();
        this.cmbMunicipio.getItems().addAll(this.datosgm.lstMunicipios);
        this.cmbMunicipio.getSelectionModel().selectFirst();
        this.datosgm.regionSel = this.datosgm.lstRegiones.get(0);
        this.RevisaMunicipioSeleccionado();
        if (this.datosgm.lstIdPlan.get(this.datosgm.indexPlan) == 4) {
            // empty if block
        }
    }

    private void RevisaMunicipioSeleccionado() {
        if (this.cmbMunicipio.getItems().size() > 0) {
            this.datosgm.indexMunicipio = this.cmbMunicipio.getSelectionModel().getSelectedIndex();
            this.datosgm.regionSel = this.datosgm.lstRegiones.get(this.datosgm.indexMunicipio);
            this.datosgm.zonaSel = this.datosgm.lstZonas.get(this.datosgm.indexMunicipio);
            this.datosgm.esFronterizo = this.datosgm.lstFronterizos.get(this.datosgm.indexMunicipio);
            this.datosgm.nombreMunicipio = this.datosgm.lstMunicipios.get(this.datosgm.indexMunicipio);
            this.tablas.CargaTarifaIncrementoSuma();
            this.tablas.CargaTarifaNacional();
            this.tablas.CargaTarifaExtranjero();
            this.RevisaFranjaFronteriza();
        }
        this.CalculaPrimas();
    }

    private void RevisaFranjaFronteriza() {
        if (this.datosgm.indexPlan > 0 && this.datosgm.lstFronterizos.get(this.datosgm.indexMunicipio).equals("S")) {
            this.chkFranjaFronteriza.setVisible(true);
            this.chkFranjaFronteriza.setSelected(false);
            this.titIva.setText("IVA 16%");
            this.datosgm.tasaIva = 0.16;
        } else {
            this.chkFranjaFronteriza.setSelected(false);
            this.chkFranjaFronteriza.setVisible(false);
            this.titIva.setText("IVA 16%");
            this.datosgm.tasaIva = 0.16;
        }
        this.datosgm.selFranjaFronteriza = this.chkFranjaFronteriza.isSelected();
    }

    private void RevisaParentescoSeleccionado() {
        Boolean hayTitular = false;
        Boolean hayConyuge = false;
        String sexoTitular = "";
        String sexoConyuge = "";
        this.datosgm.indexParentesco = this.cmbParentesco.getSelectionModel().getSelectedIndex();
        if (this.datosgm.indexParentesco < 2 && this.datosgm.listaAseg.size() > 0) {
            for (int i = 0; i < this.datosgm.listaAseg.size(); ++i) {
                if (((Aseg)this.datosgm.listaAseg.get(i)).getParentescoAseg() == "Titular") {
                    hayTitular = true;
                    sexoTitular = ((Aseg)this.datosgm.listaAseg.get(i)).getSexoAseg();
                }
                if (((Aseg)this.datosgm.listaAseg.get(i)).getParentescoAseg() != "C\u00f3nyuge") continue;
                hayConyuge = true;
                sexoConyuge = ((Aseg)this.datosgm.listaAseg.get(i)).getSexoAseg();
            }
            if (hayTitular.booleanValue()) {
                if (sexoTitular == "M") {
                    this.optFemenino.setSelected(true);
                } else {
                    this.optMasculino.setSelected(true);
                }
            }
            if (hayConyuge.booleanValue()) {
                if (sexoConyuge == "M") {
                    this.optFemenino.setSelected(true);
                } else {
                    this.optMasculino.setSelected(true);
                }
            }
        }
    }

    private void RevisaIncTabuladorSeleccionado() {
        this.datosgm.indexIncTabulador = this.cmbIncTabulador.getSelectionModel().getSelectedIndex();
        this.datosgm.selIncTabulador = this.datosgm.indexIncTabulador == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.CalculaPrimas();
    }

    private void RevisaUltimosGastosSeleccionado() {
        this.datosgm.indexUltimosGastos = this.cmbUltimosGastos.getSelectionModel().getSelectedIndex();
        this.datosgm.selUG = this.datosgm.indexUltimosGastos == this.datosgm.lstSumaUG.size() - 1 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.CalculaPrimas();
    }

    private void RevisaMuerteAccidentalSeleccionado() {
        this.datosgm.indexMuerteAccidental = this.cmbMuerteAccidental.getSelectionModel().getSelectedIndex();
        this.datosgm.selMA = this.datosgm.indexMuerteAccidental == this.datosgm.lstSumaMA.size() - 1 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.CalculaPrimas();
    }

    private void RevisaFormaPagoSeleccionado() {
        this.datosgm.indexFormaPago = this.cmbFormaPago.getSelectionModel().getSelectedIndex();
        this.CalculaTotales();
        if (this.datosgm.indexFormaPago == 0) {
            this.titPrimerPago.setVisible(false);
            this.lblPrimerPago.setVisible(false);
            this.titSubsecuentes.setVisible(false);
            this.lblSubsecuentes.setVisible(false);
        } else {
            this.titPrimerPago.setVisible(true);
            this.lblPrimerPago.setVisible(true);
            this.titSubsecuentes.setVisible(true);
            this.lblSubsecuentes.setVisible(true);
        }
    }

    private void RevisaRentaDiariaSeleccionada() {
        this.datosgm.indexRentaDiaria = this.cmbRentaDiaria.getSelectionModel().getSelectedIndex();
        this.datosgm.selRD = this.datosgm.indexRentaDiaria == this.datosgm.lstSumaRD.size() - 1 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.CalculaPrimas();
    }

    private void RevisaAnoVenta() {
        if (this.cmbAnoVenta.getItems().size() > 0) {
            this.datosgm.indexAnoVenta = this.cmbAnoVenta.getSelectionModel().getSelectedIndex();
        }
        this.ClicNuevaRenov();
    }

    public void ClicConversionPG() {
        if (this.chkConversionPG.isSelected()) {
            this.chkConversionEndoso.setSelected(false);
        }
        this.datosgm.selConversionPG = this.chkConversionPG.isSelected();
        this.datosgm.selConversionCol = this.chkConversionEndoso.isSelected();
        this.ClicNuevaRenov();
        this.CalculaPrimas();
    }

    public void ClicConversionEndoso() {
        if (this.chkConversionEndoso.isSelected()) {
            this.chkConversionPG.setSelected(false);
        }
        this.datosgm.selConversionCol = this.chkConversionEndoso.isSelected();
        this.datosgm.selConversionPG = this.chkConversionPG.isSelected();
        this.ClicNuevaRenov();
        this.CalculaPrimas();
    }

    public void ClicDentalPlus() {
        this.datosgm.selDentalPlus = this.chkDentalPlus.isSelected();
        this.CalculaPrimas();
    }

    public void ClicVision() {
        this.datosgm.selVision = this.chkVision.isSelected();
        this.CalculaPrimas();
    }

    public void ClicEmergencia() {
        this.datosgm.selEmergencia = this.chkEmergencia.isSelected();
        this.CalculaPrimas();
    }

    public void ClicCatastroficas() {
        this.datosgm.selCatastroficas = this.chkCatastroficas.isSelected();
        this.CalculaPrimas();
    }

    public void ClicIncSuma() {
        this.datosgm.selIncSuma = this.chkIncSuma.isSelected();
        this.CalculaPrimas();
    }

    public void ClicDeducibleCero() {
        this.datosgm.selDeducibleCero = this.chkDeducibleCero.isSelected();
        this.CalculaPrimas();
    }

    public void ClicPG() {
        this.DatosEmpresa();
        if (this.datosgm.selPG.booleanValue()) {
            this.ParametrosPG();
        } else {
            this.ParametrosNormales();
        }
        this.CalculaPrimas();
    }

    private void DatosEmpresa() {
        this.datosgm.selPG = this.chkPG.isSelected();
        this.lblPolizaGrupo.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.polizaGrupo.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.lblNombreEmpresa.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.nombreEmpresa.setVisible(this.datosgm.selConversionPG.booleanValue());
        this.datosgm.conversionPG = this.datosgm.selPG;
        this.lblPolizaGrupo.setVisible(this.datosgm.selPG.booleanValue());
        this.polizaGrupo.setVisible(this.datosgm.selPG.booleanValue());
        this.lblNombreEmpresa.setVisible(this.datosgm.selPG.booleanValue());
        this.nombreEmpresa.setVisible(this.datosgm.selPG.booleanValue());
    }

    private void ParametrosPG() {
        this.ArmaDeducibleCoaseguro();
        this.CalculaPrimas();
    }

    private void ParametrosNormales() {
        this.ArmaDeducibleCoaseguro();
        this.CalculaPrimas();
    }

    public void ClicNuevaRenov() {
        if (this.optRenovacion.isSelected()) {
            this.datos.esNN = false;
            this.datos.esGManterior = false;
            this.medicaAlt.CargaTablasMedicaLife();
            this.lblAnoVenta.setVisible(true);
            this.cmbAnoVenta.setVisible(true);
        } else {
            this.datos.esNN = true;
            this.datos.esGManterior = false;
            this.medicaAlt.CargaTablasMedicaLife();
            this.lblAnoVenta.setVisible(false);
            this.cmbAnoVenta.setVisible(false);
        }
        if (this.optPolizaNueva.isSelected()) {
            this.txtMensaje = "";
            this.RevisaRangoEdades();
        }
        this.tablas.CargaTopeCoaseguro();
        if (this.continuar.booleanValue()) {
            int indexSuma = this.datosgm.indexSuma;
            this.cmbSumaAseg.getItems().clear();
            this.datosgm.polizaNueva = this.optPolizaNueva.isSelected();
            this.datos.esNN = this.optPolizaNueva.isSelected();
            if (this.optPolizaNueva.isSelected()) {
                if (this.datosgm.selConversionPG.booleanValue()) {
                    this.cmbSumaAseg.getItems().addAll(this.datosgm.lstTxtSumaAsegRen);
                } else {
                    this.cmbSumaAseg.getItems().addAll(this.datosgm.lstTxtSumaAseg);
                }
                this.datosgm.esRenovacion = false;
            } else {
                if (this.datosgm.indexAnoVenta == 0) {
                    this.cmbSumaAseg.getItems().addAll(this.datosgm.lstTxtSumaAsegRen);
                } else {
                    this.cmbSumaAseg.getItems().addAll(this.datosgm.lstTxtSumaAsegRen);
                }
                this.datosgm.esRenovacion = true;
            }
            if (indexSuma >= this.datosgm.lstTxtSumaAseg.size()) {
                this.cmbSumaAseg.getSelectionModel().selectLast();
            } else {
                this.cmbSumaAseg.getSelectionModel().select(indexSuma);
            }
            this.RevisaPlanSeleccionado();
            this.tablas.CargaCoasNal();
            this.ArmaCmbCoasNal();
            this.RevisaCoasNalSeleccionado();
        } else {
            this.txtMensaje = this.txtMensaje + "Hay Asegurados con edad fuera de rango para Nuevos Negocios";
            this.genSubs.MuestraMensaje(this.txtMensaje);
            this.optPolizaNueva.setSelected(false);
            this.optRenovacion.setSelected(true);
        }
    }

    private void RevisaRangoEdades() {
        this.continuar = true;
        if (this.datosgm.listaAseg.size() > 0) {
            for (int i = 0; i < this.datosgm.listaAseg.size(); ++i) {
                if (Integer.parseInt(((Aseg)this.datosgm.listaAseg.get(i)).getEdadAseg()) <= this.datosgm.edadMaxBasico) continue;
                this.continuar = false;
            }
        }
    }

    public void ClicEstudiantesExtranjero() {
        this.datosgm.selEstudiantesExtranjero = this.chkEstudiantesExtranjero.isSelected();
        this.CalculaPrimas();
    }

    public void ClicFranjaFronteriza() {
        this.datosgm.selFranjaFronteriza = this.chkFranjaFronteriza.isSelected();
        if (this.chkFranjaFronteriza.isSelected()) {
            this.datosgm.tasaIva = 0.16;
            this.titIva.setText("IVA 16%");
        } else {
            this.datosgm.tasaIva = 0.16;
            this.titIva.setText("IVA 16%");
        }
        this.CalculaPrimas();
    }

    public void AgregaAseg() {
        int i;
        this.txtNombre = this.nombre.getText().toString();
        this.txtParentesco = this.datosgm.lstParentesco.get(this.datosgm.indexParentesco);
        if (this.edad.getText().equals("")) {
            this.edad.setText("0");
        }
        this.txtEdad = this.edad.getText().toString();
        this.txtSexo = this.optMasculino.isSelected() ? "M" : "F";
        this.asegValido = true;
        this.txtMensaje = "";
        if (this.txtNombre == "") {
            this.asegValido = false;
            this.txtMensaje = "Falta nombre del solicitante\r";
        }
        if (this.datosgm.indexParentesco == 0 && this.datosgm.listaAseg.size() > 0) {
            for (i = 0; i < this.datosgm.listaAseg.size(); ++i) {
                if (((Aseg)this.datosgm.listaAseg.get(i)).getParentescoAseg() == "Titular") {
                    this.asegValido = false;
                }
                if (this.asegValido.booleanValue()) continue;
                this.txtMensaje = this.txtMensaje + "Ya exite el titular";
            }
        }
        if (this.datosgm.indexParentesco == 1 && this.datosgm.listaAseg.size() > 0) {
            for (i = 0; i < this.datosgm.listaAseg.size(); ++i) {
                if (((Aseg)this.datosgm.listaAseg.get(i)).getParentescoAseg() == "C\u00f3nyuge") {
                    this.asegValido = false;
                }
                if (this.asegValido.booleanValue()) continue;
                this.txtMensaje = this.txtMensaje + "Ya exite C\u00f3nyuge";
            }
        }
        Integer edadCapturada = Integer.parseInt(this.txtEdad);
        if (!this.optPolizaNueva.isSelected() || !this.datosgm.selConversionCol.booleanValue() && !this.datosgm.selConversionPG.booleanValue()) {
            if (edadCapturada > this.datosgm.edadMaxBasico && this.optPolizaNueva.isSelected()) {
                this.asegValido = false;
                this.txtMensaje = this.txtMensaje + "Edad superior a edad m\u00e1xima";
            }
            if (edadCapturada >= 65 && this.optPolizaNueva.isSelected()) {
                this.datosgm.indexSuma = this.cmbSumaAseg.getSelectionModel().getSelectedIndex();
                if (this.datosgm.lstSumaAseg.get(this.datosgm.indexSuma) > 7500) {
                    this.txtMensaje = "Suma asegurada mayor a 7,500 UMAM no est\u00e1 permitida para edad mayor a 65 a\u00f1os. ";
                    this.asegValido = false;
                }
            }
        }
        if (this.asegValido.booleanValue()) {
            this.txtPrima = "$$";
            this.datosgm.listaAseg.add((Object)new Aseg(this.txtNombre, this.txtParentesco, this.txtEdad, this.txtSexo, this.txtPrima));
            this.CalculaPrimas();
            this.nombre.setText("");
            this.edad.setText("");
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje);
        }
    }

    public void EliminaAseg() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            Aseg aseg = (Aseg)this.tblAseg.getSelectionModel().getSelectedItem();
            this.datosgm.listaAseg.remove((Object)aseg);
            this.CalculaPrimas();
        } else {
            this.genSubs.MuestraMensaje("Debe seleccionar un solicitante");
        }
    }

    public void ModificaAseg() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            Aseg aseg = (Aseg)this.tblAseg.getSelectionModel().getSelectedItem();
            this.txtNombre = aseg.getNombreAseg();
            this.txtParentesco = aseg.getParentescoAseg();
            this.txtSexo = aseg.getSexoAseg();
            this.txtEdad = aseg.getEdadAseg();
            int index = this.txtParentesco == "Titular" ? 0 : (this.txtParentesco == "C\u00f3nyuge" ? 1 : (this.txtParentesco == "Hijo" ? 2 : 3));
            if (this.txtSexo == "M") {
                this.optMasculino.setSelected(true);
            } else {
                this.optFemenino.setSelected(true);
            }
            this.nombre.setText(this.txtNombre);
            this.edad.setText(this.txtEdad);
            this.cmbParentesco.getSelectionModel().select(index);
            this.EliminaAseg();
        }
    }

    public void ClicBorraDatos() {
        this.datosgm.listaAseg.clear();
        this.datosgm.lstEdadAct.clear();
        this.nombre.setText("");
        this.chkDentalPlus.setSelected(false);
        this.chkVision.setSelected(false);
        this.chkEmergencia.setSelected(false);
        this.chkCatastroficas.setSelected(false);
        this.chkIncSuma.setSelected(false);
        this.chkDeducibleCero.setSelected(false);
        this.chkPG.setSelected(false);
        this.chkEstudiantesExtranjero.setSelected(false);
        this.chkFranjaFronteriza.setSelected(false);
        this.chkConversionPG.setSelected(false);
        this.chkConversionEndoso.setSelected(false);
        this.datosgm.selDentalPlus = false;
        this.datosgm.selVision = false;
        this.datosgm.selEmergencia = false;
        this.datosgm.selCatastroficas = false;
        this.datosgm.selIncSuma = false;
        this.datosgm.selDeducibleCero = false;
        this.datosgm.selPG = false;
        this.datosgm.selEstudiantesExtranjero = false;
        this.datosgm.selFranjaFronteriza = false;
        this.datosgm.selConversionPG = false;
        this.datosgm.selConversionCol = false;
        this.cmbIncTabulador.getSelectionModel().selectFirst();
        this.cmbUltimosGastos.getSelectionModel().selectLast();
        this.cmbMuerteAccidental.getSelectionModel().selectLast();
        this.cmbRentaDiaria.getSelectionModel().selectLast();
        this.polizaGrupo.setText("");
        this.nombreEmpresa.setText("");
        this.lblPolizaGrupo.setVisible(false);
        this.polizaGrupo.setVisible(false);
        this.lblNombreEmpresa.setVisible(false);
        this.nombreEmpresa.setVisible(false);
        this.cmbParentesco.getSelectionModel().selectFirst();
        this.nombreContratante.setText("");
        this.datosgm.primaNeta = 0.0;
        this.datosgm.recargoFP = 0.0;
        this.datosgm.derPolTotal = 0.0;
        this.CalculaTotales();
    }

    public void RevisaSeleccion() {
        if (this.tblAseg.getSelectionModel().getSelectedItem() != null) {
            Aseg aseg = (Aseg)this.tblAseg.getSelectionModel().getSelectedItem();
            this.txtNombre = aseg.getNombreAseg();
            this.txtParentesco = aseg.getParentescoAseg();
            this.txtSexo = aseg.getSexoAseg();
            this.txtEdad = aseg.getEdadAseg();
            if (this.datosPrimor.combinaPrimordial.booleanValue()) {
                if (this.txtParentesco == "Titular") {
                    this.btnModificar.setDisable(true);
                    this.btnEliminar.setDisable(true);
                } else {
                    this.btnModificar.setDisable(false);
                    this.btnEliminar.setDisable(false);
                }
            } else {
                this.btnModificar.setDisable(false);
                this.btnEliminar.setDisable(false);
            }
        }
    }

    public void VerCotizacion() {
        this.datosgm.lstEdadAct.clear();
        this.datosgm.nombreContratante = this.nombreContratante.getText().toString();
        this.datosgm.polizaGrupo = this.polizaGrupo.getText().toString();
        this.datosgm.nombreEmpresa = this.nombreEmpresa.getText().toString();
        this.datosgm.polizaGrupo = this.polizaGrupo.getText().toString();
        this.datosgm.nombreEstado = this.datosgm.lstEstado.get(this.datosgm.indexEstado);
        this.datosgm.nombrePDF = "MedicaLife.pdf";
        this.cotizMedica.ImprimeCotizacion();
        if (!this.datosgm.esRenovacion.booleanValue() || this.datosgm.indexPlan > 0) {
            // empty if block
        }
    }

    public void TarifaAnterior() {
        this.GuardaParametrosActuales();
        this.datos.esGManterior = true;
        this.medicaAlt.CargaTablasMedicaLife();
        this.AsignaParametrosActuales();
        this.DeterminaPrimaObjetivo();
        this.datos.esGManterior = false;
        this.datos.esNN = false;
        this.medicaAlt.CargaTablasMedicaLife();
        this.RestableceParametros();
        this.CalculaAlternativa();
        this.RestableceParametros();
    }

    private void AsignaParametrosActuales() {
        int i;
        for (i = 0; i < this.datosgm.lstDedNal.size(); ++i) {
            if (this.datosgm.lstDedNal.get(i) < this.datosgm.deducibleAct) continue;
            this.datosgm.indexDedNalAnt = i;
            break;
        }
        for (i = 0; i < this.datosgm.lstCoasNal.size(); ++i) {
            if (!(this.datosgm.lstCoasNal.get(i) >= this.datosgm.coasAct)) continue;
            this.datosgm.indexCoasNalAnt = i;
            break;
        }
        for (i = 0; i < this.datosgm.lstSumaAseg.size(); ++i) {
            if (this.datosgm.lstSumaAseg.get(i) < this.datosgm.sumaAct) continue;
            this.datosgm.indexSumaAnt = i;
            break;
        }
        for (i = 0; i < this.datosgm.listaAseg.size(); ++i) {
            Integer edadActual = Integer.parseInt(((Aseg)this.datosgm.listaAseg.get(i)).getEdadAseg()) - 1;
            if (edadActual < 0) {
                edadActual = 0;
            }
            ((Aseg)this.datosgm.listaAseg.get(i)).setEdadAseg(edadActual.toString());
        }
    }

    private void DeterminaPrimaObjetivo() {
        this.cmbDedNal.getSelectionModel().select(0);
        this.cmbDedNal.getSelectionModel().select(1);
        this.cmbDedNal.getSelectionModel().select(this.datosgm.indexDedNalAnt);
        this.CalculaTotales();
        this.datosgm.primaGMobjetivo = this.datosgm.primaTotal;
        this.txtMensaje = "Deducible equivalente: " + this.genSubs.FormatoNumInteger("###,###", this.datosgm.lstDedNal.get(this.datosgm.indexDedNalAnt));
        this.txtMensaje = this.txtMensaje + "\rCoaseguro equivalente: " + this.genSubs.FormatoNumDouble("##.#%", this.datosgm.lstCoasNal.get(this.datosgm.indexCoasNalAnt));
        this.txtMensaje = this.txtMensaje + "\rSUma asegurada: " + this.genSubs.FormatoNumInteger("###,###", this.datosgm.lstSumaAseg.get(this.datosgm.indexSumaAnt));
        this.txtMensaje = this.txtMensaje + "\rPrima total objetivo: " + this.genSubs.FormatoNumDouble("###,###.00", this.datosgm.primaTotal);
    }

    private void CalculaAlternativa() {
        this.calculosgm.CalculaPrimas();
        this.CalculaTotales();
        if (this.datosgm.primaTotal / this.datosgm.primaGMobjetivo <= this.datosgm.aproxPrimaObjetivo) {
            this.ContinuarAlternativa();
        } else {
            this.ContinuarAlternativa();
        }
    }

    private void ContinuarAlternativa() {
        Double aproximacion = 0.0;
        Boolean objetivoLogrado = false;
        objetivoLogrado = false;
        for (int i = 0; i < 2; ++i) {
            this.IncrementaDeducible();
            if (!(this.datosgm.primaTotal / this.datosgm.primaGMobjetivo <= this.datosgm.aproxPrimaObjetivo)) continue;
            this.ResultadoObjetivo();
            objetivoLogrado = true;
            break;
        }
        if (!objetivoLogrado.booleanValue()) {
            for (int j = 0; j < 2; ++j) {
                this.IncrementaCoaseguro();
                if (!(this.datosgm.primaTotal / this.datosgm.primaGMobjetivo <= this.datosgm.aproxPrimaObjetivo)) continue;
                this.ResultadoObjetivo();
                break;
            }
        }
        this.txtMensaje = "Se ha elaborado una cotizaci\u00f3n alternativa ";
        if (this.datosgm.primaTotal > this.datosgm.primaGMobjetivo) {
            aproximacion = this.datosgm.primaTotal / this.datosgm.primaGMobjetivo - 1.0;
            this.txtMensaje = this.txtMensaje + "\rcon un incremento del ";
        } else {
            aproximacion = this.datosgm.primaGMobjetivo / this.datosgm.primaTotal - 1.0;
            this.txtMensaje = this.txtMensaje + "\rcon una reducci\u00f3n del ";
        }
        this.txtMensaje = this.txtMensaje + this.genSubs.FormatoNumDouble("###.00%", aproximacion);
        this.txtMensaje = this.txtMensaje + " respecto de la tarifa anterior";
        this.datosgm.nombrePDF = "MedicaLife opcional.pdf";
        this.cotizMedica.ImprimeCotizacion();
    }

    private void IncrementaDeducible() {
        if (this.datosgm.indexDedNal < this.datosgm.lstDedNal.size() - 1) {
            ++this.datosgm.indexDedNal;
            this.cmbDedNal.getSelectionModel().select(this.datosgm.indexDedNal);
            this.CalculaTotales();
        }
    }

    private void IncrementaCoaseguro() {
        if (this.datosgm.indexCoasNal < this.datosgm.lstCoasNal.size() - 1) {
            ++this.datosgm.indexCoasNal;
            this.cmbCoasNal.getSelectionModel().select(this.datosgm.indexCoasNal);
            this.CalculaTotales();
        }
    }

    private void ResultadoObjetivo() {
        this.txtMensaje = "Prima objetivo : " + this.genSubs.FormatoNumDouble("###,###", this.datosgm.primaGMobjetivo);
        this.txtMensaje = this.txtMensaje + "\rPrima de renovaci\u00f3n: " + this.genSubs.FormatoNumDouble("###,###", this.datosgm.primaTotal);
        this.txtMensaje = this.txtMensaje + "\rCon deducible de : " + this.genSubs.FormatoNumInteger("###,###", this.datosgm.lstDedNal.get(this.datosgm.indexDedNal));
        this.txtMensaje = this.txtMensaje + "\rY coaseguro de :" + this.genSubs.FormatoNumDouble("##.##%", this.datosgm.lstCoasNal.get(this.datosgm.indexCoasNal));
    }

    private void GuardaParametrosActuales() {
        this.datosgm.indexPlanAct = this.datosgm.indexPlan;
        this.datosgm.indexSumaAct = this.datosgm.indexSuma;
        this.datosgm.indexDedNalAct = this.datosgm.indexDedNal;
        this.datosgm.indexDedExtAct = this.datosgm.indexDedExt;
        this.datosgm.indexCoasNalAct = this.datosgm.indexCoasNal;
        this.datosgm.indexCoasExtAct = this.datosgm.indexCoasExt;
        this.datosgm.indexEstadoAct = this.datosgm.indexEstado;
        this.datosgm.indexMunicipioAct = this.datosgm.indexMunicipio;
        this.datosgm.indexParentescoAct = this.datosgm.indexParentesco;
        this.datosgm.indexIncTabuladorAct = this.datosgm.indexIncTabulador;
        this.datosgm.indexUltimosGastosAct = this.datosgm.indexUltimosGastos;
        this.datosgm.indexMuerteAccidentalAct = this.datosgm.indexMuerteAccidental;
        this.datosgm.indexRentaDiariaAct = this.datosgm.indexRentaDiaria;
        this.datosgm.indexFormaPagoAct = this.datosgm.indexFormaPago;
        this.datosgm.selDentalPlusAnt = this.datosgm.selDentalPlus;
        this.datosgm.selVisionAnt = this.datosgm.selVision;
        this.datosgm.selEmergenciaAnt = this.datosgm.selEmergencia;
        this.datosgm.selCatastroficasAnt = this.datosgm.selCatastroficas;
        this.datosgm.selIncSumaAnt = this.datosgm.selIncSuma;
        this.datosgm.selIncTabuladorAnt = this.datosgm.selIncTabulador;
        this.datosgm.selUGAnt = this.datosgm.selUG;
        this.datosgm.selMAAnt = this.datosgm.selMA;
        this.datosgm.selRDAnt = this.datosgm.selRD;
        this.datosgm.selPGAnt = this.datosgm.selPG;
        this.datosgm.selConversionPGAnt = this.datosgm.selConversionPG;
        this.datosgm.selConversionColAnt = this.datosgm.selConversionCol;
        this.datosgm.selDeducibleCeroAnt = this.datosgm.selDeducibleCero;
        this.datosgm.selEstudiantesExtranjeroAnt = this.datosgm.selEstudiantesExtranjero;
        this.datosgm.selFranjaFronterizaAnt = this.datosgm.selFranjaFronteriza;
        this.datosgm.deducibleAct = this.datosgm.lstDedNal.get(this.datosgm.indexDedNal);
        this.datosgm.coasAct = this.datosgm.lstCoasNal.get(this.datosgm.indexCoasNal);
        this.datosgm.sumaAct = this.datosgm.lstSumaAseg.get(this.datosgm.indexSuma);
        for (int i = 0; i < this.datosgm.listaAseg.size(); ++i) {
            this.datosgm.lstEdadAct.add(Integer.parseInt(((Aseg)this.datosgm.listaAseg.get(i)).getEdadAseg()));
        }
    }

    private void RestableceParametros() {
        this.cmbDedNal.getSelectionModel().select(this.datosgm.indexDedNalAct);
        this.cmbCoasNal.getSelectionModel().select(this.datosgm.indexCoasNalAct);
        this.cmbSumaAseg.getSelectionModel().select(this.datosgm.indexSumaAct);
        for (int i = 0; i < this.datosgm.listaAseg.size(); ++i) {
            ((Aseg)this.datosgm.listaAseg.get(i)).setEdadAseg(this.datosgm.lstEdadAct.get(i).toString());
        }
    }

    public void MixMedicaLife() {
        if (this.datosgm.listaAseg.size() > 0) {
            this.cotizMixMedicaLife.ImprimeCotizacion();
        } else {
            this.genSubs.MuestraMensaje("Debe capturar participantes");
        }
    }

    public void RegresaPrimordial() {
        this.datosvi.planSel = "Primordial";
        this.datosvi.prodSel = "Primordial";
        this.ValoresInicialesPrimordial();
        this.MuestraInfo("PrimorCob.fxml");
    }

    private void ValoresInicialesPrimordial() {
        this.datosPrimor.indexPlan = 0;
    }

    private void MuestraInfo(String nombreVentana) {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        if (this.datosvi.planSel == "EducaLife") {
            this.datosvi.idPlanSelAnt = this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt("B\u00e1sico EducaLife", this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        } else {
            this.datosvi.idPlanSel = this.genSubs.VlookUpStrInt(this.datosvi.planSel, this.datosvi.lstNombrePlan, this.datosvi.lstIdPlan);
        }
        this.MuestraVentana(nombreVentana);
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Inicio.fxml");
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
            Scene scene = new Scene(this.root);
            this.stage.setScene(scene);
            scene.getStylesheets().add((Object)"cssBase.css");
            this.stage.show();
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
    }
}

