/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.util.ArrayList;
import java.util.List;
import provida.GenSubs;
import provida.Met99Datos;

public class Met99Calcula {
    private static Met99Calcula met99Calcula = new Met99Calcula();
    private static Met99Datos met99Datos = Met99Datos.getInstance();
    private static GenSubs genSubs = GenSubs.getInstance();
    Integer indiceCob;
    Integer sumaObj = 0;
    Double sumaInferior = 0.0;
    Double sumaSuperior = 0.0;
    Boolean error = false;
    Double valTemp = 0.0;
    Double facSel = 0.0;
    Double facMort = 0.0;
    Double facAnualidadInv = 0.0;
    Double Vp = 0.0;
    Double qxGFH;
    Double qxCAT;
    Double qxBCAC;
    Double qxEG;
    Double qxCR;
    Double qxPHT;
    Double qxPHX;
    Double facTipoAP;
    Integer canCAT;
    Integer canBCAC;
    Integer canBCACcomp;
    Integer canAPcomp;
    Double sumaBITcoi;
    Double primaAPcomp;
    Double primaGFcomp;
    Double primaBCACcomp;
    Double primaEGcomp;
    Double primaCRcomp;
    Double primaPHXcomp;
    Double sumaPC;
    Integer edadCanBIT;
    Integer edadCanCAT;
    Integer edadCanBCAC;
    Integer edadCanAP;
    Integer edadCanPHT;
    Double facCanCAT;
    Double facCanBCAC;
    Double facCanAP;
    Double facCanPHT;
    Double facCanEG;
    Double facCanCR;
    Double facCanPHX;
    Double facCanGF;
    List<Integer> lstEdadCanAP = new ArrayList<Integer>();
    List<Integer> lstEdadCanBCAC = new ArrayList<Integer>();
    public Double primaBasTitular;

    private Met99Calcula() {
    }

    public static Met99Calcula getInstance() {
        return met99Calcula;
    }

    public void CalculaPrimas() {
        this.PrimaBAS();
        this.PrimaCII();
        this.PrimaCMA();
        this.PrimaTIBA();
        this.PrimaCAT();
        this.PrimaGFA();
        this.PrimaGE();
        this.PrimaAP();
        this.PrimaEG();
        this.PrimaCR();
        this.PrimaPHT();
        this.PrimaBACY();
        this.PrimaGFC();
        this.PrimaBCAC();
        this.PrimaGFH();
        for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
            this.PrimaBACcomp(i);
            this.PrimaBCACcomp(i);
            this.PrimaAPcomp(i);
            this.PrimaGFcomp(i);
            this.PrimaEGcomp(i);
            this.PrimaCRcomp(i);
            this.PrimaPHXcomp(i);
        }
        this.PrimaBIT();
        Met99Calcula.met99Datos.primaAnualTotal = Met99Calcula.met99Datos.primaBAS + Met99Calcula.met99Datos.primaBIT + Met99Calcula.met99Datos.primaCII;
        Met99Datos i = met99Datos;
        i.primaAnualTotal = i.primaAnualTotal + (Met99Calcula.met99Datos.primaCMA + Met99Calcula.met99Datos.primaTIBA);
        i = met99Datos;
        i.primaAnualTotal = i.primaAnualTotal + (Met99Calcula.met99Datos.primaCAT + Met99Calcula.met99Datos.primaGFA + Met99Calcula.met99Datos.primaGE);
        i = met99Datos;
        i.primaAnualTotal = i.primaAnualTotal + (Met99Calcula.met99Datos.primaAP + Met99Calcula.met99Datos.primaEG + Met99Calcula.met99Datos.primaCR + Met99Calcula.met99Datos.primaPHT);
        i = met99Datos;
        i.primaAnualTotal = i.primaAnualTotal + (Met99Calcula.met99Datos.primaBACY + Met99Calcula.met99Datos.primaGFC + Met99Calcula.met99Datos.primaBCAC);
        i = met99Datos;
        i.primaAnualTotal = i.primaAnualTotal + Met99Calcula.met99Datos.primaGFH;
        for (int i2 = 0; i2 < Met99Calcula.met99Datos.numComp; ++i2) {
            Met99Datos met99Datos = Met99Calcula.met99Datos;
            Double.valueOf(met99Datos.primaAnualTotal + (Met99Calcula.met99Datos.lstPrimaBAC.get(i2) + Met99Calcula.met99Datos.lstPrimaBCAC.get(i2) + Met99Calcula.met99Datos.lstPrimaAP.get(i2)));
            met99Datos.primaAnualTotal = met99Datos.primaAnualTotal;
            met99Datos = Met99Calcula.met99Datos;
            Double.valueOf(met99Datos.primaAnualTotal + (Met99Calcula.met99Datos.lstPrimaGF.get(i2) + Met99Calcula.met99Datos.lstPrimaEG.get(i2) + Met99Calcula.met99Datos.lstPrimaCR.get(i2)));
            met99Datos.primaAnualTotal = met99Datos.primaAnualTotal;
            met99Datos = Met99Calcula.met99Datos;
            Double.valueOf(met99Datos.primaAnualTotal + Met99Calcula.met99Datos.lstPrimaPHX.get(i2));
            met99Datos.primaAnualTotal = met99Datos.primaAnualTotal;
        }
        Met99Calcula.met99Datos.primaFPago = Met99Calcula.met99Datos.formaPago == "Anual" ? Double.valueOf(Met99Calcula.met99Datos.primaAnualTotal + Met99Calcula.met99Datos.primaExcedente) : (Met99Calcula.met99Datos.formaPago == "Mensual" ? Double.valueOf((Met99Calcula.met99Datos.primaAnualTotal + Met99Calcula.met99Datos.primaExcedente) / 12.0) : Double.valueOf((Met99Calcula.met99Datos.primaAnualTotal + Met99Calcula.met99Datos.primaExcedente) / 24.0));
        Met99Calcula.met99Datos.primaAnualConExc = Met99Calcula.met99Datos.primaAnualTotal + Met99Calcula.met99Datos.primaExcedente;
    }

    private void PrimaBAS() {
        if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
            Met99Calcula.met99Datos.epBAS = Met99Calcula.met99Datos.epVida * (double)Met99Calcula.met99Datos.sumaBAS.intValue() / 1000.0;
            Met99Calcula.met99Datos.primaBAS = (Met99Calcula.met99Datos.tarBAS + Met99Calcula.met99Datos.epVida) * (double)Met99Calcula.met99Datos.sumaBAS.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaBAS = 0.0;
            Met99Calcula.met99Datos.epBAS = 0.0;
            Met99Calcula.met99Datos.sumaBAS = 0;
        }
    }

    private void PrimaCII() {
        if (Met99Calcula.met99Datos.selCII.booleanValue()) {
            Met99Calcula.met99Datos.epCII = (Met99Calcula.met99Datos.epInvalidez - 1.0) * Met99Calcula.met99Datos.tarCII * (double)Met99Calcula.met99Datos.sumaCII.intValue() / 1000.0;
            Met99Calcula.met99Datos.primaCII = Met99Calcula.met99Datos.tarCII * Met99Calcula.met99Datos.epInvalidez * (double)Met99Calcula.met99Datos.sumaCII.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaCII = 0.0;
            Met99Calcula.met99Datos.sumaCII = 0;
            Met99Calcula.met99Datos.epCII = 0.0;
        }
    }

    private void PrimaCMA() {
        if (Met99Calcula.met99Datos.selCMA.booleanValue()) {
            Met99Calcula.met99Datos.epCMA = (Met99Calcula.met99Datos.epAccidentes - 1.0) * Met99Calcula.met99Datos.tarCMA * (double)Met99Calcula.met99Datos.sumaCMA.intValue() / 1000.0;
            Met99Calcula.met99Datos.primaCMA = Met99Calcula.met99Datos.tarCMA * Met99Calcula.met99Datos.epAccidentes * (double)Met99Calcula.met99Datos.sumaCMA.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaCMA = 0.0;
            Met99Calcula.met99Datos.sumaCMA = 0;
            Met99Calcula.met99Datos.epCMA = 0.0;
        }
    }

    private void PrimaTIBA() {
        if (Met99Calcula.met99Datos.selTIBA.booleanValue()) {
            Met99Calcula.met99Datos.epTIBA = (Met99Calcula.met99Datos.epAccidentes - 1.0) * Met99Calcula.met99Datos.tarTIBA * (double)Met99Calcula.met99Datos.sumaTIBA.intValue() / 1000.0;
            Met99Calcula.met99Datos.primaTIBA = Met99Calcula.met99Datos.tarTIBA * Met99Calcula.met99Datos.epAccidentes * (double)Met99Calcula.met99Datos.sumaTIBA.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaTIBA = 0.0;
            Met99Calcula.met99Datos.sumaTIBA = 0;
            Met99Calcula.met99Datos.epTIBA = 0.0;
        }
    }

    private void PrimaCAT() {
        Met99Calcula.met99Datos.epCAT = 0.0;
        if (Met99Calcula.met99Datos.selCAT.booleanValue()) {
            Met99Calcula.met99Datos.primaCAT = Met99Calcula.met99Datos.sexoTitular == "M" ? Double.valueOf(Met99Calcula.met99Datos.tarCATH * (double)Met99Calcula.met99Datos.sumaCAT.intValue() / 1000.0) : Double.valueOf(Met99Calcula.met99Datos.tarCATM * (double)Met99Calcula.met99Datos.sumaCAT.intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.primaCAT = 0.0;
            Met99Calcula.met99Datos.sumaCAT = 0;
        }
    }

    private void PrimaGFA() {
        if (Met99Calcula.met99Datos.selGFA.booleanValue()) {
            Met99Calcula.met99Datos.epGFA = Met99Calcula.met99Datos.epVida * (double)Met99Calcula.met99Datos.sumaGFA.intValue() / 1000.0;
            Met99Calcula.met99Datos.primaGFA = (Met99Calcula.met99Datos.tarGFA + Met99Calcula.met99Datos.epVida) * (double)Met99Calcula.met99Datos.sumaGFA.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaGFA = 0.0;
            Met99Calcula.met99Datos.sumaGFA = 0;
            Met99Calcula.met99Datos.epGFA = 0.0;
        }
    }

    private void PrimaGE() {
        if (Met99Calcula.met99Datos.selGE.booleanValue()) {
            Met99Calcula.met99Datos.epGE = Met99Calcula.met99Datos.epVida * (double)Met99Calcula.met99Datos.sumaGE.intValue() / 1000.0;
            Met99Calcula.met99Datos.primaGE = (Met99Calcula.met99Datos.tarGE + Met99Calcula.met99Datos.epVida) * (double)Met99Calcula.met99Datos.sumaGE.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaGE = 0.0;
            Met99Calcula.met99Datos.sumaGE = 0;
            Met99Calcula.met99Datos.epGE = 0.0;
        }
    }

    private void PrimaAP() {
        Met99Calcula.met99Datos.epAP = 0.0;
        if (Met99Calcula.met99Datos.selAP.booleanValue()) {
            Met99Calcula.met99Datos.primaAP = Met99Calcula.met99Datos.ftpSel == 1 ? (Met99Calcula.met99Datos.optSumaAP == 1 ? Double.valueOf(Met99Calcula.met99Datos.tarAPbasicoConPFT * (double)Met99Calcula.met99Datos.sumaAPbasico.intValue() / 1000.0) : Double.valueOf(Met99Calcula.met99Datos.tarAPbasicoConPFT * (double)Met99Calcula.met99Datos.sumaAPextra.intValue() / 1000.0)) : (Met99Calcula.met99Datos.optSumaAP == 1 ? Double.valueOf(Met99Calcula.met99Datos.tarAPbasicoSinPFT * (double)Met99Calcula.met99Datos.sumaAPbasico.intValue() / 1000.0) : Double.valueOf(Met99Calcula.met99Datos.tarAPbasicoSinPFT * (double)Met99Calcula.met99Datos.sumaAPextra.intValue() / 1000.0));
        } else {
            Met99Calcula.met99Datos.primaAP = 0.0;
            Met99Calcula.met99Datos.sumaAP = 0;
        }
    }

    private void PrimaEG() {
        if (Met99Calcula.met99Datos.selEG.booleanValue()) {
            Met99Calcula.met99Datos.epEG = 0.0;
            Met99Calcula.met99Datos.primaEG = Met99Calcula.met99Datos.sexoTitular == "M" ? Double.valueOf(Met99Calcula.met99Datos.tarEGH * (double)Met99Calcula.met99Datos.sumaEG.intValue() / 1000.0) : Double.valueOf(Met99Calcula.met99Datos.tarEGM * (double)Met99Calcula.met99Datos.sumaEG.intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.primaEG = 0.0;
            Met99Calcula.met99Datos.sumaEG = 0;
            Met99Calcula.met99Datos.epEG = 0.0;
        }
    }

    private void PrimaCR() {
        if (Met99Calcula.met99Datos.selCR.booleanValue()) {
            Met99Calcula.met99Datos.epCR = 0.0;
            Met99Calcula.met99Datos.primaCR = Met99Calcula.met99Datos.sexoTitular == "M" ? Double.valueOf(Met99Calcula.met99Datos.tarCRH * (double)Met99Calcula.met99Datos.sumaCR.intValue() / 1000.0) : Double.valueOf(Met99Calcula.met99Datos.tarCRM * (double)Met99Calcula.met99Datos.sumaCR.intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.primaCR = 0.0;
            Met99Calcula.met99Datos.sumaCR = 0;
            Met99Calcula.met99Datos.epCR = 0.0;
        }
    }

    private void PrimaPHT() {
        if (Met99Calcula.met99Datos.selPHT.booleanValue()) {
            Met99Calcula.met99Datos.epPHT = 0.0;
            Met99Calcula.met99Datos.primaPHT = Met99Calcula.met99Datos.sexoTitular == "M" ? Met99Calcula.met99Datos.tarPHH : Met99Calcula.met99Datos.tarPHM;
        } else {
            Met99Calcula.met99Datos.epPHT = 0.0;
            Met99Calcula.met99Datos.sumaPHT = 0;
            Met99Calcula.met99Datos.primaPHT = 0.0;
        }
    }

    private void PrimaBACY() {
        Met99Calcula.met99Datos.epBACY = 0.0;
        if (Met99Calcula.met99Datos.selBACY.booleanValue()) {
            Met99Calcula.met99Datos.primaBACY = Met99Calcula.met99Datos.tarBACY * (double)Met99Calcula.met99Datos.sumaBACY.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaBACY = 0.0;
            Met99Calcula.met99Datos.sumaBACY = 0;
        }
    }

    private void PrimaGFC() {
        Met99Calcula.met99Datos.epGFC = 0.0;
        if (Met99Calcula.met99Datos.selGFC.booleanValue()) {
            Met99Calcula.met99Datos.primaGFC = Met99Calcula.met99Datos.tarGFC * (double)Met99Calcula.met99Datos.sumaGFC.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaGFC = 0.0;
            Met99Calcula.met99Datos.sumaGFC = 0;
        }
    }

    private void PrimaBCAC() {
        Met99Calcula.met99Datos.epBCAC = 0.0;
        if (Met99Calcula.met99Datos.selBCAC.booleanValue()) {
            Met99Calcula.met99Datos.primaBCAC = Met99Calcula.met99Datos.sexoConyuge == "M" ? Double.valueOf(Met99Calcula.met99Datos.tarBCACH * (double)Met99Calcula.met99Datos.sumaBCAC.intValue() / 1000.0) : Double.valueOf(Met99Calcula.met99Datos.tarBCACM * (double)Met99Calcula.met99Datos.sumaBCAC.intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.primaBCAC = 0.0;
            Met99Calcula.met99Datos.sumaBCAC = 0;
        }
    }

    private void PrimaGFH() {
        Double tarifaGFH = 0.0;
        Met99Calcula.met99Datos.epGFH = 0.0;
        if (Met99Calcula.met99Datos.selGFH.booleanValue()) {
            switch (Met99Calcula.met99Datos.numHijos) {
                case 1: {
                    tarifaGFH = Met99Calcula.met99Datos.tarGFH1;
                    break;
                }
                case 2: {
                    tarifaGFH = Met99Calcula.met99Datos.tarGFH2;
                    break;
                }
                case 3: {
                    tarifaGFH = Met99Calcula.met99Datos.tarGFH3;
                }
            }
            Met99Calcula.met99Datos.primaGFH = tarifaGFH * (double)Met99Calcula.met99Datos.sumaGFH.intValue() / 1000.0;
        } else {
            Met99Calcula.met99Datos.primaGFH = 0.0;
            Met99Calcula.met99Datos.sumaGFH = 0;
            Met99Calcula.met99Datos.epGFH = 0.0;
        }
    }

    public void PrimaBACcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpBAC.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelBAC.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstPrimaBAC.set(indexComp, Met99Calcula.met99Datos.lstTarBAC.get(indexComp) * (double)Met99Calcula.met99Datos.lstSumaBAC.get(indexComp).intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.lstPrimaBAC.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaBAC.set(indexComp, 0);
        }
    }

    public void PrimaBCACcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpBCAC.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelBCAC.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstPrimaBCAC.set(indexComp, Met99Calcula.met99Datos.lstTarBCAC.get(indexComp) * (double)Met99Calcula.met99Datos.lstSumaBCAC.get(indexComp).intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.lstPrimaBCAC.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaBCAC.set(indexComp, 0);
        }
    }

    public void PrimaAPcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpAP.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelAP.get(indexComp).booleanValue()) {
            if (Met99Calcula.met99Datos.ftpSel == 1) {
                if (Met99Calcula.met99Datos.lstOptSumaAP.get(indexComp) == 1) {
                    Met99Calcula.met99Datos.lstPrimaAP.set(indexComp, Met99Calcula.met99Datos.tarAPbasicoConPFT * (double)Met99Calcula.met99Datos.sumaAPbasico.intValue() / 1000.0);
                } else {
                    Met99Calcula.met99Datos.lstPrimaAP.set(indexComp, Met99Calcula.met99Datos.tarAPbasicoConPFT * (double)Met99Calcula.met99Datos.sumaAPextra.intValue() / 1000.0);
                }
            } else if (Met99Calcula.met99Datos.lstOptSumaAP.get(indexComp) == 1) {
                Met99Calcula.met99Datos.lstPrimaAP.set(indexComp, Met99Calcula.met99Datos.tarAPbasicoSinPFT * (double)Met99Calcula.met99Datos.sumaAPbasico.intValue() / 1000.0);
            } else {
                Met99Calcula.met99Datos.lstPrimaAP.set(indexComp, Met99Calcula.met99Datos.tarAPbasicoSinPFT * (double)Met99Calcula.met99Datos.sumaAPextra.intValue() / 1000.0);
            }
        } else {
            Met99Calcula.met99Datos.lstPrimaAP.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaAP.set(indexComp, 0);
        }
    }

    public void PrimaGFcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpGF.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelGF.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstPrimaGF.set(indexComp, Met99Calcula.met99Datos.lstTarGF.get(indexComp) * (double)Met99Calcula.met99Datos.lstSumaGF.get(indexComp).intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.lstPrimaGF.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaGF.set(indexComp, 0);
        }
    }

    public void PrimaEGcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpEG.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelEG.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstPrimaEG.set(indexComp, Met99Calcula.met99Datos.lstTarEG.get(indexComp) * (double)Met99Calcula.met99Datos.lstSumaEG.get(indexComp).intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.lstPrimaEG.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaEG.set(indexComp, 0);
        }
    }

    public void PrimaCRcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpCR.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelCR.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstPrimaCR.set(indexComp, Met99Calcula.met99Datos.lstTarCR.get(indexComp) * (double)Met99Calcula.met99Datos.lstSumaCR.get(indexComp).intValue() / 1000.0);
        } else {
            Met99Calcula.met99Datos.lstPrimaCR.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaCR.set(indexComp, 0);
        }
    }

    public void PrimaPHXcomp(Integer indexComp) {
        Met99Calcula.met99Datos.lstEpPHX.set(indexComp, 0.0);
        if (Met99Calcula.met99Datos.lstSelPHX.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstPrimaPHX.set(indexComp, Met99Calcula.met99Datos.lstTarPHX.get(indexComp));
        } else {
            Met99Calcula.met99Datos.lstPrimaPHX.set(indexComp, 0.0);
            Met99Calcula.met99Datos.lstSumaPHX.set(indexComp, 0);
        }
    }

    private void PrimaBIT() {
        if (Met99Calcula.met99Datos.selBIT.booleanValue()) {
            Met99Calcula.met99Datos.sumaBIT = Met99Calcula.met99Datos.primaBAS + Met99Calcula.met99Datos.primaCAT + Met99Calcula.met99Datos.primaGFA;
            Met99Datos met99Datos = Met99Calcula.met99Datos;
            met99Datos.sumaBIT = met99Datos.sumaBIT + (Met99Calcula.met99Datos.primaGE + Met99Calcula.met99Datos.primaPHT);
            met99Datos = Met99Calcula.met99Datos;
            met99Datos.sumaBIT = met99Datos.sumaBIT + (Met99Calcula.met99Datos.primaBACY + Met99Calcula.met99Datos.primaGFC + Met99Calcula.met99Datos.primaBCAC);
            met99Datos = Met99Calcula.met99Datos;
            met99Datos.sumaBIT = met99Datos.sumaBIT + Met99Calcula.met99Datos.primaGFH;
            for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                Met99Datos met99Datos2 = Met99Calcula.met99Datos;
                Double.valueOf(met99Datos2.sumaBIT + (Met99Calcula.met99Datos.lstPrimaBAC.get(i) + Met99Calcula.met99Datos.lstPrimaBCAC.get(i)));
                met99Datos2.sumaBIT = met99Datos2.sumaBIT;
                met99Datos2 = Met99Calcula.met99Datos;
                Double.valueOf(met99Datos2.sumaBIT + (Met99Calcula.met99Datos.lstPrimaAP.get(i) + Met99Calcula.met99Datos.lstPrimaGF.get(i)));
                met99Datos2.sumaBIT = met99Datos2.sumaBIT;
                met99Datos2 = Met99Calcula.met99Datos;
                Double.valueOf(met99Datos2.sumaBIT + (Met99Calcula.met99Datos.lstPrimaEG.get(i) + Met99Calcula.met99Datos.lstPrimaCR.get(i)));
                met99Datos2.sumaBIT = met99Datos2.sumaBIT;
                met99Datos2 = Met99Calcula.met99Datos;
                Double.valueOf(met99Datos2.sumaBIT + Met99Calcula.met99Datos.lstPrimaPHX.get(i));
                met99Datos2.sumaBIT = met99Datos2.sumaBIT;
            }
            if (Met99Calcula.met99Datos.productoSeleccionado == "PT20") {
                Met99Datos met99Datos3 = Met99Calcula.met99Datos;
                met99Datos3.sumaBIT = met99Datos3.sumaBIT + Met99Calcula.met99Datos.primaExcedente;
            }
            Met99Calcula.met99Datos.epBIT = Met99Calcula.met99Datos.sumaBIT * Met99Calcula.met99Datos.tarBIT * (Met99Calcula.met99Datos.epInvalidez - 1.0) / 100.0;
            Met99Calcula.met99Datos.primaBIT = Met99Calcula.met99Datos.sumaBIT * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
        } else {
            Met99Calcula.met99Datos.primaBIT = 0.0;
            Met99Calcula.met99Datos.epBIT = 0.0;
        }
    }

    public void CalculaSumaObjetivo() {
        this.error = false;
        this.CalculaSumaInferior();
        if (this.error.booleanValue()) {
            this.sumaObj = 0;
            this.error = false;
        } else {
            this.CalculaSumaSuperior();
            if (this.error.booleanValue()) {
                this.sumaObj = 0;
                this.error = false;
            } else {
                this.InterpolaSuma();
            }
        }
    }

    private void InterpolaSuma() {
        Integer maxIter = 50;
        Integer i = 1;
        Double aproxObjetivo = 1.0E-5;
        Double aproxActual = 1.0;
        while (i < maxIter && aproxActual > aproxObjetivo) {
            if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
                Met99Calcula.met99Datos.sumaBAS = (int)((this.sumaSuperior + this.sumaInferior) / 2.0 + 0.5);
            } else {
                Met99Calcula.met99Datos.sumaObjetivo = (int)((this.sumaSuperior + this.sumaInferior) / 2.0 + 0.5);
            }
            if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
                this.AsignaSumasCoberturas();
            } else {
                this.AsignaSumaCoberturasSinBAS(Met99Calcula.met99Datos.sumaObjetivo);
            }
            if (Met99Calcula.met99Datos.sumaLimitada.booleanValue() && Met99Calcula.met99Datos.sumaBAS > Met99Calcula.met99Datos.impSumaLimitada) {
                Met99Calcula.met99Datos.sumaBAS = Met99Calcula.met99Datos.impSumaLimitada;
            }
            this.CalculaPrimas();
            if (Met99Calcula.met99Datos.primaFPago > Met99Calcula.met99Datos.primaObjetivo) {
                this.sumaSuperior = Met99Calcula.met99Datos.selBAS.booleanValue() ? Double.valueOf((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 1.0) : Double.valueOf((double)Met99Calcula.met99Datos.sumaObjetivo.intValue() * 1.0);
            } else {
                this.sumaInferior = Met99Calcula.met99Datos.selBAS != false ? Double.valueOf((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 1.0) : Double.valueOf((double)Met99Calcula.met99Datos.sumaObjetivo.intValue() * 1.0);
            }
            i = i + 1;
            aproxActual = Math.abs(1.0 - Met99Calcula.met99Datos.primaFPago / Met99Calcula.met99Datos.primaObjetivo);
        }
        if (i >= maxIter && aproxActual > aproxObjetivo) {
            genSubs.MuestraMensaje("No es posible encontrar una soluci\u00f3n, intente con otra prima", "Provida");
        }
    }

    private void CalculaSumaInferior() {
        this.indiceCob = genSubs.IndiceCob("BAS");
        this.sumaInferior = (double)Met99Calcula.met99Datos.sumaMin.get(this.indiceCob).intValue() * 1.0;
        if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
            this.AsignaSumasCoberturas();
            if (Met99Calcula.met99Datos.selGFA.booleanValue() && (int)(0.35 * (double)Met99Calcula.met99Datos.sumaBAS.intValue() + 0.5) < Met99Calcula.met99Datos.sumaMin.get(genSubs.IndiceCob("GFA"))) {
                genSubs.MuestraMensaje("No es posible encontrar una soluci\u00f3n, intente con otra prima", "Provida");
                this.error = true;
                Met99Calcula.met99Datos.sumaGFA = 0;
            }
        } else {
            this.AsignaSumaCoberturasSinBAS(this.sumaInferior.intValue());
        }
        this.CalculaPrimas();
    }

    private void CalculaSumaSuperior() {
        if (Met99Calcula.met99Datos.primaFPago > Met99Calcula.met99Datos.primaObjetivo) {
            this.sumaSuperior = Met99Calcula.met99Datos.selBAS.booleanValue() ? Double.valueOf((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 3.0) : Double.valueOf((double)this.SeleccionaSumaSuperior().intValue() * 3.0);
        } else {
            if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
                this.sumaSuperior = Met99Calcula.met99Datos.primaObjetivo / Met99Calcula.met99Datos.primaFPago * (double)Met99Calcula.met99Datos.sumaBAS.intValue();
                Met99Calcula.met99Datos.sumaBAS = (int)(this.sumaSuperior * 1.0);
            } else {
                this.sumaSuperior = (double)this.SeleccionaSumaSuperior().intValue() * 5.0;
            }
            if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
                this.AsignaSumasCoberturas();
            } else {
                this.AsignaSumaCoberturasSinBAS(this.sumaSuperior.intValue());
            }
            this.CalculaPrimas();
            if (Met99Calcula.met99Datos.primaFPago < Met99Calcula.met99Datos.primaObjetivo) {
                this.sumaSuperior = this.sumaSuperior * (Met99Calcula.met99Datos.primaObjetivo / Met99Calcula.met99Datos.primaFPago) * 20.0;
                if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
                    Met99Calcula.met99Datos.sumaBAS = (int)(this.sumaSuperior * 1.0);
                    this.AsignaSumasCoberturas();
                } else {
                    this.AsignaSumaCoberturasSinBAS(this.sumaSuperior.intValue());
                }
                this.CalculaPrimas();
                if (Met99Calcula.met99Datos.primaFPago < Met99Calcula.met99Datos.primaObjetivo) {
                    this.error = true;
                    genSubs.MuestraMensaje("No es posible encontrar soluci\u00f3n, intente con otra prima", "Calcula");
                }
            }
        }
    }

    private Integer SeleccionaSumaSuperior() {
        Integer sumaSeleccionada = Math.max(Met99Calcula.met99Datos.sumaCII, Met99Calcula.met99Datos.sumaCMA);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaTIBA);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaCAT);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaGE);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaCII);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaBACY);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaGFC);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaGFA);
        sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.sumaGFH);
        for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
            sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.lstSumaBAC.get(i));
            sumaSeleccionada = Math.max(sumaSeleccionada, Met99Calcula.met99Datos.lstSumaBCAC.get(i));
        }
        return sumaSeleccionada;
    }

    private void AsignaSumasCoberturas() {
        Met99Calcula.met99Datos.sumaCII = this.SumaCobertura("CII", Met99Calcula.met99Datos.selCII, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaCMA = this.SumaCobertura("CMA", Met99Calcula.met99Datos.selCMA, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaTIBA = this.SumaCobertura("TIBA", Met99Calcula.met99Datos.selTIBA, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaCAT = this.SumaCobertura("CAT", Met99Calcula.met99Datos.selCAT, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaGFA = this.SumaCobertura("GFA", Met99Calcula.met99Datos.selGFA, (int)(0.35 * (double)Met99Calcula.met99Datos.sumaBAS.intValue() + 0.5), 0);
        Met99Calcula.met99Datos.sumaGE = this.SumaCobertura("GE", Met99Calcula.met99Datos.selGE, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaAP = this.SumaCobertura("AP", Met99Calcula.met99Datos.selAP, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaEG = this.SumaCobertura("EG", Met99Calcula.met99Datos.selEG, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaCR = this.SumaCobertura("CR", Met99Calcula.met99Datos.selCR, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaPHT = this.SumaCobertura("PHT", Met99Calcula.met99Datos.selCR, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaBACY = this.SumaCobertura("BACY", Met99Calcula.met99Datos.selBACY, Met99Calcula.met99Datos.sumaBAS, 0);
        if (Met99Calcula.met99Datos.optSuma.booleanValue()) {
            Met99Calcula.met99Datos.sumaGFC = this.SumaCobertura("GFC", Met99Calcula.met99Datos.selGFC, Met99Calcula.met99Datos.sumaBAS, 0);
        } else {
            this.CalculaBacyGfc();
        }
        Met99Calcula.met99Datos.sumaBCAC = this.SumaCobertura("BCAC", Met99Calcula.met99Datos.selBCAC, Met99Calcula.met99Datos.sumaBAS, 0);
        Met99Calcula.met99Datos.sumaGFH = this.SumaCobertura("GFH", Met99Calcula.met99Datos.selGFH, Met99Calcula.met99Datos.sumaBAS, 0);
        for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
            if (Met99Calcula.met99Datos.optSuma.booleanValue()) {
                Met99Calcula.met99Datos.lstSumaBAC.set(i, this.SumaCobertura("BACcomp", Met99Calcula.met99Datos.lstSelBAC.get(i), Met99Calcula.met99Datos.sumaBAS, i));
                Met99Calcula.met99Datos.lstSumaGF.set(i, this.SumaCobertura("GFcomp", Met99Calcula.met99Datos.lstSelGF.get(i), Met99Calcula.met99Datos.sumaBAS, i));
            } else {
                this.CalculaSumaBACyGFcomp(i);
            }
            Met99Calcula.met99Datos.lstSumaBCAC.set(i, this.SumaCobertura("BCACcomp", Met99Calcula.met99Datos.lstSelBCAC.get(i), Met99Calcula.met99Datos.sumaBAS, i));
            Met99Calcula.met99Datos.lstSumaAP.set(i, this.SumaCobertura("APcomp", Met99Calcula.met99Datos.lstSelAP.get(i), Met99Calcula.met99Datos.sumaBAS, i));
            Met99Calcula.met99Datos.lstSumaEG.set(i, this.SumaCobertura("EGcomp", Met99Calcula.met99Datos.lstSelEG.get(i), Met99Calcula.met99Datos.sumaBAS, i));
            Met99Calcula.met99Datos.lstSumaCR.set(i, this.SumaCobertura("CRcomp", Met99Calcula.met99Datos.lstSelCR.get(i), Met99Calcula.met99Datos.sumaBAS, i));
            Met99Calcula.met99Datos.lstSumaPHX.set(i, this.SumaCobertura("PHX", Met99Calcula.met99Datos.lstSelPHX.get(i), Met99Calcula.met99Datos.sumaBAS, i));
        }
    }

    private void AsignaSumaCoberturasSinBAS(Integer sumaReferencia) {
        Met99Calcula.met99Datos.sumaCII = this.SumaCoberturaSinBAS("CII", Met99Calcula.met99Datos.selCII, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaCMA = this.SumaCoberturaSinBAS("CMA", Met99Calcula.met99Datos.selCMA, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaTIBA = this.SumaCoberturaSinBAS("TIBA", Met99Calcula.met99Datos.selTIBA, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaCAT = this.SumaCoberturaSinBAS("CAT", Met99Calcula.met99Datos.selCAT, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaGFA = this.SumaCoberturaSinBAS("GFA", Met99Calcula.met99Datos.selGFA, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaPHT = this.SumaCoberturaSinBAS("PHT", Met99Calcula.met99Datos.selPHT, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaGE = this.SumaCoberturaSinBAS("GE", Met99Calcula.met99Datos.selGE, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaAP = this.SumaCoberturaSinBAS("AP", Met99Calcula.met99Datos.selAP, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaEG = this.SumaCoberturaSinBAS("EG", Met99Calcula.met99Datos.selEG, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaCR = this.SumaCoberturaSinBAS("CR", Met99Calcula.met99Datos.selCR, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaBACY = this.SumaCoberturaSinBAS("BACY", Met99Calcula.met99Datos.selBACY, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaGFC = this.SumaCoberturaSinBAS("GFC", Met99Calcula.met99Datos.selGFC, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaBCAC = this.SumaCoberturaSinBAS("BCAC", Met99Calcula.met99Datos.selBCAC, sumaReferencia, 0);
        Met99Calcula.met99Datos.sumaGFH = this.SumaCoberturaSinBAS("GFH", Met99Calcula.met99Datos.selGFH, sumaReferencia, 0);
        for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
            Met99Calcula.met99Datos.lstSumaBAC.set(i, this.SumaCoberturaSinBAS("BACcomp", Met99Calcula.met99Datos.lstSelBAC.get(i), sumaReferencia, i));
            Met99Calcula.met99Datos.lstSumaBCAC.set(i, this.SumaCoberturaSinBAS("BCACcomp", Met99Calcula.met99Datos.lstSelBCAC.get(i), sumaReferencia, i));
            Met99Calcula.met99Datos.lstSumaAP.set(i, this.SumaCoberturaSinBAS("APcomp", Met99Calcula.met99Datos.lstSelAP.get(i), sumaReferencia, i));
            Met99Calcula.met99Datos.lstSumaGF.set(i, this.SumaCoberturaSinBAS("GFcomp", Met99Calcula.met99Datos.lstSelGF.get(i), sumaReferencia, i));
            Met99Calcula.met99Datos.lstSumaEG.set(i, this.SumaCoberturaSinBAS("EGcomp", Met99Calcula.met99Datos.lstSelEG.get(i), sumaReferencia, i));
            Met99Calcula.met99Datos.lstSumaCR.set(i, this.SumaCoberturaSinBAS("CRcomp", Met99Calcula.met99Datos.lstSelCR.get(i), sumaReferencia, i));
            Met99Calcula.met99Datos.lstSumaPHX.set(i, this.SumaCoberturaSinBAS("PHX", Met99Calcula.met99Datos.lstSelPHX.get(i), sumaReferencia, i));
        }
    }

    private void CalculaBacyGfc() {
        this.indiceCob = genSubs.IndiceCob("GFC");
        if (Met99Calcula.met99Datos.selBACY.booleanValue()) {
            if (Met99Calcula.met99Datos.selGFC.booleanValue()) {
                if (Met99Calcula.met99Datos.sumaBAS > 0) {
                    Met99Calcula.met99Datos.sumaGFC = (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5);
                    if (Met99Calcula.met99Datos.sumaGFC > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                        Met99Calcula.met99Datos.sumaGFC = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                    }
                } else {
                    Met99Calcula.met99Datos.sumaGFC = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
                if (Met99Calcula.met99Datos.sumaBAS > 0) {
                    Met99Calcula.met99Datos.sumaBACY = Met99Calcula.met99Datos.sumaBAS - Met99Calcula.met99Datos.sumaGFC;
                    this.indiceCob = genSubs.IndiceCob("BACY");
                    if (Met99Calcula.met99Datos.sumaBACY > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                        Met99Calcula.met99Datos.sumaBACY = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                    }
                } else {
                    Met99Calcula.met99Datos.sumaBACY = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
            } else {
                Met99Calcula.met99Datos.sumaGFC = 0;
                this.indiceCob = genSubs.IndiceCob("BACY");
                Met99Calcula.met99Datos.sumaBACY = Met99Calcula.met99Datos.sumaBAS > 0 ? Met99Calcula.met99Datos.sumaBAS : Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                if (Met99Calcula.met99Datos.sumaBACY > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    Met99Calcula.met99Datos.sumaBACY = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
            }
        } else if (Met99Calcula.met99Datos.selGFC.booleanValue()) {
            if (Met99Calcula.met99Datos.selBAS.booleanValue()) {
                Met99Calcula.met99Datos.sumaGFC = (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5);
                if (Met99Calcula.met99Datos.sumaGFC > Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFC"))) {
                    Met99Calcula.met99Datos.sumaGFC = Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFC"));
                }
            } else {
                Met99Calcula.met99Datos.sumaGFC = Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFC"));
            }
        } else {
            Met99Calcula.met99Datos.sumaGFC = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer SumaCobertura(String idCob, Boolean selCob, Integer sumaBasica, Integer indexComp) {
        Integer sumaCob = 0;
        this.indiceCob = genSubs.IndiceCob(idCob);
        if (!Met99Calcula.met99Datos.optNueva.booleanValue()) {
            if (Met99Calcula.met99Datos.selBAS == false) return 0;
        }
        switch (idCob) {
            case "AP": {
                if (selCob == false) return 0;
                if (Met99Calcula.met99Datos.optSumaAP != 1) return Met99Calcula.met99Datos.sumaAPextra;
                return Met99Calcula.met99Datos.sumaAPbasico;
            }
            case "PHT": {
                if (selCob == false) return 0;
                return 1000;
            }
            case "BACY": {
                if (selCob.booleanValue()) {
                    sumaCob = Met99Calcula.met99Datos.selGFC != false ? Integer.valueOf(Met99Calcula.met99Datos.sumaBAS - Met99Calcula.met99Datos.sumaGFC) : Met99Calcula.met99Datos.sumaBAS;
                    if (sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                        sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                    }
                    if (sumaCob < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                        sumaCob = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                    }
                    if (Met99Calcula.met99Datos.edadRealConyuge <= 70) return sumaCob;
                    if (sumaCob <= 400000) return sumaCob;
                    return 400000;
                }
                Met99Calcula.met99Datos.sumaBACY = 0;
                return sumaCob;
            }
            case "GFC": {
                if (selCob == false) return 0;
                sumaCob = Met99Calcula.met99Datos.selBACY != false ? Integer.valueOf(Met99Calcula.met99Datos.sumaBAS - Met99Calcula.met99Datos.sumaBACY) : Integer.valueOf((int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5));
                if (sumaCob <= 0) return sumaCob;
                if (sumaCob < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                }
                if (Met99Calcula.met99Datos.sumaMax.get(this.indiceCob) <= 0) return sumaCob;
                if (sumaCob <= Integer.min(Met99Calcula.met99Datos.sumaMax.get(this.indiceCob), (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5))) return sumaCob;
                return Integer.min(Met99Calcula.met99Datos.sumaMax.get(this.indiceCob), (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5));
            }
            case "GFH": {
                sumaCob = selCob != false ? Integer.valueOf((int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5)) : Integer.valueOf(0);
                if (Met99Calcula.met99Datos.sumaMax.get(this.indiceCob) <= 0) return sumaCob;
                if (sumaCob <= Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
            }
            case "APcomp": {
                if (selCob == false) return 0;
                if (Met99Calcula.met99Datos.lstOptSumaAP.get(indexComp) != 1) return Met99Calcula.met99Datos.sumaAPextra;
                return Met99Calcula.met99Datos.sumaAPbasico;
            }
            case "BACcomp": {
                if (selCob == false) return 0;
                sumaCob = sumaBasica;
                if (Met99Calcula.met99Datos.lstSelGF.get(indexComp).booleanValue()) {
                    if (Met99Calcula.met99Datos.lstSumaGF.get(indexComp) + sumaCob > Met99Calcula.met99Datos.sumaBAS && (sumaCob = Integer.valueOf(Met99Calcula.met99Datos.sumaBAS - Met99Calcula.met99Datos.lstSumaGF.get(indexComp))) < 0) {
                        sumaCob = 0;
                    }
                } else {
                    if (Met99Calcula.met99Datos.sumaMax.get(this.indiceCob) > 0 && sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                        sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                    }
                    if (Met99Calcula.met99Datos.sumaMin.get(this.indiceCob) > 0 && sumaCob < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                        sumaCob = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                    }
                }
                if (Met99Calcula.met99Datos.lstEdadComp.get(indexComp) <= 70) return sumaCob;
                if (Met99Calcula.met99Datos.lstSumaBAC.get(indexComp) <= 400000) return sumaCob;
                Met99Calcula.met99Datos.lstSumaBAC.set(indexComp, 400000);
                return sumaCob;
            }
            case "GFcomp": {
                if (selCob == false) return 0;
                sumaCob = (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5);
                if (Met99Calcula.met99Datos.lstSelBAC.get(indexComp).booleanValue()) {
                    if (Met99Calcula.met99Datos.lstSumaBAC.get(indexComp) + sumaCob > Met99Calcula.met99Datos.sumaBAS) {
                        sumaCob = Met99Calcula.met99Datos.sumaBAS - Met99Calcula.met99Datos.lstSumaBAC.get(indexComp);
                        if (sumaCob < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                            sumaCob = 0;
                        }
                        if (sumaCob <= Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFcomp"))) return sumaCob;
                        return Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFcomp"));
                    }
                    if (sumaCob < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob) && (sumaCob = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) < (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5)) {
                        sumaCob = 0;
                        genSubs.MuestraMensaje("Se requiere uns suma b\u00e1sica mayor", null);
                    }
                    if (sumaCob <= Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFcomp"))) return sumaCob;
                    return Met99Calcula.met99Datos.sumaMax.get(genSubs.IndiceCob("GFcomp"));
                }
                if (sumaCob < Met99Calcula.met99Datos.sumaMin.get(genSubs.IndiceCob("GFcomp"))) {
                    return 0;
                }
                if (sumaCob < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                }
                if (sumaCob <= Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
            }
            case "PHX": {
                if (selCob == false) return 0;
                return 1000;
            }
            default: {
                if (selCob == false) return 0;
                sumaCob = sumaBasica;
                if (Met99Calcula.met99Datos.sumaMax.get(this.indiceCob) > 0 && sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
                if (Met99Calcula.met99Datos.sumaMin.get(this.indiceCob) <= 0) return sumaCob;
                if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer SumaCoberturaSinBAS(String idCob, Boolean selCob, Integer sumaReferencia, Integer indexComp) {
        Integer sumaCob = 0;
        this.indiceCob = genSubs.IndiceCob(idCob);
        if (Met99Calcula.met99Datos.selBAS != false) return 0;
        switch (idCob) {
            case "AP": {
                if (selCob == false) return 0;
                if (Met99Calcula.met99Datos.optSumaAP != 1) return Met99Calcula.met99Datos.sumaAPextra;
                return Met99Calcula.met99Datos.sumaAPbasico;
            }
            case "PHT": {
                if (selCob == false) return 0;
                return Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
            }
            case "BACY": {
                if (selCob.booleanValue()) {
                    sumaCob = sumaReferencia;
                    if (sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                        sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                    }
                    if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                    return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                }
                Met99Calcula.met99Datos.sumaBACY = 0;
                return sumaCob;
            }
            case "GFC": {
                if (selCob == false) return 0;
                sumaCob = sumaReferencia;
                if (sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
                if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
            case "GFH": {
                if (selCob == false) return 0;
                sumaCob = sumaReferencia;
                if (sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
                if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
            case "APcomp": {
                if (selCob == false) return 0;
                if (Met99Calcula.met99Datos.lstOptSumaAP.get(indexComp) != 1) return Met99Calcula.met99Datos.sumaAPextra;
                return Met99Calcula.met99Datos.sumaAPbasico;
            }
            case "BACcomp": {
                if (selCob == false) return 0;
                sumaCob = sumaReferencia;
                if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
            case "GFcomp": {
                if (selCob == false) return 0;
                sumaCob = sumaReferencia;
                if (sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
                if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
            case "PHX": {
                if (selCob == false) return 0;
                return Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
            }
            default: {
                if (selCob == false) return 0;
                sumaCob = sumaReferencia;
                if (Met99Calcula.met99Datos.sumaMax.get(this.indiceCob) > 0 && sumaCob > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    sumaCob = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
                if (Met99Calcula.met99Datos.sumaMin.get(this.indiceCob) <= 0) return sumaCob;
                if (sumaCob >= Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) return sumaCob;
                return Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
        }
    }

    private void CalculaSumaBACyGFcomp(Integer indexComp) {
        Integer valorTemp;
        if (Met99Calcula.met99Datos.lstSelBAC.get(indexComp).booleanValue() && Met99Calcula.met99Datos.lstSelGF.get(indexComp).booleanValue()) {
            valorTemp = (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5);
            if (valorTemp < Met99Calcula.met99Datos.sumaMin.get(genSubs.IndiceCob("GFcomp"))) {
                valorTemp = 0;
            } else {
                this.indiceCob = genSubs.IndiceCob("GFcomp");
                if (valorTemp < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                    valorTemp = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                }
                if (valorTemp > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    valorTemp = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
            }
            Met99Calcula.met99Datos.lstSumaGF.set(indexComp, valorTemp);
            Met99Calcula.met99Datos.lstSumaBAC.set(indexComp, Met99Calcula.met99Datos.sumaBAS - valorTemp);
        }
        if (Met99Calcula.met99Datos.lstSelBAC.get(indexComp).booleanValue() && !Met99Calcula.met99Datos.lstSelGF.get(indexComp).booleanValue()) {
            valorTemp = Met99Calcula.met99Datos.sumaBAS;
            this.indiceCob = genSubs.IndiceCob("BACcomp");
            if (valorTemp < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                valorTemp = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
            }
            Met99Calcula.met99Datos.lstSumaBAC.set(indexComp, valorTemp);
            Met99Calcula.met99Datos.lstSumaGF.set(indexComp, 0);
        }
        if (!Met99Calcula.met99Datos.lstSelBAC.get(indexComp).booleanValue() && Met99Calcula.met99Datos.lstSelGF.get(indexComp).booleanValue()) {
            valorTemp = (int)((double)Met99Calcula.met99Datos.sumaBAS.intValue() * 0.35 + 0.5);
            if (valorTemp < Met99Calcula.met99Datos.sumaMin.get(genSubs.IndiceCob("GFcomp"))) {
                valorTemp = 0;
            } else {
                this.indiceCob = genSubs.IndiceCob("GFcomp");
                if (valorTemp < Met99Calcula.met99Datos.sumaMin.get(this.indiceCob)) {
                    valorTemp = Met99Calcula.met99Datos.sumaMin.get(this.indiceCob);
                }
                if (valorTemp > Met99Calcula.met99Datos.sumaMax.get(this.indiceCob)) {
                    valorTemp = Met99Calcula.met99Datos.sumaMax.get(this.indiceCob);
                }
            }
            Met99Calcula.met99Datos.lstSumaGF.set(indexComp, valorTemp);
            Met99Calcula.met99Datos.lstSumaBAC.set(indexComp, 0);
        }
        if (!Met99Calcula.met99Datos.lstSelBAC.get(indexComp).booleanValue() && !Met99Calcula.met99Datos.lstSelGF.get(indexComp).booleanValue()) {
            Met99Calcula.met99Datos.lstSumaGF.set(indexComp, 0);
            Met99Calcula.met99Datos.lstSumaBAC.set(indexComp, 0);
        }
    }

    public void Proyecta() {
        this.facMort = Met99Calcula.met99Datos.facMortalidad;
        this.Vp = genSubs.Redondea(1.0 / (1.0 + Met99Calcula.met99Datos.tasaTecAnual), 7);
        this.InicializaVectores();
        this.CalculaEdades();
        this.CalculaPC();
        this.CalculaPrimaExcedentes();
        this.CalculaSOB();
        this.CalculaCoiTitCon();
        this.CalculaCoiBACcomp();
        this.CalculaCoiBCACcomp();
        this.CalculaCoiAPcomp();
        this.CalculaCoiGFcomp();
        this.CalculaCoiEGcomp();
        this.CalculaCoiCRcomp();
        this.CalculaCoiPHXcomp();
        this.CalculaCoiCoberturaComp();
        this.CalculaCoiTotal();
        this.CalculaReservaFondo();
    }

    private void CalculaEdades() {
        Integer mesActual = 0;
        Integer anoActual = 1;
        ArrayList edades = new ArrayList();
        Integer edadTemp = 0;
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            if ((mesActual = Integer.valueOf(mesActual + 1)) > 12) {
                mesActual = 1;
                anoActual = anoActual + 1;
            }
            Met99Calcula.met99Datos.mes.add(mesActual);
            Met99Calcula.met99Datos.ano.add(anoActual);
            Met99Calcula.met99Datos.edadRealTit.add(Met99Calcula.met99Datos.edadRealTitular + anoActual - 1);
            Met99Calcula.met99Datos.edadCalTit.add(Met99Calcula.met99Datos.edadCalculoTitular + anoActual - 1);
            Met99Calcula.met99Datos.edadCon.add(Met99Calcula.met99Datos.edadRealConyuge + anoActual - 1);
        }
        for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
            Met99Calcula.met99Datos.edadComp[i] = new ArrayList();
            Met99Calcula.met99Datos.edadComp[i].add(0);
            for (int j = 1; j <= Met99Calcula.met99Datos.mesesPry; ++j) {
                edadTemp = Met99Calcula.met99Datos.lstEdadComp.get(i) + Met99Calcula.met99Datos.ano.get(j) - 1;
                Met99Calcula.met99Datos.edadComp[i].add(edadTemp);
            }
            edadTemp = 0;
        }
    }

    private void CalculaPC() {
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            if ("Anual".equals(Met99Calcula.met99Datos.formaPago)) {
                if (Met99Calcula.met99Datos.mes.get(m) == 1) {
                    Met99Calcula.met99Datos.PC.add(Met99Calcula.met99Datos.primaAnualConExc);
                    continue;
                }
                Met99Calcula.met99Datos.PC.add(0.0);
                continue;
            }
            Met99Calcula.met99Datos.PC.add(genSubs.Redondea(Met99Calcula.met99Datos.primaAnualConExc / 12.0, 2));
        }
    }

    private void CalculaPrimaExcedentes() {
        Met99Calcula.met99Datos.PPEcii = this.CalculaPPE("CII", Met99Calcula.met99Datos.selCII, Met99Calcula.met99Datos.primaCII, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEcma = this.CalculaPPE("CMA", Met99Calcula.met99Datos.selCMA, Met99Calcula.met99Datos.primaCMA, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEtiba = this.CalculaPPE("TIBA", Met99Calcula.met99Datos.selTIBA, Met99Calcula.met99Datos.primaTIBA, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEcat = this.CalculaPPE("CAT", Met99Calcula.met99Datos.selCAT, Met99Calcula.met99Datos.primaCAT, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEgfa = this.CalculaPPE("GFA", Met99Calcula.met99Datos.selGFA, Met99Calcula.met99Datos.primaGFA, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEge = this.CalculaPPE("GE", Met99Calcula.met99Datos.selGE, Met99Calcula.met99Datos.primaGE, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEap = this.CalculaPPE("AP", Met99Calcula.met99Datos.selAP, Met99Calcula.met99Datos.primaAP, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEeg = this.CalculaPPE("EG", Met99Calcula.met99Datos.selEG, Met99Calcula.met99Datos.primaEG, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEcr = this.CalculaPPE("CR", Met99Calcula.met99Datos.selCR, Met99Calcula.met99Datos.primaCR, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEpht = this.CalculaPPE("PHT", Met99Calcula.met99Datos.selPHT, Met99Calcula.met99Datos.primaPHT, Met99Calcula.met99Datos.edadRealTit);
        Met99Calcula.met99Datos.PPEbacy = this.CalculaPPE("BACY", Met99Calcula.met99Datos.selBACY, Met99Calcula.met99Datos.primaBACY, Met99Calcula.met99Datos.edadCon);
        Met99Calcula.met99Datos.PPEgfc = this.CalculaPPE("GFC", Met99Calcula.met99Datos.selGFC, Met99Calcula.met99Datos.primaGFC, Met99Calcula.met99Datos.edadCon);
        Met99Calcula.met99Datos.PPEbcac = this.CalculaPPE("BCAC", Met99Calcula.met99Datos.selBCAC, Met99Calcula.met99Datos.primaBCAC, Met99Calcula.met99Datos.edadCon);
        Met99Calcula.met99Datos.PPEbacComp = this.CalculaPPEcomp("BACcomp");
        Met99Calcula.met99Datos.PPEgfComp = this.CalculaPPEcomp("GFcomp");
        Met99Calcula.met99Datos.PPEbcacComp = this.CalculaPPEcomp("BCAC");
        Met99Calcula.met99Datos.PPEapComp = this.CalculaPPEcomp("AP");
        Met99Calcula.met99Datos.PPEegComp = this.CalculaPPEcomp("EG");
        Met99Calcula.met99Datos.PPEcrComp = this.CalculaPPEcomp("CR");
        Met99Calcula.met99Datos.PPEphxComp = this.CalculaPPEcomp("PHX");
        Met99Calcula.met99Datos.PPEbit = this.CalculaPPE("BIT", Met99Calcula.met99Datos.selBIT, Met99Calcula.met99Datos.primaBIT, Met99Calcula.met99Datos.edadRealTit);
        if (Met99Calcula.met99Datos.selBIT.booleanValue()) {
            this.CalculaPPEbitEGyCR();
        }
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            if ("Anual".equals(Met99Calcula.met99Datos.formaPago)) {
                if (Met99Calcula.met99Datos.mes.get(m) == 1) {
                    Met99Calcula.met99Datos.PPEexc.add(Met99Calcula.met99Datos.primaExcedente);
                    continue;
                }
                Met99Calcula.met99Datos.PPEexc.add(0.0);
                continue;
            }
            Met99Calcula.met99Datos.PPEexc.add(genSubs.Redondea(Met99Calcula.met99Datos.primaExcedente / 12.0, 2));
        }
    }

    private void CalculaSOB() {
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            if (m == 228) {
                this.valTemp = 0.0;
            }
            Double ppeTotal = Met99Calcula.met99Datos.PPEbit.get(m) + Met99Calcula.met99Datos.PPEcii.get(m);
            ppeTotal = ppeTotal + (Met99Calcula.met99Datos.PPEcma.get(m) + Met99Calcula.met99Datos.PPEtiba.get(m));
            ppeTotal = ppeTotal + (Met99Calcula.met99Datos.PPEcat.get(m) + Met99Calcula.met99Datos.PPEap.get(m));
            ppeTotal = ppeTotal + (Met99Calcula.met99Datos.PPEeg.get(m) + Met99Calcula.met99Datos.PPEcr.get(m) + Met99Calcula.met99Datos.PPEpht.get(m));
            ppeTotal = ppeTotal + (Met99Calcula.met99Datos.PPEegComp.get(m) + Met99Calcula.met99Datos.PPEcrComp.get(m));
            ppeTotal = ppeTotal + (Met99Calcula.met99Datos.PPEapComp.get(m) + Met99Calcula.met99Datos.PPEbcacComp.get(m));
            ppeTotal = ppeTotal + Met99Calcula.met99Datos.PPEgfa.get(m);
            ppeTotal = ppeTotal + Met99Calcula.met99Datos.PPEgfc.get(m);
            ppeTotal = ppeTotal + Met99Calcula.met99Datos.PPEbacy.get(m);
            ppeTotal = ppeTotal + Met99Calcula.met99Datos.PPEgfComp.get(m);
            ppeTotal = ppeTotal + Met99Calcula.met99Datos.PPEbacComp.get(m);
            ppeTotal = ppeTotal + Met99Calcula.met99Datos.PPEphxComp.get(m);
            ppeTotal = ppeTotal + (Met99Calcula.met99Datos.PPEbcac.get(m) + Met99Calcula.met99Datos.PPEexc.get(m));
            Met99Calcula.met99Datos.PPE.add(ppeTotal);
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                Double tasaGDAM = Met99Calcula.met99Datos.facGadm.get(Met99Calcula.met99Datos.edadCalculoTitular);
                Met99Calcula.met99Datos.GADM.add((Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.PPE.get(m)) * tasaGDAM);
            } else {
                Met99Calcula.met99Datos.GADM.add((Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.PPE.get(m)) * Met99Calcula.met99Datos.tasaGADM);
            }
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                Double tasaGADQ;
                switch (Met99Calcula.met99Datos.ano.get(m)) {
                    case 1: {
                        tasaGADQ = Met99Calcula.met99Datos.tasaGADQ1;
                        break;
                    }
                    case 2: {
                        tasaGADQ = Met99Calcula.met99Datos.tasaGADQ2;
                        break;
                    }
                    case 3: {
                        tasaGADQ = Met99Calcula.met99Datos.tasaGADQ3;
                        break;
                    }
                    case 4: {
                        tasaGADQ = Met99Calcula.met99Datos.tasaGADQ4;
                        break;
                    }
                    case 5: {
                        tasaGADQ = Met99Calcula.met99Datos.tasaGADQ5;
                        break;
                    }
                    default: {
                        tasaGADQ = 0.0;
                    }
                }
                Met99Calcula.met99Datos.GADQ.add((Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.PPE.get(m)) * tasaGADQ);
            } else if (Met99Calcula.met99Datos.ano.get(m) == 1) {
                Met99Calcula.met99Datos.GADQ.add((Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.PPE.get(m)) * Met99Calcula.met99Datos.tasaGADQ1);
            } else if (Met99Calcula.met99Datos.ano.get(m) <= 3) {
                Met99Calcula.met99Datos.GADQ.add((Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.PPE.get(m)) * Met99Calcula.met99Datos.tasaGADQ2);
            } else {
                Met99Calcula.met99Datos.GADQ.add((Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.PPE.get(m)) * Met99Calcula.met99Datos.tasaGADQ4);
            }
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                if (Met99Calcula.met99Datos.ano.get(m) <= 5) {
                    this.valTemp = Met99Calcula.met99Datos.PPE.get(m) * Met99Calcula.met99Datos.tasaGADQexc;
                    Met99Calcula.met99Datos.GADQexc.add(this.valTemp);
                } else {
                    Met99Calcula.met99Datos.GADQexc.add(0.0);
                }
            } else if (Met99Calcula.met99Datos.ano.get(m) <= 3) {
                this.valTemp = Met99Calcula.met99Datos.PPE.get(m) * Met99Calcula.met99Datos.tasaGADQexc;
                Met99Calcula.met99Datos.GADQexc.add(this.valTemp);
            } else {
                Met99Calcula.met99Datos.GADQexc.add(0.0);
            }
            Met99Calcula.met99Datos.SOB.add(genSubs.Redondea(Met99Calcula.met99Datos.PC.get(m) - Met99Calcula.met99Datos.GADM.get(m) - Met99Calcula.met99Datos.GADQ.get(m) - Met99Calcula.met99Datos.PPE.get(m), 2));
            Met99Calcula.met99Datos.SOBprimaExc.add(Met99Calcula.met99Datos.PPE.get(m) - Met99Calcula.met99Datos.GADQexc.get(m));
        }
    }

    private void CalculaCoiTitCon() {
        Integer edadCanTmp = 0;
        this.indiceCob = genSubs.IndiceCob("CAT");
        this.edadCanCAT = Met99Calcula.met99Datos.edadCan.get(this.indiceCob);
        this.indiceCob = genSubs.IndiceCob("BCAC");
        this.edadCanBCAC = Met99Calcula.met99Datos.edadCan.get(this.indiceCob);
        this.indiceCob = genSubs.IndiceCob("AP");
        this.edadCanAP = Met99Calcula.met99Datos.edadCan.get(this.indiceCob);
        this.indiceCob = genSubs.IndiceCob("PHT");
        this.edadCanPHT = Met99Calcula.met99Datos.edadCan.get(this.indiceCob);
        Met99Calcula.met99Datos.lstSumaBit.clear();
        Met99Calcula.met99Datos.lstSumaBit.add(0.0);
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            int i;
            this.facSel = Met99Calcula.met99Datos.ano.get(m) == 1 ? Met99Calcula.met99Datos.facSel1 : (Met99Calcula.met99Datos.ano.get(m) == 2 ? Met99Calcula.met99Datos.facSel2 : (Met99Calcula.met99Datos.ano.get(m) == 3 ? Met99Calcula.met99Datos.facSel3 : Met99Calcula.met99Datos.facSel4));
            this.qxGFH = Met99Calcula.met99Datos.productoAnterior == "Met99" ? (Met99Calcula.met99Datos.numHijos == 1 ? Met99Calcula.met99Datos.qxGFH1Met99 : (Met99Calcula.met99Datos.numHijos == 2 ? Met99Calcula.met99Datos.qxGFH2Met99 : Met99Calcula.met99Datos.qxGFH3Met99)) : (Met99Calcula.met99Datos.productoSeleccionado == "PT20" ? (Met99Calcula.met99Datos.numHijos == 1 ? Met99Calcula.met99Datos.qxGFH1PT20 : (Met99Calcula.met99Datos.numHijos == 2 ? Met99Calcula.met99Datos.qxGFH2PT20 : Met99Calcula.met99Datos.qxGFH3PT20)) : Double.valueOf(0.0));
            this.qxCAT = "M".equals(Met99Calcula.met99Datos.sexoTitular) ? Met99Calcula.met99Datos.qxCATH.get(Met99Calcula.met99Datos.edadRealTit.get(m)) : Met99Calcula.met99Datos.qxCATM.get(Met99Calcula.met99Datos.edadRealTit.get(m));
            this.qxPHT = Met99Calcula.met99Datos.selPHT.booleanValue() ? ("M".equals(Met99Calcula.met99Datos.sexoTitular) ? Met99Calcula.met99Datos.qxPHH.get(Met99Calcula.met99Datos.edadRealTit.get(m)) : Met99Calcula.met99Datos.qxPHM.get(Met99Calcula.met99Datos.edadRealTit.get(m))) : Double.valueOf(0.0);
            this.qxBCAC = "M".equals(Met99Calcula.met99Datos.sexoConyuge) ? Met99Calcula.met99Datos.qxCATH.get(Met99Calcula.met99Datos.edadCon.get(m)) : Met99Calcula.met99Datos.qxCATM.get(Met99Calcula.met99Datos.edadCon.get(m));
            this.facTipoAP = Met99Calcula.met99Datos.optSumaAP == 1 ? Met99Calcula.met99Datos.facTipo1AP : Met99Calcula.met99Datos.facTipo2AP;
            this.qxEG = "M".equals(Met99Calcula.met99Datos.sexoTitular) ? Met99Calcula.met99Datos.qxEGH.get(Met99Calcula.met99Datos.edadRealTit.get(m)) : Met99Calcula.met99Datos.qxEGM.get(Met99Calcula.met99Datos.edadRealTit.get(m));
            this.qxCR = "M".equals(Met99Calcula.met99Datos.sexoTitular) ? Met99Calcula.met99Datos.qxCRH.get(Met99Calcula.met99Datos.edadRealTit.get(m)) : Met99Calcula.met99Datos.qxCRM.get(Met99Calcula.met99Datos.edadRealTit.get(m));
            this.sumaPC = 0.0;
            this.valTemp = (double)Met99Calcula.met99Datos.sumaBAS.intValue() * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCalTit.get(m)) * this.facSel;
            this.valTemp = Met99Calcula.met99Datos.productoSeleccionado.equals("PT20") ? Double.valueOf(this.valTemp + (double)Met99Calcula.met99Datos.sumaBAS.intValue() * (1.0 - Met99Calcula.met99Datos.FacX.get(Met99Calcula.met99Datos.edadCalTit.get(m))) * Met99Calcula.met99Datos.epVida / 1000.0) : Double.valueOf(this.valTemp + (double)Met99Calcula.met99Datos.sumaBAS.intValue() * Met99Calcula.met99Datos.epVida / 1000.0);
            this.valTemp = genSubs.Redondea(this.valTemp * this.facMort * this.Vp, 2);
            Met99Calcula.met99Datos.coiBAS.add(this.valTemp);
            this.facCanCAT = 0.0;
            this.facCanBCAC = 0.0;
            this.facCanPHT = 0.0;
            if (Met99Calcula.met99Datos.edadRealTit.get(m) > this.edadCanCAT) {
                this.facCanCAT = 1.0;
            }
            if (Met99Calcula.met99Datos.edadCon.get(m) > this.edadCanBCAC) {
                this.facCanBCAC = 1.0;
            }
            if (Met99Calcula.met99Datos.edadRealTit.get(m) > this.edadCanPHT) {
                this.facCanPHT = 1.0;
            }
            this.primaAPcomp = 0.0;
            this.primaBCACcomp = 0.0;
            this.primaEGcomp = 0.0;
            this.primaCRcomp = 0.0;
            this.primaPHXcomp = 0.0;
            this.primaGFcomp = 0.0;
            this.facCanBCAC = 0.0;
            this.facCanEG = 0.0;
            this.facCanCR = 0.0;
            this.facCanPHX = 0.0;
            this.facCanAP = 0.0;
            this.facCanGF = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                if (m == 181) {
                    this.valTemp = 0.0;
                }
                if (Met99Calcula.met99Datos.edadComp[i].get(m) >= this.edadCanBCAC) {
                    this.primaBCACcomp = this.primaBCACcomp + Met99Calcula.met99Datos.lstPrimaBCAC.get(i);
                    this.facCanBCAC = 1.0;
                }
                edadCanTmp = Met99Calcula.met99Datos.edadCan.get(genSubs.IndiceCob("EGcomp"));
                if (Met99Calcula.met99Datos.edadComp[i].get(m) >= edadCanTmp) {
                    this.primaEGcomp = this.primaEGcomp + Met99Calcula.met99Datos.lstPrimaEG.get(i);
                    this.facCanEG = 1.0;
                }
                edadCanTmp = Met99Calcula.met99Datos.edadCan.get(genSubs.IndiceCob("CRcomp"));
                if (Met99Calcula.met99Datos.edadComp[i].get(m) >= edadCanTmp) {
                    this.primaCRcomp = this.primaCRcomp + Met99Calcula.met99Datos.lstPrimaCR.get(i);
                    this.facCanCR = 1.0;
                }
                edadCanTmp = Met99Calcula.met99Datos.edadCan.get(genSubs.IndiceCob("PHX"));
                if (Met99Calcula.met99Datos.edadComp[i].get(m) >= edadCanTmp) {
                    this.primaPHXcomp = this.primaPHXcomp + Met99Calcula.met99Datos.lstPrimaPHX.get(i);
                    this.facCanPHX = 1.0;
                }
                edadCanTmp = Met99Calcula.met99Datos.edadCan.get(genSubs.IndiceCob("APcomp"));
                if (Met99Calcula.met99Datos.edadComp[i].get(m) >= edadCanTmp) {
                    this.primaAPcomp = this.primaAPcomp + Met99Calcula.met99Datos.lstPrimaAP.get(i);
                    this.facCanAP = 1.0;
                }
                edadCanTmp = Met99Calcula.met99Datos.edadCan.get(genSubs.IndiceCob("GFcomp"));
                if (Met99Calcula.met99Datos.edadComp[i].get(m) < edadCanTmp) continue;
                this.primaGFcomp = this.primaGFcomp + Met99Calcula.met99Datos.lstPrimaAP.get(i);
                this.facCanGF = 1.0;
            }
            this.indiceCob = genSubs.IndiceCob("BIT");
            this.edadCanBIT = Met99Calcula.met99Datos.edadCan.get(this.indiceCob);
            if (Met99Calcula.met99Datos.edadRealTit.get(m) >= this.edadCanBIT) {
                this.sumaBITcoi = 0.0;
            } else if (Met99Calcula.met99Datos.selBIT.booleanValue()) {
                this.sumaBITcoi = Met99Calcula.met99Datos.sumaBIT;
                this.sumaBITcoi = this.sumaBITcoi - this.primaPHXcomp * this.facCanPHX;
                this.sumaBITcoi = this.sumaBITcoi - this.primaAPcomp * this.facCanAP;
                this.sumaBITcoi = this.sumaBITcoi - this.primaEGcomp * this.facCanEG;
                this.sumaBITcoi = this.sumaBITcoi - this.primaCRcomp * this.facCanCR;
                this.sumaBITcoi = this.sumaBITcoi - this.primaBCACcomp * this.facCanBCAC;
                this.sumaBITcoi = this.sumaBITcoi - this.primaGFcomp * this.facCanGF;
            } else {
                this.sumaBITcoi = 0.0;
            }
            if (!Met99Calcula.met99Datos.selBIT.booleanValue()) {
                this.sumaBITcoi = 0.0;
            }
            Met99Calcula.met99Datos.lstSumaBit.add(this.sumaBITcoi);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("BIT");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                if (Met99Calcula.met99Datos.productoSeleccionado.equals("PT20")) {
                    this.valTemp = this.sumaBITcoi * Met99Calcula.met99Datos.qxBIT.get(Met99Calcula.met99Datos.edadRealTit.get(m));
                } else if (Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                    this.facAnualidadInv = 1.0;
                    if (Met99Calcula.met99Datos.edadCalculoTitular <= 55) {
                        this.facAnualidadInv = Met99Calcula.met99Datos.facInv.get(Met99Calcula.met99Datos.ano.get(m) - 1);
                        if (this.facAnualidadInv == 0.0) {
                            this.facAnualidadInv = 1.0;
                        }
                    }
                    this.valTemp = this.sumaBITcoi * Met99Calcula.met99Datos.qxBIT.get(Met99Calcula.met99Datos.edadCalTit.get(m)) * this.facAnualidadInv;
                } else {
                    this.valTemp = Met99Calcula.met99Datos.sexoTitular == "M" ? Double.valueOf(this.sumaBITcoi * Met99Calcula.met99Datos.qxBIT.get(Met99Calcula.met99Datos.edadRealTit.get(m))) : Double.valueOf(this.sumaBITcoi * Met99Calcula.met99Datos.qxBIT.get(Met99Calcula.met99Datos.edadRealTit.get(m) - 3));
                }
                this.valTemp = this.valTemp * Met99Calcula.met99Datos.epInvalidez * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
            }
            Met99Calcula.met99Datos.coiBIT.add(this.valTemp);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("CII");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = Met99Calcula.met99Datos.productoSeleccionado.equals("PT20") ? Double.valueOf((double)Met99Calcula.met99Datos.sumaCII.intValue() * Met99Calcula.met99Datos.qxCII.get(Met99Calcula.met99Datos.edadRealTit.get(m)) * Met99Calcula.met99Datos.epInvalidez) : (Met99Calcula.met99Datos.sexoTitular == "M" ? Double.valueOf((double)Met99Calcula.met99Datos.sumaCII.intValue() * Met99Calcula.met99Datos.qxCII.get(Met99Calcula.met99Datos.edadRealTit.get(m)) * Met99Calcula.met99Datos.epInvalidez) : Double.valueOf((double)Met99Calcula.met99Datos.sumaCII.intValue() * Met99Calcula.met99Datos.qxCII.get(Met99Calcula.met99Datos.edadRealTit.get(m) - 3) * Met99Calcula.met99Datos.epInvalidez));
                this.valTemp = genSubs.Redondea(this.valTemp * this.facMort * this.Vp, 2);
            }
            Met99Calcula.met99Datos.coiCII.add(this.valTemp);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("CMA");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaCMA.intValue() * Met99Calcula.met99Datos.qxCMA.get(Met99Calcula.met99Datos.edadRealTit.get(m)) * Met99Calcula.met99Datos.epAccidentes;
                this.valTemp = genSubs.Redondea(this.valTemp * this.facMort * this.Vp, 2);
            }
            Met99Calcula.met99Datos.coiCMA.add(this.valTemp);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("TIBA");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaTIBA.intValue() * Met99Calcula.met99Datos.qxTIBA.get(Met99Calcula.met99Datos.edadRealTit.get(m)) * Met99Calcula.met99Datos.epAccidentes;
                this.valTemp = genSubs.Redondea(this.valTemp * this.facMort * this.Vp, 2);
            }
            Met99Calcula.met99Datos.coiTIBA.add(this.valTemp);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("CAT");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaCAT.intValue() * this.qxCAT * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
            }
            Met99Calcula.met99Datos.coiCAT.add(this.valTemp);
            this.indiceCob = genSubs.IndiceCob("GFA");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaGFA.intValue() * (Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCalTit.get(m)) * this.facSel + Met99Calcula.met99Datos.epVida / 1000.0);
                this.valTemp = genSubs.Redondea(this.valTemp * this.facMort * this.Vp, 2);
            } else {
                this.valTemp = 0.0;
            }
            Met99Calcula.met99Datos.coiGFA.add(this.valTemp);
            this.valTemp = (double)Met99Calcula.met99Datos.sumaGE.intValue() * (Met99Calcula.met99Datos.qxGE.get(Met99Calcula.met99Datos.edadCalTit.get(m)) * this.facSel + Met99Calcula.met99Datos.epVida) / 1000.0 * this.facMort * this.Vp;
            this.valTemp = genSubs.Redondea(this.valTemp, 2);
            Met99Calcula.met99Datos.coiGE.add(this.valTemp);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("AP");
            if (Met99Calcula.met99Datos.edadRealTit.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaAP.intValue() * Met99Calcula.met99Datos.facMorbAP * Met99Calcula.met99Datos.facMortAP * this.facTipoAP * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
            }
            Met99Calcula.met99Datos.coiAP.add(this.valTemp);
            this.indiceCob = genSubs.IndiceCob("EG");
            if (Met99Calcula.met99Datos.ano.get(m) > Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                Met99Calcula.met99Datos.coiEG.add(0.0);
            } else {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaEG.intValue() * this.qxEG * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.coiEG.add(this.valTemp);
            }
            this.indiceCob = genSubs.IndiceCob("CR");
            if (Met99Calcula.met99Datos.ano.get(m) > Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                Met99Calcula.met99Datos.coiCR.add(0.0);
            } else {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaCR.intValue() * this.qxCR * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.coiCR.add(this.valTemp);
            }
            this.indiceCob = genSubs.IndiceCob("PHT");
            if (Met99Calcula.met99Datos.selPHT.booleanValue()) {
                if (Met99Calcula.met99Datos.ano.get(m) > Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    Met99Calcula.met99Datos.coiPHT.add(0.0);
                } else {
                    this.valTemp = (double)Met99Calcula.met99Datos.sumaPHT.intValue() * this.qxPHT * this.facMort * this.Vp * 5.0;
                    this.valTemp = genSubs.Redondea(this.valTemp, 2);
                    Met99Calcula.met99Datos.coiPHT.add(this.valTemp);
                }
            } else {
                Met99Calcula.met99Datos.coiPHT.add(0.0);
            }
            this.indiceCob = genSubs.IndiceCob("BACY");
            if (Met99Calcula.met99Datos.edadCon.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaBACY.intValue() * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCon.get(m)) * this.facSel * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
            } else {
                this.valTemp = 0.0;
            }
            Met99Calcula.met99Datos.coiBACY.add(this.valTemp);
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("Met99")) {
                this.indiceCob = genSubs.IndiceCob("GFC");
                this.valTemp = Met99Calcula.met99Datos.edadCon.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob) ? Double.valueOf((double)Met99Calcula.met99Datos.sumaGFC.intValue() * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCon.get(m)) * this.facSel * this.facMort * this.Vp) : Double.valueOf(0.0);
            } else {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaGFC.intValue() * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCon.get(m)) * this.facMort * this.Vp;
            }
            this.valTemp = genSubs.Redondea(this.valTemp, 2);
            Met99Calcula.met99Datos.coiGFC.add(this.valTemp);
            this.valTemp = 0.0;
            this.indiceCob = genSubs.IndiceCob("BCAC");
            if (Met99Calcula.met99Datos.edadCon.get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                this.valTemp = (double)Met99Calcula.met99Datos.sumaBCAC.intValue() * this.qxBCAC * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
            }
            Met99Calcula.met99Datos.coiBCAC.add(this.valTemp);
            this.valTemp = (double)Met99Calcula.met99Datos.sumaGFH.intValue() * this.qxGFH * this.facMort * this.Vp;
            this.valTemp = genSubs.Redondea(this.valTemp, 2);
            Met99Calcula.met99Datos.coiGFH.add(this.valTemp);
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("PT20")) {
                Met99Calcula.met99Datos.CPMN.add(0.0);
            } else if (m <= 2) {
                this.valTemp = (double)Integer.min(Met99Calcula.met99Datos.sumaBAS, 500000) * 1.0;
                this.valTemp = Met99Calcula.met99Datos.productoSeleccionado == "Maestro20" ? Double.valueOf(this.valTemp * 0.08333333333333333 * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCalTit.get(m))) : Double.valueOf(this.valTemp * 0.0821917808219178 * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCalTit.get(m)));
                this.valTemp = genSubs.Redondea(this.valTemp, 6);
                Met99Calcula.met99Datos.CPMN.add(this.valTemp);
            } else {
                Met99Calcula.met99Datos.CPMN.add(0.0);
            }
            if (m == 1) {
                if (Met99Calcula.met99Datos.productoSeleccionado.equals("Met99") || Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                    Met99Calcula.met99Datos.CPMA.add(0.0);
                } else if (Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                    Met99Calcula.met99Datos.CPMA.add(Met99Calcula.met99Datos.facCPMA.get(30) * (double)Integer.min(Met99Calcula.met99Datos.sumaBAS, 200000) / 1000.0);
                } else {
                    Met99Calcula.met99Datos.CPMA.add(Met99Calcula.met99Datos.facCPMA.get(30) * (double)Integer.min(Met99Calcula.met99Datos.sumaBAS, 200000) / 1000.0);
                }
            } else {
                Met99Calcula.met99Datos.CPMA.add(0.0);
            }
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("PT20")) {
                Met99Calcula.met99Datos.PFT.add(0.0);
                continue;
            }
            if (Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20")) {
                if (Met99Calcula.met99Datos.ftpSel == 1) {
                    for (i = 1; i <= m; ++i) {
                        this.sumaPC = this.sumaPC + (Met99Calcula.met99Datos.PC.get(i) - Met99Calcula.met99Datos.PPE.get(i));
                    }
                    if (Met99Calcula.met99Datos.ano.get(m) > 5) {
                        this.valTemp = this.sumaPC * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCalTit.get(m)) * this.facSel;
                        this.valTemp = (this.valTemp + this.sumaPC * Met99Calcula.met99Datos.epVida / 1000.0) * this.facMort * this.Vp;
                        this.valTemp = genSubs.Redondea(this.valTemp, 2);
                        Met99Calcula.met99Datos.PFT.add(this.valTemp);
                        continue;
                    }
                    Met99Calcula.met99Datos.PFT.add(0.0);
                    continue;
                }
                Met99Calcula.met99Datos.PFT.add(0.0);
                continue;
            }
            if (Met99Calcula.met99Datos.ftpSel == 1) {
                for (i = 1; i <= m; ++i) {
                    this.sumaPC = this.sumaPC + (Met99Calcula.met99Datos.PC.get(i) - Met99Calcula.met99Datos.PPE.get(i));
                }
                if (Met99Calcula.met99Datos.ano.get(m) <= 5) {
                    this.valTemp = this.sumaPC * Met99Calcula.met99Datos.qxBAS.get(Met99Calcula.met99Datos.edadCalTit.get(m)) * this.facSel;
                    this.valTemp = (this.valTemp + this.sumaPC * Met99Calcula.met99Datos.epVida / 1000.0) * this.facMort * this.Vp;
                    this.valTemp = genSubs.Redondea(this.valTemp, 2);
                    Met99Calcula.met99Datos.PFT.add(this.valTemp);
                    continue;
                }
                Met99Calcula.met99Datos.PFT.add(0.0);
                continue;
            }
            Met99Calcula.met99Datos.PFT.add(0.0);
        }
    }

    private void CalculaCoiBACcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiBAC[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiBAC[indexComp].add(0.0);
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                this.facSel = Met99Calcula.met99Datos.ano.get(m) == 1 ? Met99Calcula.met99Datos.facSel1 : (Met99Calcula.met99Datos.ano.get(m) == 2 ? Met99Calcula.met99Datos.facSel2 : Met99Calcula.met99Datos.facSel3);
                Integer edadAlcanzada = Met99Calcula.met99Datos.edadComp[indexComp].get(m);
                Double qxBAC = Met99Calcula.met99Datos.qxBAS.get(edadAlcanzada);
                this.indiceCob = genSubs.IndiceCob("BACcomp");
                if (edadAlcanzada < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    this.valTemp = (double)Met99Calcula.met99Datos.lstSumaBAC.get(indexComp).intValue() * qxBAC * this.facSel * this.facMort * this.Vp;
                    this.valTemp = genSubs.Redondea(this.valTemp, 2);
                } else {
                    this.valTemp = 0.0;
                }
                Met99Calcula.met99Datos.lstCoiBAC[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiBCACcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiBCAC[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiBCAC[indexComp].add(0.0);
            this.indiceCob = genSubs.IndiceCob("BCACcomp");
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                Integer edadAlcanzada = Met99Calcula.met99Datos.edadComp[indexComp].get(m);
                this.qxCAT = "M".equals(Met99Calcula.met99Datos.lstSexoComp.get(indexComp)) ? Met99Calcula.met99Datos.qxCATH.get(edadAlcanzada) : Met99Calcula.met99Datos.qxCATM.get(edadAlcanzada);
                this.valTemp = 0.0;
                if (edadAlcanzada < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    this.valTemp = (double)Met99Calcula.met99Datos.lstSumaBCAC.get(indexComp).intValue() * this.qxCAT * this.facSel * this.facMort * this.Vp;
                    this.valTemp = genSubs.Redondea(this.valTemp, 2);
                }
                Met99Calcula.met99Datos.lstCoiBCAC[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiAPcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiAP[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiAP[indexComp].add(0.0);
            this.facTipoAP = Met99Calcula.met99Datos.lstOptSumaAP.get(indexComp) == 1 ? Met99Calcula.met99Datos.facTipo1AP : Met99Calcula.met99Datos.facTipo2AP;
            this.indiceCob = genSubs.IndiceCob("APcomp");
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                this.valTemp = 0.0;
                if (Met99Calcula.met99Datos.edadComp[indexComp].get(m) < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    this.valTemp = (double)Met99Calcula.met99Datos.lstSumaAP.get(indexComp).intValue() * Met99Calcula.met99Datos.facMorbAP * Met99Calcula.met99Datos.facMortAP * this.facTipoAP * this.Vp;
                    this.valTemp = genSubs.Redondea(this.valTemp, 2);
                }
                Met99Calcula.met99Datos.lstCoiAP[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiGFcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiGF[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiGF[indexComp].add(0.0);
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                if (m == 229) {
                    this.valTemp = 0.0;
                }
                Integer edadAlcanzada = Met99Calcula.met99Datos.edadComp[indexComp].get(m);
                this.facSel = Met99Calcula.met99Datos.ano.get(m) == 1 ? Met99Calcula.met99Datos.facSel1 : (Met99Calcula.met99Datos.ano.get(m) == 2 ? Met99Calcula.met99Datos.facSel2 : Met99Calcula.met99Datos.facSel3);
                this.indiceCob = genSubs.IndiceCob("GFcomp");
                if (edadAlcanzada < Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    this.valTemp = (double)Met99Calcula.met99Datos.lstSumaGF.get(indexComp).intValue() * Met99Calcula.met99Datos.qxGF.get(edadAlcanzada);
                    this.valTemp = this.valTemp * this.facMort * this.facSel * this.Vp;
                    this.valTemp = genSubs.Redondea(this.valTemp, 2);
                } else {
                    this.valTemp = 0.0;
                }
                Met99Calcula.met99Datos.lstCoiGF[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiEGcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiEG[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiEG[indexComp].add(0.0);
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                Integer edadAlcanzada = Met99Calcula.met99Datos.edadComp[indexComp].get(m);
                this.qxEG = "M".equals(Met99Calcula.met99Datos.lstSexoComp.get(indexComp)) ? Met99Calcula.met99Datos.qxEGH.get(edadAlcanzada) : Met99Calcula.met99Datos.qxEGM.get(edadAlcanzada);
                this.indiceCob = genSubs.IndiceCob("EG");
                if (Met99Calcula.met99Datos.ano.get(m) > Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    Met99Calcula.met99Datos.lstCoiEG[indexComp].add(0.0);
                    continue;
                }
                this.valTemp = (double)Met99Calcula.met99Datos.lstSumaEG.get(indexComp).intValue() * this.qxEG;
                this.valTemp = this.valTemp * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.lstCoiEG[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiCRcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiCR[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiCR[indexComp].add(0.0);
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                Integer edadAlcanzada = Met99Calcula.met99Datos.edadComp[indexComp].get(m);
                this.qxCR = "M".equals(Met99Calcula.met99Datos.lstSexoComp.get(indexComp)) ? Met99Calcula.met99Datos.qxCRH.get(edadAlcanzada) : Met99Calcula.met99Datos.qxCRM.get(edadAlcanzada);
                this.indiceCob = genSubs.IndiceCob("CR");
                if (Met99Calcula.met99Datos.ano.get(m) > Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    Met99Calcula.met99Datos.lstCoiCR[indexComp].add(0.0);
                    continue;
                }
                this.valTemp = (double)Met99Calcula.met99Datos.lstSumaCR.get(indexComp).intValue() * this.qxCR;
                this.valTemp = this.valTemp * this.facMort * this.Vp;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.lstCoiCR[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiPHXcomp() {
        for (int indexComp = 0; indexComp < Met99Calcula.met99Datos.numComp; ++indexComp) {
            Met99Calcula.met99Datos.lstCoiPHX[indexComp] = new ArrayList();
            Met99Calcula.met99Datos.lstCoiPHX[indexComp].add(0.0);
            for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                Integer edadAlcanzada = Met99Calcula.met99Datos.edadComp[indexComp].get(m);
                this.qxPHX = "M".equals(Met99Calcula.met99Datos.lstSexoComp.get(indexComp)) ? Met99Calcula.met99Datos.qxPHH.get(edadAlcanzada) : Met99Calcula.met99Datos.qxPHM.get(edadAlcanzada);
                this.indiceCob = genSubs.IndiceCob("PHX");
                if (Met99Calcula.met99Datos.ano.get(m) > Met99Calcula.met99Datos.edadCan.get(this.indiceCob)) {
                    Met99Calcula.met99Datos.lstCoiPHX[indexComp].add(0.0);
                    continue;
                }
                this.valTemp = (double)Met99Calcula.met99Datos.lstSumaPHX.get(indexComp).intValue() * this.qxPHX * this.facMort * this.Vp * 5.0;
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.lstCoiPHX[indexComp].add(this.valTemp);
            }
        }
    }

    private void CalculaCoiCoberturaComp() {
        int i;
        int m;
        Met99Calcula.met99Datos.lstCoiBACtot.clear();
        Met99Calcula.met99Datos.lstCoiBCACtot.clear();
        Met99Calcula.met99Datos.lstCoiAPtot.clear();
        Met99Calcula.met99Datos.lstCoiGFtot.clear();
        Met99Calcula.met99Datos.lstCoiEGtot.clear();
        Met99Calcula.met99Datos.lstCoiCRtot.clear();
        Met99Calcula.met99Datos.lstCoiPHXtot.clear();
        Met99Calcula.met99Datos.lstCoiBACtot.add(0.0);
        Met99Calcula.met99Datos.lstCoiBCACtot.add(0.0);
        Met99Calcula.met99Datos.lstCoiAPtot.add(0.0);
        Met99Calcula.met99Datos.lstCoiGFtot.add(0.0);
        Met99Calcula.met99Datos.lstCoiEGtot.add(0.0);
        Met99Calcula.met99Datos.lstCoiCRtot.add(0.0);
        Met99Calcula.met99Datos.lstCoiPHXtot.add(0.0);
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiAP[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiAPtot.add(this.valTemp);
        }
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiBAC[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiBACtot.add(this.valTemp);
        }
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiBCAC[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiBCACtot.add(this.valTemp);
        }
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiGF[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiGFtot.add(this.valTemp);
        }
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiEG[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiEGtot.add(this.valTemp);
        }
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiCR[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiCRtot.add(this.valTemp);
        }
        for (m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            this.valTemp = 0.0;
            for (i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiPHX[i].get(m);
            }
            Met99Calcula.met99Datos.lstCoiPHXtot.add(this.valTemp);
        }
    }

    private void CalculaCoiTotal() {
        for (int i = 1; i <= Met99Calcula.met99Datos.mesesPry; ++i) {
            this.valTemp = Met99Calcula.met99Datos.coiBAS.get(i) + Met99Calcula.met99Datos.coiBIT.get(i);
            this.valTemp = this.valTemp + (Met99Calcula.met99Datos.coiCII.get(i) + Met99Calcula.met99Datos.coiCMA.get(i));
            this.valTemp = this.valTemp + (Met99Calcula.met99Datos.coiTIBA.get(i) + Met99Calcula.met99Datos.coiCAT.get(i));
            this.valTemp = this.valTemp + (Met99Calcula.met99Datos.coiGFA.get(i) + Met99Calcula.met99Datos.coiGE.get(i));
            this.valTemp = this.valTemp + (Met99Calcula.met99Datos.coiAP.get(i) + Met99Calcula.met99Datos.coiEG.get(i));
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.coiCR.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.coiPHT.get(i);
            this.valTemp = this.valTemp + (Met99Calcula.met99Datos.coiBACY.get(i) + Met99Calcula.met99Datos.coiGFC.get(i));
            this.valTemp = this.valTemp + (Met99Calcula.met99Datos.coiBCAC.get(i) + Met99Calcula.met99Datos.coiGFH.get(i));
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiBACtot.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiBCACtot.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiAPtot.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiGFtot.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiEGtot.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiCRtot.get(i);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.lstCoiPHXtot.get(i);
            Met99Calcula.met99Datos.COI.add(this.valTemp);
        }
    }

    private void CalculaReservaFondo() {
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            if (m == 1) {
                this.valTemp = Met99Calcula.met99Datos.SOB.get(m) - Met99Calcula.met99Datos.COI.get(m) - Met99Calcula.met99Datos.CPMN.get(m);
                this.valTemp = Met99Calcula.met99Datos.productoSeleccionado.equals("Maestro20") ? Double.valueOf(this.valTemp - Met99Calcula.met99Datos.CPMA.get(m)) : Double.valueOf(this.valTemp - Met99Calcula.met99Datos.PFT.get(m) - Met99Calcula.met99Datos.CPMA.get(m));
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.RVA.add(this.valTemp);
                Met99Calcula.met99Datos.Fondo.add(Met99Calcula.met99Datos.SOBprimaExc.get(m));
            } else {
                if (Met99Calcula.met99Datos.productoSeleccionado == "Maestro20") {
                    this.valTemp = Met99Calcula.met99Datos.RVA.get(m - 1) * (1.0 + Met99Calcula.met99Datos.tasaTecMensual);
                    this.valTemp = this.valTemp + Met99Calcula.met99Datos.SOB.get(m) - Met99Calcula.met99Datos.COI.get(m) - Met99Calcula.met99Datos.CPMN.get(m);
                    this.valTemp = this.valTemp - Met99Calcula.met99Datos.PFT.get(m) - Met99Calcula.met99Datos.CPMA.get(m);
                } else if (Met99Calcula.met99Datos.RVA.get(m - 1) > 0.0) {
                    this.valTemp = Met99Calcula.met99Datos.RVA.get(m - 1) * (1.0 + Met99Calcula.met99Datos.tasaPryMensual);
                    this.valTemp = this.valTemp + Met99Calcula.met99Datos.SOB.get(m) - Met99Calcula.met99Datos.COI.get(m) - Met99Calcula.met99Datos.CPMN.get(m);
                    this.valTemp = this.valTemp - Met99Calcula.met99Datos.PFT.get(m) - Met99Calcula.met99Datos.CPMA.get(m);
                } else {
                    this.valTemp = Met99Calcula.met99Datos.RVA.get(m - 1) * (1.0 + Met99Calcula.met99Datos.tasaTecMensual);
                    this.valTemp = this.valTemp + Met99Calcula.met99Datos.SOB.get(m) - Met99Calcula.met99Datos.COI.get(m) - Met99Calcula.met99Datos.CPMN.get(m);
                    this.valTemp = this.valTemp - Met99Calcula.met99Datos.PFT.get(m) - Met99Calcula.met99Datos.CPMA.get(m);
                }
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.RVA.add(this.valTemp);
                this.valTemp = Met99Calcula.met99Datos.Fondo.get(m - 1) * (1.0 + Met99Calcula.met99Datos.tasaPryMensual) + Met99Calcula.met99Datos.SOBprimaExc.get(m);
                this.valTemp = genSubs.Redondea(this.valTemp, 2);
                Met99Calcula.met99Datos.Fondo.add(this.valTemp);
            }
            if (Met99Calcula.met99Datos.RVA.get(m) < 0.0) {
                Met99Calcula.met99Datos.valorEfectivo.add(0.0);
                continue;
            }
            Met99Calcula.met99Datos.valorEfectivo.add(Met99Calcula.met99Datos.RVA.get(m));
        }
    }

    private List CalculaPPE(String idCob, Boolean selCob, Double primaCob, List<Integer> lstEdad) {
        ArrayList<Double> PPE = new ArrayList<Double>();
        PPE.add(0.0);
        Integer indexCob = selCob != false ? genSubs.IndiceCob(idCob) : Integer.valueOf(0);
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            Boolean cancelaCob = false;
            if (selCob.booleanValue()) {
                cancelaCob = idCob.equals("EG") || idCob.equals("CR") || idCob.equals("EGcomp") || idCob.equals("CRcomp") ? (lstEdad.get(m) >= Met99Calcula.met99Datos.edadCan.get(indexCob) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (lstEdad.get(m) >= Met99Calcula.met99Datos.edadCan.get(indexCob) ? Boolean.valueOf(true) : Boolean.valueOf(false));
                if (cancelaCob.booleanValue()) {
                    if ("Anual".equals(Met99Calcula.met99Datos.formaPago)) {
                        if (Met99Calcula.met99Datos.mes.get(m) == 1) {
                            PPE.add(primaCob);
                            continue;
                        }
                        PPE.add(0.0);
                        continue;
                    }
                    PPE.add(genSubs.Redondea(primaCob / 12.0, 2));
                    continue;
                }
                PPE.add(0.0);
                continue;
            }
            PPE.add(0.0);
        }
        return PPE;
    }

    private List CalculaPPEcomp(String idCob) {
        Integer indexCob = genSubs.IndiceCob(idCob);
        ArrayList<Double> PPE = new ArrayList<Double>();
        PPE.add(0.0);
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            PPE.add(0.0);
        }
        for (int i = 0; i < Met99Calcula.met99Datos.numComp; ++i) {
            block20: for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
                switch (idCob) {
                    case "BCAC": {
                        indexCob = genSubs.IndiceCob("BCAC");
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaBCAC.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaBCAC.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                        continue block20;
                    }
                    case "AP": {
                        indexCob = genSubs.IndiceCob("AP");
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaAP.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaAP.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                        continue block20;
                    }
                    case "EG": {
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaEG.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaEG.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                        continue block20;
                    }
                    case "CR": {
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaCR.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaCR.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                        continue block20;
                    }
                    case "PHX": {
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaPHX.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaPHX.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                        continue block20;
                    }
                    case "GFcomp": {
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaGF.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaGF.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                        continue block20;
                    }
                    case "BACcomp": {
                        if (Met99Calcula.met99Datos.edadComp[i].get(m) < Met99Calcula.met99Datos.edadCan.get(indexCob)) continue block20;
                        Double valorTemp = (Double)PPE.get(m);
                        valorTemp = "Anual".equals(Met99Calcula.met99Datos.formaPago) ? (Met99Calcula.met99Datos.mes.get(m) == 1 ? Double.valueOf(valorTemp + Met99Calcula.met99Datos.lstPrimaBAC.get(i)) : Double.valueOf(valorTemp + 0.0)) : Double.valueOf(valorTemp + genSubs.Redondea(Met99Calcula.met99Datos.lstPrimaBAC.get(i) / 12.0, 2));
                        PPE.set(m, valorTemp);
                    }
                }
            }
        }
        return PPE;
    }

    private void CalculaPPEbitEGyCR() {
        for (int m = 1; m <= Met99Calcula.met99Datos.mesesPry; ++m) {
            if (Met99Calcula.met99Datos.edadRealTit.get(m) >= Met99Calcula.met99Datos.edadCan.get(genSubs.IndiceCob("BIT"))) continue;
            if (Met99Calcula.met99Datos.PPEegComp.get(m) > 0.0) {
                this.valTemp = Met99Calcula.met99Datos.PPEbit.get(m);
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.PPEegComp.get(m) * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
                Met99Calcula.met99Datos.PPEbit.set(m, this.valTemp);
            }
            if (Met99Calcula.met99Datos.PPEcrComp.get(m) > 0.0) {
                this.valTemp = Met99Calcula.met99Datos.PPEbit.get(m);
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.PPEcrComp.get(m) * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
                Met99Calcula.met99Datos.PPEbit.set(m, this.valTemp);
            }
            if (Met99Calcula.met99Datos.PPEapComp.get(m) > 0.0) {
                this.valTemp = Met99Calcula.met99Datos.PPEbit.get(m);
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.PPEapComp.get(m) * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
                Met99Calcula.met99Datos.PPEbit.set(m, this.valTemp);
            }
            if (Met99Calcula.met99Datos.PPEphxComp.get(m) > 0.0) {
                this.valTemp = Met99Calcula.met99Datos.PPEbit.get(m);
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.PPEphxComp.get(m) * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
                Met99Calcula.met99Datos.PPEbit.set(m, this.valTemp);
            }
            if (Met99Calcula.met99Datos.PPEgfComp.get(m) > 0.0) {
                this.valTemp = Met99Calcula.met99Datos.PPEbit.get(m);
                this.valTemp = this.valTemp + Met99Calcula.met99Datos.PPEgfComp.get(m) * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
                Met99Calcula.met99Datos.PPEbit.set(m, this.valTemp);
            }
            if (!(Met99Calcula.met99Datos.PPEbcacComp.get(m) > 0.0)) continue;
            this.valTemp = Met99Calcula.met99Datos.PPEbit.get(m);
            this.valTemp = this.valTemp + Met99Calcula.met99Datos.PPEbcacComp.get(m) * (Met99Calcula.met99Datos.tarBIT * Met99Calcula.met99Datos.epInvalidez) / 100.0;
            Met99Calcula.met99Datos.PPEbit.set(m, this.valTemp);
        }
    }

    private void InicializaVectores() {
        Met99Calcula.met99Datos.mes.clear();
        Met99Calcula.met99Datos.ano.clear();
        Met99Calcula.met99Datos.edadCalTit.clear();
        Met99Calcula.met99Datos.edadRealTit.clear();
        Met99Calcula.met99Datos.edadCon.clear();
        Met99Calcula.met99Datos.PC.clear();
        Met99Calcula.met99Datos.PPEbit.clear();
        Met99Calcula.met99Datos.PPEcii.clear();
        Met99Calcula.met99Datos.PPEcma.clear();
        Met99Calcula.met99Datos.PPEtiba.clear();
        Met99Calcula.met99Datos.PPEcat.clear();
        Met99Calcula.met99Datos.PPEgfa.clear();
        Met99Calcula.met99Datos.PPEgfc.clear();
        Met99Calcula.met99Datos.PPEgfComp.clear();
        Met99Calcula.met99Datos.PPEbacComp.clear();
        Met99Calcula.met99Datos.PPEbacy.clear();
        Met99Calcula.met99Datos.PPEge.clear();
        Met99Calcula.met99Datos.PPEap.clear();
        Met99Calcula.met99Datos.PPEeg.clear();
        Met99Calcula.met99Datos.PPEcr.clear();
        Met99Calcula.met99Datos.PPEpht.clear();
        Met99Calcula.met99Datos.PPEbcac.clear();
        Met99Calcula.met99Datos.PPEexc.clear();
        Met99Calcula.met99Datos.GADQexc.clear();
        Met99Calcula.met99Datos.SOBprimaExc.clear();
        Met99Calcula.met99Datos.PPE.clear();
        Met99Calcula.met99Datos.GADQ.clear();
        Met99Calcula.met99Datos.GADM.clear();
        Met99Calcula.met99Datos.SOB.clear();
        Met99Calcula.met99Datos.RVA.clear();
        Met99Calcula.met99Datos.valorEfectivo.clear();
        Met99Calcula.met99Datos.Fondo.clear();
        Met99Calcula.met99Datos.coiBAS.clear();
        Met99Calcula.met99Datos.coiGFA.clear();
        Met99Calcula.met99Datos.coiGE.clear();
        Met99Calcula.met99Datos.coiBACY.clear();
        Met99Calcula.met99Datos.coiBAC.clear();
        Met99Calcula.met99Datos.coiGFC.clear();
        Met99Calcula.met99Datos.coiCMA.clear();
        Met99Calcula.met99Datos.coiTIBA.clear();
        Met99Calcula.met99Datos.coiCII.clear();
        Met99Calcula.met99Datos.coiBIT.clear();
        Met99Calcula.met99Datos.coiGFH.clear();
        Met99Calcula.met99Datos.coiCAT.clear();
        Met99Calcula.met99Datos.coiBCAC.clear();
        Met99Calcula.met99Datos.coiAP.clear();
        Met99Calcula.met99Datos.coiEG.clear();
        Met99Calcula.met99Datos.coiCR.clear();
        Met99Calcula.met99Datos.coiPHT.clear();
        Met99Calcula.met99Datos.CPMA.clear();
        Met99Calcula.met99Datos.CPMN.clear();
        Met99Calcula.met99Datos.PFT.clear();
        Met99Calcula.met99Datos.COI.clear();
        Met99Calcula.met99Datos.lstSumaBit.clear();
        this.lstEdadCanAP.clear();
        this.lstEdadCanBCAC.clear();
        Met99Calcula.met99Datos.mes.add(0);
        Met99Calcula.met99Datos.ano.add(0);
        Met99Calcula.met99Datos.edadCalTit.add(0);
        Met99Calcula.met99Datos.edadRealTit.add(0);
        Met99Calcula.met99Datos.edadCon.add(0);
        Met99Calcula.met99Datos.PC.add(0.0);
        Met99Calcula.met99Datos.PPEbit.add(0.0);
        Met99Calcula.met99Datos.PPEcii.add(0.0);
        Met99Calcula.met99Datos.PPEcma.add(0.0);
        Met99Calcula.met99Datos.PPEtiba.add(0.0);
        Met99Calcula.met99Datos.PPEcat.add(0.0);
        Met99Calcula.met99Datos.PPEgfa.add(0.0);
        Met99Calcula.met99Datos.PPEgfc.add(0.0);
        Met99Calcula.met99Datos.PPEgfComp.add(0.0);
        Met99Calcula.met99Datos.PPEbacComp.add(0.0);
        Met99Calcula.met99Datos.PPEbacy.add(0.0);
        Met99Calcula.met99Datos.PPEge.add(0.0);
        Met99Calcula.met99Datos.PPEap.add(0.0);
        Met99Calcula.met99Datos.PPEeg.add(0.0);
        Met99Calcula.met99Datos.PPEcr.add(0.0);
        Met99Calcula.met99Datos.PPEpht.add(0.0);
        Met99Calcula.met99Datos.PPEbcac.add(0.0);
        Met99Calcula.met99Datos.PPEexc.add(0.0);
        Met99Calcula.met99Datos.GADQexc.add(0.0);
        Met99Calcula.met99Datos.SOBprimaExc.add(0.0);
        Met99Calcula.met99Datos.PPE.add(0.0);
        Met99Calcula.met99Datos.GADQ.add(0.0);
        Met99Calcula.met99Datos.GADM.add(0.0);
        Met99Calcula.met99Datos.SOB.add(0.0);
        Met99Calcula.met99Datos.RVA.add(0.0);
        Met99Calcula.met99Datos.valorEfectivo.add(0.0);
        Met99Calcula.met99Datos.Fondo.add(0.0);
        Met99Calcula.met99Datos.coiBAS.add(0.0);
        Met99Calcula.met99Datos.coiGFA.add(0.0);
        Met99Calcula.met99Datos.coiGE.add(0.0);
        Met99Calcula.met99Datos.coiBACY.add(0.0);
        Met99Calcula.met99Datos.coiBAC.add(0.0);
        Met99Calcula.met99Datos.coiGFC.add(0.0);
        Met99Calcula.met99Datos.coiCMA.add(0.0);
        Met99Calcula.met99Datos.coiTIBA.add(0.0);
        Met99Calcula.met99Datos.coiCII.add(0.0);
        Met99Calcula.met99Datos.coiBIT.add(0.0);
        Met99Calcula.met99Datos.coiGFH.add(0.0);
        Met99Calcula.met99Datos.coiCAT.add(0.0);
        Met99Calcula.met99Datos.coiBCAC.add(0.0);
        Met99Calcula.met99Datos.coiAP.add(0.0);
        Met99Calcula.met99Datos.coiEG.add(0.0);
        Met99Calcula.met99Datos.coiCR.add(0.0);
        Met99Calcula.met99Datos.coiPHT.add(0.0);
        Met99Calcula.met99Datos.CPMA.add(0.0);
        Met99Calcula.met99Datos.CPMN.add(0.0);
        Met99Calcula.met99Datos.PFT.add(0.0);
        Met99Calcula.met99Datos.COI.add(0.0);
        Met99Calcula.met99Datos.lstSumaBit.add(0.0);
    }
}

