/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import provida.AutoCompleteComboBoxListener;
import provida.GenSubs;
import provida.Met99Datos;
import provida.Met99Reglas;
import provida.Tablas;

public class Met99DPerController
implements Initializable {
    Stage stage;
    Parent root;
    Image imgLogoProducto;
    @FXML
    Tab tabTitular;
    @FXML
    Tab tabComp;
    @FXML
    Label lblVersion;
    @FXML
    TextField txtNombreTitular;
    @FXML
    TextField txtEdadRealTitular;
    @FXML
    Label lblEdadCalculoTitular;
    @FXML
    Label lblNombreConyuge;
    @FXML
    Label lblEdadConyuge;
    @FXML
    TextField txtNombreConyuge;
    @FXML
    TextField txtEdadRealConyuge;
    @FXML
    Label lblOcupacion;
    @FXML
    Label lblExtraprima;
    @FXML
    ComboBox cmbOcupaciones;
    @FXML
    Label lblDecisionSus;
    @FXML
    RadioButton optMasculinoTitular;
    @FXML
    RadioButton optFemeninoTitular;
    @FXML
    RadioButton optMasculinoConyuge;
    @FXML
    RadioButton optFemeninoConyuge;
    @FXML
    RadioButton optFumaTitular;
    @FXML
    RadioButton optNoFumaTitular;
    @FXML
    Button btnBorrarDatos;
    @FXML
    ImageView logoProducto;
    @FXML
    TableView<Person> tblComp;
    @FXML
    TextField txtNombreComp;
    @FXML
    TextField txtEdadComp;
    @FXML
    RadioButton optMasculinoComp;
    @FXML
    RadioButton optFemeninoComp;
    @FXML
    TableColumn tblNombreComp;
    @FXML
    TableColumn tblEdadComp;
    @FXML
    TableColumn tblSexoComp;
    @FXML
    ImageView imgCoberturas2;
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private Met99Reglas met99Reglas = Met99Reglas.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();
    private final ObservableList<Person> listaComp = FXCollections.observableArrayList();
    private String sexoComp;
    private Integer intValue;
    private Boolean hayError = false;
    private Integer indexOcupacion;
    private String txtDecision;
    private String txtEPvida;
    private String txtEPinvalidez;
    private String txtEPaccidentes;
    String idConyuge;
    String idComp;
    String txtMensaje = "";
    Boolean hayErrorComp;
    Boolean huboCambioComp;
    private String ocupacionSel;
    private Object math;

    public void initialize(URL location, ResourceBundle resources) {
        this.tblNombreComp.setCellValueFactory((Callback)new PropertyValueFactory("nombreComp"));
        this.tblEdadComp.setCellValueFactory((Callback)new PropertyValueFactory("edadComp"));
        this.tblSexoComp.setCellValueFactory((Callback)new PropertyValueFactory("sexoComp"));
        this.tblComp.setItems(this.listaComp);
        this.tblEdadComp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Person, String> cell = new TableCell<Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.tblSexoComp.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                TableCell<Person, String> cell = new TableCell<Person, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(empty ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.txtEdadRealTitular.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99DPerController.this.ValidaEdadRealTitular();
                }
            }
        });
        this.txtEdadRealConyuge.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99DPerController.this.ValidaCaptura();
                }
            }
        });
        this.txtEdadComp.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Met99DPerController.this.ValidaCaptura();
                }
            }
        });
        this.cmbOcupaciones.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Met99DPerController.this.DeterminaEP();
            }
        });
        this.txtNombreTitular.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(200));
        this.txtNombreConyuge.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(200));
        this.txtNombreComp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaLetras(200));
        this.txtEdadRealTitular.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros2Digitos());
        this.txtEdadRealConyuge.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros2Digitos());
        this.txtEdadComp.addEventFilter(KeyEvent.KEY_TYPED, this.genSubs.ValidaNumeros2Digitos());
        new AutoCompleteComboBoxListener(this.cmbOcupaciones);
        this.InicializaVentana();
    }

    private void InicializaVentana() {
        if ("PrimeraVez".equals(this.met99Datos.txtInicio)) {
            this.huboCambioComp = true;
            this.ValoresDefault();
            this.ValoresCambioProducto();
            this.DefineTabs();
            this.met99Datos.productoAnterior = this.met99Datos.productoSeleccionado;
            this.CargaTablas();
            this.LlenaCmbOcupaciones();
            this.cmbOcupaciones.setValue((Object)"No especificada");
            this.GuardaDatos();
            this.RecuperaDatos();
        } else {
            this.LlenaCmbOcupaciones();
            if (this.met99Datos.regresaDeTarifario.booleanValue()) {
                this.RecuperaDatosTmp();
                this.met99Datos.regresaDeTarifario = false;
            } else if (!this.met99Datos.productoSeleccionado.equals(this.met99Datos.productoAnterior)) {
                this.RecuperaDatosCambioProducto();
            } else {
                this.RecuperaDatos();
            }
            if (!this.met99Datos.productoSeleccionado.equals(this.met99Datos.productoAnterior)) {
                this.huboCambioComp = true;
                this.ValoresCambioProducto();
                this.DefineTabs();
                this.CargaTablas();
                this.GuardaDatos();
            } else {
                this.DefineTabs();
            }
        }
        if (this.met99Datos.productoSeleccionado == "Maestro20") {
            this.lblNombreConyuge.setVisible(false);
            this.txtNombreConyuge.setVisible(false);
            this.lblEdadConyuge.setVisible(false);
            this.txtEdadRealConyuge.setVisible(false);
            this.optMasculinoConyuge.setVisible(false);
            this.optFemeninoConyuge.setVisible(false);
            this.met99Datos.nombreConyuge = "";
            this.met99Datos.edadRealConyuge = 0;
            if (this.optMasculinoTitular.isSelected()) {
                this.optFemeninoConyuge.setSelected(true);
                this.optMasculinoConyuge.setSelected(false);
            } else {
                this.optFemeninoConyuge.setSelected(false);
                this.optMasculinoConyuge.setSelected(true);
            }
        } else {
            this.lblNombreConyuge.setVisible(true);
            this.txtNombreConyuge.setVisible(true);
            this.lblEdadConyuge.setVisible(true);
            this.txtEdadRealConyuge.setVisible(true);
            this.optMasculinoConyuge.setVisible(true);
            this.optFemeninoConyuge.setVisible(true);
        }
        if (this.met99Datos.productoSeleccionado != this.met99Datos.productoAnterior) {
            this.InicializaCoberturas();
            this.met99Datos.productoAnterior = this.met99Datos.productoSeleccionado;
        }
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                try {
                    if (this.met99Datos.esVida360.booleanValue()) {
                        this.imgLogoProducto = new Image("Img/LogoMetLifeVida360.jpg");
                        this.logoProducto.setImage(this.imgLogoProducto);
                        break;
                    }
                    this.imgLogoProducto = new Image("Img/LogoMetLifeMet99.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e2) {
                    System.out.println("No enuentra imagen, error: " + e2);
                }
                break;
            }
            case "Maestro20": {
                try {
                    this.imgLogoProducto = new Image("Img/LogoMetLifeMaestro20.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                }
                catch (Exception e3) {
                    System.out.println("No enuentra imagen, error: " + e3);
                }
                break;
            }
            case "PT20": {
                try {
                    this.imgLogoProducto = new Image("Img/LogoMetLifePT20.jpg");
                    this.logoProducto.setImage(this.imgLogoProducto);
                    break;
                }
                catch (Exception e4) {
                    System.out.println("No enuentra imagen, error: " + e4);
                }
            }
        }
        this.txtNombreTitular.requestFocus();
        this.txtNombreTitular.selectAll();
        this.huboCambioComp = false;
        if (this.met99Datos.esVida360.booleanValue()) {
            this.lblVersion.setText(this.met99Datos.idVersion360);
        } else {
            this.lblVersion.setText(this.met99Datos.idVersion);
        }
        this.optFumaTitular.setVisible(false);
        this.optNoFumaTitular.setVisible(false);
        if (this.met99Datos.esVida360.booleanValue()) {
            this.lblOcupacion.setVisible(true);
            this.lblExtraprima.setVisible(true);
            this.cmbOcupaciones.setVisible(true);
            this.lblDecisionSus.setVisible(true);
        } else {
            this.lblOcupacion.setVisible(true);
            this.lblExtraprima.setVisible(true);
            this.cmbOcupaciones.setVisible(true);
            this.lblDecisionSus.setVisible(true);
        }
    }

    private void InicializaCoberturas() {
        this.met99Datos.selBIT = false;
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.primaBIT = 0.0;
        this.met99Datos.selCII = false;
        this.met99Datos.sumaCII = 0;
        this.met99Datos.primaCII = 0.0;
        this.met99Datos.selCMA = false;
        this.met99Datos.sumaCMA = 0;
        this.met99Datos.primaCMA = 0.0;
        this.met99Datos.selTIBA = false;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.primaTIBA = 0.0;
        this.met99Datos.selCAT = false;
        this.met99Datos.sumaCAT = 0;
        this.met99Datos.primaCAT = 0.0;
        this.met99Datos.selGFA = false;
        this.met99Datos.sumaGFA = 0;
        this.met99Datos.primaGFA = 0.0;
        this.met99Datos.selGE = false;
        this.met99Datos.sumaGE = 0;
        this.met99Datos.primaGE = 0.0;
        this.met99Datos.selAP = false;
        this.met99Datos.sumaAP = 0;
        this.met99Datos.primaAP = 0.0;
        this.met99Datos.selEG = false;
        this.met99Datos.sumaEG = 0;
        this.met99Datos.primaEG = 0.0;
        this.met99Datos.selCR = false;
        this.met99Datos.sumaCR = 0;
        this.met99Datos.primaCR = 0.0;
        this.met99Datos.selPHT = false;
        this.met99Datos.sumaPHT = 0;
        this.met99Datos.primaPHT = 0.0;
        this.met99Datos.selBACY = false;
        this.met99Datos.sumaBACY = 0;
        this.met99Datos.primaBACY = 0.0;
        this.met99Datos.selGFC = false;
        this.met99Datos.sumaGFC = 0;
        this.met99Datos.primaGFC = 0.0;
        this.met99Datos.selBCAC = false;
        this.met99Datos.sumaBCAC = 0;
        this.met99Datos.primaBCAC = 0.0;
        this.met99Datos.selGFH = false;
        this.met99Datos.sumaGFH = 0;
        this.met99Datos.primaGFH = 0.0;
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstSelBAC.set(i, false);
            this.met99Datos.lstSelBCAC.set(i, false);
            this.met99Datos.lstSelAP.set(i, false);
            this.met99Datos.lstSelGF.set(i, false);
            this.met99Datos.lstSelEG.set(i, false);
            this.met99Datos.lstSelCR.set(i, false);
            this.met99Datos.lstSelPHX.set(i, false);
            this.met99Datos.lstSumaBAC.set(i, 0);
            this.met99Datos.lstSumaBCAC.set(i, 0);
            this.met99Datos.lstSumaAP.set(i, 0);
            this.met99Datos.lstSumaGF.set(i, 0);
            this.met99Datos.lstSumaEG.set(i, 0);
            this.met99Datos.lstSumaPHX.set(i, 0);
            this.met99Datos.lstPrimaBAC.set(i, 0.0);
            this.met99Datos.lstPrimaBCAC.set(i, 0.0);
            this.met99Datos.lstPrimaAP.set(i, 0.0);
            this.met99Datos.lstPrimaGF.set(i, 0.0);
            this.met99Datos.lstPrimaEG.set(i, 0.0);
            this.met99Datos.lstPrimaCR.set(i, 0.0);
            this.met99Datos.lstPrimaPHX.set(i, 0.0);
        }
    }

    private void ValoresDefault() {
        this.met99Datos.txtInicio = "iniciado";
        this.met99Datos.nombreTitular = "";
        this.met99Datos.edadRealTitular = 0;
        this.met99Datos.sexoTitular = "M";
        this.met99Datos.fumaTitular = "N";
        this.met99Datos.edadCalculoTitular = 0;
        this.met99Datos.edadRealConyuge = 0;
        this.met99Datos.nombreConyuge = "";
        this.met99Datos.sexoConyuge = "F";
        this.met99Datos.selBAS = true;
        this.met99Datos.sumaBAS = 350000;
        this.met99Datos.primaAnualTotal = 0.0;
        this.met99Datos.smDiario = 90.0;
        this.met99Datos.sumaAPbasico = 1000;
        this.met99Datos.sumaAPextra = 1203;
        this.met99Datos.optSumaAP = 1;
        this.met99Datos.tarAPbasicoConPFT = 189.0;
        this.met99Datos.tarAPbasicoSinPFT = 187.0;
        this.met99Datos.tarAPextraConPFT = 189.0;
        this.met99Datos.tarAPextraSinPFT = 187.0;
        this.met99Datos.ftpSel = 1;
        this.met99Datos.optNueva = true;
        this.met99Datos.optSuma = true;
        this.met99Datos.lstFormaPago.clear();
        this.met99Datos.lstFormaPago.add("Anual");
        this.met99Datos.lstFormaPago.add("Mensual");
        this.met99Datos.lstFormaPago.add("Quincenal");
        this.met99Datos.formaPago = "Anual";
        this.met99Datos.primaExcedente = 0.0;
        this.met99Datos.mesesPry = 240;
        this.met99Datos.impSumaLimitada = 1000000;
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.met99Datos.tasaGADM = 0.17;
                this.met99Datos.tasaGADQ1 = 0.77;
                this.met99Datos.tasaGADQ2 = 0.13;
                this.met99Datos.tasaGADQ3 = 0.13;
                this.met99Datos.tasaGADQ4 = 0.12;
                this.met99Datos.tasaGADQexc = 0.005;
                this.met99Datos.facSel1 = 0.8;
                this.met99Datos.facSel2 = 0.9;
                this.met99Datos.facSel3 = 1.0;
                this.met99Datos.facSel4 = 1.0;
                break;
            }
            case "Maestro20": {
                this.met99Datos.tasaGADM = 0.17;
                this.met99Datos.tasaGADQ1 = 0.75;
                this.met99Datos.tasaGADQ2 = 0.3;
                this.met99Datos.tasaGADQ3 = 0.2;
                this.met99Datos.tasaGADQ4 = 0.1;
                this.met99Datos.tasaGADQ5 = 0.05;
                this.met99Datos.tasaGADQexc = 0.005;
                this.met99Datos.facSel1 = 0.63;
                this.met99Datos.facSel2 = 0.72;
                this.met99Datos.facSel3 = 0.81;
                this.met99Datos.facSel4 = 0.9;
                break;
            }
            case "PT20": {
                this.met99Datos.tasaGADM = 0.15;
                this.met99Datos.tasaGADQ1 = 0.7;
                this.met99Datos.tasaGADQ2 = 0.1;
                this.met99Datos.tasaGADQ3 = 0.1;
                this.met99Datos.tasaGADQ4 = 0.0;
                this.met99Datos.tasaGADQexc = 0.02;
                this.met99Datos.facSel1 = 0.8;
                this.met99Datos.facSel2 = 0.9;
                this.met99Datos.facSel3 = 1.0;
                this.met99Datos.facSel4 = 1.0;
            }
        }
        this.met99Datos.facMortalidad = 0.08533724;
        this.met99Datos.tasaTecAnual = 0.045;
        this.met99Datos.tasaPryAnual = 0.06;
        this.met99Datos.tasaTecMensual = this.genSubs.Redondea(Math.pow(1.0 + this.met99Datos.tasaTecAnual, 0.08333333333333333) - 1.0, 9);
        this.met99Datos.tasaPryMensual = this.genSubs.Redondea(0.9 * (Math.pow(1.0 + this.met99Datos.tasaPryAnual, 0.08333333333333333) - 1.0), 9);
        this.met99Datos.qxGFH1Met99 = 9.69026E-4;
        this.met99Datos.qxGFH2Met99 = 0.001959499;
        this.met99Datos.qxGFH3Met99 = 0.002907105;
        this.met99Datos.qxGFH1PT20 = 9.7E-4;
        this.met99Datos.qxGFH2PT20 = 0.00196;
        this.met99Datos.qxGFH3PT20 = 0.0029;
        this.met99Datos.facMorbAP = 0.03332;
        this.met99Datos.facMortAP = 0.08533724;
        this.met99Datos.facTipo1AP = 1.0;
        this.met99Datos.facTipo2AP = 1.3162;
        this.met99Datos.selBIT = false;
        this.met99Datos.selCII = false;
        this.met99Datos.selCMA = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCAT = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.selGE = false;
        this.met99Datos.selAP = false;
        this.met99Datos.selEG = false;
        this.met99Datos.selCR = false;
        this.met99Datos.selPHT = false;
        this.met99Datos.selBITtmp = false;
        this.met99Datos.selCIItmp = false;
        this.met99Datos.selCMAtmp = false;
        this.met99Datos.selTIBAtmp = false;
        this.met99Datos.selCATtmp = false;
        this.met99Datos.selGFAtmp = false;
        this.met99Datos.selGEtmp = false;
        this.met99Datos.selAPtmp = false;
        this.met99Datos.selEGtmp = false;
        this.met99Datos.selCRtmp = false;
        this.met99Datos.selBACY = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.selBCAC = false;
        this.met99Datos.selGFH = false;
        this.met99Datos.numHijos = 1;
        this.met99Datos.selBACYtmp = false;
        this.met99Datos.selGFCtmp = false;
        this.met99Datos.selBCACtmp = false;
        this.met99Datos.selGFHtmp = false;
        this.met99Datos.numHijosTmp = 1;
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.sumaCII = 0;
        this.met99Datos.sumaCMA = 0;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.sumaCAT = 0;
        this.met99Datos.sumaGFA = 0;
        this.met99Datos.sumaGE = 0;
        this.met99Datos.sumaAP = 0;
        this.met99Datos.sumaEG = 0;
        this.met99Datos.sumaCR = 0;
        this.met99Datos.sumaBACY = 0;
        this.met99Datos.sumaGFC = 0;
        this.met99Datos.sumaBCAC = 0;
        this.met99Datos.sumaGFH = 0;
        this.met99Datos.sumaBITtmp = 0.0;
        this.met99Datos.sumaCIItmp = 0;
        this.met99Datos.sumaCMAtmp = 0;
        this.met99Datos.sumaTIBAtmp = 0;
        this.met99Datos.sumaCATtmp = 0;
        this.met99Datos.sumaGFAtmp = 0;
        this.met99Datos.sumaGEtmp = 0;
        this.met99Datos.sumaAPtmp = 0;
        this.met99Datos.sumaEGtmp = 0;
        this.met99Datos.sumaCRtmp = 0;
        this.met99Datos.sumaBACYtmp = 0;
        this.met99Datos.sumaGFCtmp = 0;
        this.met99Datos.sumaBCACtmp = 0;
        this.met99Datos.sumaGFHtmp = 0;
        this.met99Datos.numComp = 0;
        this.met99Datos.indexCompConyuge = -1;
        this.idConyuge = "";
        this.idComp = "";
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.ocupacionSel = "No especificada";
        this.met99Datos.regresaDeTarifario = false;
    }

    private void ValoresCambioProducto() {
        this.met99Datos.primaAnualTotal = 0.0;
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.met99Datos.tasaGADM = 0.17;
                this.met99Datos.tasaGADQ1 = 0.77;
                this.met99Datos.tasaGADQ2 = 0.13;
                this.met99Datos.tasaGADQ3 = 0.13;
                this.met99Datos.tasaGADQ4 = 0.12;
                this.met99Datos.tasaGADQexc = 0.005;
                this.met99Datos.facSel1 = 0.8;
                this.met99Datos.facSel2 = 0.9;
                this.met99Datos.facSel3 = 1.0;
                this.met99Datos.facSel4 = 1.0;
                break;
            }
            case "Maestro20": {
                this.met99Datos.tasaGADM = 0.17;
                this.met99Datos.tasaGADQ1 = 0.75;
                this.met99Datos.tasaGADQ2 = 0.3;
                this.met99Datos.tasaGADQ3 = 0.2;
                this.met99Datos.tasaGADQ4 = 0.1;
                this.met99Datos.tasaGADQ5 = 0.05;
                this.met99Datos.tasaGADQexc = 0.005;
                this.met99Datos.facSel1 = 0.63;
                this.met99Datos.facSel2 = 0.72;
                this.met99Datos.facSel3 = 0.81;
                this.met99Datos.facSel4 = 0.9;
                break;
            }
            case "PT20": {
                this.met99Datos.tasaGADM = 0.15;
                this.met99Datos.tasaGADQ1 = 0.7;
                this.met99Datos.tasaGADQ2 = 0.1;
                this.met99Datos.tasaGADQ3 = 0.1;
                this.met99Datos.tasaGADQ4 = 0.0;
                this.met99Datos.tasaGADQexc = 0.02;
                this.met99Datos.facSel1 = 0.8;
                this.met99Datos.facSel2 = 0.9;
                this.met99Datos.facSel3 = 1.0;
                this.met99Datos.facSel4 = 1.0;
            }
        }
        if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.met99Datos.selCII = false;
            this.met99Datos.selCMA = false;
            this.met99Datos.selCAT = false;
            this.met99Datos.selGE = false;
            this.met99Datos.selAP = false;
            this.met99Datos.selEG = false;
            this.met99Datos.selCR = false;
            this.met99Datos.selBACY = false;
            this.met99Datos.selGFC = false;
            this.met99Datos.selBCAC = false;
            this.met99Datos.selGFH = false;
            this.met99Datos.numHijos = 1;
            this.met99Datos.sumaCMA = 0;
            this.met99Datos.sumaCII = 0;
            this.met99Datos.sumaCAT = 0;
            this.met99Datos.sumaGE = 0;
            this.met99Datos.sumaAP = 0;
            this.met99Datos.sumaEG = 0;
            this.met99Datos.sumaCR = 0;
            this.met99Datos.sumaBACY = 0;
            this.met99Datos.sumaGFC = 0;
            this.met99Datos.sumaBCAC = 0;
            this.met99Datos.sumaGFH = 0;
        }
        if (this.met99Datos.productoSeleccionado.equals("PT20")) {
            this.met99Datos.selCMA = false;
            this.met99Datos.selCAT = false;
            this.met99Datos.selGFA = false;
            this.met99Datos.selGE = false;
            this.met99Datos.selAP = false;
            this.met99Datos.selEG = false;
            this.met99Datos.selCR = false;
            this.met99Datos.selBACY = false;
            this.met99Datos.selBCAC = false;
            this.met99Datos.numHijos = 1;
            this.met99Datos.sumaCMA = 0;
            this.met99Datos.sumaCAT = 0;
            this.met99Datos.sumaGFA = 0;
            this.met99Datos.sumaGE = 0;
            this.met99Datos.sumaAP = 0;
            this.met99Datos.sumaEG = 0;
            this.met99Datos.sumaCR = 0;
            this.met99Datos.sumaBACY = 0;
            this.met99Datos.sumaBCAC = 0;
        }
        if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.idConyuge = "";
        }
    }

    private void DefineTabs() {
        switch (this.met99Datos.productoSeleccionado) {
            case "Met99": {
                this.tabTitular.setText("Titular y c\u00f3nyuge");
                this.tabComp.setDisable(false);
                this.tabComp.setText("Complementarios");
                break;
            }
            case "Maestro20": {
                this.tabTitular.setText("Titular");
                this.tabComp.setText("");
                this.tabComp.setDisable(true);
                break;
            }
            case "PT20": {
                this.tabTitular.setText("Titular y c\u00f3nyuge");
                this.tabComp.setText("Complementarios");
                this.tabComp.setDisable(false);
            }
        }
    }

    private void CargaTablas() {
        this.tablas.ConectaBD();
        this.tablas.CargaOcupaciones();
        this.tablas.CargaReglas();
        this.tablas.CargaDesCob();
        this.tablas.CargaRequisitos();
        if (this.met99Datos.productoSeleccionado.equals("PT20")) {
            this.tablas.CargaQxPT20();
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.tablas.CargaQxMaestro20();
            this.tablas.CargaFacInv();
            this.tablas.CargaFacGadm();
        } else {
            this.tablas.CargaQx();
        }
        this.tablas.CierraBD();
    }

    private void LlenaCmbOcupaciones() {
        this.cmbOcupaciones.getItems().clear();
        this.cmbOcupaciones.getItems().addAll(this.met99Datos.lstOcupaciones);
    }

    private void GuardaDatos() {
        this.met99Datos.nombreTitular = this.txtNombreTitular.getText();
        this.met99Datos.nombreConyuge = this.txtNombreConyuge.getText();
        this.met99Datos.hayConuge = !"".equals(this.met99Datos.nombreConyuge);
        this.met99Datos.ocupacionSel = this.ocupacionSel;
        this.met99Datos.sexoTitular = this.optMasculinoTitular.isSelected() ? "M" : "F";
        this.met99Datos.fumaTitular = this.optFumaTitular.isSelected() ? "S" : "N";
        this.met99Datos.sexoConyuge = this.optMasculinoConyuge.isSelected() ? "M" : "F";
        if (this.huboCambioComp.booleanValue()) {
            this.InicializaComp();
        }
        this.idConyuge = this.met99Datos.nombreConyuge + this.met99Datos.edadRealConyuge + this.met99Datos.sexoConyuge;
        this.met99Datos.conyugeEsComplementario = false;
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            this.idComp = this.met99Datos.lstNombreComp.get(i) + this.met99Datos.lstEdadComp.get(i) + this.met99Datos.lstSexoComp.get(i);
            if (!this.idConyuge.equals(this.idComp)) continue;
            this.met99Datos.indexCompConyuge = i;
            this.met99Datos.conyugeEsComplementario = true;
        }
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.tablas.CargaTarifasMet99();
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.tablas.CargaTarifasMaestro20();
        } else {
            this.tablas.CargaTarifasPT20();
        }
        this.tablas.CargaFacCPMA();
    }

    private void ValidaOtrosDatos() {
        String idConyuge;
        this.indexOcupacion = this.cmbOcupaciones.getSelectionModel().getSelectedIndex();
        if (this.indexOcupacion == -1) {
            this.cmbOcupaciones.setValue((Object)"No especificada");
        }
        String txtSexoTitular = this.optMasculinoTitular.isSelected() ? "M" : "F";
        String txtSexoConyuge = this.optMasculinoConyuge.isSelected() ? "M" : "F";
        String idTitular = this.txtNombreTitular.getText() + this.txtEdadRealTitular.getText() + txtSexoTitular;
        if (idTitular.equals(idConyuge = this.txtNombreConyuge.getText() + this.txtEdadRealConyuge.getText() + txtSexoConyuge)) {
            this.hayError = true;
            this.txtMensaje = this.txtMensaje + "El c\u00f3nyuge no debe ser el mismo titular\r";
        }
    }

    private void BorraCoberturasComp() {
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelBCAC.clear();
        this.met99Datos.lstSelAP.clear();
        this.met99Datos.lstSelGF.clear();
        this.met99Datos.lstSelEG.clear();
        this.met99Datos.lstSelCR.clear();
        this.met99Datos.lstSelPHX.clear();
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstPrimaBAC.clear();
        this.met99Datos.lstPrimaBCAC.clear();
        this.met99Datos.lstPrimaAP.clear();
        this.met99Datos.lstPrimaGF.clear();
        this.met99Datos.lstPrimaEG.clear();
        this.met99Datos.lstPrimaCR.clear();
        this.met99Datos.lstPrimaPHX.clear();
        this.met99Datos.lstEpBAC.clear();
        this.met99Datos.lstEpBCAC.clear();
        this.met99Datos.lstEpAP.clear();
        this.met99Datos.lstEpGF.clear();
        this.met99Datos.lstEpEG.clear();
        this.met99Datos.lstEpCR.clear();
        this.met99Datos.lstEpPHX.clear();
        this.met99Datos.lstSumaBAC.clear();
        this.met99Datos.lstSumaBCAC.clear();
        this.met99Datos.lstSumaAP.clear();
        this.met99Datos.lstSumaGF.clear();
        this.met99Datos.lstSumaEG.clear();
        this.met99Datos.lstSumaCR.clear();
        this.met99Datos.lstSumaPHX.clear();
    }

    private void InicializaComp() {
        if (!this.listaComp.isEmpty()) {
            this.met99Datos.lstSelBAC.clear();
            this.met99Datos.lstSelBCAC.clear();
            this.met99Datos.lstSelAP.clear();
            this.met99Datos.lstSelGF.clear();
            this.met99Datos.lstSelEG.clear();
            this.met99Datos.lstSelCR.clear();
            this.met99Datos.lstSelPHX.clear();
            this.met99Datos.lstNombreComp.clear();
            this.met99Datos.lstSexoComp.clear();
            this.met99Datos.lstEdadComp.clear();
            this.met99Datos.lstPrimaBAC.clear();
            this.met99Datos.lstPrimaBCAC.clear();
            this.met99Datos.lstPrimaAP.clear();
            this.met99Datos.lstPrimaGF.clear();
            this.met99Datos.lstPrimaEG.clear();
            this.met99Datos.lstPrimaCR.clear();
            this.met99Datos.lstPrimaPHX.clear();
            this.met99Datos.lstEpBAC.clear();
            this.met99Datos.lstEpBCAC.clear();
            this.met99Datos.lstEpAP.clear();
            this.met99Datos.lstEpGF.clear();
            this.met99Datos.lstEpEG.clear();
            this.met99Datos.lstEpCR.clear();
            this.met99Datos.lstEpPHX.clear();
            this.met99Datos.lstSumaBAC.clear();
            this.met99Datos.lstSumaBCAC.clear();
            this.met99Datos.lstSumaAP.clear();
            this.met99Datos.lstSumaGF.clear();
            this.met99Datos.lstSumaEG.clear();
            this.met99Datos.lstSumaCR.clear();
            this.met99Datos.lstSumaPHX.clear();
            this.met99Datos.numComp = this.listaComp.size();
            for (int i = 0; i < this.listaComp.size(); ++i) {
                this.met99Datos.lstNombreComp.add(((Person)this.listaComp.get(i)).getNombre());
                this.met99Datos.lstSexoComp.add(((Person)this.listaComp.get(i)).getSexo());
                this.met99Datos.lstEdadComp.add(Integer.parseInt(((Person)this.listaComp.get(i)).getEdad()));
                this.met99Datos.lstSelBAC.add(false);
                this.met99Datos.lstSelBCAC.add(false);
                this.met99Datos.lstSelAP.add(false);
                this.met99Datos.lstSelGF.add(false);
                this.met99Datos.lstSelEG.add(false);
                this.met99Datos.lstSelCR.add(false);
                this.met99Datos.lstSelPHX.add(false);
                this.met99Datos.lstSumaBAC.add(0);
                this.met99Datos.lstPrimaBAC.add(0.0);
                this.met99Datos.lstEpBAC.add(0.0);
                this.met99Datos.lstSumaBCAC.add(0);
                this.met99Datos.lstPrimaBCAC.add(0.0);
                this.met99Datos.lstEpBCAC.add(0.0);
                this.met99Datos.lstSumaAP.add(0);
                this.met99Datos.lstPrimaAP.add(0.0);
                this.met99Datos.lstEpAP.add(0.0);
                this.met99Datos.lstOptSumaAP.add(1);
                this.met99Datos.lstSumaGF.add(0);
                this.met99Datos.lstPrimaGF.add(0.0);
                this.met99Datos.lstEpGF.add(0.0);
                this.met99Datos.lstSumaEG.add(0);
                this.met99Datos.lstSumaPHX.add(0);
                this.met99Datos.lstPrimaEG.add(0.0);
                this.met99Datos.lstEpEG.add(0.0);
                this.met99Datos.lstEpPHX.add(0.0);
                this.met99Datos.lstPrimaPHX.add(0.0);
                this.met99Datos.lstSumaCR.add(0);
                this.met99Datos.lstPrimaCR.add(0.0);
                this.met99Datos.lstEpCR.add(0.0);
            }
        }
    }

    private void RecuperaDatosTmp() {
        this.RecuperaDatosTitularTmp();
        this.met99Reglas.EdadCalculoTitular();
        this.lblEdadCalculoTitular.setText(this.met99Datos.edadCalculoTitular.toString());
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.RecuperaDatosConyugeTmp();
            this.RecuperaDatosCompTmp();
            this.RecuperaCoberturasMet99();
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.RecuperaCoberturasMaestro20();
        } else {
            this.RecuperaDatosConyugeTmp();
            this.RecuperaDatosCompTmp();
            this.RecuperaCoberturasPT20();
        }
    }

    private void RecuperaDatosTitularTmp() {
        this.txtNombreTitular.setText(this.met99Datos.nombreTitularTmp);
        if (this.met99Datos.edadRealTitularTmp == 0) {
            this.txtEdadRealTitular.setText("");
        } else {
            this.txtEdadRealTitular.setText(this.met99Datos.edadRealTitularTmp.toString());
        }
        this.met99Datos.epVida = this.met99Datos.epVidaTmp;
        this.met99Datos.epAccidentes = this.met99Datos.epAccidentesTmp;
        this.met99Datos.epInvalidez = this.met99Datos.epInvalidezTmp;
        this.met99Datos.sexoTitular = this.met99Datos.sexoTitularTmp;
        this.met99Datos.fumaTitular = this.met99Datos.fumaTitularTmp;
        this.met99Datos.edadRealTitular = this.met99Datos.edadRealTitularTmp;
        this.met99Datos.edadRealConyuge = this.met99Datos.edadRealConyugeTmp;
        if (this.met99Datos.sexoTitularTmp.equals("M")) {
            this.optMasculinoTitular.setSelected(true);
            this.optFemeninoTitular.setSelected(false);
        } else {
            this.optMasculinoTitular.setSelected(false);
            this.optFemeninoTitular.setSelected(true);
        }
        if (this.met99Datos.fumaTitularTmp.equals("S")) {
            this.optFumaTitular.setSelected(true);
            this.optNoFumaTitular.setSelected(false);
        } else {
            this.optFumaTitular.setSelected(false);
            this.optNoFumaTitular.setSelected(true);
        }
        this.cmbOcupaciones.getItems().clear();
        this.cmbOcupaciones.getItems().addAll(this.met99Datos.lstOcupaciones);
        this.cmbOcupaciones.setValue((Object)this.met99Datos.ocupacionSelTmp);
    }

    private void RecuperaDatosConyugeTmp() {
        this.txtNombreConyuge.setText(this.met99Datos.nombreConyugeTmp);
        if (this.met99Datos.sexoConyugeTmp.equals("M")) {
            this.optMasculinoConyuge.setSelected(true);
            this.optFemeninoConyuge.setSelected(false);
        } else {
            this.optMasculinoConyuge.setSelected(false);
            this.optFemeninoConyuge.setSelected(true);
        }
        if (this.met99Datos.edadRealConyugeTmp == 0) {
            this.txtEdadRealConyuge.setText("");
        } else {
            this.txtEdadRealConyuge.setText(this.met99Datos.edadRealConyugeTmp.toString());
        }
    }

    private void RecuperaDatosCompTmp() {
        this.listaComp.clear();
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.met99Datos.lstEdadComp.clear();
        for (int i = 0; i < this.met99Datos.lstNombreCompTmp.size(); ++i) {
            this.listaComp.add((Object)new Person(this.met99Datos.lstNombreCompTmp.get(i), this.met99Datos.lstEdadCompTmp.get(i).toString(), this.met99Datos.lstSexoCompTmp.get(i)));
            this.met99Datos.lstNombreComp.add(this.met99Datos.lstNombreCompTmp.get(i));
            this.met99Datos.lstEdadComp.add(this.met99Datos.lstEdadCompTmp.get(i));
            this.met99Datos.lstSexoComp.add(this.met99Datos.lstSexoCompTmp.get(i));
        }
        this.met99Datos.numComp = this.met99Datos.lstNombreCompTmp.size();
    }

    private void RecuperaCoberturasMet99() {
        int i;
        this.met99Datos.selBAS = this.met99Datos.selBAStmp;
        this.met99Datos.selBIT = this.met99Datos.selBITtmp;
        this.met99Datos.selCII = this.met99Datos.selCIItmp;
        this.met99Datos.selCMA = this.met99Datos.selCMAtmp;
        this.met99Datos.selTIBA = this.met99Datos.selTIBAtmp;
        this.met99Datos.selCAT = this.met99Datos.selCATtmp;
        this.met99Datos.selGFA = this.met99Datos.selGFAtmp;
        this.met99Datos.selGE = this.met99Datos.selGEtmp;
        this.met99Datos.selAP = this.met99Datos.selAPtmp;
        this.met99Datos.selEG = this.met99Datos.selEGtmp;
        this.met99Datos.selCR = this.met99Datos.selCRtmp;
        this.met99Datos.sumaBAS = this.met99Datos.sumaBAStmp;
        this.met99Datos.sumaBIT = this.met99Datos.sumaBITtmp;
        this.met99Datos.sumaCII = this.met99Datos.sumaCIItmp;
        this.met99Datos.sumaCMA = this.met99Datos.sumaCMAtmp;
        this.met99Datos.sumaTIBA = this.met99Datos.sumaTIBAtmp;
        this.met99Datos.sumaCAT = this.met99Datos.sumaCATtmp;
        this.met99Datos.sumaGFA = this.met99Datos.sumaGFAtmp;
        this.met99Datos.sumaGE = this.met99Datos.sumaGEtmp;
        this.met99Datos.sumaAP = this.met99Datos.sumaAPtmp;
        this.met99Datos.sumaEG = this.met99Datos.sumaEGtmp;
        this.met99Datos.sumaCR = this.met99Datos.sumaCRtmp;
        this.met99Datos.optSumaAP = this.met99Datos.optSumaAPtmp;
        this.met99Datos.selBACY = this.met99Datos.selBACYtmp;
        this.met99Datos.selGFC = this.met99Datos.selGFCtmp;
        this.met99Datos.selBCAC = this.met99Datos.selBCACtmp;
        this.met99Datos.selGFH = this.met99Datos.selGFHtmp;
        this.met99Datos.numHijos = this.met99Datos.numHijosTmp;
        this.met99Datos.sumaBACY = this.met99Datos.sumaBACYtmp;
        this.met99Datos.sumaGFC = this.met99Datos.sumaGFCtmp;
        this.met99Datos.sumaBCAC = this.met99Datos.sumaBCACtmp;
        this.met99Datos.sumaGFH = this.met99Datos.sumaGFHtmp;
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelBCAC.clear();
        this.met99Datos.lstSelAP.clear();
        this.met99Datos.lstSelGF.clear();
        this.met99Datos.lstSelEG.clear();
        this.met99Datos.lstSelCR.clear();
        this.met99Datos.lstSelPHX.clear();
        this.met99Datos.lstTarBAC.clear();
        this.met99Datos.lstTarBCAC.clear();
        this.met99Datos.lstOptSumaAP.clear();
        this.met99Datos.lstTarGF.clear();
        this.met99Datos.lstTarEG.clear();
        this.met99Datos.lstTarCR.clear();
        this.met99Datos.lstTarPHX.clear();
        this.met99Datos.lstSumaBAC.clear();
        this.met99Datos.lstSumaBCAC.clear();
        this.met99Datos.lstSumaAP.clear();
        this.met99Datos.lstSumaGF.clear();
        this.met99Datos.lstSumaEG.clear();
        this.met99Datos.lstSumaCR.clear();
        this.met99Datos.lstSumaPHX.clear();
        this.met99Datos.lstPrimaBAC.clear();
        this.met99Datos.lstPrimaBCAC.clear();
        this.met99Datos.lstPrimaAP.clear();
        this.met99Datos.lstPrimaGF.clear();
        this.met99Datos.lstPrimaEG.clear();
        this.met99Datos.lstPrimaCR.clear();
        this.met99Datos.lstPrimaPHX.clear();
        this.met99Datos.lstEpBAC.clear();
        this.met99Datos.lstEpBCAC.clear();
        this.met99Datos.lstEpAP.clear();
        this.met99Datos.lstEpGF.clear();
        this.met99Datos.lstEpEG.clear();
        this.met99Datos.lstEpCR.clear();
        this.met99Datos.lstEpPHX.clear();
        for (i = 0; i < this.met99Datos.lstNombreCompTmp.size(); ++i) {
            this.met99Datos.lstNombreComp.add(this.met99Datos.lstNombreCompTmp.get(i));
            this.met99Datos.lstEdadComp.add(this.met99Datos.lstEdadCompTmp.get(i));
            this.met99Datos.lstSexoComp.add(this.met99Datos.lstSexoCompTmp.get(i));
            if (this.met99Datos.lstSelBACtmp.size() <= 0) continue;
            this.met99Datos.lstSelBAC.add(this.met99Datos.lstSelBACtmp.get(i));
            this.met99Datos.lstSelBCAC.add(this.met99Datos.lstSelBCACtmp.get(i));
            this.met99Datos.lstSelAP.add(this.met99Datos.lstSelAPtmp.get(i));
            this.met99Datos.lstSelGF.add(this.met99Datos.lstSelGFtmp.get(i));
            this.met99Datos.lstSelEG.add(this.met99Datos.lstSelEGtmp.get(i));
            this.met99Datos.lstSelCR.add(this.met99Datos.lstSelCRtmp.get(i));
            this.met99Datos.lstSelPHX.add(this.met99Datos.lstSelPHXtmp.get(i));
            this.met99Datos.lstTarBAC.add(this.met99Datos.lstTarBACtmp.get(i));
            this.met99Datos.lstTarBCAC.add(this.met99Datos.lstTarBCACtmp.get(i));
            this.met99Datos.lstOptSumaAP.add(this.met99Datos.lstOptSumaAPtmp.get(i));
            this.met99Datos.lstTarGF.add(this.met99Datos.lstTarGFtmp.get(i));
            this.met99Datos.lstTarEG.add(this.met99Datos.lstTarEGtmp.get(i));
            this.met99Datos.lstTarCR.add(this.met99Datos.lstTarCRtmp.get(i));
            this.met99Datos.lstTarPHX.add(this.met99Datos.lstTarPHXtmp.get(i));
            this.met99Datos.lstSumaBAC.add(this.met99Datos.lstSumaBACtmp.get(i));
            this.met99Datos.lstSumaBCAC.add(this.met99Datos.lstSumaBCACtmp.get(i));
            this.met99Datos.lstSumaAP.add(this.met99Datos.lstSumaAPtmp.get(i));
            this.met99Datos.lstSumaGF.add(this.met99Datos.lstSumaGFtmp.get(i));
            this.met99Datos.lstSumaEG.add(this.met99Datos.lstSumaEGtmp.get(i));
            this.met99Datos.lstSumaCR.add(this.met99Datos.lstSumaCRtmp.get(i));
            this.met99Datos.lstSumaPHX.add(this.met99Datos.lstSumaPHXtmp.get(i));
            this.met99Datos.lstPrimaBAC.add(this.met99Datos.lstPrimaBACtmp.get(i));
            this.met99Datos.lstPrimaBCAC.add(this.met99Datos.lstPrimaBCACtmp.get(i));
            this.met99Datos.lstPrimaAP.add(this.met99Datos.lstPrimaAPtmp.get(i));
            this.met99Datos.lstPrimaGF.add(this.met99Datos.lstPrimaGFtmp.get(i));
            this.met99Datos.lstPrimaEG.add(this.met99Datos.lstPrimaEGtmp.get(i));
            this.met99Datos.lstPrimaCR.add(this.met99Datos.lstPrimaCRtmp.get(i));
            this.met99Datos.lstPrimaPHX.add(this.met99Datos.lstPrimaPHXtmp.get(i));
            this.met99Datos.lstEpBAC.add(this.met99Datos.lstEpBACtmp.get(i));
            this.met99Datos.lstEpBCAC.add(this.met99Datos.lstEpBCACtmp.get(i));
            this.met99Datos.lstEpAP.add(this.met99Datos.lstEpAPtmp.get(i));
            this.met99Datos.lstEpGF.add(this.met99Datos.lstEpGFtmp.get(i));
            this.met99Datos.lstEpEG.add(this.met99Datos.lstEpEGtmp.get(i));
            this.met99Datos.lstEpCR.add(this.met99Datos.lstEpCRtmp.get(i));
            this.met99Datos.lstEpPHX.add(this.met99Datos.lstEpPHXtmp.get(i));
        }
        this.listaComp.clear();
        for (i = 0; i < this.met99Datos.lstNombreComp.size(); ++i) {
            this.listaComp.add((Object)new Person(this.met99Datos.lstNombreComp.get(i), this.met99Datos.lstEdadComp.get(i).toString(), this.met99Datos.lstSexoComp.get(i)));
        }
        this.met99Datos.numComp = this.listaComp.size();
    }

    private void RecuperaCoberturasMaestro20() {
        this.met99Datos.selBAS = this.met99Datos.selBAStmp;
        this.met99Datos.selBIT = this.met99Datos.selBITtmp;
        this.met99Datos.selTIBA = this.met99Datos.selTIBAtmp;
        this.met99Datos.selGFA = this.met99Datos.selGFAtmp;
        this.met99Datos.sumaBAS = this.met99Datos.sumaBAStmp;
        this.met99Datos.sumaBIT = this.met99Datos.sumaBITtmp;
        this.met99Datos.sumaTIBA = this.met99Datos.sumaTIBAtmp;
        this.met99Datos.sumaGFA = this.met99Datos.sumaGFAtmp;
    }

    private void RecuperaCoberturasPT20() {
        this.met99Datos.selBAS = this.met99Datos.selBAStmp;
        this.met99Datos.selBIT = this.met99Datos.selBITtmp;
        this.met99Datos.selTIBA = this.met99Datos.selTIBAtmp;
        this.met99Datos.selCII = this.met99Datos.selCIItmp;
        this.met99Datos.sumaBAS = this.met99Datos.sumaBAStmp;
        this.met99Datos.sumaBIT = this.met99Datos.sumaBITtmp;
        this.met99Datos.sumaTIBA = this.met99Datos.sumaTIBAtmp;
        this.met99Datos.sumaCII = this.met99Datos.sumaCIItmp;
        this.met99Datos.selGFC = this.met99Datos.selGFCtmp;
        this.met99Datos.selGFH = this.met99Datos.selGFHtmp;
        this.met99Datos.sumaGFC = this.met99Datos.sumaGFCtmp;
        this.met99Datos.numHijos = this.met99Datos.numHijosTmp;
        this.met99Datos.sumaGFH = this.met99Datos.sumaGFHtmp;
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelBCAC.clear();
        this.met99Datos.lstSelAP.clear();
        this.met99Datos.lstSelGF.clear();
        this.met99Datos.lstSelEG.clear();
        this.met99Datos.lstSelCR.clear();
        this.met99Datos.lstSelPHX.clear();
        this.met99Datos.lstTarBAC.clear();
        this.met99Datos.lstTarBCAC.clear();
        this.met99Datos.lstTarCR.clear();
        this.met99Datos.lstTarGF.clear();
        this.met99Datos.lstTarEG.clear();
        this.met99Datos.lstTarCR.clear();
        this.met99Datos.lstTarPHX.clear();
        this.met99Datos.lstSumaBAC.clear();
        this.met99Datos.lstSumaBCAC.clear();
        this.met99Datos.lstSumaAP.clear();
        this.met99Datos.lstSumaGF.clear();
        this.met99Datos.lstSumaEG.clear();
        this.met99Datos.lstSumaCR.clear();
        this.met99Datos.lstSumaPHX.clear();
        this.met99Datos.lstPrimaBAC.clear();
        this.met99Datos.lstPrimaBCAC.clear();
        this.met99Datos.lstPrimaAP.clear();
        this.met99Datos.lstPrimaGF.clear();
        this.met99Datos.lstPrimaEG.clear();
        this.met99Datos.lstPrimaCR.clear();
        this.met99Datos.lstPrimaPHX.clear();
        this.met99Datos.lstEpBAC.clear();
        this.met99Datos.lstEpBCAC.clear();
        this.met99Datos.lstEpAP.clear();
        this.met99Datos.lstEpGF.clear();
        this.met99Datos.lstEpEG.clear();
        this.met99Datos.lstEpCR.clear();
        this.met99Datos.lstEpPHX.clear();
        if (this.met99Datos.lstNombreCompTmp.size() > 0 && this.met99Datos.lstSelBACtmp.size() > 0) {
            this.met99Datos.lstSelBCAC.add(false);
            this.met99Datos.lstSelAP.add(false);
            this.met99Datos.lstSelEG.add(false);
            this.met99Datos.lstSelCR.add(false);
            this.met99Datos.lstSelGF.add(false);
            this.met99Datos.lstSelPHX.add(false);
            this.met99Datos.lstEpBCAC.add(0.0);
            this.met99Datos.lstEpAP.add(0.0);
            this.met99Datos.lstEpEG.add(0.0);
            this.met99Datos.lstEpCR.add(0.0);
            this.met99Datos.lstEpPHX.add(0.0);
            this.met99Datos.lstEpGF.add(0.0);
            this.met99Datos.lstPrimaBCAC.add(0.0);
            this.met99Datos.lstPrimaAP.add(0.0);
            this.met99Datos.lstPrimaEG.add(0.0);
            this.met99Datos.lstPrimaCR.add(0.0);
            this.met99Datos.lstPrimaEG.add(0.0);
            this.met99Datos.lstPrimaPHX.add(0.0);
            this.met99Datos.lstSumaBCAC.add(0);
            this.met99Datos.lstSumaAP.add(0);
            this.met99Datos.lstSumaEG.add(0);
            this.met99Datos.lstSumaCR.add(0);
            this.met99Datos.lstSumaPHX.add(0);
            this.met99Datos.lstSumaGF.add(0);
            this.met99Datos.lstSelBAC.add(this.met99Datos.lstSelBACtmp.get(0));
            this.met99Datos.lstTarBAC.add(this.met99Datos.lstTarBACtmp.get(0));
            this.met99Datos.lstSumaBAC.add(this.met99Datos.lstSumaBACtmp.get(0));
            this.met99Datos.lstPrimaBAC.add(this.met99Datos.lstPrimaBACtmp.get(0));
            this.met99Datos.lstEpBAC.add(this.met99Datos.lstEpBACtmp.get(0));
        }
    }

    private void RecuperaDatosCambioProducto() {
        this.RecuperaDatosTitularTmp();
        this.met99Reglas.EdadCalculoTitular();
        this.lblEdadCalculoTitular.setText(this.met99Datos.edadCalculoTitular.toString());
        if (this.met99Datos.productoAnterior.equals("Met99")) {
            if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
                this.BorraDatosConyuge();
                this.BorraDatosComp();
                this.InicializaCoberturasMaestro20();
            } else {
                this.RecuperaDatosConyugeTmp();
                this.InicializaDatosComp();
                this.InicializaCoberturasPT20();
            }
        } else if (this.met99Datos.productoAnterior.equals("Maestro20")) {
            this.BorraDatosConyuge();
            this.BorraDatosComp();
            if (this.met99Datos.productoSeleccionado.equals("Met99")) {
                this.InicializaCoberturasMet99();
            } else {
                this.InicializaCoberturasPT20();
            }
        } else if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.RecuperaDatosConyugeTmp();
            this.InicializaCoberturasMet99();
            this.InicializaDatosComp();
        } else {
            this.BorraDatosConyuge();
            this.BorraDatosComp();
            this.InicializaCoberturasMaestro20();
        }
        this.cmbOcupaciones.getItems().clear();
        this.cmbOcupaciones.getItems().addAll(this.met99Datos.lstOcupaciones);
        this.cmbOcupaciones.setValue((Object)this.met99Datos.ocupacionSelTmp);
    }

    private void InicializaCoberturasMet99() {
        int i;
        this.met99Datos.selBAS = true;
        this.met99Datos.selBIT = false;
        this.met99Datos.selCII = false;
        this.met99Datos.selCMA = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCAT = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.selGE = false;
        this.met99Datos.selAP = false;
        this.met99Datos.selEG = false;
        this.met99Datos.selCR = false;
        this.met99Datos.sumaBAS = 350000;
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.sumaCII = 0;
        this.met99Datos.sumaCMA = 0;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.sumaCAT = 0;
        this.met99Datos.sumaGFA = 0;
        this.met99Datos.sumaGE = 0;
        this.met99Datos.sumaAP = 0;
        this.met99Datos.sumaEG = 0;
        this.met99Datos.sumaCR = 0;
        this.met99Datos.optSumaAP = 0;
        this.met99Datos.selBACY = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.selBCAC = false;
        this.met99Datos.selGFH = false;
        this.met99Datos.numHijos = 1;
        this.met99Datos.sumaBACY = 0;
        this.met99Datos.sumaGFC = 0;
        this.met99Datos.sumaBCAC = 0;
        this.met99Datos.sumaGFH = 0;
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelBCAC.clear();
        this.met99Datos.lstSelAP.clear();
        this.met99Datos.lstSelGF.clear();
        this.met99Datos.lstSelEG.clear();
        this.met99Datos.lstSelCR.clear();
        this.met99Datos.lstSelPHX.clear();
        this.met99Datos.lstTarBAC.clear();
        this.met99Datos.lstTarBCAC.clear();
        this.met99Datos.lstOptSumaAP.clear();
        this.met99Datos.lstTarGF.clear();
        this.met99Datos.lstTarEG.clear();
        this.met99Datos.lstTarCR.clear();
        this.met99Datos.lstTarPHX.clear();
        this.met99Datos.lstSumaBAC.clear();
        this.met99Datos.lstSumaBCAC.clear();
        this.met99Datos.lstSumaAP.clear();
        this.met99Datos.lstSumaGF.clear();
        this.met99Datos.lstSumaEG.clear();
        this.met99Datos.lstSumaCR.clear();
        this.met99Datos.lstSumaPHX.clear();
        this.met99Datos.lstPrimaBAC.clear();
        this.met99Datos.lstPrimaBCAC.clear();
        this.met99Datos.lstPrimaAP.clear();
        this.met99Datos.lstPrimaGF.clear();
        this.met99Datos.lstPrimaEG.clear();
        this.met99Datos.lstPrimaCR.clear();
        this.met99Datos.lstPrimaPHX.clear();
        this.met99Datos.lstEpBAC.clear();
        this.met99Datos.lstEpBCAC.clear();
        this.met99Datos.lstEpAP.clear();
        this.met99Datos.lstEpGF.clear();
        this.met99Datos.lstEpEG.clear();
        this.met99Datos.lstEpCR.clear();
        this.met99Datos.lstEpPHX.clear();
        for (i = 0; i < this.met99Datos.lstNombreCompTmp.size(); ++i) {
            this.met99Datos.lstNombreComp.add(this.met99Datos.lstNombreCompTmp.get(i));
            this.met99Datos.lstEdadComp.add(this.met99Datos.lstEdadCompTmp.get(i));
            this.met99Datos.lstSexoComp.add(this.met99Datos.lstSexoCompTmp.get(i));
            this.met99Datos.lstSelBAC.add(false);
            this.met99Datos.lstSelBCAC.add(false);
            this.met99Datos.lstSelAP.add(false);
            this.met99Datos.lstSelGF.add(false);
            this.met99Datos.lstSelEG.add(false);
            this.met99Datos.lstSelCR.add(false);
            this.met99Datos.lstSelPHX.add(false);
            this.met99Datos.lstTarBAC.add(this.met99Datos.lstTarBACtmp.get(i));
            this.met99Datos.lstTarBCAC.add(0.0);
            this.met99Datos.lstOptSumaAP.add(1);
            this.met99Datos.lstTarGF.add(0.0);
            this.met99Datos.lstTarEG.add(0.0);
            this.met99Datos.lstTarCR.add(0.0);
            this.met99Datos.lstTarPHX.add(0.0);
            this.met99Datos.lstSumaBAC.add(0);
            this.met99Datos.lstSumaBCAC.add(0);
            this.met99Datos.lstSumaAP.add(0);
            this.met99Datos.lstSumaGF.add(0);
            this.met99Datos.lstSumaEG.add(0);
            this.met99Datos.lstSumaCR.add(0);
            this.met99Datos.lstSumaPHX.add(0);
            this.met99Datos.lstPrimaBAC.add(0.0);
            this.met99Datos.lstPrimaBCAC.add(0.0);
            this.met99Datos.lstPrimaAP.add(0.0);
            this.met99Datos.lstPrimaGF.add(0.0);
            this.met99Datos.lstPrimaEG.add(0.0);
            this.met99Datos.lstPrimaCR.add(0.0);
            this.met99Datos.lstPrimaPHX.add(0.0);
            this.met99Datos.lstEpBAC.add(0.0);
            this.met99Datos.lstEpBCAC.add(0.0);
            this.met99Datos.lstEpAP.add(0.0);
            this.met99Datos.lstEpGF.add(0.0);
            this.met99Datos.lstEpEG.add(0.0);
            this.met99Datos.lstEpCR.add(0.0);
            this.met99Datos.lstEpPHX.add(0.0);
        }
        this.listaComp.clear();
        for (i = 0; i < this.met99Datos.lstNombreComp.size(); ++i) {
            this.listaComp.add((Object)new Person(this.met99Datos.lstNombreComp.get(i), this.met99Datos.lstEdadComp.get(i).toString(), this.met99Datos.lstSexoComp.get(i)));
        }
        this.met99Datos.numComp = this.listaComp.size();
    }

    private void InicializaCoberturasMaestro20() {
        this.met99Datos.selBAS = true;
        this.met99Datos.selBIT = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.sumaBAS = 350000;
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.sumaGFA = 0;
    }

    private void InicializaCoberturasPT20() {
        this.met99Datos.selBAS = true;
        this.met99Datos.selBIT = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCII = false;
        this.met99Datos.sumaBAS = 350000;
        this.met99Datos.sumaBIT = 0.0;
        this.met99Datos.sumaTIBA = 0;
        this.met99Datos.sumaCII = 0;
        this.met99Datos.selGFC = false;
        this.met99Datos.selGFH = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.numHijos = 1;
        this.met99Datos.sumaGFH = 0;
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelBCAC.clear();
        this.met99Datos.lstSelAP.clear();
        this.met99Datos.lstSelGF.clear();
        this.met99Datos.lstSelBAC.clear();
        this.met99Datos.lstSelEG.clear();
        this.met99Datos.lstTarCR.clear();
        this.met99Datos.lstSelPHX.clear();
        this.met99Datos.lstTarGF.clear();
        this.met99Datos.lstSumaBAC.clear();
        this.met99Datos.lstSumaGF.clear();
        this.met99Datos.lstPrimaBAC.clear();
        this.met99Datos.lstPrimaGF.clear();
        this.met99Datos.lstEpBAC.clear();
        this.met99Datos.lstEpGF.clear();
        if (this.met99Datos.lstNombreCompTmp.size() > 0) {
            this.met99Datos.lstSelBAC.add(false);
            this.met99Datos.lstSelBCAC.add(false);
            this.met99Datos.lstSelAP.add(false);
            this.met99Datos.lstSelGF.add(false);
            this.met99Datos.lstSelEG.add(false);
            this.met99Datos.lstSelCR.add(false);
            this.met99Datos.lstSelPHX.add(false);
            this.met99Datos.lstTarBAC.add(this.met99Datos.lstTarBACtmp.get(0));
            this.met99Datos.lstTarBCAC.add(this.met99Datos.lstTarBCACtmp.get(0));
            this.met99Datos.lstTarGF.add(this.met99Datos.lstTarGFtmp.get(0));
            this.met99Datos.lstTarEG.add(this.met99Datos.lstTarEGtmp.get(0));
            this.met99Datos.lstTarCR.add(this.met99Datos.lstTarCRtmp.get(0));
            this.met99Datos.lstTarPHX.add(this.met99Datos.lstTarPHXtmp.get(0));
            this.met99Datos.lstSumaBAC.add(0);
            this.met99Datos.lstSumaBCAC.add(0);
            this.met99Datos.lstSumaGF.add(0);
            this.met99Datos.lstSumaEG.add(0);
            this.met99Datos.lstSumaCR.add(0);
            this.met99Datos.lstSumaPHX.add(0);
            this.met99Datos.lstPrimaBAC.add(0.0);
            this.met99Datos.lstPrimaGF.add(0.0);
            this.met99Datos.lstEpBAC.add(this.met99Datos.lstEpBACtmp.get(0));
            this.met99Datos.lstEpGF.add(this.met99Datos.lstEpGFtmp.get(0));
        }
    }

    private void InicializaDatosComp() {
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstSexoComp.clear();
        if (this.met99Datos.lstNombreCompTmp.size() > 0) {
            this.met99Datos.lstNombreComp.add(this.met99Datos.lstNombreCompTmp.get(0));
            this.met99Datos.lstEdadComp.add(this.met99Datos.lstEdadCompTmp.get(0));
            this.met99Datos.lstSexoComp.add(this.met99Datos.lstSexoCompTmp.get(0));
        }
        this.met99Datos.numComp = this.met99Datos.lstNombreComp.size();
        this.listaComp.clear();
        for (int i = 0; i < this.met99Datos.lstNombreComp.size(); ++i) {
            this.listaComp.add((Object)new Person(this.met99Datos.lstNombreComp.get(i), this.met99Datos.lstEdadComp.get(i).toString(), this.met99Datos.lstSexoComp.get(i)));
        }
    }

    private void RecuperaDatos() {
        this.txtNombreTitular.setText(this.met99Datos.nombreTitular);
        this.txtNombreConyuge.setText(this.met99Datos.nombreConyuge);
        try {
            if (this.met99Datos.edadRealTitular == 0) {
                this.txtEdadRealTitular.setText("");
            } else {
                this.txtEdadRealTitular.setText(this.met99Datos.edadRealTitular.toString());
            }
            if (this.met99Datos.edadCalculoTitular == 0) {
                this.lblEdadCalculoTitular.setText("");
            } else {
                this.lblEdadCalculoTitular.setText(this.met99Datos.edadCalculoTitular.toString());
            }
            if ("M".equals(this.met99Datos.sexoTitular)) {
                this.optMasculinoTitular.setSelected(true);
                this.optFemeninoTitular.setSelected(false);
            } else {
                this.optMasculinoTitular.setSelected(false);
                this.optFemeninoTitular.setSelected(true);
            }
            if ("M".equals(this.met99Datos.sexoConyuge)) {
                this.optMasculinoConyuge.setSelected(true);
                this.optFemeninoConyuge.setSelected(false);
            } else {
                this.optFemeninoConyuge.setSelected(true);
                this.optMasculinoConyuge.setSelected(false);
            }
            if ("S".equals(this.met99Datos.fumaTitular)) {
                this.optFumaTitular.setSelected(true);
                this.optNoFumaTitular.setSelected(false);
            } else {
                this.optFumaTitular.setSelected(false);
                this.optNoFumaTitular.setSelected(true);
            }
            if (this.met99Datos.edadRealConyuge == 0) {
                this.txtEdadRealConyuge.setText("");
            } else {
                this.txtEdadRealConyuge.setText(this.met99Datos.edadRealConyuge.toString());
            }
        }
        catch (Exception e2) {
            this.txtEdadRealTitular.setText("0");
            this.lblEdadCalculoTitular.setText("0");
            this.optMasculinoTitular.setSelected(true);
            this.optFumaTitular.setSelected(true);
            this.txtEdadRealConyuge.setText("0");
            this.optMasculinoConyuge.setSelected(true);
        }
        this.listaComp.clear();
        for (int i = 0; i < this.met99Datos.lstNombreComp.size(); ++i) {
            this.listaComp.add((Object)new Person(this.met99Datos.lstNombreComp.get(i), this.met99Datos.lstEdadComp.get(i).toString(), this.met99Datos.lstSexoComp.get(i)));
        }
        this.ocupacionSel = this.met99Datos.ocupacionSel;
        this.cmbOcupaciones.getItems().clear();
        this.cmbOcupaciones.getItems().addAll(this.met99Datos.lstOcupaciones);
        this.cmbOcupaciones.setValue((Object)this.ocupacionSel);
    }

    private void BorraDatosConyuge() {
        this.met99Datos.nombreConyuge = "";
        this.met99Datos.nombreConyugeTmp = "";
        this.met99Datos.edadRealConyuge = 0;
        this.met99Datos.edadRealConyugeTmp = 0;
    }

    private void BorraDatosComp() {
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstNombreCompTmp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstEdadCompTmp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.met99Datos.lstSexoCompTmp.clear();
        this.listaComp.clear();
        this.met99Datos.numComp = 0;
    }

    public void MuestraCoberturas() {
        this.RevisaDatos();
        if (!this.hayError.booleanValue()) {
            this.GuardaDatos();
            this.stage = (Stage)this.lblVersion.getScene().getWindow();
            this.MuestraVentana("Met99Cob.fxml");
            this.hayError = false;
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje, "Provida");
            this.hayError = false;
        }
    }

    private void RevisaDatos() {
        this.hayError = false;
        this.txtMensaje = "";
        this.ValidaNombreTitular();
        this.ValidaNombreConyuge();
        this.ValidaEdadRealTitular();
        this.ValidaEdadRealConyuge();
        this.txtEdadRealTitular.requestFocus();
        this.ValidaOtrosDatos();
    }

    public void MuestraTarifario() {
        this.hayError = false;
        if (!this.txtNombreTitular.getText().equals("") || !this.txtEdadRealTitular.getText().equals("")) {
            this.RevisaDatos();
        }
        if (!this.hayError.booleanValue()) {
            this.GuardaDatosTmp();
            this.hayError = false;
            this.cmbOcupaciones.setValue((Object)"No especificada");
            this.stage = (Stage)this.lblVersion.getScene().getWindow();
            this.MuestraVentana("Met99Tarifario.fxml");
        } else {
            this.genSubs.MuestraMensaje(this.txtMensaje, "Provida");
            this.hayError = false;
        }
    }

    public void DeterminEdadCalculo() {
        if (this.optMasculinoTitular.isSelected()) {
            this.met99Datos.sexoTitular = "M";
            this.optMasculinoConyuge.setSelected(false);
            this.optFemeninoConyuge.setSelected(true);
        } else {
            this.met99Datos.sexoTitular = "F";
            this.optMasculinoConyuge.setSelected(true);
        }
        this.met99Datos.fumaTitular = this.optFumaTitular.isSelected() ? "S" : "N";
        this.met99Reglas.DeterminaEdadCalculoTitular();
        this.lblEdadCalculoTitular.setText(this.met99Datos.edadCalculoTitular.toString());
    }

    public void AgregaComp() {
        this.hayErrorComp = false;
        if (this.met99Datos.productoSeleccionado.equals("PT20") && this.listaComp.size() > 0) {
            this.genSubs.MuestraMensaje("En PT20 s\u00f3lo se permite un complementario", "");
            this.hayErrorComp = true;
        } else {
            String sexoTitular = this.optMasculinoTitular.isSelected() ? "M" : "F";
            String sexoComp = this.optMasculinoComp.isSelected() ? "M" : "F";
            String sexoConyuge = this.optMasculinoConyuge.isSelected() ? "M" : "F";
            if ("".equals(this.txtNombreComp.getText()) || "".equals(this.txtEdadComp.getText())) {
                this.genSubs.MuestraMensaje("El nombre y edad del asegurado no deben estar en blanco", "");
            } else {
                String txtTmp = this.genSubs.TextoTipoTitulo(this.txtNombreComp.getText());
                this.txtNombreComp.setText(txtTmp);
                String idComp = this.txtNombreComp.getText() + this.txtEdadComp.getText() + sexoComp;
                String idTitular = this.txtNombreTitular.getText() + this.txtEdadRealTitular.getText() + sexoTitular;
                String idConyuge = this.txtNombreConyuge.getText() + this.txtEdadRealConyuge.getText() + sexoConyuge;
                if (idComp.equals(idTitular)) {
                    this.hayErrorComp = true;
                    this.genSubs.MuestraMensaje("El complementario no debe ser el mismo que el titular", "");
                } else if (idConyuge.equals(idComp) && this.met99Datos.productoSeleccionado.equals("PT20")) {
                    this.hayErrorComp = true;
                    this.genSubs.MuestraMensaje("El complementario no debe ser el mismo que el c\u00f3nyuge", "");
                } else {
                    sexoComp = this.optMasculinoComp.isSelected() ? "M" : "F";
                    this.ValidaEdadComp();
                    if (this.listaComp.size() > 0) {
                        this.ValidaDuplicadoComp();
                    }
                    if (!this.hayErrorComp.booleanValue()) {
                        this.listaComp.add((Object)new Person(this.txtNombreComp.getText(), this.txtEdadComp.getText(), sexoComp));
                        this.huboCambioComp = true;
                        this.txtNombreComp.clear();
                        this.txtEdadComp.clear();
                        this.genSubs.EnfocaObjeto(this.txtNombreComp);
                    } else {
                        this.genSubs.MuestraMensaje(this.txtMensaje, "Provida");
                    }
                }
            }
        }
    }

    public void EliminaComp() {
        Person person = (Person)this.tblComp.getSelectionModel().getSelectedItem();
        this.huboCambioComp = true;
        this.BorraCoberturasComp();
        this.listaComp.remove((Object)person);
        this.met99Datos.numComp = this.listaComp.size();
    }

    public void ModificaComp() {
        Person person = (Person)this.tblComp.getSelectionModel().getSelectedItem();
        this.txtNombreComp.setText(person.getNombre());
        this.txtEdadComp.setText(person.getEdad());
        if (person.getSexo().equals("M")) {
            this.optMasculinoComp.setSelected(true);
        } else {
            this.optFemeninoComp.setSelected(true);
        }
        this.BorraCoberturasComp();
        this.listaComp.remove((Object)person);
        this.huboCambioComp = true;
        this.met99Datos.numComp = this.listaComp.size();
    }

    private void ValidaCaptura() {
    }

    private void ValidaEdadRealTitular() {
        if (this.txtEdadRealTitular.getText().equals("")) {
            this.txtEdadRealTitular.setText("0");
        }
        if (this.genSubs.EsNumeroEntero(this.txtEdadRealTitular.getText()).booleanValue()) {
            this.met99Datos.edadRealTitular = Integer.parseInt(this.txtEdadRealTitular.getText());
            this.met99Reglas.EdadCalculoTitular();
            if (this.met99Datos.edadCalculoTitular == 0) {
                this.hayError = true;
                this.txtMensaje = this.txtMensaje + "La edad del titular debe estar entre " + this.met99Datos.edadMin.get(this.met99Datos.indexBas).toString() + " y " + this.met99Datos.edadMax.get(this.met99Datos.indexBas).toString() + "\r";
            } else {
                this.lblEdadCalculoTitular.setText(this.met99Datos.edadCalculoTitular.toString());
            }
        } else {
            this.txtMensaje = this.txtMensaje + "Valor inv\u00e1lido de edad titular \r";
            this.hayError = true;
        }
    }

    private void ValidaNombreTitular() {
        if (this.txtNombreTitular.getText().equals(null) || this.txtNombreTitular.getText().isEmpty() || this.txtNombreTitular.getText().trim().isEmpty()) {
            this.txtMensaje = this.txtMensaje + "Falta nombre del titular\r";
            this.hayError = true;
        } else {
            String txtTmp = this.genSubs.TextoTipoTitulo(this.txtNombreTitular.getText());
            this.txtNombreTitular.setText(txtTmp);
        }
    }

    private void ValidaNombreConyuge() {
        if (this.txtNombreConyuge.getText().equals("")) {
            if (!this.txtEdadRealConyuge.getText().equals("")) {
                this.hayError = true;
                this.txtMensaje = this.txtMensaje + "Falta nombre del c\u00f3nyuge\r";
            }
        } else {
            String txtTmp = this.genSubs.TextoTipoTitulo(this.txtNombreConyuge.getText());
            this.txtNombreConyuge.setText(txtTmp);
        }
    }

    private void ValidaEdadRealConyuge() {
        if (!"".equals(this.txtNombreConyuge.getText())) {
            if (this.txtEdadRealConyuge.getText().equals("")) {
                this.txtEdadRealConyuge.setText("0");
            }
            if (this.genSubs.EsNumeroEntero(this.txtEdadRealConyuge.getText()).booleanValue()) {
                this.met99Datos.edadRealConyuge = Integer.parseInt(this.txtEdadRealConyuge.getText());
                if (this.met99Datos.productoSeleccionado.equals("PT20")) {
                    if (this.met99Datos.edadRealConyuge < 18 || this.met99Datos.edadRealConyuge > 69) {
                        this.txtMensaje = this.txtMensaje + "La edad del c\u00f3nyuge debe estrar entre 18 y 69\r";
                        this.hayError = true;
                    }
                } else if (this.met99Datos.edadRealConyuge < 15 || this.met99Datos.edadRealConyuge > 80) {
                    this.txtMensaje = this.txtMensaje + "La edad del c\u00f3nyuge debe estrar entre 15 y 80\r";
                    this.hayError = true;
                }
            } else {
                this.txtMensaje = this.txtMensaje + "Valor inv\u00e1lido,edad c\u00f3yuge\r";
                this.hayError = true;
            }
        } else if (this.txtEdadRealConyuge.getText().equals("")) {
            this.met99Datos.edadRealConyuge = 0;
        }
    }

    private void ValidaEdadComp() {
        this.txtMensaje = "";
        if (this.genSubs.EsNumeroEntero(this.txtEdadComp.getText()).booleanValue() && !"".equals(this.txtEdadComp.getText())) {
            this.intValue = Integer.parseInt(this.txtEdadComp.getText());
            if (this.met99Datos.productoSeleccionado.equals("Met99")) {
                if (this.intValue < 0 || this.intValue > 80) {
                    this.hayErrorComp = true;
                    this.txtMensaje = this.txtMensaje + "La edad del complementario debe estar entre 0 y 80\r";
                }
            } else if (this.met99Datos.productoSeleccionado.equals("PT20")) {
                if (this.intValue < 18 || this.intValue > 70) {
                    this.hayErrorComp = true;
                    this.txtMensaje = this.txtMensaje + "La edad del complementario debe estar entre 18 y 70\r";
                }
            } else if (this.intValue < 15 || this.intValue > 70) {
                this.hayErrorComp = true;
                this.txtMensaje = this.txtMensaje + "La edad del complementario debe estar entre 15 y 70\r";
            }
        } else {
            this.txtMensaje = this.txtMensaje + "Valor inv\u00e1lido, edad de complementario\r";
            this.hayErrorComp = true;
        }
    }

    private void ValidaDuplicadoComp() {
        String txtSexoComp = this.optMasculinoComp.isSelected() ? "M" : "F";
        String compCapturado = this.txtNombreComp.getText() + this.txtEdadComp.getText() + txtSexoComp;
        for (int i = 0; i < this.listaComp.size(); ++i) {
            String compExistente = ((Person)this.listaComp.get(i)).getNombre() + ((Person)this.listaComp.get(i)).getEdad() + ((Person)this.listaComp.get(i)).getSexo();
            if (!compCapturado.equals(compExistente)) continue;
            this.hayErrorComp = true;
            this.txtMensaje = this.txtMensaje + "Este complementario ya fue registrado.\r";
        }
    }

    private void DeterminaEP() {
        if (this.cmbOcupaciones.getItems().size() > 0) {
            this.met99Datos.indexOcupacionSel = this.indexOcupacion = Integer.valueOf(this.cmbOcupaciones.getSelectionModel().getSelectedIndex());
            if (this.indexOcupacion == -1) {
                this.indexOcupacion = 0;
            }
            this.met99Datos.ocupacionSel = this.ocupacionSel = this.met99Datos.lstOcupaciones.get(this.indexOcupacion);
            this.txtDecision = this.met99Datos.lstDecisiones.get(this.indexOcupacion);
            this.met99Datos.epVida = this.met99Datos.lstEPvida.get(this.indexOcupacion);
            this.met99Datos.epInvalidez = this.met99Datos.lstEPinvalidez.get(this.indexOcupacion);
            this.met99Datos.epAccidentes = this.met99Datos.lstEPaccidentes.get(this.indexOcupacion);
            this.met99Datos.APactivado = this.met99Datos.lstAPactivado.get(this.indexOcupacion);
            if (this.met99Datos.lstSumaLimitada.get(this.indexOcupacion) == 0) {
                this.met99Datos.sumaLimitada = false;
            } else {
                this.met99Datos.sumaLimitada = true;
                this.met99Datos.impSumaLimitada = this.met99Datos.lstSumaLimitada.get(this.indexOcupacion);
            }
            this.txtEPvida = "Vida: ";
            this.txtEPaccidentes = "Accidentes: ";
            this.txtEPinvalidez = "Invalidez: ";
            this.met99Datos.txtSuscripcion = "";
            this.met99Datos.rechazoAccidentes = false;
            this.met99Datos.rechazoInvalidez = false;
            if (this.indexOcupacion >= 0) {
                if ("RECHAZO".equals(this.txtDecision)) {
                    this.met99Datos.txtSuscripcion = "RECHAZO";
                    this.imgCoberturas2.setDisable(true);
                    this.lblDecisionSus.setStyle("-fx-background-color: red;");
                } else {
                    this.imgCoberturas2.setDisable(false);
                    this.lblDecisionSus.setStyle("-fx-background-color: rgb(235,235,235);");
                    if (this.met99Datos.epVida == 0.0 && this.met99Datos.epInvalidez == 1.0 && this.met99Datos.epAccidentes == 1.0) {
                        this.met99Datos.txtSuscripcion = "No se aplican extraprimas ocupacionales";
                    } else {
                        this.txtEPvida = this.txtEPvida + this.met99Datos.epVida.toString() + " al millar";
                        if (this.met99Datos.epAccidentes == 9.9) {
                            this.txtEPaccidentes = this.txtEPaccidentes + "RECHAZO";
                            this.met99Datos.rechazoAccidentes = true;
                        } else {
                            this.txtEPaccidentes = this.txtEPaccidentes + this.met99Datos.epAccidentes.toString() + " tantos";
                            this.met99Datos.rechazoAccidentes = false;
                        }
                        if (this.met99Datos.epInvalidez == 9.9) {
                            this.txtEPinvalidez = this.txtEPinvalidez + "RECHAZO";
                            this.met99Datos.rechazoInvalidez = true;
                        } else {
                            this.txtEPinvalidez = this.txtEPinvalidez + this.met99Datos.epInvalidez.toString() + " tantos.";
                            this.met99Datos.rechazoInvalidez = false;
                        }
                        this.met99Datos.txtSuscripcion = this.txtEPvida + " " + this.txtEPaccidentes + " " + this.txtEPinvalidez;
                    }
                }
            } else {
                this.imgCoberturas2.setDisable(false);
                this.lblDecisionSus.setStyle("-fx-background-color: rgb(235,235,235);");
            }
            this.met99Datos.txtSuscripcion = this.txtDecision;
            if (this.met99Datos.epAccidentes == 0.0) {
                this.met99Datos.epAccidentes = 1.0;
            }
            if (this.met99Datos.epInvalidez == 0.0) {
                this.met99Datos.epInvalidez = 1.0;
            }
            this.lblDecisionSus.setText(this.met99Datos.txtSuscripcion);
            this.met99Datos.hayEP = "".equals(this.met99Datos.txtSuscripcion) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
    }

    public void RegresaInicio() {
        this.GuardaDatosCambioProducto();
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Provida.fxml");
    }

    private void GuardaDatosTmp() {
        this.GuardaDatosTitularTmp();
        this.GuardaDatosConyugeTmp();
        this.GuardaDatosCompTmp();
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.genSubs.GuardaCoberturasMet99();
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.genSubs.GuardaCoberturasMaestro20();
        } else {
            this.genSubs.GuardaCoberturasPT20();
        }
    }

    private void GuardaDatosCambioProducto() {
        this.GuardaDatosTitularTmp();
        if (this.met99Datos.productoSeleccionado.equals("Met99")) {
            this.GuardaDatosConyugeTmp();
            this.GuardaDatosCompTmp();
            this.genSubs.GuardaCoberturasMet99();
        } else if (this.met99Datos.productoSeleccionado.equals("Maestro20")) {
            this.genSubs.GuardaCoberturasMaestro20();
        } else {
            this.GuardaDatosConyugeTmp();
            this.GuardaDatosCompTmp();
            this.genSubs.GuardaCoberturasPT20();
        }
    }

    private void GuardaDatosTitularTmp() {
        this.met99Datos.nombreTitularTmp = this.txtNombreTitular.getText();
        this.met99Datos.edadRealTitularTmp = this.met99Datos.edadRealTitular;
        this.met99Datos.edadCalculoTitularTmp = this.met99Datos.edadCalculoTitular;
        this.met99Datos.epVidaTmp = this.met99Datos.epVida;
        this.met99Datos.epAccidentesTmp = this.met99Datos.epAccidentes;
        this.met99Datos.epInvalidezTmp = this.met99Datos.epInvalidez;
        this.met99Datos.sexoTitularTmp = this.optMasculinoTitular.isSelected() ? "M" : "F";
        this.met99Datos.fumaTitularTmp = this.optFumaTitular.isSelected() ? "S" : "N";
        this.indexOcupacion = this.cmbOcupaciones.getSelectionModel().getSelectedIndex();
        if (this.indexOcupacion == -1) {
            this.indexOcupacion = 0;
        }
        this.met99Datos.ocupacionSelTmp = this.met99Datos.lstOcupaciones.get(this.indexOcupacion);
    }

    private void GuardaDatosConyugeTmp() {
        this.met99Datos.nombreConyugeTmp = this.txtNombreConyuge.getText();
        this.met99Datos.edadRealConyugeTmp = this.met99Datos.edadRealConyuge;
        this.met99Datos.sexoConyugeTmp = this.optMasculinoConyuge.isSelected() ? "M" : "F";
    }

    private void GuardaDatosCompTmp() {
        this.met99Datos.lstNombreCompTmp.clear();
        this.met99Datos.lstEdadCompTmp.clear();
        this.met99Datos.lstSexoCompTmp.clear();
        for (int i = 0; i < this.listaComp.size(); ++i) {
            this.met99Datos.lstNombreCompTmp.add(((Person)this.listaComp.get(i)).getNombre());
            this.met99Datos.lstEdadCompTmp.add(Integer.parseInt(((Person)this.listaComp.get(i)).getEdad()));
            this.met99Datos.lstSexoCompTmp.add(((Person)this.listaComp.get(i)).getSexo());
        }
    }

    private void GuardaCoberturasMet99Ant() {
        this.met99Datos.selBAStmp = this.met99Datos.selBAS;
        this.met99Datos.selBITtmp = this.met99Datos.selBIT;
        this.met99Datos.selCIItmp = this.met99Datos.selCII;
        this.met99Datos.selCMAtmp = this.met99Datos.selCMA;
        this.met99Datos.selTIBAtmp = this.met99Datos.selTIBA;
        this.met99Datos.selCATtmp = this.met99Datos.selCAT;
        this.met99Datos.selGFAtmp = this.met99Datos.selGFA;
        this.met99Datos.selGEtmp = this.met99Datos.selGE;
        this.met99Datos.selAPtmp = this.met99Datos.selAP;
        this.met99Datos.selEGtmp = this.met99Datos.selEG;
        this.met99Datos.selCRtmp = this.met99Datos.selCR;
        this.met99Datos.sumaBAStmp = this.met99Datos.sumaBAS;
        this.met99Datos.sumaBITtmp = this.met99Datos.sumaBIT;
        this.met99Datos.sumaCIItmp = this.met99Datos.sumaCII;
        this.met99Datos.sumaCMAtmp = this.met99Datos.sumaCMA;
        this.met99Datos.sumaTIBAtmp = this.met99Datos.sumaTIBA;
        this.met99Datos.sumaCATtmp = this.met99Datos.sumaCAT;
        this.met99Datos.sumaGFAtmp = this.met99Datos.sumaGFA;
        this.met99Datos.sumaGEtmp = this.met99Datos.sumaGE;
        this.met99Datos.sumaAPtmp = this.met99Datos.sumaAP;
        this.met99Datos.sumaEGtmp = this.met99Datos.sumaEG;
        this.met99Datos.sumaCRtmp = this.met99Datos.sumaCR;
        this.met99Datos.optSumaAPtmp = this.met99Datos.optSumaAP;
        this.met99Datos.selBACYtmp = this.met99Datos.selBACY;
        this.met99Datos.selGFCtmp = this.met99Datos.selGFC;
        this.met99Datos.selBCACtmp = this.met99Datos.selBCAC;
        this.met99Datos.selGFHtmp = this.met99Datos.selGFH;
        this.met99Datos.numHijosTmp = this.met99Datos.numHijos;
        this.met99Datos.sumaBACYtmp = this.met99Datos.sumaBACY;
        this.met99Datos.sumaGFCtmp = this.met99Datos.sumaGFC;
        this.met99Datos.sumaBCACtmp = this.met99Datos.sumaBCAC;
        this.met99Datos.sumaGFHtmp = this.met99Datos.sumaGFH;
        this.met99Datos.lstSelBACtmp.clear();
        this.met99Datos.lstSelBCACtmp.clear();
        this.met99Datos.lstSelAPtmp.clear();
        this.met99Datos.lstSelGFtmp.clear();
        this.met99Datos.lstSelEGtmp.clear();
        this.met99Datos.lstSelCRtmp.clear();
        this.met99Datos.lstSelPHXtmp.clear();
        this.met99Datos.lstTarBACtmp.clear();
        this.met99Datos.lstTarBCACtmp.clear();
        this.met99Datos.lstOptSumaAPtmp.clear();
        this.met99Datos.lstTarGFtmp.clear();
        this.met99Datos.lstTarEGtmp.clear();
        this.met99Datos.lstTarCRtmp.clear();
        this.met99Datos.lstTarPHXtmp.clear();
        this.met99Datos.lstSumaBACtmp.clear();
        this.met99Datos.lstSumaBCACtmp.clear();
        this.met99Datos.lstSumaAPtmp.clear();
        this.met99Datos.lstSumaGFtmp.clear();
        this.met99Datos.lstSumaEGtmp.clear();
        this.met99Datos.lstSumaCRtmp.clear();
        this.met99Datos.lstSumaPHXtmp.clear();
        this.met99Datos.lstPrimaBACtmp.clear();
        this.met99Datos.lstPrimaBCACtmp.clear();
        this.met99Datos.lstPrimaAPtmp.clear();
        this.met99Datos.lstPrimaGFtmp.clear();
        this.met99Datos.lstPrimaEGtmp.clear();
        this.met99Datos.lstPrimaCRtmp.clear();
        this.met99Datos.lstPrimaPHXtmp.clear();
        this.met99Datos.lstEpBACtmp.clear();
        this.met99Datos.lstEpBCACtmp.clear();
        this.met99Datos.lstEpAPtmp.clear();
        this.met99Datos.lstEpGFtmp.clear();
        this.met99Datos.lstEpEGtmp.clear();
        this.met99Datos.lstEpCRtmp.clear();
        this.met99Datos.lstEpPHXtmp.clear();
        for (int i = 0; i < this.met99Datos.lstNombreComp.size(); ++i) {
            if (this.met99Datos.lstSelBAC.size() <= 0) continue;
            this.met99Datos.lstSelBACtmp.add(this.met99Datos.lstSelBAC.get(i));
            this.met99Datos.lstSelBCACtmp.add(this.met99Datos.lstSelBCAC.get(i));
            this.met99Datos.lstSelAPtmp.add(this.met99Datos.lstSelAP.get(i));
            this.met99Datos.lstSelGFtmp.add(this.met99Datos.lstSelGF.get(i));
            this.met99Datos.lstSelEGtmp.add(this.met99Datos.lstSelEG.get(i));
            this.met99Datos.lstSelCRtmp.add(this.met99Datos.lstSelCR.get(i));
            this.met99Datos.lstSelPHXtmp.add(this.met99Datos.lstSelPHX.get(i));
            this.met99Datos.lstTarBACtmp.add(this.met99Datos.lstTarBAC.get(i));
            this.met99Datos.lstTarBCACtmp.add(this.met99Datos.lstTarBCAC.get(i));
            this.met99Datos.lstOptSumaAPtmp.add(this.met99Datos.lstOptSumaAP.get(i));
            this.met99Datos.lstTarGFtmp.add(this.met99Datos.lstTarGF.get(i));
            this.met99Datos.lstTarEGtmp.add(this.met99Datos.lstTarEG.get(i));
            this.met99Datos.lstTarCRtmp.add(this.met99Datos.lstTarCR.get(i));
            this.met99Datos.lstTarPHXtmp.add(this.met99Datos.lstTarPHX.get(i));
            this.met99Datos.lstTarPHXtmp.add(this.met99Datos.lstTarPHX.get(i));
            this.met99Datos.lstSumaBACtmp.add(this.met99Datos.lstSumaBAC.get(i));
            this.met99Datos.lstSumaBCACtmp.add(this.met99Datos.lstSumaBCAC.get(i));
            this.met99Datos.lstSumaAPtmp.add(this.met99Datos.lstSumaAP.get(i));
            this.met99Datos.lstSumaGFtmp.add(this.met99Datos.lstSumaGF.get(i));
            this.met99Datos.lstSumaEGtmp.add(this.met99Datos.lstSumaEG.get(i));
            this.met99Datos.lstSumaCRtmp.add(this.met99Datos.lstSumaCR.get(i));
            this.met99Datos.lstSumaPHXtmp.add(this.met99Datos.lstSumaPHX.get(i));
            this.met99Datos.lstPrimaBACtmp.add(this.met99Datos.lstPrimaBAC.get(i));
            this.met99Datos.lstPrimaBCACtmp.add(this.met99Datos.lstPrimaBCAC.get(i));
            this.met99Datos.lstPrimaAPtmp.add(this.met99Datos.lstPrimaAP.get(i));
            this.met99Datos.lstPrimaGFtmp.add(this.met99Datos.lstPrimaGF.get(i));
            this.met99Datos.lstPrimaEGtmp.add(this.met99Datos.lstPrimaEG.get(i));
            this.met99Datos.lstPrimaCRtmp.add(this.met99Datos.lstPrimaCR.get(i));
            this.met99Datos.lstPrimaPHXtmp.add(this.met99Datos.lstPrimaPHX.get(i));
            this.met99Datos.lstEpBACtmp.add(this.met99Datos.lstEpBAC.get(i));
            this.met99Datos.lstEpBCACtmp.add(this.met99Datos.lstEpBCAC.get(i));
            this.met99Datos.lstEpAPtmp.add(this.met99Datos.lstEpAP.get(i));
            this.met99Datos.lstEpGFtmp.add(this.met99Datos.lstEpGF.get(i));
            this.met99Datos.lstEpEGtmp.add(this.met99Datos.lstEpEG.get(i));
            this.met99Datos.lstEpCRtmp.add(this.met99Datos.lstEpCR.get(i));
            this.met99Datos.lstEpPHXtmp.add(this.met99Datos.lstEpPHX.get(i));
        }
    }

    private void GuardaCoberturasMaestro20Ant() {
        this.met99Datos.selBAStmp = this.met99Datos.selBAS;
        this.met99Datos.selBITtmp = this.met99Datos.selBIT;
        this.met99Datos.selTIBAtmp = this.met99Datos.selTIBA;
        this.met99Datos.selGFAtmp = this.met99Datos.selGFA;
        this.met99Datos.sumaBAStmp = this.met99Datos.sumaBAS;
        this.met99Datos.sumaBITtmp = this.met99Datos.sumaBIT;
        this.met99Datos.sumaTIBAtmp = this.met99Datos.sumaTIBA;
        this.met99Datos.sumaGFAtmp = this.met99Datos.sumaGFA;
    }

    private void GuardaCoberturasPT20Ant() {
        this.met99Datos.selBAStmp = this.met99Datos.selBAS;
        this.met99Datos.selBITtmp = this.met99Datos.selBIT;
        this.met99Datos.selTIBAtmp = this.met99Datos.selTIBA;
        this.met99Datos.selCIItmp = this.met99Datos.selCII;
        this.met99Datos.sumaBAStmp = this.met99Datos.sumaBAS;
        this.met99Datos.sumaBITtmp = this.met99Datos.sumaBIT;
        this.met99Datos.sumaTIBAtmp = this.met99Datos.sumaTIBA;
        this.met99Datos.sumaCIItmp = this.met99Datos.sumaCII;
        this.met99Datos.selGFCtmp = this.met99Datos.selGFC;
        this.met99Datos.sumaGFCtmp = this.met99Datos.sumaGFC;
        this.met99Datos.selGFHtmp = this.met99Datos.selGFH;
        this.met99Datos.numHijosTmp = this.met99Datos.numHijos;
        this.met99Datos.sumaGFHtmp = this.met99Datos.sumaGFH;
        this.met99Datos.lstSelBACtmp.clear();
        this.met99Datos.lstSelBCACtmp.clear();
        this.met99Datos.lstSelAPtmp.clear();
        this.met99Datos.lstSelGFtmp.clear();
        this.met99Datos.lstSelEGtmp.clear();
        this.met99Datos.lstSelCRtmp.clear();
        this.met99Datos.lstSelPHXtmp.clear();
        this.met99Datos.lstEpBACtmp.clear();
        this.met99Datos.lstEpGFtmp.clear();
        for (int i = 0; i < this.met99Datos.lstNombreComp.size(); ++i) {
            if (this.met99Datos.lstSelBAC.size() <= 0) continue;
            this.met99Datos.lstSelBCACtmp.add(false);
            this.met99Datos.lstSelAPtmp.add(false);
            this.met99Datos.lstSelEGtmp.add(false);
            this.met99Datos.lstSelCRtmp.add(false);
            this.met99Datos.lstSelGFtmp.add(false);
            this.met99Datos.lstSelPHXtmp.add(false);
            this.met99Datos.lstTarBCACtmp.add(0.0);
            this.met99Datos.lstTarEGtmp.add(0.0);
            this.met99Datos.lstTarCRtmp.add(0.0);
            this.met99Datos.lstTarGFtmp.add(0.0);
            this.met99Datos.lstTarPHXtmp.add(0.0);
            this.met99Datos.lstSumaBCACtmp.add(0);
            this.met99Datos.lstSumaAPtmp.add(0);
            this.met99Datos.lstSumaEGtmp.add(0);
            this.met99Datos.lstSumaCRtmp.add(0);
            this.met99Datos.lstSumaGFtmp.add(0);
            this.met99Datos.lstSumaPHXtmp.add(0);
            this.met99Datos.lstEpBCACtmp.add(0.0);
            this.met99Datos.lstEpAPtmp.add(0.0);
            this.met99Datos.lstEpEGtmp.add(0.0);
            this.met99Datos.lstEpCRtmp.add(0.0);
            this.met99Datos.lstEpGFtmp.add(0.0);
            this.met99Datos.lstEpPHXtmp.add(0.0);
            this.met99Datos.lstSelBACtmp.add(this.met99Datos.lstSelBAC.get(i));
            this.met99Datos.lstTarBACtmp.add(this.met99Datos.lstTarBAC.get(i));
            this.met99Datos.lstSumaBACtmp.add(this.met99Datos.lstSumaBAC.get(i));
            this.met99Datos.lstPrimaBACtmp.add(this.met99Datos.lstPrimaBAC.get(i));
            this.met99Datos.lstEpBACtmp.add(this.met99Datos.lstEpBAC.get(i));
        }
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void BorrarDatos() {
        this.txtNombreTitular.setText("");
        this.met99Datos.nombreTitular = "";
        this.txtEdadRealTitular.setText("");
        this.met99Datos.edadRealTitular = 0;
        this.met99Datos.edadCalculoTitular = 0;
        this.lblEdadCalculoTitular.setText("");
        this.cmbOcupaciones.setValue((Object)"Seleccione una ocupaci\u00f3n");
        this.met99Datos.ocupacionSel = "Seleccione una ocupaci\u00f3n";
        this.met99Datos.sexoTitular = "M";
        this.optMasculinoTitular.setSelected(true);
        this.met99Datos.fumaTitular = "N";
        this.optFumaTitular.setSelected(false);
        this.txtNombreConyuge.setText("");
        this.met99Datos.nombreConyuge = "";
        this.txtEdadRealConyuge.setText("");
        this.met99Datos.edadRealConyuge = 0;
        this.optFemeninoConyuge.setSelected(true);
        this.listaComp.removeAll(this.listaComp);
        for (int i = 0; i < this.met99Datos.numComp; ++i) {
            this.met99Datos.lstSelBAC.set(i, false);
            this.met99Datos.lstSelBCAC.set(i, false);
            this.met99Datos.lstSelAP.set(i, false);
            this.met99Datos.lstSelGF.set(i, false);
            this.met99Datos.lstSelEG.set(i, false);
            this.met99Datos.lstSelCR.set(i, false);
            this.met99Datos.lstSelPHX.set(i, false);
        }
        this.met99Datos.numComp = 0;
        this.met99Datos.lstNombreComp.clear();
        this.met99Datos.lstEdadComp.clear();
        this.met99Datos.lstSexoComp.clear();
        this.met99Datos.sumaBAS = 350000;
        this.met99Datos.selBAS = true;
        this.met99Datos.selBIT = false;
        this.met99Datos.selCII = false;
        this.met99Datos.selCMA = false;
        this.met99Datos.selTIBA = false;
        this.met99Datos.selCAT = false;
        this.met99Datos.selGFA = false;
        this.met99Datos.selGE = false;
        this.met99Datos.selAP = false;
        this.met99Datos.selEG = false;
        this.met99Datos.selCR = false;
        this.met99Datos.selPHT = false;
        this.met99Datos.selBACY = false;
        this.met99Datos.selGFC = false;
        this.met99Datos.selGFH = false;
        this.met99Datos.optNueva = true;
        this.met99Datos.ftpSel = 1;
        this.met99Datos.optSuma = true;
        this.met99Datos.formaPago = "Anual";
        this.met99Datos.primaExcedente = 0.0;
    }

    private EventHandler<KeyEvent> ValidaLetrasAnt(final Integer max_Lengh) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e2) {
                TextField txt_TextField = (TextField)e2.getSource();
                if (txt_TextField.getText().length() >= max_Lengh) {
                    e2.consume();
                }
                if (!e2.getCharacter().matches("[\u00e1\u00e9\u00ed\u00f3\u00fa\u00f1\u00d1a-zA-Z ]")) {
                    e2.consume();
                }
            }
        };
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Provida");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        }
    }

    public static class Person {
        private SimpleStringProperty nombreComp = new SimpleStringProperty();
        private SimpleStringProperty sexoComp = new SimpleStringProperty();
        private SimpleStringProperty edadComp = new SimpleStringProperty();

        public SimpleStringProperty nombreCompProperty() {
            return this.nombreComp;
        }

        public void setNombre(String value) {
            this.nombreComp.set(value);
        }

        public String getNombre() {
            return this.nombreComp.get();
        }

        public SimpleStringProperty sexoCompProperty() {
            return this.sexoComp;
        }

        public void setSexo(String value) {
            this.sexoComp.set(value);
        }

        public String getSexo() {
            return this.sexoComp.get();
        }

        public SimpleStringProperty edadCompProperty() {
            return this.edadComp;
        }

        public void setEdad(String value) {
            this.edadComp.set(value);
        }

        public String getEdad() {
            return this.edadComp.get();
        }

        private Person(String nombre, String edad, String sexo) {
            this.nombreComp = new SimpleStringProperty(nombre);
            this.sexoComp = new SimpleStringProperty(sexo);
            this.edadComp = new SimpleStringProperty(edad);
        }
    }
}

