/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import provida.GenSubs;
import provida.Met99Datos;
import provida.Tablas;

public class Personaliza
implements Initializable {
    Stage stage;
    Parent root;
    Image imagenLogo;
    Integer indexLogo;
    String ubicacionImagen;
    Boolean datosValidos;
    @FXML
    Label lblVersion;
    @FXML
    ImageView imgInicio;
    @FXML
    ComboBox cmbLogos;
    @FXML
    ImageView imgLogo;
    @FXML
    TextField txtNombrePromotor;
    @FXML
    TextField txtDireccion1;
    @FXML
    TextField txtDireccion2;
    @FXML
    TextField txtTelefonoPromotor;
    @FXML
    TextField txtCorreoPromotor;
    @FXML
    TextField txtNombreAgente;
    @FXML
    TextField txtTelefonoAgente;
    @FXML
    TextField txtCelularAgente;
    @FXML
    TextField txtCorreoAgente;
    @FXML
    Label lblAviso;
    private Tablas tablas = Tablas.getInstance();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();

    public void initialize(URL location, ResourceBundle resources) {
        this.cmbLogos.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Personaliza.this.MuestraLogo();
            }
        });
        this.InicializaVentana();
    }

    private void MuestraLogo() {
        Float tempFloat;
        this.indexLogo = this.cmbLogos.getSelectionModel().getSelectedIndex();
        this.met99Datos.nombreLogo = this.cmbLogos.getSelectionModel().getSelectedItem().toString();
        this.met99Datos.anchoLogo = tempFloat = this.met99Datos.lstAnchoNuevoLogo.get(this.indexLogo);
        this.met99Datos.altoLogo = this.met99Datos.lstAltoNuevoLogo.get(this.indexLogo);
        this.ubicacionImagen = "Logos/" + this.met99Datos.nombreLogo + ".jpg";
        try {
            this.imagenLogo = new Image(this.ubicacionImagen);
            this.imgLogo.setImage(this.imagenLogo);
        }
        catch (Exception e2) {
            System.out.println("No enuentra imagen, error: " + e2);
        }
    }

    private void InicializaVentana() {
        this.tablas.ConectaBD();
        this.tablas.CargaNombreLogos();
        this.cmbLogos.getItems().clear();
        this.cmbLogos.getItems().addAll(this.met99Datos.lstPromotoria);
        this.RecuperaDatosPromotor();
        this.lblAviso.setVisible(false);
        this.tablas.CierraBD();
        this.lblVersion.setText(this.met99Datos.idVersion);
    }

    public void AceptaLogo() {
        this.ValidaDatos();
        if (this.datosValidos.booleanValue()) {
            this.GuardaDatosPromotor();
            this.lblAviso.setVisible(true);
        }
    }

    private void ValidaDatos() {
        String mensajeError = "";
        this.datosValidos = true;
        if (this.txtNombrePromotor.getText().equals("")) {
            this.datosValidos = false;
            mensajeError = mensajeError + "Nombre de promotor obligatorio, ";
        }
        if (this.txtNombreAgente.getText().equals("")) {
            this.datosValidos = false;
            mensajeError = mensajeError + "Nombre de agente obligatorio";
        }
        if (!this.datosValidos.booleanValue()) {
            this.genSubs.MuestraMensaje(mensajeError, "Provida");
        }
    }

    private void GuardaDatosPromotor() {
        this.met99Datos.nombrePromotor = this.txtNombrePromotor.getText();
        this.met99Datos.direccion1 = this.txtDireccion1.getText();
        this.met99Datos.direccion2 = this.txtDireccion2.getText();
        this.met99Datos.telefonoPromotor = this.txtTelefonoPromotor.getText();
        this.met99Datos.correoPromotor = this.txtCorreoPromotor.getText();
        this.met99Datos.nombreAgente = this.txtNombreAgente.getText();
        this.met99Datos.telefonoAgente = this.txtTelefonoAgente.getText();
        this.met99Datos.celularAgente = this.txtCelularAgente.getText();
        this.met99Datos.correoAgente = this.txtCorreoAgente.getText();
        this.tablas.ConectaBD();
        this.tablas.EscribeDatosPromotoria();
        this.tablas.CierraBD();
    }

    private void RecuperaDatosPromotor() {
        this.tablas.DatosPromotoria();
        this.txtNombrePromotor.setText(this.met99Datos.nombrePromotor);
        this.txtDireccion1.setText(this.met99Datos.direccion1);
        this.txtDireccion2.setText(this.met99Datos.direccion2);
        this.txtTelefonoPromotor.setText(this.met99Datos.telefonoPromotor);
        this.txtCorreoPromotor.setText(this.met99Datos.correoPromotor);
        this.txtNombreAgente.setText(this.met99Datos.nombreAgente);
        this.txtTelefonoAgente.setText(this.met99Datos.telefonoAgente);
        this.txtCelularAgente.setText(this.met99Datos.celularAgente);
        this.txtCorreoAgente.setText(this.met99Datos.correoAgente);
        this.cmbLogos.setValue((Object)this.met99Datos.nombreLogo);
    }

    public void RegresaInicio() {
        this.stage = (Stage)this.imgInicio.getScene().getWindow();
        this.MostrarVentana("Provida.fxml");
    }

    private void MostrarVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
        }
        catch (Exception e2) {
            System.out.println("No pudo cargar " + nombreVentana + " error: " + e2);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void Salir() {
        Platform.exit();
    }
}

