/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import provida.GenSubs;
import provida.Met99Datos;
import provida.Met99Imprime;
import provida.Tablas;

public class ProvidaController
implements Initializable {
    private Met99Imprime met99Imprime = Met99Imprime.getInstance();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private GenSubs genSubs = GenSubs.getInstance();
    private Tablas tablas = Tablas.getInstance();
    Stage stage;
    Parent root;
    @FXML
    private Label lblVersion;
    @FXML
    ListView lstProductos;
    @FXML
    ImageView imgLogo;
    @FXML
    Label lblNombrePromotor;
    @FXML
    ImageView imgPersonaliza;
    @FXML
    ImageView imgManual;
    @FXML
    Label lblPersonaliza;
    @FXML
    Label lblManual;
    @FXML
    ImageView imgConoce;
    @FXML
    Label lblConoce;
    @FXML
    ImageView imgCotiza;
    @FXML
    Label lblCotiza;
    @FXML
    Label lblProducto;
    private String seleccion;

    @FXML
    private void handleButtonAction(ActionEvent event) {
        System.out.println("You clicked me!");
    }

    public void initialize(URL url, ResourceBundle rb) {
        ObservableList listaProductos = FXCollections.observableArrayList((Object[])new String[]{"Met99", "Maestro20"});
        this.lstProductos.setItems(listaProductos);
        this.lstProductos.setVisible(false);
        this.InicializaVentana();
    }

    private void InicializaVentana() {
        Double imgConoceY = 0.0;
        Double lblConoceY = 0.0;
        Double imgCotizaY = 0.0;
        Double lblCotizaY = 0.0;
        this.tablas.ConectaBD();
        this.RecuperaDatosPromotor();
        this.tablas.CargaAtributoControles();
        this.tablas.CargaPosicionControles();
        this.tablas.CargaPosCTLtarifario();
        this.tablas.CargaVisibleCTLtarifario();
        this.tablas.CierraBD();
        if (this.met99Datos.esVida360.booleanValue()) {
            this.imgPersonaliza.setVisible(false);
            this.lblPersonaliza.setVisible(false);
            this.imgManual.setVisible(false);
            this.lblManual.setVisible(false);
            imgConoceY = 175.0;
            lblConoceY = 184.0;
            imgCotizaY = 234.0;
            lblCotizaY = 244.0;
            this.lblConoce.setText("Conoce Vida360");
            this.lblProducto.setText("Vida 360");
            this.lblCotiza.setText("Cotiza Vida 360");
            this.lblVersion.setText(this.met99Datos.idVersion360);
        } else {
            this.imgPersonaliza.setVisible(true);
            this.lblPersonaliza.setVisible(true);
            this.imgManual.setVisible(true);
            this.lblManual.setVisible(true);
            imgConoceY = 101.0;
            lblConoceY = 110.0;
            imgCotizaY = 160.0;
            lblCotizaY = 170.0;
            this.lblConoce.setText("Conoce los productos");
            this.lblProducto.setText("Negocio Individual P\u00fablico");
            this.lblCotiza.setText("Cotiza");
            this.lblVersion.setText(this.met99Datos.idVersion);
        }
        this.imgConoce.setLayoutY(imgConoceY.doubleValue());
        this.lblConoce.setLayoutY(lblConoceY.doubleValue());
        this.imgCotiza.setLayoutY(imgCotizaY.doubleValue());
        this.lblCotiza.setLayoutY(lblCotizaY.doubleValue());
    }

    private void RecuperaDatosPromotor() {
        this.tablas.DatosPromotoria();
        String ubicacionImagen = "Logos/" + this.met99Datos.nombreLogo + ".jpg";
        try {
            Image imagenLogo = new Image(ubicacionImagen);
            this.imgLogo.setImage(imagenLogo);
            this.lblNombrePromotor.setText(this.met99Datos.nombreLogo);
        }
        catch (Exception e2) {
            System.out.println("No enuentra imagen, error: " + e2);
        }
    }

    public void MuestraProductos() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Productos.fxml");
    }

    public void MuestraPersonaliza() {
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Personaliza.fxml");
    }

    public void MuestraManual() {
        this.AbreArchivoPDF("ManualUsuario.pdf");
    }

    private void AbreArchivoPDF(String archivoPDF) {
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(archivoPDF);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException ex) {
                this.genSubs.MuestraMensaje("Es necesario tener instalado Adobe Acrobat Reader", "TarifarioMet99");
            }
        }
    }

    public void CotizaProducto() {
        if (this.lstProductos.getItems().size() > 0) {
            switch (this.seleccion = this.lstProductos.getSelectionModel().getSelectedItem().toString()) {
                case "Met99": {
                    this.stage = (Stage)this.lblVersion.getScene().getWindow();
                    this.met99Datos.productoSeleccionado = "Met99";
                    this.MuestraVentana("Met99DPer.fxml");
                    break;
                }
                case "Maestro20": {
                    this.stage = (Stage)this.lblVersion.getScene().getWindow();
                    this.met99Datos.productoSeleccionado = "Maestro20";
                    this.MuestraVentana("Met99DPer.fxml");
                    break;
                }
                case "PT20": {
                    this.stage = (Stage)this.lblVersion.getScene().getWindow();
                    this.met99Datos.productoSeleccionado = "PT20";
                    this.MuestraVentana("Met99DPer.fxml");
                    break;
                }
                default: {
                    System.out.println("Pendiente");
                }
            }
            this.OcultarListas();
        }
    }

    public void CotizaVida360() {
        if (this.met99Datos.esVida360.booleanValue()) {
            this.stage = (Stage)this.lblVersion.getScene().getWindow();
            this.met99Datos.productoSeleccionado = "Met99";
            this.MuestraVentana("Met99DPer.fxml");
        }
    }

    public void MuestraMet99() {
        this.met99Datos.productoSeleccionado = "Met99";
        this.stage = (Stage)this.lblVersion.getScene().getWindow();
        this.MuestraVentana("Met99DPer.fxml");
    }

    public void MostrarListaProductos() {
        this.OcultarListas();
        if (!this.met99Datos.esVida360.booleanValue()) {
            this.lstProductos.setVisible(true);
        } else {
            this.lstProductos.setVisible(false);
        }
    }

    public void OcultarListas() {
        this.lstProductos.setVisible(false);
    }

    private void MuestraVentana(String nombreVentana) {
        try {
            this.root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(nombreVentana));
        }
        catch (Exception e2) {
            System.out.println("Hay Error: " + e2);
            System.out.println("No pudo cargar " + nombreVentana);
        }
        Scene scene = new Scene(this.root);
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void Salir() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Provida");
        alert.setHeaderText("");
        alert.setContentText("\u00bfEst\u00e1 seguro de salir del cotizador?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        }
    }
}

