/*
 * Decompiled with CFR 0.152.
 */
package provida;

import java.sql.Connection;
import java.sql.ResultSet;
import provida.Met99Datos;
import provida.RutinasDB;

public class Tablas {
    private static Tablas tablas = new Tablas();
    private RutinasDB rutinasDB = new RutinasDB();
    private Met99Datos met99Datos = Met99Datos.getInstance();
    private String txtQuery;
    private ResultSet rs = null;
    private Connection c = null;

    private Tablas() {
    }

    public static Tablas getInstance() {
        return tablas;
    }

    public void ConectaBD() {
        this.rutinasDB.ConectaDb("dbProvida.db");
        this.c = this.rutinasDB.c;
    }

    public void CierraBD() {
        try {
            this.c.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    public void CargaOcupaciones() {
        this.met99Datos.lstOcupaciones.clear();
        this.met99Datos.lstDecisiones.clear();
        this.met99Datos.lstEPaccidentes.clear();
        this.met99Datos.lstEPinvalidez.clear();
        this.met99Datos.lstEPvida.clear();
        this.met99Datos.lstSumaLimitada.clear();
        this.met99Datos.lstAPactivado.clear();
        try {
            this.txtQuery = "SELECT * FROM tblOcupaciones;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.lstOcupaciones.add(this.rs.getString("Ocupacion"));
                this.met99Datos.lstDecisiones.add(this.rs.getString("Decision"));
                this.met99Datos.lstEPaccidentes.add(this.rs.getDouble("EPaccidentes"));
                this.met99Datos.lstEPinvalidez.add(this.rs.getDouble("EPinvalidez"));
                this.met99Datos.lstEPvida.add(this.rs.getDouble("EPvida"));
                this.met99Datos.lstSumaLimitada.add(this.rs.getInt("sumaLimitada"));
                this.met99Datos.lstAPactivado.add(this.rs.getInt("APactivado"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Ocupaciones: " + e2.getMessage());
        }
    }

    public void CargaNombreLogos() {
        Float altoNuevo = Float.valueOf(40.0f);
        try {
            this.txtQuery = "SELECT * FROM tblLogos ORDER BY nombreLogo;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.lstPromotoria.add(this.rs.getString("nombreLogo"));
                this.met99Datos.lstAnchoLogo.add(Float.valueOf(this.rs.getFloat("ancho")));
                this.met99Datos.lstAltoLogo.add(Float.valueOf(this.rs.getFloat("alto")));
                Float prop = Float.valueOf(this.rs.getFloat("ancho") / this.rs.getFloat("alto"));
                this.met99Datos.lstProporcion.add(prop);
                this.met99Datos.lstAltoNuevoLogo.add(Float.valueOf(40.0f));
                Float anchoNuevo = Float.valueOf(prop.floatValue() * altoNuevo.floatValue());
                this.met99Datos.lstAnchoNuevoLogo.add(anchoNuevo);
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Logos: " + e2.getMessage());
        }
    }

    public void CargaReglas() {
        this.met99Datos.indexCobertura.clear();
        this.met99Datos.idCobertura.clear();
        this.met99Datos.edadMin.clear();
        this.met99Datos.edadMax.clear();
        this.met99Datos.edadCan.clear();
        this.met99Datos.sumaMin.clear();
        this.met99Datos.sumaMax.clear();
        try {
            this.met99Datos.numCob = 0;
            int i = 0;
            this.txtQuery = this.met99Datos.productoSeleccionado.equals("Met99") ? "SELECT * FROM tblMet99Reglas;" : (this.met99Datos.productoSeleccionado.equals("Maestro20") ? "SELECT * FROM tblMaestro20Reglas;" : "SELECT * FROM tblPT20Reglas;");
            this.txtQuery = "SELECT * FROM tblReglas";
            this.txtQuery = this.txtQuery + " WHERE Producto='" + this.met99Datos.productoSeleccionado + "';";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                Integer sumaAux;
                this.met99Datos.numCob = this.met99Datos.numCob + 1;
                this.met99Datos.indexCobertura.add(i);
                this.met99Datos.idCobertura.add(this.rs.getString("idCobertura"));
                this.met99Datos.edadMin.add(this.rs.getInt("edadMin"));
                this.met99Datos.edadMax.add(this.rs.getInt("edadMax"));
                this.met99Datos.edadCan.add(this.rs.getInt("edadCan"));
                if (this.rs.getInt("sumaMin") < 100) {
                    sumaAux = (int)(this.met99Datos.smDiario * 30.0 * (double)this.rs.getInt("sumaMin") + 0.5);
                    this.met99Datos.sumaMin.add(sumaAux);
                } else {
                    this.met99Datos.sumaMin.add(this.rs.getInt("sumaMin"));
                }
                if (this.rs.getString("idCobertura").equals("BACY")) {
                    sumaAux = (int)(this.met99Datos.smDiario * 30.0 * (double)this.rs.getInt("sumaMax") + 0.5);
                    this.met99Datos.sumaMax.add(sumaAux);
                } else {
                    this.met99Datos.sumaMax.add(this.rs.getInt("sumaMax"));
                }
                ++i;
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Reglas: " + e2.getMessage());
        }
    }

    public void CargaDesCob() {
        try {
            this.met99Datos.numText = 0;
            int i = 0;
            this.txtQuery = "SELECT * FROM tblTextos;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                Met99Datos met99Datos = this.met99Datos;
                Integer.valueOf(met99Datos.numText + 1);
                met99Datos.numText = met99Datos.numText;
                this.met99Datos.indexTexto.add(i);
                this.met99Datos.idCobTexto.add(this.rs.getString("idCobertura"));
                this.met99Datos.desCob.add(this.rs.getString("desCobertura"));
                ++i;
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Textos: " + e2.getMessage());
        }
    }

    public void CargaRequisitos() {
        this.met99Datos.edadIni.clear();
        this.met99Datos.edadFin.clear();
        this.met99Datos.sumaIni.clear();
        this.met99Datos.sumaFin.clear();
        this.met99Datos.solicitud.clear();
        this.met99Datos.EMyOrina.clear();
        this.met99Datos.laboratorio.clear();
        this.met99Datos.ecgReposo.clear();
        this.met99Datos.ecgEsfuerzo.clear();
        this.met99Datos.salivaTest.clear();
        this.met99Datos.antigenoProstatico.clear();
        this.met99Datos.sida.clear();
        this.met99Datos.alcoholDrogas.clear();
        try {
            this.txtQuery = "SELECT * FROM tblRequisitos;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.edadIni.add(this.rs.getInt("edadIni"));
                this.met99Datos.edadFin.add(this.rs.getInt("edadFin"));
                this.met99Datos.sumaIni.add(this.rs.getInt("sumaIni"));
                this.met99Datos.sumaFin.add(this.rs.getInt("sumaFin"));
                this.met99Datos.solicitud.add(this.rs.getInt("solicitud"));
                this.met99Datos.EMyOrina.add(this.rs.getInt("EMyOrina"));
                this.met99Datos.laboratorio.add(this.rs.getInt("laboratorio"));
                this.met99Datos.ecgReposo.add(this.rs.getInt("ecgReposo"));
                this.met99Datos.ecgEsfuerzo.add(this.rs.getInt("ecgEsfuerzo"));
                this.met99Datos.salivaTest.add(this.rs.getInt("salivaTest"));
                this.met99Datos.antigenoProstatico.add(this.rs.getInt("antigenoProstatico"));
                this.met99Datos.sida.add(this.rs.getInt("sida"));
                this.met99Datos.alcoholDrogas.add(this.rs.getInt("alcoholDrogas"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Requisitos: " + e2.getMessage());
        }
    }

    public void CargaTarifasMet99() {
        this.ConectaBD();
        try {
            this.txtQuery = "SELECT * FROM tblTarMet99 WHERE ";
            this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
            this.txtQuery = this.txtQuery + " AND edad= " + this.met99Datos.edadCalculoTitular + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.met99Datos.tarBAS = this.rs.getDouble("tarBas");
            this.met99Datos.tarGFA = this.rs.getDouble("tarGFA");
            this.met99Datos.tarGFH1 = this.rs.getDouble("tarGFH1");
            this.met99Datos.tarGFH2 = this.rs.getDouble("tarGFH2");
            this.met99Datos.tarGFH3 = this.rs.getDouble("tarGFH3");
            this.met99Datos.tarGE = this.rs.getDouble("tarGE");
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblTarMet99: " + e2.getMessage());
        }
        try {
            this.txtQuery = "SELECT * FROM tblTarMet99 WHERE ";
            this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
            this.txtQuery = this.txtQuery + " AND edad= " + this.met99Datos.edadRealTitular + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.met99Datos.tarCATH = this.rs.getDouble("tarCATH");
            this.met99Datos.tarCATM = this.rs.getDouble("tarCATM");
            this.met99Datos.tarCRH = this.rs.getDouble("tarCRH");
            this.met99Datos.tarCRM = this.rs.getDouble("tarCRM");
            this.met99Datos.tarEGH = this.rs.getDouble("tarEGH");
            this.met99Datos.tarEGM = this.rs.getDouble("tarEGM");
            this.met99Datos.tarCII = this.rs.getDouble("tarCII");
            this.met99Datos.tarBIT = this.rs.getDouble("tarBIT");
            this.met99Datos.tarTIBA = this.rs.getDouble("tarTIBA");
            this.met99Datos.tarCMA = this.rs.getDouble("tarCMA");
            this.met99Datos.tarPHH = this.rs.getDouble("tarPHH");
            this.met99Datos.tarPHM = this.rs.getDouble("tarPHM");
        }
        catch (Exception e3) {
            System.out.println(e3.getClass().getName() + " tblTarMet99: " + e3.getMessage());
        }
        if (this.met99Datos.sexoTitular == "F") {
            try {
                this.txtQuery = "SELECT * FROM tblTarMet99 WHERE ";
                this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
                this.txtQuery = this.txtQuery + " AND edad= " + (this.met99Datos.edadRealTitular - 3) + ";";
                this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
                this.met99Datos.tarCII = this.rs.getDouble("tarCII");
                this.met99Datos.tarBIT = this.rs.getDouble("tarBIT");
                this.met99Datos.tarTIBA = this.rs.getDouble("tarTIBA");
            }
            catch (Exception e4) {
                System.out.println(e4.getClass().getName() + " tblTarMet99: " + e4.getMessage());
            }
        }
        try {
            if (this.met99Datos.hayConuge.booleanValue()) {
                this.txtQuery = "SELECT * FROM tblTarMet99 WHERE ";
                this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
                this.txtQuery = this.txtQuery + " AND edad= " + this.met99Datos.edadRealConyuge + ";";
                this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
                this.met99Datos.tarBACY = this.rs.getDouble("tarBACY");
                this.met99Datos.tarGFC = this.rs.getDouble("tarGFC");
                this.met99Datos.tarBCACH = this.rs.getDouble("tarCATH");
                this.met99Datos.tarBCACM = this.rs.getDouble("tarCATM");
            }
        }
        catch (Exception e5) {
            System.out.println(e5.getClass().getName() + " Tarifas2: " + e5.getMessage());
        }
        try {
            this.met99Datos.lstTarBAC.clear();
            this.met99Datos.lstTarGF.clear();
            this.met99Datos.lstTarBCAC.clear();
            this.met99Datos.lstTarEG.clear();
            this.met99Datos.lstTarCR.clear();
            this.met99Datos.lstTarPHX.clear();
            for (int i = 0; i < this.met99Datos.numComp; ++i) {
                this.txtQuery = "SELECT * FROM tblTarMet99 WHERE ";
                this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
                this.txtQuery = this.txtQuery + " AND edad= " + this.met99Datos.lstEdadComp.get(i) + ";";
                this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
                this.met99Datos.lstTarBAC.add(this.rs.getDouble("tarBAC"));
                this.met99Datos.lstTarGF.add(this.rs.getDouble("tarGFX"));
                if (this.met99Datos.lstSexoComp.get(i) == "M") {
                    this.met99Datos.lstTarBCAC.add(this.rs.getDouble("tarCATH"));
                    this.met99Datos.lstTarEG.add(this.rs.getDouble("tarEGH"));
                    this.met99Datos.lstTarCR.add(this.rs.getDouble("tarCRH"));
                    this.met99Datos.lstTarPHX.add(this.rs.getDouble("tarPHH"));
                    continue;
                }
                this.met99Datos.lstTarBCAC.add(this.rs.getDouble("tarCATM"));
                this.met99Datos.lstTarEG.add(this.rs.getDouble("tarEGM"));
                this.met99Datos.lstTarCR.add(this.rs.getDouble("tarCRM"));
                this.met99Datos.lstTarPHX.add(this.rs.getDouble("tarPHM"));
            }
        }
        catch (Exception e6) {
            System.out.println(e6.getClass().getName() + "Tarifas3: " + e6.getMessage());
        }
        this.CierraBD();
    }

    public void CargaQx() {
        this.met99Datos.qxBAS.clear();
        this.met99Datos.qxBIT.clear();
        this.met99Datos.qxCII.clear();
        this.met99Datos.qxCMA.clear();
        this.met99Datos.qxTIBA.clear();
        this.met99Datos.qxCATH.clear();
        this.met99Datos.qxCATM.clear();
        this.met99Datos.qxGE.clear();
        this.met99Datos.qxGF.clear();
        this.met99Datos.qxEGH.clear();
        this.met99Datos.qxEGM.clear();
        this.met99Datos.qxCRH.clear();
        this.met99Datos.qxCRM.clear();
        this.met99Datos.qxPHH.clear();
        this.met99Datos.qxPHM.clear();
        for (int i = 0; i < 10; ++i) {
            this.met99Datos.qxBAS.add(0.0);
            this.met99Datos.qxBIT.add(0.0);
            this.met99Datos.qxCII.add(0.0);
            this.met99Datos.qxCMA.add(0.0);
            this.met99Datos.qxTIBA.add(0.0);
            this.met99Datos.qxCATH.add(0.0);
            this.met99Datos.qxCATM.add(0.0);
            this.met99Datos.qxGE.add(0.0);
            this.met99Datos.qxGF.add(0.0);
            this.met99Datos.qxEGH.add(0.0);
            this.met99Datos.qxEGM.add(0.0);
            this.met99Datos.qxCRH.add(0.0);
            this.met99Datos.qxCRM.add(0.0);
            this.met99Datos.qxPHH.add(0.0);
            this.met99Datos.qxPHM.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblQxMet99 ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.qxBAS.add(this.rs.getDouble("BAS"));
                this.met99Datos.qxBIT.add(this.rs.getDouble("BIT"));
                this.met99Datos.qxCII.add(this.rs.getDouble("CII"));
                this.met99Datos.qxCMA.add(this.rs.getDouble("CMA"));
                this.met99Datos.qxTIBA.add(this.rs.getDouble("TIBA"));
                this.met99Datos.qxCATH.add(this.rs.getDouble("CATH"));
                this.met99Datos.qxCATM.add(this.rs.getDouble("CATM"));
                this.met99Datos.qxGE.add(this.rs.getDouble("GE"));
                this.met99Datos.qxGF.add(this.rs.getDouble("GF"));
                this.met99Datos.qxEGH.add(this.rs.getDouble("EGH"));
                this.met99Datos.qxEGM.add(this.rs.getDouble("EGM"));
                this.met99Datos.qxCRH.add(this.rs.getDouble("CRH"));
                this.met99Datos.qxCRM.add(this.rs.getDouble("CRM"));
                this.met99Datos.qxPHH.add(this.rs.getDouble("PHH"));
                this.met99Datos.qxPHM.add(this.rs.getDouble("PHM"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblQxMet99: " + e2.getMessage());
        }
    }

    public void CargaQxPT20() {
        this.met99Datos.qxBAS.clear();
        this.met99Datos.qxBIT.clear();
        this.met99Datos.qxCII.clear();
        this.met99Datos.qxCMA.clear();
        this.met99Datos.qxTIBA.clear();
        this.met99Datos.qxCATH.clear();
        this.met99Datos.qxCATM.clear();
        this.met99Datos.qxGE.clear();
        this.met99Datos.qxGF.clear();
        this.met99Datos.qxEGH.clear();
        this.met99Datos.qxEGM.clear();
        this.met99Datos.qxCRH.clear();
        this.met99Datos.qxCRM.clear();
        this.met99Datos.qxPHH.clear();
        this.met99Datos.qxPHM.clear();
        this.met99Datos.FacX.clear();
        for (int i = 0; i < 10; ++i) {
            this.met99Datos.qxBAS.add(0.0);
            this.met99Datos.qxBIT.add(0.0);
            this.met99Datos.qxCII.add(0.0);
            this.met99Datos.qxCMA.add(0.0);
            this.met99Datos.qxTIBA.add(0.0);
            this.met99Datos.qxCATH.add(0.0);
            this.met99Datos.qxCATM.add(0.0);
            this.met99Datos.qxGE.add(0.0);
            this.met99Datos.qxGF.add(0.0);
            this.met99Datos.qxEGH.add(0.0);
            this.met99Datos.qxEGM.add(0.0);
            this.met99Datos.qxCRH.add(0.0);
            this.met99Datos.qxCRM.add(0.0);
            this.met99Datos.FacX.add(0.0);
            this.met99Datos.qxPHH.add(0.0);
            this.met99Datos.qxPHM.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblQxPT20 ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.qxBAS.add(this.rs.getDouble("BAS"));
                this.met99Datos.qxBIT.add(this.rs.getDouble("BIT"));
                this.met99Datos.qxCII.add(this.rs.getDouble("CII"));
                this.met99Datos.qxTIBA.add(this.rs.getDouble("TIBA"));
                this.met99Datos.FacX.add(this.rs.getDouble("FacX"));
                this.met99Datos.qxCMA.add(0.0);
                this.met99Datos.qxCATH.add(0.0);
                this.met99Datos.qxCATM.add(0.0);
                this.met99Datos.qxGE.add(0.0);
                this.met99Datos.qxGF.add(0.0);
                this.met99Datos.qxEGH.add(0.0);
                this.met99Datos.qxEGM.add(0.0);
                this.met99Datos.qxCRH.add(0.0);
                this.met99Datos.qxCRM.add(0.0);
                this.met99Datos.qxPHH.add(0.0);
                this.met99Datos.qxPHM.add(0.0);
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Qx PT20: " + e2.getMessage());
        }
    }

    public void CargaQxMaestro20() {
        String colGF;
        String colTIBA;
        String colBIT;
        String colBAS;
        if (this.met99Datos.sexoTitular.equals("M")) {
            if (this.met99Datos.fumaTitular.equals("S")) {
                colBAS = "BASmf";
                colBIT = "BITmf";
                colTIBA = "TIBAmf";
                colGF = "BASmf";
            } else {
                colBAS = "BASmnf";
                colBIT = "BITmnf";
                colTIBA = "TIBAmnf";
                colGF = "BASmnf";
            }
        } else if (this.met99Datos.fumaTitular.equals("S")) {
            colBAS = "BASff";
            colBIT = "BITff";
            colTIBA = "TIBAff";
            colGF = "BASff";
        } else {
            colBAS = "BASfnf";
            colBIT = "BITfnf";
            colTIBA = "TIBAfnf";
            colGF = "BASfnf";
        }
        this.met99Datos.qxBAS.clear();
        this.met99Datos.qxBIT.clear();
        this.met99Datos.qxCII.clear();
        this.met99Datos.qxCMA.clear();
        this.met99Datos.qxTIBA.clear();
        this.met99Datos.qxCATH.clear();
        this.met99Datos.qxCATM.clear();
        this.met99Datos.qxGE.clear();
        this.met99Datos.qxGF.clear();
        this.met99Datos.qxEGH.clear();
        this.met99Datos.qxEGM.clear();
        this.met99Datos.qxCRH.clear();
        this.met99Datos.qxCRM.clear();
        this.met99Datos.FacX.clear();
        this.met99Datos.qxPHH.add(0.0);
        this.met99Datos.qxPHM.add(0.0);
        for (int i = 0; i < 10; ++i) {
            this.met99Datos.qxBAS.add(0.0);
            this.met99Datos.qxBIT.add(0.0);
            this.met99Datos.qxCII.add(0.0);
            this.met99Datos.qxCMA.add(0.0);
            this.met99Datos.qxTIBA.add(0.0);
            this.met99Datos.qxCATH.add(0.0);
            this.met99Datos.qxCATM.add(0.0);
            this.met99Datos.qxGE.add(0.0);
            this.met99Datos.qxGF.add(0.0);
            this.met99Datos.qxEGH.add(0.0);
            this.met99Datos.qxEGM.add(0.0);
            this.met99Datos.qxCRH.add(0.0);
            this.met99Datos.qxCRM.add(0.0);
            this.met99Datos.FacX.add(0.0);
            this.met99Datos.qxPHH.add(0.0);
            this.met99Datos.qxPHM.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblQxMaestro20 ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.qxBAS.add(this.rs.getDouble(colBAS));
                this.met99Datos.qxBIT.add(this.rs.getDouble(colBIT));
                this.met99Datos.qxTIBA.add(this.rs.getDouble(colTIBA));
                this.met99Datos.qxGF.add(this.rs.getDouble(colGF));
                this.met99Datos.qxCMA.add(0.0);
                this.met99Datos.qxCII.add(0.0);
                this.met99Datos.qxCATH.add(0.0);
                this.met99Datos.qxCATM.add(0.0);
                this.met99Datos.qxGE.add(0.0);
                this.met99Datos.qxEGH.add(0.0);
                this.met99Datos.qxEGM.add(0.0);
                this.met99Datos.qxCRH.add(0.0);
                this.met99Datos.qxCRM.add(0.0);
                this.met99Datos.FacX.add(0.0);
                this.met99Datos.qxPHH.add(0.0);
                this.met99Datos.qxPHM.add(0.0);
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " TarifasM20: " + e2.getMessage());
        }
    }

    public void CargaFacCPMA() {
        this.ConectaBD();
        this.met99Datos.facCPMA.clear();
        try {
            this.txtQuery = "SELECT * FROM tblCPMA ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.facCPMA.add(this.rs.getDouble("facCPMA"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " CPMA: " + e2.getMessage());
        }
        this.CierraBD();
    }

    public void CargaFacInv() {
        this.met99Datos.facInv.clear();
        try {
            this.txtQuery = "SELECT * FROM tblFacInv ";
            this.txtQuery = this.txtQuery + " WHERE Edad = " + this.met99Datos.edadCalculoTitular;
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.facInv.add(this.rs.getDouble("facInv"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " facInv: " + e2.getMessage());
        }
    }

    public void CargaFacGadm() {
        this.met99Datos.facGadm.clear();
        for (int i = 0; i < 15; ++i) {
            this.met99Datos.facGadm.add(0.0);
        }
        try {
            this.txtQuery = "SELECT * FROM tblFacGadm ";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.facGadm.add(this.rs.getDouble("facGadm"));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " facInv: " + e2.getMessage());
        }
    }

    public void EscribeDatosPromotoria() {
        try {
            this.txtQuery = "UPDATE tblDatosPromotoria ";
            this.txtQuery = this.txtQuery + "SET nombrePromotor = '" + this.met99Datos.nombrePromotor + "', ";
            this.txtQuery = this.txtQuery + " direccion1 = '" + this.met99Datos.direccion1 + "', ";
            this.txtQuery = this.txtQuery + " direccion2 = '" + this.met99Datos.direccion2 + "', ";
            this.txtQuery = this.txtQuery + " telefonoPromotor = '" + this.met99Datos.telefonoPromotor + "', ";
            this.txtQuery = this.txtQuery + " correoPromotor = '" + this.met99Datos.correoPromotor + "', ";
            this.txtQuery = this.txtQuery + " nombreAgente = '" + this.met99Datos.nombreAgente + "', ";
            this.txtQuery = this.txtQuery + " telefonoAgente = '" + this.met99Datos.telefonoAgente + "', ";
            this.txtQuery = this.txtQuery + " celularAgente = '" + this.met99Datos.celularAgente + "', ";
            this.txtQuery = this.txtQuery + " correoAgente = '" + this.met99Datos.correoAgente + "', ";
            this.txtQuery = this.txtQuery + " nombreLogo = '" + this.met99Datos.nombreLogo + "', ";
            this.txtQuery = this.txtQuery + " anchoLogo = " + this.met99Datos.anchoLogo + ", ";
            this.txtQuery = this.txtQuery + " altoLogo = " + this.met99Datos.altoLogo + " ";
            this.txtQuery = this.txtQuery + "WHERE idPromotor = 1;";
            this.rutinasDB.ActualizaTabla(this.txtQuery);
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " NO se actualiz\u00f3: " + e2.getMessage());
        }
    }

    public void DatosPromotoria() {
        try {
            this.txtQuery = "SELECT * FROM tblDatosPromotoria WHERE idPromotor = 1;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                this.met99Datos.nombrePromotor = this.rs.getString("nombrePromotor");
                this.met99Datos.direccion1 = this.rs.getString("direccion1");
                this.met99Datos.direccion2 = this.rs.getString("direccion2");
                this.met99Datos.telefonoPromotor = this.rs.getString("telefonoPromotor");
                this.met99Datos.correoPromotor = this.rs.getString("correoPromotor");
                this.met99Datos.nombreAgente = this.rs.getString("nombreAgente");
                this.met99Datos.telefonoAgente = this.rs.getString("telefonoAgente");
                this.met99Datos.celularAgente = this.rs.getString("celularAgente");
                this.met99Datos.correoAgente = this.rs.getString("correoAgente");
                this.met99Datos.nombreLogo = this.rs.getString("nombreLogo");
                this.met99Datos.anchoLogo = Float.valueOf(this.rs.getFloat("anchoLogo"));
                this.met99Datos.altoLogo = Float.valueOf(this.rs.getFloat("altoLogo"));
            }
            this.rs.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Datos Promotor: " + e2.getMessage());
        }
    }

    public void CargaAtributoControles() {
        this.met99Datos.numCtlVisibles = 0;
        this.met99Datos.indexCtlVisibles.clear();
        int i = 0;
        try {
            this.txtQuery = "SELECT * FROM tblVisibleCTL;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                Met99Datos met99Datos = this.met99Datos;
                Integer.valueOf(met99Datos.numCtlVisibles + 1);
                met99Datos.numCtlVisibles = met99Datos.numCtlVisibles;
                this.met99Datos.indexCtlVisibles.add(i);
                this.met99Datos.nombreControl.add(this.rs.getString("nombreControl"));
                this.met99Datos.Met99Visible.add(this.rs.getInt("Met99Visible"));
                this.met99Datos.Maestro20Visible.add(this.rs.getInt("Maestro20Visible"));
                this.met99Datos.PT20Visible.add(this.rs.getInt("PT20Visible"));
                this.met99Datos.Vida360Visible.add(this.rs.getInt("Vida360Visible"));
                ++i;
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Controles: " + e2.getMessage());
        }
    }

    public void CargaPosicionControles() {
        this.met99Datos.numCtlPosicion = 0;
        int i = 0;
        this.met99Datos.indexCtlPosicion.clear();
        this.met99Datos.nombreControlPos.clear();
        this.met99Datos.Met99X.clear();
        this.met99Datos.Met99Y.clear();
        this.met99Datos.Maestro20X.clear();
        this.met99Datos.Maestro20Y.clear();
        this.met99Datos.PT20X.clear();
        this.met99Datos.PT20Y.clear();
        this.met99Datos.Vida360X.clear();
        this.met99Datos.Vida360Y.clear();
        try {
            this.txtQuery = "SELECT * FROM tblPosicionCTL;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                Met99Datos met99Datos = this.met99Datos;
                Integer.valueOf(met99Datos.numCtlPosicion + 1);
                met99Datos.numCtlPosicion = met99Datos.numCtlPosicion;
                this.met99Datos.indexCtlPosicion.add(i);
                this.met99Datos.nombreControlPos.add(this.rs.getString("nombreControl"));
                this.met99Datos.Met99X.add(this.rs.getInt("Met99X"));
                this.met99Datos.Met99Y.add(this.rs.getInt("Met99Y"));
                this.met99Datos.Maestro20X.add(this.rs.getInt("Maestro20X"));
                this.met99Datos.Maestro20Y.add(this.rs.getInt("Maestro20Y"));
                this.met99Datos.PT20X.add(this.rs.getInt("PT20X"));
                this.met99Datos.PT20Y.add(this.rs.getInt("PT20Y"));
                this.met99Datos.Vida360X.add(this.rs.getInt("Vida360X"));
                this.met99Datos.Vida360Y.add(this.rs.getInt("Vida360Y"));
                ++i;
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Pos Controles: " + e2.getMessage());
        }
    }

    public void CargaVisibleCTLtarifario() {
        this.met99Datos.numCtlVisiblesTar = 0;
        this.met99Datos.indexCtlVisiblesTar.clear();
        int i = 0;
        try {
            this.txtQuery = "SELECT * FROM tblVisibleCTLtarifario;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                Met99Datos met99Datos = this.met99Datos;
                Integer.valueOf(met99Datos.numCtlVisiblesTar + 1);
                met99Datos.numCtlVisiblesTar = met99Datos.numCtlVisiblesTar;
                this.met99Datos.indexCtlVisiblesTar.add(i);
                this.met99Datos.nombreControlTar.add(this.rs.getString("nombreControl"));
                this.met99Datos.Met99VisibleTar.add(this.rs.getInt("Met99Visible"));
                this.met99Datos.Maestro20VisibleTar.add(this.rs.getInt("Maestro20Visible"));
                this.met99Datos.PT20VisibleTar.add(this.rs.getInt("PT20Visible"));
                this.met99Datos.Vida360VisibleTar.add(this.rs.getInt("Vida360Visible"));
                ++i;
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Controles Tar: " + e2.getMessage());
        }
    }

    public void CargaPosCTLtarifario() {
        this.met99Datos.numCtlPosicionTar = 0;
        int i = 0;
        this.met99Datos.indexCtlPosicionTar.clear();
        this.met99Datos.nombreControlPosTar.clear();
        this.met99Datos.Met99Xtar.clear();
        this.met99Datos.Met99Ytar.clear();
        this.met99Datos.Maestro20Xtar.clear();
        this.met99Datos.Maestro20Ytar.clear();
        this.met99Datos.PT20Xtar.clear();
        this.met99Datos.PT20Ytar.clear();
        this.met99Datos.Vida360Xtar.clear();
        this.met99Datos.Vida360Ytar.clear();
        try {
            this.txtQuery = "SELECT * FROM tblPosCTLtarifario;";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            while (this.rs.next()) {
                Met99Datos met99Datos = this.met99Datos;
                Integer.valueOf(met99Datos.numCtlPosicionTar + 1);
                met99Datos.numCtlPosicionTar = met99Datos.numCtlPosicionTar;
                this.met99Datos.indexCtlPosicionTar.add(i);
                this.met99Datos.nombreControlPosTar.add(this.rs.getString("nombreControl"));
                this.met99Datos.Met99Xtar.add(this.rs.getInt("Met99Xtar"));
                this.met99Datos.Met99Ytar.add(this.rs.getInt("Met99Ytar"));
                this.met99Datos.Maestro20Xtar.add(this.rs.getInt("Maestro20Xtar"));
                this.met99Datos.Maestro20Ytar.add(this.rs.getInt("Maestro20Ytar"));
                this.met99Datos.PT20Xtar.add(this.rs.getInt("PT20Xtar"));
                this.met99Datos.PT20Ytar.add(this.rs.getInt("PT20Ytar"));
                this.met99Datos.Vida360Xtar.add(this.rs.getInt("Vida360Xtar"));
                this.met99Datos.Vida360Ytar.add(this.rs.getInt("Vida360Ytar"));
                ++i;
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " Pos Controles Tar: " + e2.getMessage());
        }
    }

    public void CargaTarifasMaestro20() {
        String sexoHabito = this.met99Datos.sexoTitular.equals("M") ? (this.met99Datos.fumaTitular.equals("N") ? "mnf" : "mf") : (this.met99Datos.fumaTitular.equals("N") ? "fnf" : "ff");
        this.ConectaBD();
        try {
            this.txtQuery = "SELECT * FROM tblTarMaestro20 WHERE ";
            this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
            this.txtQuery = this.txtQuery + " AND edad= " + this.met99Datos.edadRealTitular + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.met99Datos.tarBAS = this.rs.getDouble("tarBAS" + sexoHabito);
            this.met99Datos.tarGFA = this.rs.getDouble("tarGFA" + sexoHabito);
            this.met99Datos.tarBIT = this.rs.getDouble("tarBIT" + sexoHabito);
            this.met99Datos.tarTIBA = this.rs.getDouble("tarTIBA" + sexoHabito);
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblTarMaestro20: " + e2.getMessage());
        }
        try {
            this.met99Datos.lstTarBAC.clear();
            this.met99Datos.lstTarGF.clear();
            this.met99Datos.lstTarBCAC.clear();
            this.met99Datos.lstTarEG.clear();
            this.met99Datos.lstTarCR.clear();
            this.met99Datos.lstTarPHX.clear();
            for (int i = 0; i < this.met99Datos.numComp; ++i) {
                this.txtQuery = "SELECT * FROM tblTarMaestro20 WHERE ";
                this.txtQuery = this.txtQuery + "conDev=" + this.met99Datos.ftpSel;
                this.txtQuery = this.txtQuery + " AND edad= " + this.met99Datos.lstEdadComp.get(i) + ";";
                this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
                this.met99Datos.lstTarGF.add(this.rs.getDouble("tarGFX"));
            }
        }
        catch (Exception e3) {
            System.out.println(e3.getClass().getName() + "Tarifas3: " + e3.getMessage());
        }
        this.CierraBD();
    }

    public void CargaTarifasPT20() {
        this.ConectaBD();
        try {
            this.txtQuery = "SELECT * FROM tblTarPT20 WHERE ";
            this.txtQuery = this.txtQuery + " edad= " + this.met99Datos.edadCalculoTitular + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.met99Datos.tarBAS = this.rs.getDouble("tarBas");
            this.met99Datos.tarTIBA = this.rs.getDouble("tarTIBA");
            this.met99Datos.tarGFH1 = this.rs.getDouble("tarGFH1");
            this.met99Datos.tarGFH2 = this.rs.getDouble("tarGFH2");
            this.met99Datos.tarGFH3 = this.rs.getDouble("tarGFH3");
        }
        catch (Exception e2) {
            System.out.println(e2.getClass().getName() + " tblTarPT20: " + e2.getMessage());
        }
        try {
            this.txtQuery = "SELECT * FROM tblTarPT20 WHERE ";
            this.txtQuery = this.txtQuery + " edad= " + this.met99Datos.edadRealTitular + ";";
            this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
            this.met99Datos.tarCII = this.rs.getDouble("tarCII");
            this.met99Datos.tarBIT = this.rs.getDouble("tarBIT");
        }
        catch (Exception e3) {
            System.out.println(e3.getClass().getName() + " tblTarPT20: " + e3.getMessage());
        }
        try {
            if (this.met99Datos.hayConuge.booleanValue()) {
                this.txtQuery = "SELECT * FROM tblTarPT20 WHERE ";
                this.txtQuery = this.txtQuery + " edad= " + this.met99Datos.edadRealConyuge + ";";
                this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
                this.met99Datos.tarGFC = this.rs.getDouble("tarGFC");
            }
        }
        catch (Exception e4) {
            System.out.println(e4.getClass().getName() + " Tarifas2: " + e4.getMessage());
        }
        try {
            this.met99Datos.lstTarBAC.clear();
            this.met99Datos.lstTarGF.clear();
            this.met99Datos.lstTarBCAC.clear();
            this.met99Datos.lstTarEG.clear();
            this.met99Datos.lstTarCR.clear();
            this.met99Datos.lstTarPHX.clear();
            for (int i = 0; i < this.met99Datos.numComp; ++i) {
                this.txtQuery = "SELECT * FROM tblTarPT20 WHERE ";
                this.txtQuery = this.txtQuery + " edad= " + this.met99Datos.lstEdadComp.get(i) + ";";
                this.rs = this.rutinasDB.SeleccionaDatos(this.txtQuery);
                this.met99Datos.lstTarBAC.add(this.rs.getDouble("tarBAC"));
                this.met99Datos.lstTarGF.add(this.rs.getDouble("tarGFX"));
            }
        }
        catch (Exception e5) {
            System.out.println(e5.getClass().getName() + "Tarifas3: " + e5.getMessage());
        }
        this.CierraBD();
    }
}

